/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.explosion.ExplosionLarge;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import scala.util.Random;

public class TileEntityAMSEmitter
extends TileEntity
implements ITickable,
IFluidHandler,
ITankPacketAcceptor {
    public ItemStackHandler inventory;
    public long power = 0L;
    public static final long maxPower = 100000000L;
    public int efficiency = 0;
    public static final int maxEfficiency = 100;
    public int heat = 0;
    public static final int maxHeat = 2500;
    public int age = 0;
    public int warning = 0;
    public boolean locked = false;
    public FluidTank tank;
    public Fluid tankType;
    public boolean needsUpdate;
    Random rand = new Random();
    private String customName;

    public TileEntityAMSEmitter() {
        this.inventory = new ItemStackHandler(4){

            protected void onContentsChanged(int slot) {
                TileEntityAMSEmitter.this.func_70296_d();
                super.onContentsChanged(slot);
            }
        };
        this.tank = new FluidTank(16000);
        this.tankType = ModForgeFluids.COOLANT;
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.amsEmitter";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 128.0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        this.tank.readFromNBT(compound);
        this.efficiency = compound.func_74762_e("efficiency");
        this.heat = compound.func_74762_e("heat");
        this.locked = compound.func_74767_n("locked");
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        this.tank.writeToNBT(compound);
        compound.func_74768_a("efficiency", this.efficiency);
        compound.func_74768_a("heat", this.heat);
        compound.func_74757_a("locked", this.locked);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (this.tank.getFluid() != null) {
            this.tankType = this.tank.getFluid().getFluid();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.needsUpdate) {
                this.needsUpdate = false;
            }
            if (!this.locked) {
                if (this.power > 0L) {
                    this.efficiency = Math.round(this.calcEffect(this.power, this.heat - 1250) * 100.0f);
                    this.power = (long)((double)this.power - Math.ceil((double)this.power * 0.025));
                    this.warning = 0;
                } else {
                    this.efficiency = 0;
                    this.warning = 1;
                }
                if (this.tankType == ModForgeFluids.CRYOGEL) {
                    if (this.tank.getFluidAmount() >= 15) {
                        int i;
                        if (this.heat > 0) {
                            this.tank.drain(15, true);
                            this.needsUpdate = true;
                        }
                        if (this.heat <= 1250) {
                            if (this.efficiency > 0) {
                                this.heat += this.efficiency;
                            } else {
                                for (i = 0; i < 10; ++i) {
                                    if (this.heat <= 0) continue;
                                    --this.heat;
                                }
                            }
                        }
                        for (i = 0; i < 10; ++i) {
                            if (this.heat <= 1250) continue;
                            --this.heat;
                        }
                    } else {
                        this.heat += this.efficiency;
                    }
                } else if (this.tankType == ModForgeFluids.COOLANT) {
                    if (this.tank.getFluidAmount() >= 15) {
                        int i;
                        if (this.heat > 0) {
                            this.tank.drain(15, true);
                            this.needsUpdate = true;
                        }
                        if (this.heat <= 625) {
                            if (this.efficiency > 0) {
                                this.heat += this.efficiency;
                            } else {
                                for (i = 0; i < 5; ++i) {
                                    if (this.heat <= 0) continue;
                                    --this.heat;
                                }
                            }
                        }
                        for (i = 0; i < 5; ++i) {
                            if (this.heat <= 625) continue;
                            --this.heat;
                        }
                    } else {
                        this.heat += this.efficiency;
                    }
                } else if (this.tankType == FluidRegistry.WATER) {
                    if (this.tank.getFluidAmount() >= 45) {
                        int i;
                        if (this.heat > 0) {
                            this.tank.drain(45, true);
                            this.needsUpdate = true;
                        }
                        if ((double)this.heat <= 2125.0) {
                            if (this.efficiency > 0) {
                                this.heat += this.efficiency;
                            } else {
                                for (i = 0; i < 2; ++i) {
                                    if (this.heat <= 0) continue;
                                    --this.heat;
                                }
                            }
                        }
                        for (i = 0; i < 2; ++i) {
                            if (!((double)this.heat > 2125.0)) continue;
                            --this.heat;
                        }
                    } else {
                        this.heat += this.efficiency;
                    }
                } else {
                    this.heat += this.efficiency;
                    this.warning = 2;
                }
                if (!this.inventory.getStackInSlot(2).func_190926_b()) {
                    if (this.inventory.getStackInSlot(2).func_77973_b() != ModItems.ams_muzzle) {
                        this.efficiency = 0;
                        this.warning = 2;
                    }
                } else {
                    this.efficiency = 0;
                    this.warning = 2;
                }
                if (this.tank.getFluidAmount() <= 5 || (double)this.heat > 2250.0) {
                    this.warning = 2;
                }
                if (this.heat > 2500) {
                    this.heat = 2500;
                    this.locked = true;
                    ExplosionLarge.spawnBurst(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, 36, 3.0);
                    ExplosionLarge.spawnBurst(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, 36, 2.5);
                    ExplosionLarge.spawnBurst(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, 36, 2.0);
                    ExplosionLarge.spawnBurst(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, 36, 1.5);
                    ExplosionLarge.spawnBurst(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, 36, 1.0);
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.oldExplosion, SoundCategory.BLOCKS, 10.0f, 1.0f);
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.shutdown, SoundCategory.BLOCKS, 10.0f, 1.0f);
                }
                this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 3, this.power, 100000000L);
            } else {
                ExplosionLarge.spawnBurst(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() - 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.rand.nextInt(10), 1.0);
                this.efficiency = 0;
                this.power = 0L;
                this.warning = 3;
            }
            this.tank.drain(this.tank.getCapacity(), true);
            this.tankType = ModForgeFluids.CRYOGEL;
            this.tank.fill(new FluidStack(ModForgeFluids.CRYOGEL, this.tank.getCapacity()), true);
            this.needsUpdate = true;
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 15.0));
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new AuxGaugePacket(this.field_174879_c, this.locked ? 1 : 0, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 15.0));
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new AuxGaugePacket(this.field_174879_c, this.efficiency, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 15.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tank), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 15.0));
        }
    }

    private float gauss(float a, float x) {
        double amplifier = 0.1;
        return (float)(1.0 / Math.sqrt((double)a * Math.PI) * Math.pow(Math.E, -1.0 * Math.pow(x, 2.0) / amplifier));
    }

    private float calcEffect(float a, float x) {
        return (float)((double)this.gauss(1.0f / a, x / 2500.0f) * Math.sqrt(Math.PI * 2) / (Math.sqrt(2.0) * Math.sqrt(1.0E8)));
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000000L;
    }

    public int getEfficiencyScaled(int i) {
        return this.efficiency * i / 100;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 2500;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public boolean isValidFluid(Fluid fluid) {
        return fluid != null && (fluid == FluidRegistry.WATER || fluid == ModForgeFluids.COOLANT || fluid == ModForgeFluids.CRYOGEL);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tank.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (this.tank.getFluid() == null && this.isValidFluid(resource.getFluid()) || this.tank.getFluid() != null && this.tank.getFluid().getFluid() == resource.getFluid()) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 1) {
            return;
        }
        this.tank.readFromNBT(tags[0]);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }
}

