/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.bomb;

import api.hbm.energy.IEnergyUser;
import com.hbm.config.RadiationConfig;
import com.hbm.entity.projectile.EntityRailgunBlast;
import com.hbm.items.ModItems;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.RailgunRotationPacket;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.tileentity.TileEntityLoadedBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityRailgun
extends TileEntityLoadedBase
implements ITickable,
IEnergyUser {
    public ItemStackHandler inventory = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            TileEntityRailgun.this.func_70296_d();
            super.onContentsChanged(slot);
        }
    };
    public ICapabilityProvider specialProvider = new ICapabilityProvider(){

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)TileEntityRailgun.this.inventory) : null);
        }
    };
    private long power;
    public long startTime;
    public long fireTime;
    public float lastPitch;
    public float lastYaw;
    public static int cooldownDurationMillis = 5000;
    public static int cooldownDurationTicks = 100;
    public float pitch;
    public float yaw;
    public int delay;
    public int fireDelay;
    private String customName;

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.railgun";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.pitch = nbt.func_74760_g("pitch");
        this.yaw = nbt.func_74760_g("yaw");
        if (nbt.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("power", this.power);
        nbt.func_74776_a("pitch", this.pitch);
        nbt.func_74776_a("yaw", this.yaw);
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(nbt);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.delay > 0) {
                --this.delay;
            }
            if (this.fireDelay > 0) {
                --this.fireDelay;
                if (this.fireDelay == 0) {
                    this.tryFire();
                }
            }
            this.updateConnectionsExcept(this.field_145850_b, this.field_174879_c, ForgeDirection.UP);
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, RadiationConfig.railgunBuffer);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new RailgunRotationPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.pitch, this.yaw), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
        }
    }

    public boolean setAngles(boolean miss) {
        if ((this.inventory.getStackInSlot(1).func_77973_b() == ModItems.designator || this.inventory.getStackInSlot(1).func_77973_b() == ModItems.designator_range || this.inventory.getStackInSlot(1).func_77973_b() == ModItems.designator_manual) && this.inventory.getStackInSlot(1).func_77978_p() != null) {
            int x = this.inventory.getStackInSlot(1).func_77978_p().func_74762_e("xCoord");
            int z = this.inventory.getStackInSlot(1).func_77978_p().func_74762_e("zCoord");
            Vec3d vec = new Vec3d((double)(x - this.field_174879_c.func_177958_n()), 0.0, (double)(z - this.field_174879_c.func_177952_p()));
            Vec3d unit = new Vec3d(1.0, 0.0, 0.0);
            if (miss) {
                vec = vec.func_178785_b((float)(this.field_145850_b.field_73012_v.nextGaussian() * Math.PI / 45.0));
            }
            if (vec.func_72433_c() < 1.0 || vec.func_72433_c() > 9000.0) {
                return false;
            }
            double yawUpper = vec.field_72450_a * unit.field_72450_a;
            double yawLower = vec.func_72433_c();
            float yaw = (float)Math.acos(yawUpper / yawLower);
            float pitch = (float)(Math.asin(vec.func_72433_c() * 9.81 / 90000.0) / 2.0);
            float newYaw = (float)((double)yaw * 180.0 / Math.PI);
            float newPitch = (float)((double)pitch * 180.0 / Math.PI) - 90.0f;
            if (vec.field_72449_c > 0.0) {
                newYaw = 0.0f - (float)((double)yaw * 180.0 / Math.PI);
            }
            if (newYaw != this.yaw || newPitch != this.pitch) {
                this.yaw = newYaw;
                this.pitch = newPitch;
                this.delay = cooldownDurationTicks;
                return true;
            }
        }
        return false;
    }

    public boolean canFire() {
        int required = RadiationConfig.railgunUse;
        return this.inventory.getStackInSlot(2).func_77973_b() == ModItems.charge_railgun && this.power >= (long)required;
    }

    public void tryFire() {
        if (this.canFire()) {
            this.fire();
            this.inventory.setStackInSlot(2, ItemStack.field_190927_a);
            this.power -= (long)RadiationConfig.railgunUse;
            if (this.power < 0L) {
                this.power = 0L;
            }
            PacketDispatcher.wrapper.sendToAll((IMessage)new AuxGaugePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 0, 0));
        } else {
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.buttonNo, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void fire() {
        Vec3 vec = Vec3.createVectorHelper(6.0, 0.0, 0.0);
        vec.rotateAroundZ((float)((double)this.pitch * Math.PI / 180.0));
        vec.rotateAroundY((float)((double)this.yaw * Math.PI / 180.0));
        double fX = (double)this.field_174879_c.func_177958_n() + 0.5 + vec.xCoord;
        double fY = (double)(this.field_174879_c.func_177956_o() + 1) + vec.yCoord;
        double fZ = (double)this.field_174879_c.func_177952_p() + 0.5 + vec.zCoord;
        vec = vec.normalize();
        double motionX = vec.xCoord * 15.0;
        double motionY = vec.yCoord * 15.0;
        double motionZ = vec.zCoord * 15.0;
        EntityRailgunBlast fart = new EntityRailgunBlast(this.field_145850_b);
        fart.field_70165_t = fX;
        fart.field_70163_u = fY;
        fart.field_70161_v = fZ;
        fart.field_70159_w = motionX;
        fart.field_70181_x = motionY;
        fart.field_70179_y = motionZ;
        fart.rotation();
        this.field_145850_b.func_72838_d((Entity)fart);
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.railgunFire, SoundCategory.BLOCKS, 100.0f, 1.0f);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return super.hasCapability(capability, facing);
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return RadiationConfig.railgunBuffer;
    }

    public long getPowerScaled(long i) {
        return this.power * i / (long)RadiationConfig.railgunBuffer;
    }
}

