/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity;

import api.hbm.block.ICrucibleAcceptor;
import api.hbm.energy.IEnergyUser;
import api.hbm.tile.IHeatSource;
import com.hbm.inventory.material.Mats;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.TileEntityProxyBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityProxyCombo
extends TileEntityProxyBase
implements IEnergyUser,
IHeatSource,
ICrucibleAcceptor {
    TileEntity tile;
    boolean inventory;
    boolean power;
    boolean fluid;
    public boolean molten;
    boolean heat;

    public TileEntityProxyCombo() {
    }

    public TileEntityProxyCombo(boolean inventory, boolean power, boolean fluid) {
        this.inventory = inventory;
        this.power = power;
        this.fluid = fluid;
        this.heat = false;
        this.molten = false;
    }

    public TileEntityProxyCombo(boolean inventory, boolean power, boolean fluid, boolean heat) {
        this.inventory = inventory;
        this.power = power;
        this.fluid = fluid;
        this.heat = heat;
        this.molten = false;
    }

    public TileEntityProxyCombo(boolean inventory, boolean power, boolean fluid, boolean heat, boolean molten) {
        this.inventory = inventory;
        this.power = power;
        this.fluid = fluid;
        this.heat = heat;
        this.molten = molten;
    }

    public TileEntity getTile() {
        if (this.tile == null) {
            this.tile = this.getTE();
        }
        return this.tile;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.tile == null) {
            this.tile = this.getTE();
            if (this.tile == null) {
                return (T)super.getCapability(capability, facing);
            }
        }
        if (this.inventory && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.tile.getCapability(capability, facing);
        }
        if (this.power && capability == CapabilityEnergy.ENERGY) {
            return (T)this.tile.getCapability(capability, facing);
        }
        if (this.fluid && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tile.getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.tile == null) {
            this.tile = this.getTE();
            if (this.tile == null) {
                return super.hasCapability(capability, facing);
            }
        }
        if (this.inventory && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.tile.hasCapability(capability, facing);
        }
        if (this.power && capability == CapabilityEnergy.ENERGY) {
            return this.tile.hasCapability(capability, facing);
        }
        if (this.fluid && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tile.hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public void setPower(long i) {
        if (!this.power) {
            return;
        }
        TileEntity tileEntity = this.getTile();
        if (tileEntity instanceof IEnergyUser) {
            IEnergyUser user = (IEnergyUser)tileEntity;
            user.setPower(i);
        }
    }

    @Override
    public long getPower() {
        if (!this.power) {
            return 0L;
        }
        TileEntity tileEntity = this.getTile();
        if (tileEntity instanceof IEnergyUser) {
            IEnergyUser user = (IEnergyUser)tileEntity;
            return user.getPower();
        }
        return 0L;
    }

    @Override
    public long getMaxPower() {
        if (!this.power) {
            return 0L;
        }
        TileEntity tileEntity = this.getTile();
        if (tileEntity instanceof IEnergyUser) {
            IEnergyUser user = (IEnergyUser)tileEntity;
            return user.getMaxPower();
        }
        return 0L;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.inventory = compound.func_74767_n("inv");
        this.fluid = compound.func_74767_n("flu");
        this.power = compound.func_74767_n("pow");
        this.heat = compound.func_74767_n("hea");
        this.molten = compound.func_74767_n("mol");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("inv", this.inventory);
        compound.func_74757_a("flu", this.fluid);
        compound.func_74757_a("pow", this.power);
        compound.func_74757_a("hea", this.heat);
        compound.func_74757_a("mol", this.molten);
        return super.func_189515_b(compound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    @Override
    public int getHeatStored() {
        if (!this.heat) {
            return 0;
        }
        TileEntity tileEntity = this.getTile();
        if (tileEntity instanceof IHeatSource) {
            IHeatSource source = (IHeatSource)tileEntity;
            return source.getHeatStored();
        }
        return 0;
    }

    @Override
    public void useUpHeat(int heat) {
        if (!this.heat) {
            return;
        }
        TileEntity tileEntity = this.getTile();
        if (tileEntity instanceof IHeatSource) {
            IHeatSource source = (IHeatSource)tileEntity;
            source.useUpHeat(heat);
        }
    }

    @Override
    public boolean canAcceptPartialPour(World world, BlockPos pos, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        TileEntity tileEntity;
        if (this.molten && (tileEntity = this.getTile()) instanceof ICrucibleAcceptor) {
            ICrucibleAcceptor acc = (ICrucibleAcceptor)tileEntity;
            return acc.canAcceptPartialPour(world, pos, dX, dY, dZ, side, stack);
        }
        return false;
    }

    @Override
    public Mats.MaterialStack pour(World world, BlockPos pos, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        TileEntity tileEntity;
        if (this.molten && (tileEntity = this.getTile()) instanceof ICrucibleAcceptor) {
            ICrucibleAcceptor acc = (ICrucibleAcceptor)tileEntity;
            return acc.pour(world, pos, dX, dY, dZ, side, stack);
        }
        return null;
    }

    @Override
    public boolean canAcceptPartialFlow(World world, BlockPos pos, ForgeDirection side, Mats.MaterialStack stack) {
        TileEntity tileEntity;
        if (this.molten && (tileEntity = this.getTile()) instanceof ICrucibleAcceptor) {
            ICrucibleAcceptor acc = (ICrucibleAcceptor)tileEntity;
            return acc.canAcceptPartialFlow(world, pos, side, stack);
        }
        return false;
    }

    @Override
    public Mats.MaterialStack flow(World world, BlockPos pos, ForgeDirection side, Mats.MaterialStack stack) {
        TileEntity tileEntity;
        if (this.molten && (tileEntity = this.getTile()) instanceof ICrucibleAcceptor) {
            ICrucibleAcceptor acc = (ICrucibleAcceptor)tileEntity;
            return acc.flow(world, pos, side, stack);
        }
        return null;
    }
}

