/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity;

import com.hbm.interfaces.IKeypadHandler;
import com.hbm.lib.ForgeDirection;
import com.hbm.util.Keypad;
import com.hbm.util.KeypadClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class TileEntityKeypadBase
extends TileEntity
implements ITickable,
IKeypadHandler {
    public Keypad keypad = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? new Keypad(this) : this.makeClientKeypad();

    @SideOnly(value=Side.CLIENT)
    private Keypad makeClientKeypad() {
        return new KeypadClient(this, new Matrix4f());
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.setupKeypadClient();
        } else {
            NBTTagCompound nbt = this.keypad.writeToNbt(new NBTTagCompound());
            this.keypad = new Keypad(this);
            this.keypad.readFromNbt(nbt);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setupKeypadClient() {
        float rot = ForgeDirection.getOrientation(this.func_145832_p()).getRotationRadians();
        Matrix4f mat = new Matrix4f();
        mat.rotate(rot, new Vector3f(0.0f, 1.0f, 0.0f));
        mat.translate(new Vector3f(0.0f, 0.0f, -0.5f));
        this.keypad = new KeypadClient(this, mat);
    }

    public void func_73660_a() {
        this.keypad.update();
    }

    @Override
    public Keypad getKeypad() {
        return this.keypad;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.keypad.writeToNbt(compound);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.keypad.readFromNbt(compound);
        super.func_145839_a(compound);
    }
}

