/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.generic.BlockDoorGeneric;
import com.hbm.handler.RadiationSystemNT;
import com.hbm.interfaces.IAnimatedDoor;
import com.hbm.interfaces.IDoor;
import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.ControlEventSystem;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.IControllable;
import com.hbm.lib.ForgeDirection;
import com.hbm.main.MainRegistry;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEDoorAnimationPacket;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.DoorDecl;
import com.hbm.tileentity.machine.TileEntityLockableBase;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityDoorGeneric
extends TileEntityLockableBase
implements ITickable,
IAnimatedDoor,
IControllable {
    public IDoor.DoorState state = IDoor.DoorState.CLOSED;
    public DoorDecl doorType;
    public int openTicks = 0;
    public long animStartTime = 0L;
    public int redstonePower;
    public boolean shouldUseBB = false;
    public Set<BlockPos> activatedBlocks = new HashSet<BlockPos>(4);
    private AudioWrapper audio;
    private AudioWrapper audio2;
    private boolean toggledByPanel = false;

    public void func_73660_a() {
        if (this.doorType == null && this.func_145838_q() instanceof BlockDoorGeneric) {
            this.doorType = ((BlockDoorGeneric)this.func_145838_q()).type;
        }
        if (this.state == IDoor.DoorState.OPENING) {
            ++this.openTicks;
            if (this.openTicks >= this.doorType.timeToOpen()) {
                this.openTicks = this.doorType.timeToOpen();
            }
        } else if (this.state == IDoor.DoorState.CLOSING) {
            --this.openTicks;
            if (this.openTicks <= 0) {
                this.openTicks = 0;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            int[][] ranges = this.doorType.getDoorOpenRanges();
            ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
            if (this.state == IDoor.DoorState.OPENING) {
                for (int i = 0; i < ranges.length; ++i) {
                    int[] range = ranges[i];
                    BlockPos startPos = new BlockPos(range[0], range[1], range[2]);
                    float time = this.doorType.getDoorRangeOpenTime(this.openTicks, i);
                    for (int j = 0; j < Math.abs(range[3]) && !((float)j / (float)Math.abs(range[3] - 1) > time); ++j) {
                        for (int k = 0; k < range[4]; ++k) {
                            BlockPos finalPos;
                            BlockPos add = new BlockPos(0, 0, 0);
                            switch (EnumFacing.Axis.values()[range[5]]) {
                                case X: {
                                    add = new BlockPos(0.0, (double)k, (double)(Math.signum(range[3]) * (float)j));
                                    break;
                                }
                                case Y: {
                                    add = new BlockPos((double)k, (double)(Math.signum(range[3]) * (float)j), 0.0);
                                    break;
                                }
                                case Z: {
                                    add = new BlockPos((double)(Math.signum(range[3]) * (float)j), (double)k, 0.0);
                                }
                            }
                            Rotation r = dir.getBlockRotation();
                            if (dir.toEnumFacing().func_176740_k() == EnumFacing.Axis.X) {
                                r = r.func_185830_a(Rotation.CLOCKWISE_180);
                            }
                            if ((finalPos = startPos.func_177971_a((Vec3i)add).func_190942_a(r).func_177971_a((Vec3i)this.field_174879_c)).equals((Object)this.field_174879_c)) {
                                this.shouldUseBB = true;
                                continue;
                            }
                            ((BlockDummyable)this.func_145838_q()).makeExtra(this.field_145850_b, finalPos.func_177958_n(), finalPos.func_177956_o(), finalPos.func_177952_p());
                        }
                    }
                }
            } else if (this.state == IDoor.DoorState.CLOSING) {
                for (int i = 0; i < ranges.length; ++i) {
                    int[] range = ranges[i];
                    BlockPos startPos = new BlockPos(range[0], range[1], range[2]);
                    float time = this.doorType.getDoorRangeOpenTime(this.openTicks, i);
                    for (int j = Math.abs(range[3]) - 1; j >= 0 && !((float)j / (float)Math.abs(range[3] - 1) < time); --j) {
                        for (int k = 0; k < range[4]; ++k) {
                            BlockPos finalPos;
                            BlockPos add = new BlockPos(0, 0, 0);
                            switch (EnumFacing.Axis.values()[range[5]]) {
                                case X: {
                                    add = new BlockPos(0.0, (double)k, (double)(Math.signum(range[3]) * (float)j));
                                    break;
                                }
                                case Y: {
                                    add = new BlockPos((double)k, (double)(Math.signum(range[3]) * (float)j), 0.0);
                                    break;
                                }
                                case Z: {
                                    add = new BlockPos((double)(Math.signum(range[3]) * (float)j), (double)k, 0.0);
                                }
                            }
                            Rotation r = dir.getBlockRotation();
                            if (dir.toEnumFacing().func_176740_k() == EnumFacing.Axis.X) {
                                r = r.func_185830_a(Rotation.CLOCKWISE_180);
                            }
                            if ((finalPos = startPos.func_177971_a((Vec3i)add).func_190942_a(r).func_177971_a((Vec3i)this.field_174879_c)).equals((Object)this.field_174879_c)) {
                                this.shouldUseBB = false;
                                continue;
                            }
                            ((BlockDummyable)this.func_145838_q()).removeExtra(this.field_145850_b, finalPos.func_177958_n(), finalPos.func_177956_o(), finalPos.func_177952_p());
                        }
                    }
                }
            }
            if (this.state == IDoor.DoorState.OPENING && this.openTicks == this.doorType.timeToOpen()) {
                this.state = IDoor.DoorState.OPEN;
                this.broadcastControlEvt();
            }
            if (this.state == IDoor.DoorState.CLOSING && this.openTicks == 0) {
                this.state = IDoor.DoorState.CLOSED;
                this.broadcastControlEvt();
                RadiationSystemNT.markChunkForRebuild(this.field_145850_b, this.field_174879_c);
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new TEDoorAnimationPacket(this.field_174879_c, (byte)this.state.ordinal(), (byte)(this.shouldUseBB ? 1 : 0)), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
            if (this.redstonePower > 0) {
                this.tryOpen(-1);
            } else {
                this.tryClose(-1);
            }
            if (this.redstonePower == -1) {
                this.redstonePower = 0;
            }
            if (this.toggledByPanel) {
                this.tryOpen(-1);
            }
        }
    }

    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
        if (this.audio2 != null) {
            this.audio2.stopSound();
            this.audio2 = null;
        }
    }

    public void onLoad() {
        this.doorType = ((BlockDoorGeneric)this.func_145838_q()).type;
    }

    public boolean tryToggle(EntityPlayer player) {
        if (this.state == IDoor.DoorState.CLOSED) {
            if (!this.field_145850_b.field_72995_K) {
                this.open();
                this.broadcastControlEvt();
            }
            return true;
        }
        if (this.state == IDoor.DoorState.OPEN) {
            if (!this.field_145850_b.field_72995_K) {
                this.close();
                this.broadcastControlEvt();
            }
            return true;
        }
        return false;
    }

    public boolean tryOpen(int passcode) {
        if (this.isLocked() && passcode != this.lock) {
            return false;
        }
        if (this.state == IDoor.DoorState.CLOSED) {
            if (!this.field_145850_b.field_72995_K) {
                this.open();
                this.broadcastControlEvt();
            }
            return true;
        }
        return false;
    }

    public boolean tryToggle(int passcode) {
        if (this.state == IDoor.DoorState.CLOSED) {
            return this.tryOpen(passcode);
        }
        if (this.state == IDoor.DoorState.OPEN) {
            return this.tryClose(passcode);
        }
        return false;
    }

    public boolean tryClose(int passcode) {
        if (this.toggledByPanel) {
            return false;
        }
        if (this.isLocked() && passcode != this.lock) {
            return false;
        }
        if (this.state == IDoor.DoorState.OPEN) {
            if (!this.field_145850_b.field_72995_K) {
                this.close();
                this.broadcastControlEvt();
            }
            return true;
        }
        return false;
    }

    @Override
    public void open() {
        if (this.state == IDoor.DoorState.CLOSED) {
            this.toggle();
        }
    }

    @Override
    public void close() {
        if (this.state == IDoor.DoorState.OPEN) {
            this.toggle();
        }
    }

    @Override
    public IDoor.DoorState getState() {
        return this.state;
    }

    @Override
    public void toggle() {
        if (this.state == IDoor.DoorState.CLOSED) {
            this.state = IDoor.DoorState.OPENING;
            RadiationSystemNT.markChunkForRebuild(this.field_145850_b, this.field_174879_c);
        } else if (this.state == IDoor.DoorState.OPEN) {
            this.state = IDoor.DoorState.CLOSING;
            RadiationSystemNT.markChunkForRebuild(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleNewState(IDoor.DoorState newState) {
        if (this.state != newState) {
            if (this.state == IDoor.DoorState.CLOSED && newState == IDoor.DoorState.OPENING) {
                if (this.audio == null) {
                    this.audio = MainRegistry.proxy.getLoopedSoundStartStop(this.field_145850_b, this.doorType.getOpenSoundLoop(), this.doorType.getOpenSoundStart(), this.doorType.getOpenSoundEnd(), SoundCategory.BLOCKS, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.doorType.getSoundVolume(), 1.0f);
                    this.audio.startSound();
                }
                if (this.audio2 == null && this.doorType.getSoundLoop2() != null) {
                    this.audio2 = MainRegistry.proxy.getLoopedSoundStartStop(this.field_145850_b, this.doorType.getSoundLoop2(), null, null, SoundCategory.BLOCKS, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.doorType.getSoundVolume(), 1.0f);
                    this.audio2.startSound();
                }
            }
            if (this.state == IDoor.DoorState.OPEN && newState == IDoor.DoorState.CLOSING) {
                if (this.audio == null) {
                    this.audio = MainRegistry.proxy.getLoopedSoundStartStop(this.field_145850_b, this.doorType.getCloseSoundLoop(), this.doorType.getCloseSoundStart(), this.doorType.getCloseSoundEnd(), SoundCategory.BLOCKS, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.doorType.getSoundVolume(), 1.0f);
                    this.audio.startSound();
                }
                if (this.audio2 == null && this.doorType.getSoundLoop2() != null) {
                    this.audio2 = MainRegistry.proxy.getLoopedSoundStartStop(this.field_145850_b, this.doorType.getSoundLoop2(), null, null, SoundCategory.BLOCKS, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.doorType.getSoundVolume(), 1.0f);
                    this.audio2.startSound();
                }
            }
            if (this.state.isMovingState() && newState.isStationaryState()) {
                if (this.audio != null) {
                    this.audio.stopSound();
                    this.audio = null;
                }
                if (this.audio2 != null) {
                    this.audio2.stopSound();
                    this.audio2 = null;
                }
            }
            this.state = newState;
            if (newState.isMovingState()) {
                this.animStartTime = System.currentTimeMillis();
            }
        }
    }

    @Override
    public void setTextureState(byte tex) {
        this.shouldUseBB = tex > 0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.state = IDoor.DoorState.values()[tag.func_74771_c("state")];
        this.openTicks = tag.func_74762_e("openTicks");
        this.animStartTime = tag.func_74762_e("animStartTime");
        this.redstonePower = tag.func_74762_e("redstoned");
        this.shouldUseBB = tag.func_74767_n("shouldUseBB");
        NBTTagCompound activatedBlocks = tag.func_74775_l("activatedBlocks");
        this.activatedBlocks.clear();
        for (int i = 0; i < activatedBlocks.func_150296_c().size() / 3; ++i) {
            this.activatedBlocks.add(new BlockPos(activatedBlocks.func_74762_e("x" + i), activatedBlocks.func_74762_e("y" + i), activatedBlocks.func_74762_e("z" + i)));
        }
        super.func_145839_a(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74774_a("state", (byte)this.state.ordinal());
        tag.func_74768_a("openTicks", this.openTicks);
        tag.func_74772_a("animStartTime", this.animStartTime);
        tag.func_74768_a("redstoned", this.redstonePower);
        tag.func_74757_a("shouldUseBB", this.shouldUseBB);
        NBTTagCompound activatedBlocks = new NBTTagCompound();
        int i = 0;
        for (BlockPos p : this.activatedBlocks) {
            activatedBlocks.func_74768_a("x" + i, p.func_177958_n());
            activatedBlocks.func_74768_a("y" + i, p.func_177956_o());
            activatedBlocks.func_74768_a("z" + i, p.func_177952_p());
            ++i;
        }
        tag.func_74782_a("activatedBlocks", (NBTBase)activatedBlocks);
        return super.func_189515_b(tag);
    }

    public void broadcastControlEvt() {
        ControlEventSystem.get(this.field_145850_b).broadcastToSubscribed(this, ControlEvent.newEvent("door_open_state").setVar("state", new DataValueFloat(this.state.ordinal())));
    }

    @Override
    public void receiveEvent(BlockPos from, ControlEvent e) {
        if (e.name.equals("door_toggle") && (!this.isLocked() || this.isLocked() && e.vars.get("passcode").getNumber() == (float)this.lock)) {
            this.toggledByPanel = !this.toggledByPanel;
        }
    }

    @Override
    public List<String> getInEvents() {
        return Arrays.asList("door_toggle");
    }

    @Override
    public List<String> getOutEvents() {
        return Arrays.asList("door_open_state");
    }

    public void func_145829_t() {
        super.func_145829_t();
        ControlEventSystem.get(this.field_145850_b).addControllable(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
        if (this.audio2 != null) {
            this.audio2.stopSound();
            this.audio2 = null;
        }
        ControlEventSystem.get(this.field_145850_b).removeControllable(this);
    }

    @Override
    public BlockPos getControlPos() {
        return this.func_174877_v();
    }

    @Override
    public World getControlWorld() {
        return this.func_145831_w();
    }

    public void updateRedstonePower(BlockPos pos) {
        boolean powered = this.field_145850_b.func_175687_A(pos) > 0;
        boolean contained = this.activatedBlocks.contains(pos);
        if (!contained && powered) {
            this.activatedBlocks.add(pos);
            if (this.redstonePower == -1) {
                this.redstonePower = 0;
            }
            ++this.redstonePower;
        } else if (contained && !powered) {
            this.activatedBlocks.remove(pos);
            --this.redstonePower;
            if (this.redstonePower == 0) {
                this.redstonePower = -1;
            }
        }
    }
}

