/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity;

import com.hbm.animloader.AnimatedModel;
import com.hbm.animloader.Animation;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.main.ResourceManager;
import com.hbm.render.WavefrontObjDisplayList;
import com.hbm.util.BobMathUtil;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public abstract class DoorDecl {
    public static final DoorDecl TRANSITION_SEAL = new DoorDecl(){

        @Override
        public SoundEvent getOpenSoundStart() {
            return HBMSoundHandler.transitionSealOpen;
        }

        @Override
        public float getSoundVolume() {
            return 6.0f;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if (!partName.equals("base")) {
                this.set(trans, 0.0f, 3.5f * this.getNormTime(openTicks), 0.0f);
            } else {
                super.getTranslation(partName, openTicks, child, trans);
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void doOffsetTransform() {
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.5);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public double[][] getClippingPlanes() {
            return super.getClippingPlanes();
        }

        @Override
        public int timeToOpen() {
            return 480;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{-9, 2, 0, 20, 20, 1}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{23, 0, 0, 0, 13, 12};
        }

        @Override
        public AxisAlignedBB getBlockBound(BlockPos relPos, boolean open) {
            return super.getBlockBound(relPos, open);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getTextureForPart(String partName) {
            return ResourceManager.transition_seal_tex;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Animation getAnim() {
            return ResourceManager.transition_seal_anim;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public AnimatedModel getAnimatedModel() {
            return ResourceManager.transition_seal;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public WavefrontObjDisplayList getModel() {
            return null;
        }
    };
    public static final DoorDecl SLIDING_SEAL_DOOR = new DoorDecl(){

        @Override
        public SoundEvent getOpenSoundEnd() {
            return HBMSoundHandler.nullMine;
        }

        @Override
        public SoundEvent getOpenSoundStart() {
            return HBMSoundHandler.sliding_seal_open;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if (partName.startsWith("door")) {
                this.set(trans, 0.0f, 0.0f, Library.smoothstep(this.getNormTime(openTicks), 0.0f, 1.0f));
            } else {
                this.set(trans, 0.0f, 0.0f, 0.0f);
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public double[][] getClippingPlanes() {
            return new double[][]{{0.0, 0.0, -1.0, 0.5001}};
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void doOffsetTransform() {
            GL11.glTranslated((double)0.375, (double)0.0, (double)0.0);
        }

        @Override
        public int timeToOpen() {
            return 15;
        }

        @Override
        public AxisAlignedBB getBlockBound(BlockPos relPos, boolean open) {
            if (open) {
                if (relPos.func_177956_o() == 0) {
                    return new AxisAlignedBB(0.0, 0.0, 0.75, 1.0, 0.125, 1.0);
                }
                return super.getBlockBound(relPos, open);
            }
            return new AxisAlignedBB(0.0, 0.0, 0.75, 1.0, 1.0, 1.0);
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{0, 0, 0, 1, 2, 2}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{1, 0, 0, 0, 0, 0};
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getTextureForPart(String partName) {
            return ResourceManager.sliding_seal_door_tex;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public WavefrontObjDisplayList getModel() {
            return ResourceManager.sliding_seal_door;
        }
    };
    public static final DoorDecl SLIDING_GATE_DOOR = new DoorDecl(){

        @Override
        public SoundEvent getOpenSoundEnd() {
            return HBMSoundHandler.sliding_seal_stop;
        }

        @Override
        public SoundEvent getOpenSoundStart() {
            return HBMSoundHandler.sliding_seal_open;
        }

        @Override
        public float getSoundVolume() {
            return 3.0f;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if (partName.startsWith("door")) {
                this.set(trans, 0.0f, 0.0f, Library.smoothstep(this.getNormTime(openTicks), 0.0f, 1.0f));
            } else {
                this.set(trans, 0.0f, 0.0f, 0.0f);
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public double[][] getClippingPlanes() {
            return new double[][]{{0.0, 0.0, -1.0, 0.5001}};
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void doOffsetTransform() {
            GL11.glTranslated((double)0.375, (double)0.0, (double)0.0);
        }

        @Override
        public int timeToOpen() {
            return 28;
        }

        @Override
        public AxisAlignedBB getBlockBound(BlockPos relPos, boolean open) {
            if (open) {
                if (relPos.func_177956_o() == 0) {
                    return new AxisAlignedBB(0.0, 0.0, 0.75, 1.0, 0.125, 1.0);
                }
                return super.getBlockBound(relPos, open);
            }
            return new AxisAlignedBB(0.0, 0.0, 0.75, 1.0, 1.0, 1.0);
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{0, 0, 0, 1, 2, 2}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{1, 0, 0, 0, 0, 0};
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getTextureForPart(String partName) {
            return ResourceManager.sliding_gate_door_tex;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public WavefrontObjDisplayList getModel() {
            return ResourceManager.sliding_seal_door;
        }
    };
    public static final DoorDecl SECURE_ACCESS_DOOR = new DoorDecl(){

        @Override
        public SoundEvent getOpenSoundEnd() {
            return HBMSoundHandler.garage_stop;
        }

        @Override
        public SoundEvent getOpenSoundLoop() {
            return HBMSoundHandler.garage;
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if (!partName.equals("base")) {
                this.set(trans, 0.0f, 3.5f * this.getNormTime(openTicks), 0.0f);
            } else {
                super.getTranslation(partName, openTicks, child, trans);
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void doOffsetTransform() {
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public double[][] getClippingPlanes() {
            return new double[][]{{0.0, -1.0, 0.0, 5.0}};
        }

        @Override
        public int timeToOpen() {
            return 120;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{-2, 1, 0, 4, 5, 1}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{4, 0, 0, 0, 2, 2};
        }

        @Override
        public AxisAlignedBB getBlockBound(BlockPos relPos, boolean open) {
            if (!open) {
                if (relPos.func_177956_o() > 0) {
                    return new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
                }
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
            if (relPos.func_177956_o() == 1) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
            }
            if (relPos.func_177956_o() == 4) {
                return new AxisAlignedBB(0.0, 0.5, 0.15, 1.0, 1.0, 0.85);
            }
            return super.getBlockBound(relPos, open);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getTextureForPart(String partName) {
            return ResourceManager.secure_access_door_tex;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public WavefrontObjDisplayList getModel() {
            return ResourceManager.secure_access_door;
        }
    };
    public static final DoorDecl ROUND_AIRLOCK_DOOR = new DoorDecl(){

        @Override
        public SoundEvent getOpenSoundEnd() {
            return HBMSoundHandler.garage_stop;
        }

        @Override
        public SoundEvent getOpenSoundLoop() {
            return HBMSoundHandler.garage;
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if ("doorLeft".equals(partName)) {
                this.set(trans, 0.0f, 0.0f, 1.5f * this.getNormTime(openTicks));
            } else if ("doorRight".equals(partName)) {
                this.set(trans, 0.0f, 0.0f, -1.5f * this.getNormTime(openTicks));
            } else {
                super.getTranslation(partName, openTicks, child, trans);
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void doOffsetTransform() {
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.5);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public double[][] getClippingPlanes() {
            return new double[][]{{0.0, 0.0, 1.0, 2.0001}, {0.0, 0.0, -1.0, 2.0001}};
        }

        @Override
        public AxisAlignedBB getBlockBound(BlockPos relPos, boolean open) {
            if (!open) {
                return super.getBlockBound(relPos, open);
            }
            if (relPos.func_177952_p() == 1) {
                return new AxisAlignedBB(0.4, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
            if (relPos.func_177952_p() == -2) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 0.6, 1.0, 1.0);
            }
            if (relPos.func_177956_o() == 3) {
                return new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
            }
            if (relPos.func_177956_o() == 0) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
            }
            return super.getBlockBound(relPos, open);
        }

        @Override
        public int timeToOpen() {
            return 60;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{0, 0, 0, -2, 4, 2}, {0, 0, 0, 3, 4, 2}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{3, 0, 0, 0, 2, 1};
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getTextureForPart(String partName) {
            return ResourceManager.round_airlock_door_tex;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public WavefrontObjDisplayList getModel() {
            return ResourceManager.round_airlock_door;
        }
    };
    public static final DoorDecl HATCH = new DoorDecl(){

        @Override
        public SoundEvent getOpenSoundStart() {
            return HBMSoundHandler.hatch_open;
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getRotation(String partName, float openTicks, float[] rot) {
            if (partName.equals("hatch")) {
                this.set(rot, Library.smoothstep(this.getNormTime(openTicks, 15.0f, 30.0f), 0.0f, 1.0f) * 90.0f - 90.0f, 0.0f, 0.0f);
                return;
            }
            if (partName.equals("spinny")) {
                this.set(rot, 0.0f, 0.0f, Library.smoothstep(this.getNormTime(openTicks, 0.0f, 15.0f), 0.0f, 1.0f) * 360.0f);
                return;
            }
            this.set(rot, 0.0f, 0.0f, 0.0f);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getOrigin(String partName, float[] orig) {
            if (partName.equals("hatch")) {
                this.set(orig, 0.0f, 1.03157f, 0.591647f);
                return;
            }
            if (partName.equals("spinny")) {
                this.set(orig, 0.0f, 1.62322f, 0.434233f);
                return;
            }
            super.getOrigin(partName, orig);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public String[] getChildren(String partName) {
            if (partName.equals("hatch")) {
                return new String[]{"spinny"};
            }
            return super.getChildren(partName);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean doesRender(String partName, boolean child) {
            if (partName.equals("spinny")) {
                return child;
            }
            return true;
        }

        @Override
        public AxisAlignedBB getBlockBound(BlockPos relPos, boolean open) {
            if (open) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
            }
            return super.getBlockBound(relPos, open);
        }

        @Override
        public int timeToOpen() {
            return 30;
        }

        @Override
        public boolean isLadder(boolean open) {
            return open;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void doOffsetTransform() {
            GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{0, 0, 0, 1, 1, 1}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{0, 0, 0, 0, 0, 0};
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getTextureForPart(String partName) {
            return ResourceManager.small_hatch_tex;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public WavefrontObjDisplayList getModel() {
            return ResourceManager.small_hatch;
        }
    };
    public static final DoorDecl FIRE_DOOR = new DoorDecl(){

        @Override
        public SoundEvent getOpenSoundEnd() {
            return HBMSoundHandler.wgh_stop;
        }

        @Override
        public SoundEvent getOpenSoundLoop() {
            return HBMSoundHandler.wgh_start;
        }

        @Override
        public SoundEvent getSoundLoop2() {
            return HBMSoundHandler.alarm6;
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if (!partName.equals("frame")) {
                this.set(trans, 0.0f, 3.0f * this.getNormTime(openTicks), 0.0f);
            } else {
                super.getTranslation(partName, openTicks, child, trans);
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void doOffsetTransform() {
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.5);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public double[][] getClippingPlanes() {
            return new double[][]{{0.0, -1.0, 0.0, 3.0001}};
        }

        @Override
        public int timeToOpen() {
            return 160;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{-1, 0, 0, 3, 4, 1}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{2, 0, 0, 0, 2, 1};
        }

        @Override
        public AxisAlignedBB getBlockBound(BlockPos relPos, boolean open) {
            if (!open) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
            if (relPos.func_177952_p() == 1) {
                return new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
            if (relPos.func_177952_p() == -2) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0);
            }
            if (relPos.func_177956_o() > 1) {
                return new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
            }
            if (relPos.func_177956_o() == 0) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1, 1.0);
            }
            return super.getBlockBound(relPos, open);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getTextureForPart(String partName) {
            return ResourceManager.fire_door_tex;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public WavefrontObjDisplayList getModel() {
            return ResourceManager.fire_door;
        }
    };
    public static final DoorDecl QE_SLIDING = new DoorDecl(){

        @Override
        public SoundEvent getOpenSoundEnd() {
            return HBMSoundHandler.qe_sliding_opened;
        }

        @Override
        public SoundEvent getCloseSoundEnd() {
            return HBMSoundHandler.qe_sliding_shut;
        }

        @Override
        public SoundEvent getOpenSoundLoop() {
            return HBMSoundHandler.qe_sliding_opening;
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if (partName.startsWith("left")) {
                this.set(trans, 0.0f, 0.0f, 1.0f * this.getNormTime(openTicks));
            } else {
                this.set(trans, 0.0f, 0.0f, -1.0f * this.getNormTime(openTicks));
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void doOffsetTransform() {
            GL11.glTranslated((double)0.4375, (double)0.0, (double)0.5);
        }

        @Override
        public int timeToOpen() {
            return 10;
        }

        @Override
        public AxisAlignedBB getBlockBound(BlockPos relPos, boolean open) {
            if (open) {
                if (relPos.func_177952_p() == 0) {
                    return new AxisAlignedBB(0.875, 0.0, 0.875, 1.0, 1.0, 1.0);
                }
                return new AxisAlignedBB(0.0, 0.0, 0.875, 0.125, 1.0, 1.0);
            }
            return new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{0, 0, 0, 2, 2, 2}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{1, 0, 0, 0, 1, 0};
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getTextureForPart(String partName) {
            return ResourceManager.qe_sliding_door_tex;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public WavefrontObjDisplayList getModel() {
            return ResourceManager.qe_sliding_door;
        }
    };
    public static final DoorDecl QE_CONTAINMENT = new DoorDecl(){

        @Override
        public SoundEvent getOpenSoundEnd() {
            return HBMSoundHandler.wgh_stop;
        }

        @Override
        public SoundEvent getOpenSoundLoop() {
            return HBMSoundHandler.wgh_start;
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if (!partName.equals("frame")) {
                this.set(trans, 0.0f, 3.0f * this.getNormTime(openTicks), 0.0f);
            } else {
                super.getTranslation(partName, openTicks, child, trans);
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void doOffsetTransform() {
            GL11.glTranslated((double)0.25, (double)0.0, (double)0.0);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public double[][] getClippingPlanes() {
            return new double[][]{{0.0, -1.0, 0.0, 3.0001}};
        }

        @Override
        public int timeToOpen() {
            return 160;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{-1, 0, 0, 3, 3, 1}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{2, 0, 0, 0, 1, 1};
        }

        @Override
        public AxisAlignedBB getBlockBound(BlockPos relPos, boolean open) {
            if (!open) {
                return new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0);
            }
            if (relPos.func_177956_o() > 1) {
                return new AxisAlignedBB(0.0, 0.5, 0.5, 1.0, 1.0, 1.0);
            }
            if (relPos.func_177956_o() == 0) {
                return new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.1, 1.0);
            }
            return super.getBlockBound(relPos, open);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getTextureForPart(String partName) {
            if (partName.equals("decal")) {
                return ResourceManager.qe_containment_decal;
            }
            return ResourceManager.qe_containment_tex;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public WavefrontObjDisplayList getModel() {
            return ResourceManager.qe_containment_door;
        }
    };
    public static final DoorDecl WATER_DOOR = new DoorDecl(){

        @Override
        public SoundEvent getOpenSoundEnd() {
            return HBMSoundHandler.wgh_big_stop;
        }

        @Override
        public SoundEvent getOpenSoundLoop() {
            return HBMSoundHandler.wgh_big_start;
        }

        @Override
        public SoundEvent getOpenSoundStart() {
            return HBMSoundHandler.door_spinny;
        }

        @Override
        public SoundEvent getCloseSoundStart() {
            return null;
        }

        @Override
        public SoundEvent getCloseSoundEnd() {
            return HBMSoundHandler.door_spinny;
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if ("bolt".equals(partName)) {
                this.set(trans, 0.0f, 0.0f, 0.4f * Library.smoothstep(this.getNormTime(openTicks, 0.0f, 30.0f), 0.0f, 1.0f));
            } else {
                this.set(trans, 0.0f, 0.0f, 0.0f);
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void doOffsetTransform() {
            GL11.glTranslated((double)0.375, (double)0.0, (double)0.0);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getOrigin(String partName, float[] orig) {
            if ("door".equals(partName) || "bolt".equals(partName)) {
                this.set(orig, 0.125f, 1.5f, 1.18f);
                return;
            }
            if ("spinny_upper".equals(partName)) {
                this.set(orig, 0.041499f, 2.43569f, -0.587849f);
                return;
            }
            if ("spinny_lower".equals(partName)) {
                this.set(orig, 0.041499f, 0.571054f, -0.587849f);
                return;
            }
            super.getOrigin(partName, orig);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getRotation(String partName, float openTicks, float[] rot) {
            if (partName.startsWith("spinny")) {
                this.set(rot, Library.smoothstep(this.getNormTime(openTicks, 0.0f, 30.0f), 0.0f, 1.0f) * 360.0f, 0.0f, 0.0f);
                return;
            }
            if ("door".equals(partName) || "bolt".equals(partName)) {
                this.set(rot, 0.0f, Library.smoothstep(this.getNormTime(openTicks, 30.0f, 60.0f), 0.0f, 1.0f) * -134.0f, 0.0f);
                return;
            }
            super.getRotation(partName, openTicks, rot);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean doesRender(String partName, boolean child) {
            return child || !partName.startsWith("spinny");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public String[] getChildren(String partName) {
            if ("door".equals(partName)) {
                return new String[]{"spinny_lower", "spinny_upper"};
            }
            return super.getChildren(partName);
        }

        @Override
        public AxisAlignedBB getBlockBound(BlockPos relPos, boolean open) {
            if (!open) {
                return new AxisAlignedBB(0.0, 0.0, 0.75, 1.0, 1.0, 1.0);
            }
            if (relPos.func_177956_o() > 1) {
                return new AxisAlignedBB(0.0, 0.85, 0.75, 1.0, 1.0, 1.0);
            }
            if (relPos.func_177956_o() == 0) {
                return new AxisAlignedBB(0.0, 0.0, 0.75, 1.0, 0.15, 1.0);
            }
            return super.getBlockBound(relPos, open);
        }

        @Override
        public int timeToOpen() {
            return 60;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{1, 0, 0, -3, 3, 2}};
        }

        @Override
        public float getDoorRangeOpenTime(int ticks, int idx) {
            return this.getNormTime(ticks, 35.0f, 40.0f);
        }

        @Override
        public int[] getDimensions() {
            return new int[]{2, 0, 0, 0, 1, 1};
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getTextureForPart(String partName) {
            return ResourceManager.water_door_tex;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public WavefrontObjDisplayList getModel() {
            return ResourceManager.water_door;
        }
    };
    public static final DoorDecl LARGE_VEHICLE_DOOR = new DoorDecl(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if ("doorLeft".equals(partName)) {
                this.set(trans, 0.0f, 0.0f, 3.0f * this.getNormTime(openTicks));
            } else if ("doorRight".equals(partName)) {
                this.set(trans, 0.0f, 0.0f, -3.0f * this.getNormTime(openTicks));
            } else {
                super.getTranslation(partName, openTicks, child, trans);
            }
        }

        @Override
        public SoundEvent getOpenSoundEnd() {
            return HBMSoundHandler.garage_stop;
        }

        @Override
        public SoundEvent getOpenSoundLoop() {
            return HBMSoundHandler.garage;
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public double[][] getClippingPlanes() {
            return new double[][]{{0.0, 0.0, 1.0, 3.50001}, {0.0, 0.0, -1.0, 3.50001}};
        }

        @Override
        public AxisAlignedBB getBlockBound(BlockPos relPos, boolean open) {
            if (!open) {
                return super.getBlockBound(relPos, open);
            }
            if (relPos.func_177952_p() == 3) {
                return new AxisAlignedBB(0.4, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
            if (relPos.func_177952_p() == -3) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 0.6, 1.0, 1.0);
            }
            return super.getBlockBound(relPos, open);
        }

        @Override
        public int timeToOpen() {
            return 60;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{0, 0, 0, -4, 6, 2}, {0, 0, 0, 4, 6, 2}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{5, 0, 0, 0, 3, 3};
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getTextureForPart(String partName) {
            return ResourceManager.large_vehicle_door_tex;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public WavefrontObjDisplayList getModel() {
            return ResourceManager.large_vehicle_door;
        }
    };
    private static final String[] nothing = new String[0];

    public abstract int[][] getDoorOpenRanges();

    public abstract int[] getDimensions();

    public float getDoorRangeOpenTime(int ticks, int idx) {
        return this.getNormTime(ticks);
    }

    public int timeToOpen() {
        return 20;
    }

    public float getNormTime(float time) {
        return this.getNormTime(time, 0.0f, this.timeToOpen());
    }

    public float getNormTime(float time, float min, float max) {
        return BobMathUtil.remap01_clamp(time, min, max);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract ResourceLocation getTextureForPart(String var1);

    @SideOnly(value=Side.CLIENT)
    public abstract WavefrontObjDisplayList getModel();

    @SideOnly(value=Side.CLIENT)
    public AnimatedModel getAnimatedModel() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Animation getAnim() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
        this.set(trans, 0.0f, 0.0f, 0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void getRotation(String partName, float openTicks, float[] rot) {
        this.set(rot, 0.0f, 0.0f, 0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void getOrigin(String partName, float[] orig) {
        this.set(orig, 0.0f, 0.0f, 0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doesRender(String partName, boolean child) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public String[] getChildren(String partName) {
        return nothing;
    }

    @SideOnly(value=Side.CLIENT)
    public double[][] getClippingPlanes() {
        return new double[0][];
    }

    @SideOnly(value=Side.CLIENT)
    public void doOffsetTransform() {
    }

    public AxisAlignedBB getBlockBound(BlockPos relPos, boolean open) {
        return open ? new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0) : Block.field_185505_j;
    }

    public boolean isLadder(boolean open) {
        return false;
    }

    public SoundEvent getOpenSoundLoop() {
        return null;
    }

    public SoundEvent getSoundLoop2() {
        return null;
    }

    public SoundEvent getCloseSoundLoop() {
        return this.getOpenSoundLoop();
    }

    public SoundEvent getOpenSoundStart() {
        return null;
    }

    public SoundEvent getCloseSoundStart() {
        return this.getOpenSoundStart();
    }

    public SoundEvent getOpenSoundEnd() {
        return null;
    }

    public SoundEvent getCloseSoundEnd() {
        return this.getOpenSoundEnd();
    }

    public float getSoundVolume() {
        return 1.0f;
    }

    public float[] set(float[] f, float x, float y, float z) {
        f[0] = x;
        f[1] = y;
        f[2] = z;
        return f;
    }
}

