/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.util;

import glmath.glm.vec._3.d.Vec3d;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class ViewModelPositonDebugger {
    static boolean debug = false;
    static boolean blockInput = false;
    public Map<ItemCameraTransforms.TransformType, offset> offsetMap = new HashMap<ItemCameraTransforms.TransformType, offset>();
    protected int debugIndex = 0;

    public ViewModelPositonDebugger() {
        for (ItemCameraTransforms.TransformType transform : ItemCameraTransforms.TransformType.values()) {
            offset offset2 = new offset(this);
            offset2.scale = 0.25;
            this.offsetMap.put(transform, offset2);
            if (transform == ItemCameraTransforms.TransformType.NONE) {
                offset2.setScale(1.0);
            }
            if (transform == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
                offset2.setScale(1.0);
            }
            if (transform == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
                offset2.setScale(1.0);
            }
            if (transform != ItemCameraTransforms.TransformType.FIXED) continue;
            offset2.setScale(1.0);
        }
    }

    public offset get(ItemCameraTransforms.TransformType transform) {
        return this.offsetMap.get(transform);
    }

    public void applyCustomOffset(offset offset2) {
        GlStateManager.func_179139_a((double)offset2.scale, (double)offset2.scale, (double)offset2.scale);
        GlStateManager.func_179137_b((double)(-offset2.position.x), (double)offset2.position.y, (double)offset2.position.z);
        GL11.glRotated((double)(-offset2.rotation.y), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)offset2.rotation.x, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)(-offset2.rotation.z), (double)0.0, (double)0.0, (double)1.0);
    }

    protected void render(ItemCameraTransforms.TransformType type) {
        offset offset2 = this.offsetMap.get(type);
        this.applyCustomOffset(offset2);
    }

    public void apply(ItemCameraTransforms.TransformType type) {
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        switch (type) {
            case FIRST_PERSON_LEFT_HAND: {
                this.render(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                this.render(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
                break;
            }
            case FIXED: {
                this.render(ItemCameraTransforms.TransformType.GUI);
            }
        }
        this.render(type);
        this.render(ItemCameraTransforms.TransformType.NONE);
        if (debug) {
            this.tickDebug();
        }
    }

    protected void tickDebug() {
        boolean[] inputs = new boolean[]{Keyboard.isKeyDown((int)200), Keyboard.isKeyDown((int)203), Keyboard.isKeyDown((int)208), Keyboard.isKeyDown((int)205), Keyboard.isKeyDown((int)23), Keyboard.isKeyDown((int)36), Keyboard.isKeyDown((int)37), Keyboard.isKeyDown((int)38), Keyboard.isKeyDown((int)57), Keyboard.isKeyDown((int)54), Keyboard.isKeyDown((int)157), Keyboard.isKeyDown((int)26), Keyboard.isKeyDown((int)27)};
        boolean doUnblock = true;
        for (boolean input : inputs) {
            if (!input) continue;
            doUnblock = false;
            break;
        }
        if (doUnblock) {
            blockInput = false;
        }
        if (!blockInput) {
            if (!doUnblock) {
                blockInput = true;
            }
            if (inputs[9]) {
                ++this.debugIndex;
            }
            if (inputs[10]) {
                --this.debugIndex;
            }
            this.debugIndex = Math.floorMod(this.debugIndex, ItemCameraTransforms.TransformType.values().length);
            ItemCameraTransforms.TransformType curTransform = ItemCameraTransforms.TransformType.values()[this.debugIndex];
            offset offset2 = this.offsetMap.get(curTransform);
            double increment = 0.25;
            double incrementAngle = 5.0;
            double incrementScale = 0.05;
            boolean damn = Keyboard.isKeyDown((int)29);
            if (Keyboard.isKeyDown((int)15)) {
                increment = 0.05;
                incrementAngle = 1.0;
                incrementScale = 0.01;
            }
            if (inputs[8] || inputs[9] || inputs[10]) {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146231_a(false);
                player.func_145747_a(new TextComponentString("-- Current Grip --").func_150255_a(new Style().func_150238_a(TextFormatting.LIGHT_PURPLE)));
                player.func_145747_a((ITextComponent)new TextComponentString(String.format(" Scale: %01.2f", offset2.scale)));
                player.func_145747_a((ITextComponent)new TextComponentString(String.format(" Position: %01.2f, %01.2f, %01.2f", offset2.position.x, offset2.position.y, offset2.position.z)));
                player.func_145747_a((ITextComponent)new TextComponentString(String.format(" Rotation: %01.0f, %01.0f, %01.0f", offset2.rotation.x, offset2.rotation.y, offset2.rotation.z)));
                player.func_145747_a(new TextComponentString(" Type: " + (curTransform == ItemCameraTransforms.TransformType.NONE ? "CUSTOM" : curTransform.name())).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
            }
            if (inputs[11]) {
                offset2.scale += incrementScale;
            }
            if (inputs[12]) {
                offset2.scale -= incrementScale;
            }
            if (inputs[0]) {
                offset2.position = offset2.position.add(0.0, damn ? 0.0 : increment, damn ? increment : 0.0);
            }
            if (inputs[2]) {
                offset2.position = offset2.position.add(0.0, damn ? 0.0 : -increment, damn ? -increment : 0.0);
            }
            if (inputs[1]) {
                offset2.position = offset2.position.add(-increment, 0.0, 0.0);
            }
            if (inputs[3]) {
                offset2.position = offset2.position.add(increment, 0.0, 0.0);
            }
            if (inputs[4]) {
                offset2.rotation = offset2.rotation.add(incrementAngle, 0.0, 0.0);
            }
            if (inputs[6]) {
                offset2.rotation = offset2.rotation.add(-incrementAngle, 0.0, 0.0);
            }
            if (inputs[5]) {
                offset2.rotation = offset2.rotation.add(0.0, damn ? 0.0 : -incrementAngle, damn ? incrementAngle : 0.0);
            }
            if (inputs[7]) {
                offset2.rotation = offset2.rotation.add(0.0, damn ? 0.0 : incrementAngle, damn ? -incrementAngle : 0.0);
            }
        }
    }

    public static class offset {
        public double scale = 1.0;
        public Vec3d rotation = new Vec3d(0, 0, 0);
        public Vec3d position = new Vec3d(0, 0, 0);
        protected ViewModelPositonDebugger helper;

        public offset(ViewModelPositonDebugger helper) {
            this.helper = helper;
        }

        public offset setPosition(double x, double y, double z) {
            this.position = new Vec3d(x, y, z);
            return this;
        }

        public offset setRotation(double x, double y, double z) {
            this.rotation = new Vec3d(x, y, z);
            return this;
        }

        public offset setScale(double scale) {
            this.scale = scale;
            return this;
        }

        public ViewModelPositonDebugger getHelper() {
            return this.helper;
        }
    }
}

