/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.util;

import com.hbm.util.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class RenderOverhead {
    public static final HashMap<BlockPos, Marker> queuedMarkers = new HashMap();
    private static final HashMap<BlockPos, Marker> markers = new HashMap();

    public static void renderTag(EntityLivingBase living, double x, double y, double z, RenderLivingBase renderer, String name, boolean depthTest) {
        EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        if (RenderOverhead.shouldRenderTag(living)) {
            float range;
            float f = 1.6f;
            double distSq = living.func_70068_e((Entity)thePlayer);
            float f2 = range = living.func_70093_af() ? RenderLivingBase.NAME_TAG_RANGE_SNEAK : RenderLivingBase.NAME_TAG_RANGE;
            if (distSq < (double)(range * range)) {
                String s = name;
                RenderOverhead.drawTagAware(living, x, y, z, name, depthTest);
            }
        }
    }

    protected static boolean shouldRenderTag(EntityLivingBase p_110813_1_) {
        return Minecraft.func_71382_s() && p_110813_1_ != Minecraft.func_71410_x().field_71439_g && !p_110813_1_.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g) && !p_110813_1_.func_184207_aI();
    }

    protected static void drawTagAware(EntityLivingBase entity, double x, double y, double z, String string, boolean depthTest) {
        if (entity.func_70608_bn()) {
            RenderOverhead.drawTag((Entity)entity, string, x, y - 1.5, z, 64, depthTest);
        } else {
            RenderOverhead.drawTag((Entity)entity, string, x, y, z, 64, depthTest);
        }
    }

    public static void drawTag(Entity entity, String name, double x, double y, double z, int dist, boolean depthTest) {
        RenderOverhead.drawTag(entity.field_70131_O + 0.75f, entity.func_70068_e((Entity)Minecraft.func_71410_x().field_71439_g), name, x, y, z, dist, depthTest, -1, 0x20FFFFFF);
    }

    protected static void drawTag(float offset2, double distsq, String name, double x, double y, double z, int dist, boolean depthTest, int color, int shadowColor) {
        if (distsq <= (double)(dist * dist)) {
            FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
            float f = 1.6f;
            float scale = 0.016666668f * f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y + offset2), (float)((float)z));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)Minecraft.func_71410_x().func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(-scale), (float)(-scale), (float)scale);
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((boolean)false);
            if (depthTest) {
                GlStateManager.func_179097_i();
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buf = tessellator.func_178180_c();
            int heightOffset = 0;
            if (name.equals("deadmau5")) {
                heightOffset = -10;
            }
            GlStateManager.func_179090_x();
            buf.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            int center = fontrenderer.func_78256_a(name) / 2;
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f);
            buf.func_181662_b((double)(-center - 1), (double)(-1 + heightOffset), 0.0).func_181675_d();
            buf.func_181662_b((double)(-center - 1), (double)(8 + heightOffset), 0.0).func_181675_d();
            buf.func_181662_b((double)(center + 1), (double)(8 + heightOffset), 0.0).func_181675_d();
            buf.func_181662_b((double)(center + 1), (double)(-1 + heightOffset), 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            fontrenderer.func_78276_b(name, -fontrenderer.func_78256_a(name) / 2, heightOffset, shadowColor);
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            fontrenderer.func_78276_b(name, -fontrenderer.func_78256_a(name) / 2, heightOffset, color);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    public static void renderThermalSight(float partialTicks) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double x = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double y = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double z = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        GL11.glPushMatrix();
        GlStateManager.func_179119_h();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GL11.glEnable((int)2832);
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        for (Object o : player.field_70170_p.field_72996_f) {
            Entity ent = (Entity)o;
            if (ent == player || ent.func_70068_e((Entity)player) > 4096.0) continue;
            float b = 1.0f;
            float g = 1.0f;
            float r = 1.0f;
            if (ent instanceof IMob) {
                r = 1.0f;
                g = 0.0f;
                b = 0.0f;
            } else if (ent instanceof EntityPlayer) {
                r = 1.0f;
                g = 0.0f;
                b = 1.0f;
            } else if (ent instanceof EntityLiving) {
                r = 0.0f;
                g = 1.0f;
                b = 0.0f;
            } else if (ent instanceof EntityItem) {
                r = 1.0f;
                g = 1.0f;
                b = 0.5f;
            } else {
                if (!(ent instanceof EntityXPOrb)) continue;
                if (player.field_70173_aa % 10 < 5) {
                    r = 1.0f;
                    g = 1.0f;
                    b = 0.5f;
                } else {
                    r = 0.5f;
                    g = 1.0f;
                    b = 0.5f;
                }
            }
            AxisAlignedBB bb = ent.func_174813_aQ();
            buf.func_181662_b(bb.field_72340_a - x, bb.field_72337_e - y, bb.field_72339_c - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72340_a - x, bb.field_72338_b - y, bb.field_72339_c - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72340_a - x, bb.field_72337_e - y, bb.field_72339_c - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72336_d - x, bb.field_72337_e - y, bb.field_72339_c - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72336_d - x, bb.field_72337_e - y, bb.field_72339_c - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72336_d - x, bb.field_72338_b - y, bb.field_72339_c - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72340_a - x, bb.field_72338_b - y, bb.field_72339_c - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72336_d - x, bb.field_72338_b - y, bb.field_72339_c - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72336_d - x, bb.field_72338_b - y, bb.field_72339_c - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72336_d - x, bb.field_72338_b - y, bb.field_72334_f - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72336_d - x, bb.field_72337_e - y, bb.field_72334_f - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72336_d - x, bb.field_72337_e - y, bb.field_72339_c - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72336_d - x, bb.field_72337_e - y, bb.field_72334_f - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72336_d - x, bb.field_72338_b - y, bb.field_72334_f - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72340_a - x, bb.field_72337_e - y, bb.field_72339_c - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72340_a - x, bb.field_72337_e - y, bb.field_72334_f - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72340_a - x, bb.field_72337_e - y, bb.field_72334_f - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72340_a - x, bb.field_72338_b - y, bb.field_72334_f - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72340_a - x, bb.field_72337_e - y, bb.field_72334_f - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72336_d - x, bb.field_72337_e - y, bb.field_72334_f - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72340_a - x, bb.field_72338_b - y, bb.field_72334_f - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72336_d - x, bb.field_72338_b - y, bb.field_72334_f - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72340_a - x, bb.field_72338_b - y, bb.field_72339_c - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
            buf.func_181662_b(bb.field_72340_a - x, bb.field_72338_b - y, bb.field_72334_f - z).func_181666_a(r, g, b, 1.0f).func_181675_d();
        }
        tess.func_78381_a();
        GlStateManager.func_179142_g();
        GlStateManager.func_179098_w();
        GL11.glDisable((int)2832);
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GL11.glPopMatrix();
    }

    public static void renderMarkers(float partialTicks) {
        markers.putAll(queuedMarkers);
        queuedMarkers.clear();
        if (markers.isEmpty()) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double x = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double y = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double z = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        GL11.glPushMatrix();
        GL11.glDisable((int)2903);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2832);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        Iterator<Map.Entry<BlockPos, Marker>> it = markers.entrySet().iterator();
        ArrayList<Map.Entry<BlockPos, Marker>> tagList = new ArrayList<Map.Entry<BlockPos, Marker>>();
        while (it.hasNext()) {
            double aZ;
            double aY;
            double aX;
            Vec3d vec;
            Map.Entry<BlockPos, Marker> entry = it.next();
            BlockPos blockPos = entry.getKey();
            Marker marker = entry.getValue();
            int pX = blockPos.func_177958_n();
            int pY = blockPos.func_177956_o();
            int pZ = blockPos.func_177952_p();
            double minX = marker.minX;
            double minY = marker.minY;
            double minZ = marker.minZ;
            double maxX = marker.maxX;
            double maxY = marker.maxY;
            double maxZ = marker.maxZ;
            int red = marker.color >> 16 & 0xFF;
            int green = marker.color >> 8 & 0xFF;
            int blue = marker.color & 0xFF;
            buf.func_181662_b((double)pX + minX - x, (double)pY + maxY - y, (double)pZ + minZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + minX - x, (double)pY + minY - y, (double)pZ + minZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + minX - x, (double)pY + maxY - y, (double)pZ + minZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + maxX - x, (double)pY + maxY - y, (double)pZ + minZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + maxX - x, (double)pY + maxY - y, (double)pZ + minZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + maxX - x, (double)pY + minY - y, (double)pZ + minZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + minX - x, (double)pY + minY - y, (double)pZ + minZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + maxX - x, (double)pY + minY - y, (double)pZ + minZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + maxX - x, (double)pY + minY - y, (double)pZ + minZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + maxX - x, (double)pY + minY - y, (double)pZ + maxZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + maxX - x, (double)pY + maxY - y, (double)pZ + maxZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + maxX - x, (double)pY + maxY - y, (double)pZ + minZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + maxX - x, (double)pY + maxY - y, (double)pZ + maxZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + maxX - x, (double)pY + minY - y, (double)pZ + maxZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + minX - x, (double)pY + maxY - y, (double)pZ + minZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + minX - x, (double)pY + maxY - y, (double)pZ + maxZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + minX - x, (double)pY + maxY - y, (double)pZ + maxZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + minX - x, (double)pY + minY - y, (double)pZ + maxZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + minX - x, (double)pY + maxY - y, (double)pZ + maxZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + maxX - x, (double)pY + maxY - y, (double)pZ + maxZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + minX - x, (double)pY + minY - y, (double)pZ + maxZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + maxX - x, (double)pY + minY - y, (double)pZ + maxZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + minX - x, (double)pY + minY - y, (double)pZ + minZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            buf.func_181662_b((double)pX + minX - x, (double)pY + minY - y, (double)pZ + maxZ - z).func_181669_b(red, green, blue, 255).func_181675_d();
            tagList.add(entry);
            if (marker.expire > 0L && Clock.get_ms() > marker.expire) {
                it.remove();
                continue;
            }
            if (!(marker.maxDist > 0.0) || !((vec = new Vec3d(x - (aX = (double)pX + (maxX - minX) / 2.0), y - (aY = (double)pY + (maxY - minY) / 2.0), z - (aZ = (double)pZ + (maxZ - minZ) / 2.0))).func_72433_c() > marker.maxDist)) continue;
            it.remove();
        }
        tess.func_78381_a();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2832);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        for (Map.Entry entry : tagList) {
            BlockPos pos = (BlockPos)entry.getKey();
            Marker marker = (Marker)entry.getValue();
            int pX = pos.func_177958_n();
            int pY = pos.func_177956_o();
            int pZ = pos.func_177952_p();
            double minX = marker.minX;
            double minY = marker.minY;
            double minZ = marker.minZ;
            double maxX = marker.maxX;
            double maxY = marker.maxY;
            double maxZ = marker.maxZ;
            double aX = (double)pX + (maxX - minX) / 2.0;
            double aY = (double)pY + (maxY - minY) / 2.0;
            double aZ = (double)pZ + (maxZ - minZ) / 2.0;
            Vec3d vec = new Vec3d(aX - x, aY - y, aZ - z);
            double len = vec.field_72450_a * vec.field_72450_a + vec.field_72448_b * vec.field_72448_b + vec.field_72449_c * vec.field_72449_c;
            double sqrt = Math.sqrt(len);
            double mult = Math.min(sqrt, 16.0);
            vec = new Vec3d(vec.field_72450_a * (mult / sqrt), vec.field_72448_b * (mult / sqrt), vec.field_72449_c * (mult / sqrt));
            Vec3d look = player.func_70040_Z();
            Vec3d diff = vec.func_72432_b();
            String label = marker.label;
            if (label == null) {
                label = "";
            }
            if (Math.abs(look.field_72450_a - diff.field_72450_a) + Math.abs(look.field_72448_b - diff.field_72448_b) + Math.abs(look.field_72449_c - diff.field_72449_c) < 0.15) {
                label = label + (!label.isEmpty() ? " " : "") + (int)sqrt + "m";
            }
            if (label.isEmpty()) continue;
            RenderOverhead.drawTag(1.0f, len, label, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 100, true, marker.color, marker.color);
        }
        GL11.glPopMatrix();
    }

    public static class Marker {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 1.0;
        double maxY = 1.0;
        double maxZ = 1.0;
        int color;
        String label;
        long expire;
        double maxDist;

        public Marker(int color) {
            this.color = color;
        }

        public Marker setExpire(long expire) {
            this.expire = expire;
            return this;
        }

        public Marker setDist(double maxDist) {
            this.maxDist = maxDist;
            return this;
        }

        public Marker withLabel(String label) {
            this.label = label;
            return this;
        }
    }
}

