/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.misc;

import com.hbm.util.BobMathUtil;

public class ColorGradient {
    private float[][] colors;

    public ColorGradient(float[] ... colors) {
        this.colors = colors;
    }

    public float[] getColor(float time) {
        if (time < 0.0f) {
            return this.colors[0];
        }
        if (time > 1.0f) {
            return this.colors[this.colors.length - 1];
        }
        for (int i = 0; i < this.colors.length - 1; ++i) {
            if (!(this.colors[i][4] <= time) || !(this.colors[i + 1][4] > time)) continue;
            float interp = BobMathUtil.remap(time, 0.0f, 1.0f, this.colors[i][4], this.colors[i + 1][4]);
            float[] color = new float[]{this.colors[i][0] + (this.colors[i + 1][0] - this.colors[i][0]) * interp, this.colors[i][1] + (this.colors[i + 1][1] - this.colors[i][1]) * interp, this.colors[i][2] + (this.colors[i + 1][2] - this.colors[i][2]) * interp, this.colors[i][3] + (this.colors[i + 1][3] - this.colors[i][3]) * interp};
            return color;
        }
        return this.colors[0];
    }
}

