/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.icon;

import com.hbm.render.icon.RGBMutator;
import java.awt.image.BufferedImage;

public class RGBMutatorInterpolatedComponentRemap
implements RGBMutator {
    int sourceLight;
    int sourceDark;
    int targetLight;
    int targetDark;

    public RGBMutatorInterpolatedComponentRemap(int sourceLight, int sourceDark, int targetLight, int targetDark) {
        this.sourceLight = sourceLight;
        this.sourceDark = sourceDark;
        this.targetLight = targetLight;
        this.targetDark = targetDark;
    }

    @Override
    public void mutate(BufferedImage image, int frame, int frameCount) {
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int pix = image.getRGB(x, y);
                int rgb = RGBMutatorInterpolatedComponentRemap.shiftColor(this.sourceLight, this.sourceDark, this.targetLight, this.targetDark, pix);
                image.setRGB(x, y, rgb);
            }
        }
    }

    private static int shiftColor(int boundLighter, int boundDarker, int lighter, int darker, int pix) {
        int a = (pix & 0xFF000000) >> 24;
        int r = (pix & 0xFF0000) >> 16;
        int g = (pix & 0xFF00) >> 8;
        int b = pix & 0xFF;
        int nR = (int)RGBMutatorInterpolatedComponentRemap.shiftComponent(RGBMutatorInterpolatedComponentRemap.compR(lighter), RGBMutatorInterpolatedComponentRemap.compR(darker), RGBMutatorInterpolatedComponentRemap.compR(boundLighter), RGBMutatorInterpolatedComponentRemap.compR(boundDarker), r);
        int nG = (int)RGBMutatorInterpolatedComponentRemap.shiftComponent(RGBMutatorInterpolatedComponentRemap.compG(lighter), RGBMutatorInterpolatedComponentRemap.compG(darker), RGBMutatorInterpolatedComponentRemap.compG(boundLighter), RGBMutatorInterpolatedComponentRemap.compG(boundDarker), g);
        int nB = (int)RGBMutatorInterpolatedComponentRemap.shiftComponent(RGBMutatorInterpolatedComponentRemap.compB(lighter), RGBMutatorInterpolatedComponentRemap.compB(darker), RGBMutatorInterpolatedComponentRemap.compB(boundLighter), RGBMutatorInterpolatedComponentRemap.compB(boundDarker), b);
        r = nR & 0xFF;
        g = nG & 0xFF;
        b = nB & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static double shiftComponent(int lighter, int darker, int boundLighter, int boundDarker, int component) {
        double scaledComponent = RGBMutatorInterpolatedComponentRemap.getPosFromComp(boundLighter, boundDarker, component);
        return RGBMutatorInterpolatedComponentRemap.getCompFromFunc(lighter, darker, scaledComponent);
    }

    private static double getCompFromFunc(int lower, int upper, double interp) {
        return (double)lower + interp * ((double)upper - (double)lower);
    }

    private static double getPosFromComp(int lower, int upper, double val) {
        return (val - (double)lower) / ((double)upper - (double)lower);
    }

    private static int compR(int col) {
        return (col & 0xFF0000) >> 16;
    }

    private static int compG(int col) {
        return (col & 0xFF00) >> 8;
    }

    private static int compB(int col) {
        return col & 0xFF;
    }
}

