/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity.effect;

import com.hbm.entity.effect.EntityNukeTorex;
import com.hbm.main.MainRegistry;
import com.hbm.render.amlfrom1710.Vec3;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Random;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import org.lwjgl.opengl.GL11;

public class RenderTorex
extends Render<EntityNukeTorex> {
    public static final IRenderFactory<EntityNukeTorex> FACTORY = RenderTorex::new;
    private static final ResourceLocation cloudlet = new ResourceLocation("hbm:textures/particle/particle_base.png");
    private static final ResourceLocation flare = new ResourceLocation("hbm:textures/particle/flare.png");
    public static final int flashBaseDuration = 30;
    public static final int flareBaseDuration = 100;
    private final Comparator cloudSorter = (arg0, arg1) -> {
        EntityNukeTorex.Cloudlet first = (EntityNukeTorex.Cloudlet)arg0;
        EntityNukeTorex.Cloudlet second = (EntityNukeTorex.Cloudlet)arg1;
        EntityPlayer player = MainRegistry.proxy.me();
        double dist1 = player.func_70092_e(first.posX, first.posY, first.posZ);
        double dist2 = player.func_70092_e(second.posX, second.posY, second.posZ);
        return Double.compare(dist2, dist1);
    };

    protected RenderTorex(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityNukeTorex cloud, double x, double y, double z, float entityYaw, float partialTicks) {
        float scale = (float)cloud.getScale();
        float flashDuration = scale * 30.0f;
        float flareDuration = scale * 100.0f;
        this.doScreenShake(cloud, x, y, z, scale * 100.0f);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        boolean fog = GL11.glIsEnabled((int)2912);
        if (fog) {
            GL11.glDisable((int)2912);
        }
        this.cloudletWrapper(cloud, partialTicks);
        if ((float)cloud.field_70173_aa < flareDuration + 1.0f) {
            this.flareWrapper(cloud, partialTicks, flareDuration);
        }
        if ((float)cloud.field_70173_aa < flashDuration + 1.0f) {
            this.flashWrapper(cloud, partialTicks, flashDuration);
        }
        if (fog) {
            GL11.glEnable((int)2912);
        }
        GL11.glPopMatrix();
    }

    private void doScreenShake(EntityNukeTorex cloud, double x, double y, double z, float amplitude) {
        if (cloud.field_70173_aa > 300) {
            return;
        }
        EntityPlayer player = MainRegistry.proxy.me();
        double dist = player.func_70032_d((Entity)cloud);
        double shockwaveDistance = dist - (double)cloud.field_70173_aa * 2.0;
        if (shockwaveDistance > 4.0 || shockwaveDistance < 0.0) {
            return;
        }
        cloud.field_70170_p.func_184148_a(player, cloud.field_70165_t, cloud.field_70163_u, cloud.field_70161_v, SoundEvents.field_187754_de, SoundCategory.AMBIENT, amplitude, 0.8f + cloud.field_70170_p.field_73012_v.nextFloat() * 0.2f);
        int duration = (int)(40.0 * Math.min(1.5, (double)(amplitude * amplitude) / (dist * dist)));
        if (duration < 15) {
            return;
        }
        int swingTimer = duration << 1;
        if (player.func_145748_c_().toString().equals("Vic4Games")) {
            player.field_70737_aN = swingTimer << 1;
            player.field_70738_aO = duration << 1;
        } else {
            player.field_70737_aN = swingTimer;
            player.field_70738_aO = duration;
        }
        player.field_70739_aP = 0.0f;
    }

    private void cloudletWrapper(EntityNukeTorex cloud, float partialTicks) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glDisable((int)3008);
        GL11.glDepthMask((boolean)false);
        RenderHelper.func_74518_a();
        this.func_110776_a(cloudlet);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        ArrayList<EntityNukeTorex.Cloudlet> cloudlets = new ArrayList<EntityNukeTorex.Cloudlet>(cloud.cloudlets);
        cloudlets.sort(this.cloudSorter);
        for (EntityNukeTorex.Cloudlet cloudlet : cloudlets) {
            Vec3 vec = cloudlet.getInterpPos(partialTicks);
            this.tessellateCloudlet(buf, vec.xCoord - cloud.field_70165_t, vec.yCoord - cloud.field_70163_u, vec.zCoord - cloud.field_70161_v, cloudlet, partialTicks);
        }
        tess.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3008);
        RenderHelper.func_74519_b();
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void flareWrapper(EntityNukeTorex cloud, float partialTicks, float flareDuration) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glDisable((int)3008);
        GL11.glDepthMask((boolean)false);
        RenderHelper.func_74518_a();
        this.func_110776_a(flare);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        double age = Math.min((float)cloud.field_70173_aa + partialTicks, flareDuration);
        float alpha = (float)Math.min(1.0, ((double)flareDuration - age) / (double)flareDuration);
        Random rand = new Random(cloud.func_145782_y());
        for (int i = 0; i < 3; ++i) {
            float x = (float)(rand.nextGaussian() * 0.5 * cloud.rollerSize);
            float y = (float)(rand.nextGaussian() * 0.5 * cloud.rollerSize);
            float z = (float)(rand.nextGaussian() * 0.5 * cloud.rollerSize);
            this.tessellateFlare(buf, x, (double)y + cloud.coreHeight, z, (float)(10.0 * cloud.rollerSize), alpha, partialTicks);
        }
        tess.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3008);
        RenderHelper.func_74519_b();
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void tessellateCloudlet(BufferBuilder buf, double posX, double posY, double posZ, EntityNukeTorex.Cloudlet cloud, float partialTicks) {
        float a = cloud.getAlpha();
        float scale = cloud.getScale();
        float f1 = ActiveRenderInfo.func_178808_b();
        float f2 = ActiveRenderInfo.func_178803_d();
        float f3 = ActiveRenderInfo.func_178805_e();
        float f4 = ActiveRenderInfo.func_178807_f();
        float f5 = ActiveRenderInfo.func_178809_c();
        float brightness = cloud.type == EntityNukeTorex.TorexType.CONDENSATION ? 0.9f : 0.75f * cloud.colorMod;
        Vec3 color = cloud.getInterpColor(partialTicks);
        float r = Math.max(0.15f, (float)color.xCoord * brightness);
        float g = Math.max(0.15f, (float)color.yCoord * brightness);
        float b = Math.max(0.15f, (float)color.zCoord * brightness);
        int br = (int)Math.max(48.0, Math.min((double)(r + g + b) / 3.0, 1.0) * 240.0);
        r = Math.min(1.0f, r);
        g = Math.min(1.0f, g);
        b = Math.min(1.0f, b);
        buf.func_181662_b(posX - (double)(f1 * scale) - (double)(f3 * scale), posY - (double)(f5 * scale), posZ - (double)(f2 * scale) - (double)(f4 * scale)).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a).func_187314_a(br, br).func_181675_d();
        buf.func_181662_b(posX - (double)(f1 * scale) + (double)(f3 * scale), posY + (double)(f5 * scale), posZ - (double)(f2 * scale) + (double)(f4 * scale)).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a).func_187314_a(br, br).func_181675_d();
        buf.func_181662_b(posX + (double)(f1 * scale) + (double)(f3 * scale), posY + (double)(f5 * scale), posZ + (double)(f2 * scale) + (double)(f4 * scale)).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a).func_187314_a(br, br).func_181675_d();
        buf.func_181662_b(posX + (double)(f1 * scale) - (double)(f3 * scale), posY - (double)(f5 * scale), posZ + (double)(f2 * scale) - (double)(f4 * scale)).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a).func_187314_a(br, br).func_181675_d();
    }

    private void tessellateFlare(BufferBuilder buf, double posX, double posY, double posZ, float scale, float a, float partialTicks) {
        float f1 = ActiveRenderInfo.func_178808_b();
        float f2 = ActiveRenderInfo.func_178803_d();
        float f3 = ActiveRenderInfo.func_178805_e();
        float f4 = ActiveRenderInfo.func_178807_f();
        float f5 = ActiveRenderInfo.func_178809_c();
        int br = (int)(a * 240.0f);
        buf.func_181662_b(posX - (double)(f1 * scale) - (double)(f3 * scale), posY - (double)(f5 * scale), posZ - (double)(f2 * scale) - (double)(f4 * scale)).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, a).func_187314_a(br, br).func_181675_d();
        buf.func_181662_b(posX - (double)(f1 * scale) + (double)(f3 * scale), posY + (double)(f5 * scale), posZ - (double)(f2 * scale) + (double)(f4 * scale)).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, a).func_187314_a(br, br).func_181675_d();
        buf.func_181662_b(posX + (double)(f1 * scale) + (double)(f3 * scale), posY + (double)(f5 * scale), posZ + (double)(f2 * scale) + (double)(f4 * scale)).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, a).func_187314_a(br, br).func_181675_d();
        buf.func_181662_b(posX + (double)(f1 * scale) - (double)(f3 * scale), posY - (double)(f5 * scale), posZ + (double)(f2 * scale) - (double)(f4 * scale)).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, a).func_187314_a(br, br).func_181675_d();
    }

    private void flashWrapper(EntityNukeTorex cloud, float interp, float flashDuration) {
        if ((float)cloud.field_70173_aa < flashDuration) {
            GL11.glPushMatrix();
            double intensity = ((float)cloud.field_70173_aa + interp) / flashDuration;
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            intensity = intensity * Math.pow(Math.E, -intensity) * 2.717391304;
            this.renderFlash(50.0f * flashDuration / 30.0f, intensity, cloud.coreHeight);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GL11.glPopMatrix();
        }
    }

    private void renderFlash(float scale, double intensity, double height) {
        GL11.glScalef((float)0.2f, (float)0.2f, (float)0.2f);
        GL11.glTranslated((double)0.0, (double)(height * 4.0), (double)0.0);
        double inverse = 1.0 - intensity;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buf = tessellator.func_178180_c();
        RenderHelper.func_74518_a();
        Random random = new Random(432L);
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179118_c();
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)false);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glPushMatrix();
        for (int i = 0; i < 300; ++i) {
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            float vert1 = (random.nextFloat() * 20.0f + 5.0f + 10.0f) * (float)(intensity * (double)scale);
            float vert2 = (random.nextFloat() * 2.0f + 1.0f + 2.0f) * (float)(intensity * (double)scale);
            buf.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            buf.func_181662_b(0.0, 0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, (float)inverse).func_181675_d();
            buf.func_181662_b(-0.866 * (double)vert2, (double)vert1, -0.5 * (double)vert2).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
            buf.func_181662_b(0.866 * (double)vert2, (double)vert1, -0.5 * (double)vert2).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
            buf.func_181662_b(0.0, (double)vert1, 1.0 * (double)vert2).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
            buf.func_181662_b(-0.866 * (double)vert2, (double)vert1, -0.5 * (double)vert2).func_181666_a(1.0f, 1.0f, 1.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
        }
        GL11.glPopMatrix();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        RenderHelper.func_74519_b();
    }

    protected ResourceLocation getEntityTexture(EntityNukeTorex entity) {
        return null;
    }
}

