/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render;

import com.hbm.hfr.render.loader.HFRWavefrontObject;
import com.hbm.hfr.render.loader.S_GroupObject;
import com.hbm.render.amlfrom1710.GroupObject;
import com.hbm.render.amlfrom1710.IModelCustom;
import com.hbm.render.amlfrom1710.Tessellator;
import com.hbm.render.amlfrom1710.WavefrontObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class WavefrontObjDisplayList
implements IModelCustom {
    public List<Pair<String, Integer>> nameToCallList = new ArrayList<Pair<String, Integer>>();

    public WavefrontObjDisplayList(WavefrontObject obj) {
        Tessellator tes = Tessellator.instance;
        for (GroupObject g : obj.groupObjects) {
            int list = GL11.glGenLists((int)1);
            GL11.glNewList((int)list, (int)4864);
            tes.startDrawing(g.glDrawingMode);
            g.render(tes);
            tes.draw();
            GL11.glEndList();
            this.nameToCallList.add((Pair<String, Integer>)Pair.of((Object)g.name, (Object)list));
        }
    }

    public WavefrontObjDisplayList(HFRWavefrontObject obj) {
        for (S_GroupObject g : obj.groupObjects) {
            int list = GL11.glGenLists((int)1);
            GL11.glNewList((int)list, (int)4864);
            g.render();
            GL11.glEndList();
            this.nameToCallList.add((Pair<String, Integer>)Pair.of((Object)g.name, (Object)list));
        }
    }

    public int getListForName(String name) {
        for (Pair<String, Integer> p : this.nameToCallList) {
            if (!((String)p.getLeft()).equalsIgnoreCase(name)) continue;
            return (Integer)p.getRight();
        }
        return 0;
    }

    @Override
    public String getType() {
        return "obj_list";
    }

    @Override
    public void renderAll() {
        for (Pair<String, Integer> p : this.nameToCallList) {
            GL11.glCallList((int)((Integer)p.getRight()));
        }
    }

    @Override
    public void renderOnly(String ... groupNames) {
        block0: for (Pair<String, Integer> p : this.nameToCallList) {
            for (String name : groupNames) {
                if (!((String)p.getLeft()).equalsIgnoreCase(name)) continue;
                GL11.glCallList((int)((Integer)p.getRight()));
                continue block0;
            }
        }
    }

    @Override
    public void renderPart(String partName) {
        for (Pair<String, Integer> p : this.nameToCallList) {
            if (!((String)p.getLeft()).equalsIgnoreCase(partName)) continue;
            GL11.glCallList((int)((Integer)p.getRight()));
        }
    }

    @Override
    public void renderAllExcept(String ... excludedGroupNames) {
        for (Pair<String, Integer> p : this.nameToCallList) {
            boolean skip = false;
            for (String name : excludedGroupNames) {
                if (!((String)p.getLeft()).equalsIgnoreCase(name)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            GL11.glCallList((int)((Integer)p.getRight()));
        }
    }

    @Override
    public void tessellateAll(Tessellator tes) {
        throw new RuntimeException("Tessellate operation not supported on display list object");
    }

    @Override
    public void tessellatePart(Tessellator tes, String name) {
        throw new RuntimeException("Tessellate operation not supported on display list object");
    }

    @Override
    public void tessellateOnly(Tessellator tes, String ... names) {
        throw new RuntimeException("Tessellate operation not supported on display list object");
    }

    @Override
    public void tessellateAllExcept(Tessellator tes, String ... excluded) {
        throw new RuntimeException("Tessellate operation not supported on display list object");
    }
}

