/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render;

import com.hbm.config.GeneralConfig;
import com.hbm.handler.HbmShaderManager2;
import com.hbm.lib.Library;
import com.hbm.main.ClientProxy;
import com.hbm.main.MainRegistry;
import com.hbm.main.ResourceManager;
import com.hbm.render.GLCompat;
import com.hbm.render.RenderHelper;
import com.hbm.util.BobMathUtil;
import java.lang.reflect.Field;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;
import org.lwjgl.util.vector.Matrix4f;

public class LightRenderer {
    public static final int MAX_DIRECTIONAL_LIGHTS = 4;
    public static final int MAX_POINT_LIGHTS = 4;
    public static Field r_setTileEntities;
    private static Set<Class<?>> blacklistedObjects;
    private static List<DirectionalLight> flashlights;
    private static List<PointLight> point_lights;
    public static int width;
    public static int height;
    public static int albedoFbo;
    public static int albedoTex;
    public static int albedoDepth;
    public static int lightAccFbo;
    public static int lightAccTex;
    public static int volAccFbo;
    public static int volAccTex;
    public static int shadowFbo;
    public static int shadowTex;
    public static boolean init;
    private static boolean lock;

    public static void addPointLight(Vec3d pos, float energy) {
        LightRenderer.addPointLight(pos, new Vec3d(1.0, 1.0, 1.0), energy);
    }

    public static void addPointLight(Vec3d pos, Vec3d color, float energy) {
        LightRenderer.addPointLight(new PointLight(pos, color, energy));
    }

    public static void addPointLight(PointLight light) {
        if (!GeneralConfig.flashlight || lock || point_lights.size() > 4) {
            return;
        }
        point_lights.add(light);
    }

    public static void addFlashlight(Vec3d start, Vec3d end, float degrees, float brightness, ResourceLocation cookie) {
        LightRenderer.addFlashlight(start, end, degrees, brightness, cookie, false, false);
    }

    public static void addFlashlight(Vec3d start, Vec3d end, float degrees, float brightness, ResourceLocation cookie, boolean ent, boolean tes) {
        LightRenderer.addFlashlight(start, end, degrees, brightness, cookie, true, true, ent, tes);
    }

    public static void addFlashlight(Vec3d start, Vec3d end, float degrees, float brightness, ResourceLocation cookie, boolean vol, boolean sha, boolean ent, boolean tes) {
        if (!GeneralConfig.flashlight || lock || flashlights.size() > 4) {
            return;
        }
        flashlights.add(new DirectionalLight(start, end, degrees, brightness, cookie, vol, sha, ent, tes));
    }

    public static void worldRender() {
        if (lock) {
            return;
        }
        if (!GeneralConfig.flashlight || flashlights.isEmpty() && point_lights.isEmpty()) {
            return;
        }
        lock = true;
        Framebuffer mcFbo = Minecraft.func_71410_x().func_147110_a();
        if (width != mcFbo.field_147621_c || height != mcFbo.field_147618_d) {
            width = mcFbo.field_147621_c;
            height = mcFbo.field_147618_d;
            LightRenderer.recreateBuffers();
        }
        LightRenderer.clearAlbedoBuffer();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float partialTicks = MainRegistry.proxy.partialTicks();
        Entity renderView = Minecraft.func_71410_x().func_175606_aa();
        HashSet<RenderChunk> chunksToRender = new HashSet<RenderChunk>();
        HashSet<Entity> entitiesToRender = new HashSet<Entity>();
        HashSet<TileEntity> tilesToRender = new HashSet<TileEntity>();
        for (DirectionalLight l : flashlights) {
            LightRenderer.accumulateRenderObjects(l);
            chunksToRender.addAll(l.chunksToRender);
            if (l.entities) {
                entitiesToRender.addAll(l.entsToRender);
            }
            if (!l.tileentities) continue;
            tilesToRender.addAll(l.tilesToRender);
        }
        for (PointLight p : point_lights) {
            LightRenderer.accumulateRenderObjects(p);
            chunksToRender.addAll(p.chunksToRender);
            if (p.entities) {
                entitiesToRender.addAll(p.entsToRender);
            }
            if (!p.tileentities) continue;
            tilesToRender.addAll(p.tilesToRender);
        }
        double entPosX = renderView.field_70142_S + (renderView.field_70165_t - renderView.field_70142_S) * (double)partialTicks;
        double entPosY = renderView.field_70137_T + (renderView.field_70163_u - renderView.field_70137_T) * (double)partialTicks;
        double entPosZ = renderView.field_70136_U + (renderView.field_70161_v - renderView.field_70136_U) * (double)partialTicks;
        Vec3d playerPos = new Vec3d(entPosX, entPosY, entPosZ);
        GLCompat.bindFramebuffer(GLCompat.GL_FRAMEBUFFER, albedoFbo);
        LightRenderer.renderObjects(playerPos, chunksToRender, entitiesToRender, tilesToRender, ResourceManager.albedo, partialTicks);
        if (!init) {
            LightRenderer.initShadowBuffer();
            init = true;
        }
        LightRenderer.clearAccumulationBuffer();
        boolean didRenderVolume = false;
        for (DirectionalLight l : flashlights) {
            l.setupViewProjectionMatrix(playerPos);
            if (l.shadows) {
                GlStateManager.func_179083_b((int)0, (int)0, (int)1024, (int)1024);
                LightRenderer.clearShadowBuffer();
                GLCompat.bindFramebuffer(GLCompat.GL_FRAMEBUFFER, shadowFbo);
                ResourceManager.flashlight_depth.use();
                LightRenderer.renderShadowForLight(playerPos, l, partialTicks);
            }
            GlStateManager.func_179083_b((int)0, (int)0, (int)width, (int)height);
            ResourceManager.flashlight_post.use();
            LightRenderer.sendPostShaderUniforms(l, playerPos, ResourceManager.flashlight_post);
            GLCompat.bindFramebuffer(GLCompat.GL_FRAMEBUFFER, lightAccFbo);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            Vec3d vec = l.end.func_178788_d(l.start).func_72432_b();
            if (playerPos.func_178787_e(ActiveRenderInfo.getCameraPosition()).func_178788_d(l.start).func_72432_b().func_72430_b(vec) < Math.cos(Math.toRadians(l.degrees + 10.0f))) {
                GlStateManager.func_179089_o();
                RenderHelper.renderConeMesh(l.start.func_178788_d(playerPos), vec, (float)l.height, (float)l.radius * 1.1f, 12);
            } else {
                GL11.glPushMatrix();
                GL11.glLoadIdentity();
                GlStateManager.func_179128_n((int)5889);
                GL11.glPushMatrix();
                GL11.glLoadIdentity();
                GlStateManager.func_179128_n((int)5888);
                GL11.glGetFloat((int)2982, (FloatBuffer)ClientProxy.AUX_GL_BUFFER);
                RenderHelper.renderFullscreenTriangle();
                GlStateManager.func_179128_n((int)5889);
                GL11.glPopMatrix();
                GlStateManager.func_179128_n((int)5888);
                GL11.glPopMatrix();
            }
            if (GeneralConfig.flashlightVolumetric && l.volume) {
                GlStateManager.func_179083_b((int)0, (int)0, (int)(width / 2), (int)(height / 2));
                GLCompat.bindFramebuffer(GLCompat.GL_FRAMEBUFFER, volAccFbo);
                LightRenderer.volumetricRender(l, playerPos);
                GlStateManager.func_179083_b((int)0, (int)0, (int)width, (int)height);
                didRenderVolume = true;
            }
            GlStateManager.func_179084_k();
        }
        for (PointLight light : point_lights) {
            ResourceManager.pointlight_post.use();
            LightRenderer.sendPointLightUniforms(light, playerPos, ResourceManager.pointlight_post);
            GLCompat.bindFramebuffer(GLCompat.GL_FRAMEBUFFER, lightAccFbo);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            float rad = light.radius + 0.1f;
            if (playerPos.func_178787_e(ActiveRenderInfo.getCameraPosition()).func_72436_e(light.pos) > (double)(rad * rad)) {
                Vec3d diff = light.pos.func_178788_d(playerPos);
                GL11.glPushMatrix();
                GL11.glTranslated((double)diff.field_72450_a, (double)diff.field_72448_b, (double)diff.field_72449_c);
                GL11.glScaled((double)light.radius, (double)light.radius, (double)light.radius);
                ResourceManager.sphere_uv.renderAll();
                GL11.glPopMatrix();
            } else {
                GL11.glPushMatrix();
                GL11.glLoadIdentity();
                GlStateManager.func_179128_n((int)5889);
                GL11.glPushMatrix();
                GL11.glLoadIdentity();
                GlStateManager.func_179128_n((int)5888);
                GL11.glGetFloat((int)2982, (FloatBuffer)ClientProxy.AUX_GL_BUFFER);
                RenderHelper.renderFullscreenTriangle();
                GlStateManager.func_179128_n((int)5889);
                GL11.glPopMatrix();
                GlStateManager.func_179128_n((int)5888);
                GL11.glPopMatrix();
            }
            GlStateManager.func_179084_k();
        }
        if (GeneralConfig.flashlightVolumetric && didRenderVolume) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GLCompat.bindFramebuffer(GLCompat.GL_FRAMEBUFFER, lightAccFbo);
            ResourceManager.volume_upscale.use();
            GlStateManager.func_179138_g((int)(GLCompat.GL_TEXTURE0 + 3));
            GlStateManager.func_179144_i((int)HbmShaderManager2.depthTexture);
            GlStateManager.func_179138_g((int)GLCompat.GL_TEXTURE0);
            ResourceManager.volume_upscale.uniform1i("depthTex", 3);
            GlStateManager.func_179144_i((int)volAccTex);
            ResourceManager.volume_upscale.uniform2f("zNearFar", 0.05f, (float)(Minecraft.func_71410_x().field_71474_y.field_151451_c * 16) * MathHelper.field_180189_a);
            RenderHelper.renderFullscreenTriangle();
            GlStateManager.func_179084_k();
        }
        GlStateManager.func_179144_i((int)lightAccTex);
        mcFbo.func_147610_a(true);
        ResourceManager.flashlight_blit.use();
        GlStateManager.func_179138_g((int)(GLCompat.GL_TEXTURE0 + 3));
        GlStateManager.func_179144_i((int)mcFbo.field_147617_g);
        GlStateManager.func_179138_g((int)GLCompat.GL_TEXTURE0);
        ResourceManager.flashlight_blit.uniform1i("target", 3);
        RenderHelper.renderFullscreenTriangle();
        HbmShaderManager2.releaseShader();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        flashlights.clear();
        point_lights.clear();
        lock = false;
    }

    private static void volumetricRender(DirectionalLight light, Vec3d playerPos) {
        Vec3d vec = light.end.func_178788_d(light.start);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        ResourceManager.cone_volume.use();
        HbmShaderManager2.Shader shader = ResourceManager.cone_volume;
        float height = (float)vec.func_72433_c();
        shader.uniform1f("height", height);
        vec = vec.func_72432_b();
        shader.uniform1f("cosAngle", (float)Math.cos(Math.toRadians(light.degrees)));
        Vec3d pos = light.start.func_178788_d(playerPos);
        shader.uniform3f("pos", (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c);
        shader.uniform3f("direction", (float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c);
        shader.uniform1f("radius", (float)light.radius * 0.5f);
        shader.uniform1f("useShadows", light.shadows ? 1.0f : 0.0f);
        Vec3d camPos = ActiveRenderInfo.getCameraPosition();
        shader.uniform3f("camPos", (float)camPos.field_72450_a, (float)camPos.field_72448_b, (float)camPos.field_72449_c);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(light.cookie);
        GlStateManager.func_179138_g((int)(GLCompat.GL_TEXTURE0 + 3));
        GlStateManager.func_179144_i((int)shadowTex);
        shader.uniform1i("shadow", 3);
        GlStateManager.func_179138_g((int)(GLCompat.GL_TEXTURE0 + 4));
        GlStateManager.func_179144_i((int)HbmShaderManager2.depthTexture);
        shader.uniform1i("depth", 4);
        GlStateManager.func_179138_g((int)GLCompat.GL_TEXTURE0);
        ClientProxy.AUX_GL_BUFFER.put(HbmShaderManager2.inv_ViewProjectionMatrix);
        ClientProxy.AUX_GL_BUFFER.rewind();
        shader.uniformMatrix4("inv_ViewProjectionMatrix", false, ClientProxy.AUX_GL_BUFFER);
        light.viewProjectionMatrix.store(ClientProxy.AUX_GL_BUFFER);
        ClientProxy.AUX_GL_BUFFER.rewind();
        shader.uniformMatrix4("flashlight_ViewProjectionMatrix", false, ClientProxy.AUX_GL_BUFFER);
        GlStateManager.func_179089_o();
        if (playerPos.func_178787_e(ActiveRenderInfo.getCameraPosition()).func_178788_d(light.start).func_72432_b().func_72430_b(vec) < Math.cos(Math.toRadians(light.degrees + 10.0f))) {
            RenderHelper.renderConeMesh(light.start.func_178788_d(playerPos), vec, height, (float)light.radius * 1.1f, 12);
        } else {
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GlStateManager.func_179128_n((int)5889);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GlStateManager.func_179128_n((int)5888);
            RenderHelper.renderFullscreenTriangle();
            GlStateManager.func_179128_n((int)5889);
            GL11.glPopMatrix();
            GlStateManager.func_179128_n((int)5888);
            GL11.glPopMatrix();
        }
        HbmShaderManager2.releaseShader();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
    }

    private static void renderObjects(Vec3d playerPos, Collection<RenderChunk> chunksToRender, Collection<Entity> entitiesToRender, Collection<TileEntity> tilesToRender, HbmShaderManager2.Shader shader, float partialTicks) {
        RenderHelper.bindBlockTexture();
        GlStateManager.func_179098_w();
        shader.use();
        RenderHelper.enableBlockVBOs();
        RenderHelper.renderChunks(chunksToRender, playerPos.field_72450_a, playerPos.field_72448_b, playerPos.field_72449_c);
        RenderHelper.disableBlockVBOs();
        OpenGlHelper.func_176072_g((int)OpenGlHelper.field_176089_P, (int)0);
        for (Entity ent : entitiesToRender) {
            Minecraft.func_71410_x().func_175598_ae().func_188388_a(ent, partialTicks, false);
            if (GL11.glGetInteger((int)GLCompat.GL_CURRENT_PROGRAM) == shader.getShaderId()) continue;
            blacklistedObjects.add(ent.getClass());
            shader.use();
        }
        for (TileEntity te : tilesToRender) {
            TileEntityRendererDispatcher.field_147556_a.func_180546_a(te, partialTicks, -1);
            if (GL11.glGetInteger((int)GLCompat.GL_CURRENT_PROGRAM) == shader.getShaderId()) continue;
            blacklistedObjects.add(te.getClass());
            shader.use();
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        HbmShaderManager2.releaseShader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void accumulateRenderObjects(ILight d) {
        AxisAlignedBB box = d.getBoundingBox();
        box = new AxisAlignedBB((double)(MathHelper.func_76128_c((double)(box.field_72340_a / 16.0)) * 16), (double)(MathHelper.func_76128_c((double)(MathHelper.func_151237_a((double)box.field_72338_b, (double)0.0, (double)255.0) / 16.0)) * 16), (double)(MathHelper.func_76128_c((double)(box.field_72339_c / 16.0)) * 16), (double)(MathHelper.func_76143_f((double)(box.field_72336_d / 16.0)) * 16), (double)(MathHelper.func_76143_f((double)(MathHelper.func_151237_a((double)box.field_72337_e, (double)0.0, (double)255.0) / 16.0)) * 16), (double)(MathHelper.func_76143_f((double)(box.field_72334_f / 16.0)) * 16));
        Entity renderView = Minecraft.func_71410_x().func_175606_aa();
        int i = (int)box.field_72340_a;
        while ((double)i < box.field_72336_d) {
            int j = (int)box.field_72338_b;
            while ((double)j < box.field_72337_e) {
                int k = (int)box.field_72339_c;
                while ((double)k < box.field_72334_f) {
                    if (Minecraft.func_71410_x().field_71441_e.func_175667_e(new BlockPos(i, j, k))) {
                        RenderChunk chunk = RenderHelper.getRenderChunk(new BlockPos(i, j, k));
                        ClassInheritanceMultiMap classinheritancemultimap = Minecraft.func_71410_x().field_71441_e.func_175726_f(chunk.func_178568_j()).func_177429_s()[chunk.func_178568_j().func_177956_o() / 16];
                        if (d.intersects(chunk.field_178591_c)) {
                            d.addChunkToRender(chunk);
                            if (d.doesTiles()) {
                                for (TileEntity te : chunk.field_178590_b.func_178485_b()) {
                                    if (blacklistedObjects.contains(te.getClass()) || !d.intersects(te.getRenderBoundingBox())) continue;
                                    d.addTileToRender(te);
                                }
                            }
                            if (d.doesEnts()) {
                                for (Entity ent : classinheritancemultimap) {
                                    if (blacklistedObjects.contains(ent.getClass()) || ent == renderView || !d.intersects(ent.func_184177_bl().func_186662_g(0.5))) continue;
                                    d.addEntToRender(ent);
                                }
                            }
                        }
                    }
                    k += 16;
                }
                j += 16;
            }
            i += 16;
        }
        if (d.doesTiles()) {
            try {
                Set globals;
                if (r_setTileEntities == null) {
                    r_setTileEntities = ReflectionHelper.findField(RenderGlobal.class, (String)"setTileEntities", (String)"field_181024_n");
                }
                Set set = globals = (Set)r_setTileEntities.get(Minecraft.func_71410_x().field_71438_f);
                synchronized (set) {
                    for (TileEntity te : globals) {
                        if (blacklistedObjects.contains(te.getClass()) || !d.intersects(te.getRenderBoundingBox())) continue;
                        d.addTileToRender(te);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    private static void renderShadowForLight(Vec3d entPos, DirectionalLight l, float partialTicks) {
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        l.projectionMatrix.store(ClientProxy.AUX_GL_BUFFER);
        ClientProxy.AUX_GL_BUFFER.rewind();
        GL11.glLoadMatrix((FloatBuffer)ClientProxy.AUX_GL_BUFFER);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        l.viewMatrix.store(ClientProxy.AUX_GL_BUFFER);
        ClientProxy.AUX_GL_BUFFER.rewind();
        GL11.glLoadMatrix((FloatBuffer)ClientProxy.AUX_GL_BUFFER);
        LightRenderer.renderObjects(entPos, l.chunksToRender, l.entsToRender, l.tilesToRender, ResourceManager.flashlight_depth, partialTicks);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
    }

    private static void sendPostShaderUniforms(DirectionalLight light, Vec3d entityPos, HbmShaderManager2.Shader shader) {
        Vec3d pos = light.start.func_178788_d(entityPos);
        float height = (float)light.end.func_178788_d(light.start).func_72433_c();
        shader.uniform1f("height", height);
        shader.uniform3f("fs_Pos", (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c);
        shader.uniform2f("zNearFar", 0.05f, (float)(Minecraft.func_71410_x().field_71474_y.field_151451_c * 16) * MathHelper.field_180189_a);
        shader.uniform1f("eyeHeight", Minecraft.func_71410_x().field_71439_g.func_70047_e());
        shader.uniform1f("brightness", light.brightness);
        shader.uniform1f("useShadows", light.shadows ? 1.0f : 0.0f);
        shader.uniform2f("shadowTexSize", 1024.0f, 1024.0f);
        GlStateManager.func_179138_g((int)GLCompat.GL_TEXTURE0);
        GlStateManager.func_179144_i((int)albedoTex);
        GlStateManager.func_179138_g((int)(GLCompat.GL_TEXTURE0 + 3));
        GlStateManager.func_179144_i((int)HbmShaderManager2.depthTexture);
        GlStateManager.func_179138_g((int)(GLCompat.GL_TEXTURE0 + 4));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(light.cookie);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GlStateManager.func_179138_g((int)(GLCompat.GL_TEXTURE0 + 5));
        GlStateManager.func_179144_i((int)shadowTex);
        GlStateManager.func_179138_g((int)GLCompat.GL_TEXTURE0);
        shader.uniform1i("mc_tex", 0);
        shader.uniform1i("depthBuffer", 3);
        shader.uniform1i("flashlightTex", 4);
        shader.uniform1i("shadowTex", 5);
        light.viewProjectionMatrix.store(ClientProxy.AUX_GL_BUFFER);
        ClientProxy.AUX_GL_BUFFER.rewind();
        shader.uniformMatrix4("flashlight_ViewProjectionMatrix", false, ClientProxy.AUX_GL_BUFFER);
        ClientProxy.AUX_GL_BUFFER.put(HbmShaderManager2.inv_ViewProjectionMatrix);
        ClientProxy.AUX_GL_BUFFER.rewind();
        shader.uniformMatrix4("inv_ViewProjectionMatrix", false, ClientProxy.AUX_GL_BUFFER);
    }

    private static void sendPointLightUniforms(PointLight light, Vec3d entityPos, HbmShaderManager2.Shader shader) {
        Vec3d pos = light.pos.func_178788_d(entityPos);
        Vec3d camPos = ActiveRenderInfo.getCameraPosition();
        shader.uniform3f("light_pos", (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c);
        shader.uniform3f("cam_pos", (float)camPos.field_72450_a, (float)camPos.field_72448_b, (float)camPos.field_72449_c);
        shader.uniform1f("brightness", light.energy);
        shader.uniform1f("radius", light.radius);
        shader.uniform3f("light_color", (float)light.color.field_72450_a, (float)light.color.field_72448_b, (float)light.color.field_72449_c);
        GlStateManager.func_179138_g((int)GLCompat.GL_TEXTURE0);
        GlStateManager.func_179144_i((int)albedoTex);
        GlStateManager.func_179138_g((int)(GLCompat.GL_TEXTURE0 + 3));
        GlStateManager.func_179144_i((int)HbmShaderManager2.depthTexture);
        GlStateManager.func_179138_g((int)GLCompat.GL_TEXTURE0);
        shader.uniform1i("mc_tex", 0);
        shader.uniform1i("depthBuffer", 3);
        ClientProxy.AUX_GL_BUFFER.put(HbmShaderManager2.inv_ViewProjectionMatrix);
        ClientProxy.AUX_GL_BUFFER.rewind();
        shader.uniformMatrix4("inv_ViewProjectionMatrix", false, ClientProxy.AUX_GL_BUFFER);
    }

    private static void initShadowBuffer() {
        shadowFbo = GLCompat.genFramebuffers();
        shadowTex = GL11.glGenTextures();
        GLCompat.bindFramebuffer(GLCompat.GL_FRAMEBUFFER, shadowFbo);
        GlStateManager.func_179144_i((int)shadowTex);
        GL11.glTexImage2D((int)3553, (int)0, (int)GLCompat.GL_DEPTH_COMPONENT24, (int)1024, (int)1024, (int)0, (int)6402, (int)5126, (FloatBuffer)null);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLCompat.framebufferTexture2D(GLCompat.GL_FRAMEBUFFER, GLCompat.GL_DEPTH_ATTACHMENT, 3553, shadowTex, 0);
    }

    private static void clearShadowBuffer() {
        GLCompat.bindFramebuffer(GLCompat.GL_FRAMEBUFFER, shadowFbo);
        GlStateManager.func_179151_a((double)1.0);
        GL11.glClear((int)256);
    }

    private static void recreateBuffers() {
        GL11.glDeleteTextures((int)albedoTex);
        GLCompat.deleteFramebuffers(albedoFbo);
        GLCompat.deleteRenderbuffers(albedoDepth);
        albedoFbo = GLCompat.genFramebuffers();
        albedoTex = GL11.glGenTextures();
        albedoDepth = GLCompat.genRenderbuffers();
        GLCompat.bindFramebuffer(GLCompat.GL_FRAMEBUFFER, albedoFbo);
        GlStateManager.func_179144_i((int)albedoTex);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)width, (int)height, (int)0, (int)6408, (int)5121, (FloatBuffer)null);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLCompat.framebufferTexture2D(GLCompat.GL_FRAMEBUFFER, GLCompat.GL_COLOR_ATTACHMENT0, 3553, albedoTex, 0);
        GLCompat.bindRenderbuffer(GLCompat.GL_RENDERBUFFER, albedoDepth);
        GLCompat.renderbufferStorage(GLCompat.GL_RENDERBUFFER, GLCompat.GL_DEPTH_COMPONENT24, width, height);
        GLCompat.framebufferRenderbuffer(GLCompat.GL_FRAMEBUFFER, GLCompat.GL_DEPTH_ATTACHMENT, GLCompat.GL_RENDERBUFFER, albedoDepth);
        GL11.glDeleteTextures((int)lightAccTex);
        GLCompat.deleteFramebuffers(lightAccFbo);
        lightAccFbo = GLCompat.genFramebuffers();
        lightAccTex = GL11.glGenTextures();
        GLCompat.bindFramebuffer(GLCompat.GL_FRAMEBUFFER, lightAccFbo);
        GlStateManager.func_179144_i((int)lightAccTex);
        GL11.glTexImage2D((int)3553, (int)0, (int)GLCompat.GL_RGBA16F, (int)width, (int)height, (int)0, (int)6408, (int)5126, (FloatBuffer)null);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLCompat.framebufferTexture2D(GLCompat.GL_FRAMEBUFFER, GLCompat.GL_COLOR_ATTACHMENT0, 3553, lightAccTex, 0);
        GL11.glDeleteTextures((int)volAccTex);
        GLCompat.deleteFramebuffers(volAccFbo);
        volAccFbo = GLCompat.genFramebuffers();
        volAccTex = GL11.glGenTextures();
        GLCompat.bindFramebuffer(GLCompat.GL_FRAMEBUFFER, volAccFbo);
        GlStateManager.func_179144_i((int)volAccTex);
        GL11.glTexImage2D((int)3553, (int)0, (int)GLCompat.GL_RGBA16F, (int)(width / 2), (int)(height / 2), (int)0, (int)6408, (int)5126, (FloatBuffer)null);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLCompat.framebufferTexture2D(GLCompat.GL_FRAMEBUFFER, GLCompat.GL_COLOR_ATTACHMENT0, 3553, volAccTex, 0);
        Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
    }

    private static void clearAccumulationBuffer() {
        GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLCompat.bindFramebuffer(GLCompat.GL_FRAMEBUFFER, lightAccFbo);
        GlStateManager.func_179086_m((int)16384);
        GLCompat.bindFramebuffer(GLCompat.GL_FRAMEBUFFER, volAccFbo);
        GlStateManager.func_179086_m((int)16384);
        Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
    }

    private static void clearAlbedoBuffer() {
        GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179151_a((double)1.0);
        GLCompat.bindFramebuffer(GLCompat.GL_FRAMEBUFFER, albedoFbo);
        GlStateManager.func_179086_m((int)16640);
        Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
    }

    static {
        blacklistedObjects = new HashSet();
        flashlights = new ArrayList<DirectionalLight>();
        point_lights = new ArrayList<PointLight>();
        albedoFbo = -1;
        albedoTex = -1;
        albedoDepth = -1;
        lightAccFbo = -1;
        lightAccTex = -1;
        volAccFbo = -1;
        volAccTex = -1;
        shadowFbo = -1;
        shadowTex = -1;
        init = false;
        lock = false;
    }

    public static class PointLight
    implements ILight {
        public static final float cutoff = 0.15f;
        public Vec3d pos;
        public Vec3d color;
        public float energy;
        public float radius;
        public boolean entities = true;
        public boolean tileentities = true;
        public List<RenderChunk> chunksToRender = new ArrayList<RenderChunk>();
        public List<TileEntity> tilesToRender;
        public List<Entity> entsToRender;

        public PointLight(Vec3d pos, float energy) {
            this(pos, new Vec3d(1.0, 1.0, 1.0), energy);
        }

        public PointLight(Vec3d pos, Vec3d color, float energy) {
            this(pos, color, energy, true, true);
        }

        public PointLight(Vec3d pos, Vec3d color, float energy, boolean tile, boolean ent) {
            this.pos = pos;
            this.color = color;
            this.energy = energy;
            this.radius = (float)Math.sqrt(Math.max(this.energy / 0.15f - 1.0f, 0.0f));
            this.entities = ent;
            this.tileentities = tile;
            if (this.tileentities) {
                this.tilesToRender = new ArrayList<TileEntity>();
            }
            if (this.entities) {
                this.entsToRender = new ArrayList<Entity>();
            }
        }

        @Override
        public AxisAlignedBB getBoundingBox() {
            return new AxisAlignedBB((double)(-this.radius), (double)(-this.radius), (double)(-this.radius), (double)this.radius, (double)this.radius, (double)this.radius).func_191194_a(this.pos);
        }

        @Override
        public void addEntToRender(Entity e) {
            this.entsToRender.add(e);
        }

        @Override
        public void addTileToRender(TileEntity t) {
            this.tilesToRender.add(t);
        }

        @Override
        public void addChunkToRender(RenderChunk r) {
            this.chunksToRender.add(r);
        }

        @Override
        public boolean doesEnts() {
            return this.entities;
        }

        @Override
        public boolean doesTiles() {
            return this.tileentities;
        }

        @Override
        public boolean intersects(AxisAlignedBB box) {
            Vec3d closestOnBox = new Vec3d(MathHelper.func_151237_a((double)this.pos.field_72450_a, (double)box.field_72340_a, (double)box.field_72336_d), MathHelper.func_151237_a((double)this.pos.field_72448_b, (double)box.field_72338_b, (double)box.field_72337_e), MathHelper.func_151237_a((double)this.pos.field_72449_c, (double)box.field_72339_c, (double)box.field_72334_f));
            return closestOnBox.func_72436_e(this.pos) < (double)(this.radius * this.radius);
        }
    }

    private static class DirectionalLight
    implements ILight {
        public Matrix4f projectionMatrix;
        public Matrix4f viewMatrix;
        public Matrix4f viewProjectionMatrix;
        public List<RenderChunk> chunksToRender = new ArrayList<RenderChunk>();
        public List<TileEntity> tilesToRender;
        public List<Entity> entsToRender;
        public Vec3d start;
        public Vec3d end;
        public float degrees;
        double height;
        double radius;
        public float brightness;
        public ResourceLocation cookie;
        public boolean shadows;
        public boolean volume;
        public boolean entities;
        public boolean tileentities;

        public DirectionalLight(Vec3d start, Vec3d end, float deg, float b, ResourceLocation cookie, boolean volume, boolean shadows, boolean entities, boolean tileentities) {
            this.start = start;
            this.end = end;
            this.degrees = deg;
            this.brightness = b;
            this.cookie = cookie;
            this.volume = volume;
            this.shadows = shadows;
            this.entities = entities;
            this.tileentities = tileentities;
            if (tileentities) {
                this.tilesToRender = new ArrayList<TileEntity>();
            }
            if (entities) {
                this.entsToRender = new ArrayList<Entity>();
            }
            double radians = Math.toRadians(this.degrees);
            Vec3d startToEnd = end.func_178788_d(start);
            this.height = startToEnd.func_72433_c();
            this.radius = this.height * Math.tan(radians);
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            Project.gluPerspective((float)(this.degrees * 2.0f), (float)1.0f, (float)0.05f, (float)((float)this.height * MathHelper.field_180189_a));
            GL11.glGetFloat((int)2983, (FloatBuffer)ClientProxy.AUX_GL_BUFFER);
            this.projectionMatrix = new Matrix4f();
            this.projectionMatrix.load(ClientProxy.AUX_GL_BUFFER);
            ClientProxy.AUX_GL_BUFFER.rewind();
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
        }

        public void setupViewProjectionMatrix(Vec3d entPos) {
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            Vec3d startToEnd = this.end.func_178788_d(this.start);
            Vec3d angles = BobMathUtil.getEulerAngles(startToEnd.func_72432_b());
            GL11.glRotated((double)(-angles.field_72448_b + 270.0), (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)(-angles.field_72450_a + 180.0), (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)(-(this.start.field_72450_a - entPos.field_72450_a)), (double)(-(this.start.field_72448_b - entPos.field_72448_b)), (double)(-(this.start.field_72449_c - entPos.field_72449_c)));
            this.viewMatrix = new Matrix4f();
            GL11.glGetFloat((int)2982, (FloatBuffer)ClientProxy.AUX_GL_BUFFER);
            this.viewMatrix.load(ClientProxy.AUX_GL_BUFFER);
            ClientProxy.AUX_GL_BUFFER.rewind();
            this.viewProjectionMatrix = new Matrix4f();
            Matrix4f.mul((Matrix4f)this.projectionMatrix, (Matrix4f)this.viewMatrix, (Matrix4f)this.viewProjectionMatrix);
            GL11.glPopMatrix();
        }

        @Override
        public AxisAlignedBB getBoundingBox() {
            return new AxisAlignedBB(this.start.field_72450_a, this.start.field_72448_b, this.start.field_72449_c, this.end.field_72450_a, this.end.field_72448_b, this.end.field_72449_c).func_186662_g(this.radius);
        }

        @Override
        public void addEntToRender(Entity e) {
            this.entsToRender.add(e);
        }

        @Override
        public void addTileToRender(TileEntity t) {
            this.tilesToRender.add(t);
        }

        @Override
        public void addChunkToRender(RenderChunk r) {
            this.chunksToRender.add(r);
        }

        @Override
        public boolean doesEnts() {
            return this.entities;
        }

        @Override
        public boolean doesTiles() {
            return this.tileentities;
        }

        @Override
        public boolean intersects(AxisAlignedBB box) {
            return Library.isBoxCollidingCone(box, this.start, this.end, this.degrees);
        }
    }

    private static interface ILight {
        public AxisAlignedBB getBoundingBox();

        public void addEntToRender(Entity var1);

        public void addTileToRender(TileEntity var1);

        public void addChunkToRender(RenderChunk var1);

        public boolean doesEnts();

        public boolean doesTiles();

        public boolean intersects(AxisAlignedBB var1);
    }
}

