/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.physics;

import com.hbm.physics.Collider;
import com.hbm.physics.RigidBody;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.render.util.Triangle;
import javax.vecmath.Matrix3f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class ConvexMeshCollider
extends Collider {
    public Triangle[] triangles;
    public float[] vertices;
    public int[] indices;
    public AxisAlignedBB localBox;

    private ConvexMeshCollider() {
    }

    public ConvexMeshCollider(Triangle[] triangles) {
        int[] indc = new int[triangles.length * 3];
        float[] verts = new float[triangles.length * 9];
        for (int i = 0; i < triangles.length; ++i) {
            indc[i * 3 + 0] = i * 9 + 0;
            indc[i * 3 + 1] = i * 9 + 3;
            indc[i * 3 + 2] = i * 9 + 6;
            verts[i * 9 + 0] = (float)triangles[i].p1.pos.field_72450_a;
            verts[i * 9 + 1] = (float)triangles[i].p1.pos.field_72448_b;
            verts[i * 9 + 2] = (float)triangles[i].p1.pos.field_72449_c;
            verts[i * 9 + 3] = (float)triangles[i].p2.pos.field_72450_a;
            verts[i * 9 + 4] = (float)triangles[i].p2.pos.field_72448_b;
            verts[i * 9 + 5] = (float)triangles[i].p2.pos.field_72449_c;
            verts[i * 9 + 6] = (float)triangles[i].p3.pos.field_72450_a;
            verts[i * 9 + 7] = (float)triangles[i].p3.pos.field_72448_b;
            verts[i * 9 + 8] = (float)triangles[i].p3.pos.field_72449_c;
        }
        this.fromData(indc, verts);
    }

    public ConvexMeshCollider(Triangle[] triangles, float density) {
        this(triangles);
        this.localCentroid = this.computeCenterOfMass();
        this.mass = this.computeVolume() * density;
        this.localInertiaTensor = this.computeInertia(this.localCentroid, this.mass);
    }

    public ConvexMeshCollider(int[] indices, float[] vertices, float density) {
        this.fromData(indices, vertices, density);
    }

    public ConvexMeshCollider(int[] indices, float[] vertices) {
        this.fromData(indices, vertices);
    }

    public void fromData(int[] indices, float[] vertices, float density) {
        this.fromData(indices, vertices);
        this.localCentroid = this.computeCenterOfMass();
        this.mass = this.computeVolume() * density;
        this.localInertiaTensor = this.computeInertia(this.localCentroid, this.mass);
    }

    public void fromData(int[] indices, float[] vertices) {
        this.indices = indices;
        this.vertices = vertices;
        this.triangles = new Triangle[indices.length / 3];
        for (int i = 0; i < indices.length; i += 3) {
            Vec3d p1 = new Vec3d((double)vertices[indices[i + 0] * 3 + 0], (double)vertices[indices[i + 0] * 3 + 1], (double)vertices[indices[i + 0] * 3 + 2]);
            Vec3d p2 = new Vec3d((double)vertices[indices[i + 1] * 3 + 0], (double)vertices[indices[i + 1] * 3 + 1], (double)vertices[indices[i + 1] * 3 + 2]);
            Vec3d p3 = new Vec3d((double)vertices[indices[i + 2] * 3 + 0], (double)vertices[indices[i + 2] * 3 + 1], (double)vertices[indices[i + 2] * 3 + 2]);
            this.triangles[i / 3] = new Triangle(p1, p2, p3);
        }
        double maxX = this.support((Vec3)RigidBody.cardinals[0]).xCoord;
        double maxY = this.support((Vec3)RigidBody.cardinals[1]).yCoord;
        double maxZ = this.support((Vec3)RigidBody.cardinals[2]).zCoord;
        double minX = this.support((Vec3)RigidBody.cardinals[3]).xCoord;
        double minY = this.support((Vec3)RigidBody.cardinals[4]).yCoord;
        double minZ = this.support((Vec3)RigidBody.cardinals[5]).zCoord;
        this.localBox = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private float computeVolume() {
        float vol = 0.0f;
        for (Triangle t : this.triangles) {
            vol += new Matrix3f((float)t.p1.pos.field_72450_a, (float)t.p1.pos.field_72448_b, (float)t.p1.pos.field_72449_c, (float)t.p2.pos.field_72450_a, (float)t.p2.pos.field_72448_b, (float)t.p2.pos.field_72449_c, (float)t.p3.pos.field_72450_a, (float)t.p3.pos.field_72448_b, (float)t.p3.pos.field_72449_c).determinant();
        }
        return vol / 6.0f;
    }

    private Vec3 computeCenterOfMass() {
        Vec3 center = new Vec3(0.0, 0.0, 0.0);
        float volume = 0.0f;
        for (Triangle t : this.triangles) {
            Matrix3f mat = new Matrix3f((float)t.p1.pos.field_72450_a, (float)t.p1.pos.field_72448_b, (float)t.p1.pos.field_72449_c, (float)t.p2.pos.field_72450_a, (float)t.p2.pos.field_72448_b, (float)t.p2.pos.field_72449_c, (float)t.p3.pos.field_72450_a, (float)t.p3.pos.field_72448_b, (float)t.p3.pos.field_72449_c);
            float vol = mat.determinant();
            center.xCoord += (double)(vol * (mat.m00 + mat.m10 + mat.m20));
            center.yCoord += (double)(vol * (mat.m01 + mat.m11 + mat.m21));
            center.zCoord += (double)(vol * (mat.m02 + mat.m12 + mat.m22));
            volume += vol;
        }
        center.xCoord /= (double)(volume * 4.0f);
        center.yCoord /= (double)(volume * 4.0f);
        center.zCoord /= (double)(volume * 4.0f);
        return center;
    }

    private Matrix3f computeInertia(Vec3 com, float mass) {
        float volume = 0.0f;
        Vec3 diag = new Vec3(0.0, 0.0, 0.0);
        Vec3 offd = new Vec3(0.0, 0.0, 0.0);
        for (Triangle t : this.triangles) {
            Matrix3f mat = new Matrix3f((float)(t.p1.pos.field_72450_a - com.xCoord), (float)(t.p1.pos.field_72448_b - com.yCoord), (float)(t.p1.pos.field_72449_c - com.zCoord), (float)(t.p2.pos.field_72450_a - com.xCoord), (float)(t.p2.pos.field_72448_b - com.yCoord), (float)(t.p2.pos.field_72449_c - com.zCoord), (float)(t.p3.pos.field_72450_a - com.xCoord), (float)(t.p3.pos.field_72448_b - com.yCoord), (float)(t.p3.pos.field_72449_c - com.zCoord));
            float d = mat.determinant();
            volume += d;
            for (int j = 0; j < 3; ++j) {
                int j1 = (j + 1) % 3;
                int j2 = (j + 2) % 3;
                ConvexMeshCollider.setVal(diag, j, ConvexMeshCollider.val(diag, j) + (double)((mat.getElement(0, j) * mat.getElement(1, j) + mat.getElement(1, j) * mat.getElement(2, j) + mat.getElement(2, j) * mat.getElement(0, j) + mat.getElement(0, j) * mat.getElement(0, j) + mat.getElement(1, j) * mat.getElement(1, j) + mat.getElement(2, j) * mat.getElement(2, j)) * d));
                ConvexMeshCollider.setVal(offd, j, ConvexMeshCollider.val(offd, j) + (double)((mat.getElement(0, j1) * mat.getElement(1, j2) + mat.getElement(1, j1) * mat.getElement(2, j2) + mat.getElement(2, j1) * mat.getElement(0, j2) + mat.getElement(0, j1) * mat.getElement(2, j2) + mat.getElement(1, j1) * mat.getElement(0, j2) + mat.getElement(2, j1) * mat.getElement(1, j2) + mat.getElement(0, j1) * mat.getElement(0, j2) + mat.getElement(1, j1) * mat.getElement(1, j2) + mat.getElement(2, j1) * mat.getElement(2, j2)) * d));
            }
        }
        float volume2 = volume * 10.0f;
        diag.xCoord /= (double)volume2;
        diag.yCoord /= (double)volume2;
        diag.zCoord /= (double)volume2;
        volume2 = volume * 20.0f;
        offd.xCoord /= (double)volume2;
        offd.yCoord /= (double)volume2;
        offd.zCoord /= (double)volume2;
        diag = diag.mult(mass);
        offd = offd.mult(mass);
        return new Matrix3f((float)(diag.yCoord + diag.zCoord), (float)(-offd.zCoord), (float)(-offd.yCoord), (float)(-offd.zCoord), (float)(diag.xCoord + diag.zCoord), (float)(-offd.xCoord), (float)(-offd.yCoord), (float)(-offd.xCoord), (float)(diag.xCoord + diag.yCoord));
    }

    private static void setVal(Vec3 vec, int idx, double val) {
        switch (idx) {
            case 0: {
                vec.xCoord = val;
                return;
            }
            case 1: {
                vec.yCoord = val;
                return;
            }
            case 2: {
                vec.zCoord = val;
                return;
            }
        }
    }

    private static double val(Vec3 vec, int idx) {
        switch (idx) {
            case 0: {
                return vec.xCoord;
            }
            case 1: {
                return vec.yCoord;
            }
            case 2: {
                return vec.zCoord;
            }
        }
        throw new RuntimeException("Out of range");
    }

    @Override
    public Vec3 support(Vec3 dir) {
        double dot = -3.4028234663852886E38;
        int index = 0;
        for (int i = 0; i < this.vertices.length; i += 3) {
            double newDot = dir.xCoord * (double)this.vertices[i] + dir.yCoord * (double)this.vertices[i + 1] + dir.zCoord * (double)this.vertices[i + 2];
            if (!(newDot > dot)) continue;
            dot = newDot;
            index = i;
        }
        return new Vec3(this.vertices[index], this.vertices[index + 1], this.vertices[index + 2]);
    }

    @Override
    public Collider copy() {
        ConvexMeshCollider c = new ConvexMeshCollider();
        c.vertices = this.vertices;
        c.indices = this.indices;
        c.triangles = this.triangles;
        c.localBox = this.localBox;
        c.localCentroid = this.localCentroid;
        c.localInertiaTensor = this.localInertiaTensor;
        c.mass = this.mass;
        return c;
    }

    @Override
    public void debugRender() {
        BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179090_x();
        buf.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        for (Triangle t : this.triangles) {
            buf.func_181662_b(t.p1.pos.field_72450_a, t.p1.pos.field_72448_b, t.p1.pos.field_72449_c).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            buf.func_181662_b(t.p2.pos.field_72450_a, t.p2.pos.field_72448_b, t.p2.pos.field_72449_c).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            buf.func_181662_b(t.p2.pos.field_72450_a, t.p2.pos.field_72448_b, t.p2.pos.field_72449_c).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            buf.func_181662_b(t.p3.pos.field_72450_a, t.p3.pos.field_72448_b, t.p3.pos.field_72449_c).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            buf.func_181662_b(t.p3.pos.field_72450_a, t.p3.pos.field_72448_b, t.p3.pos.field_72449_c).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            buf.func_181662_b(t.p1.pos.field_72450_a, t.p1.pos.field_72448_b, t.p1.pos.field_72449_c).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        }
        GlStateManager.func_179098_w();
        Tessellator.func_178181_a().func_78381_a();
    }
}

