/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.interfaces.IDoor;
import com.hbm.tileentity.machine.TileEntityBlastDoor;
import com.hbm.tileentity.machine.TileEntityLockableBase;
import com.hbm.tileentity.machine.TileEntityVaultDoor;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TEVaultPacket
implements IMessage {
    int x;
    int y;
    int z;
    boolean isOpening;
    int state;
    long sysTime;
    int type;

    public TEVaultPacket() {
    }

    public TEVaultPacket(int x, int y, int z, int state, long sysTime, int type) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.state = state;
        this.sysTime = sysTime;
        this.type = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.state = buf.readInt();
        this.sysTime = buf.readLong();
        this.type = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.state);
        buf.writeLong(this.sysTime);
        buf.writeInt(this.type);
    }

    public static class Handler
    implements IMessageHandler<TEVaultPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(TEVaultPacket m, MessageContext ctx) {
            if (m == null) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                BlockPos pos = new BlockPos(m.x, m.y, m.z);
                if (world.func_175667_e(pos)) {
                    TileEntityLockableBase vault;
                    TileEntity te = world.func_175625_s(pos);
                    if (te != null && te instanceof TileEntityVaultDoor) {
                        vault = (TileEntityVaultDoor)te;
                        vault.state = IDoor.DoorState.values()[m.state];
                        if (m.sysTime == 1L) {
                            vault.sysTime = System.currentTimeMillis();
                        }
                        vault.type = m.type;
                    }
                    if (te != null && te instanceof TileEntityBlastDoor) {
                        vault = (TileEntityBlastDoor)te;
                        ((TileEntityBlastDoor)vault).state = IDoor.DoorState.values()[m.state];
                        if (m.sysTime == 1L) {
                            ((TileEntityBlastDoor)vault).sysTime = System.currentTimeMillis();
                        }
                    }
                }
            });
            return null;
        }
    }
}

