/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.items.weapon.ItemGunBase;
import com.hbm.render.anim.HbmAnimations;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GunAnimationPacket
implements IMessage {
    int type;
    EnumHand hand;

    public GunAnimationPacket() {
    }

    public GunAnimationPacket(int type, EnumHand hand) {
        this.type = type;
        this.hand = hand;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = buf.readInt();
        this.hand = buf.readInt() > 0 ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type);
        buf.writeInt(this.hand == EnumHand.MAIN_HAND ? 0 : 1);
    }

    public static class Handler
    implements IMessageHandler<GunAnimationPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(GunAnimationPacket m, MessageContext ctx) {
            try {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                ItemStack stack = player.func_184586_b(m.hand);
                int slot = player.field_71071_by.field_70461_c;
                if (m.hand == EnumHand.OFF_HAND) {
                    slot = 9;
                }
                if (stack == null) {
                    return null;
                }
                if (!(stack.func_77973_b() instanceof ItemGunBase)) {
                    return null;
                }
                if (m.type < 0 || m.type >= HbmAnimations.AnimType.values().length) {
                    return null;
                }
                HbmAnimations.AnimType type = HbmAnimations.AnimType.values()[m.type];
                ((ItemGunBase)stack.func_77973_b()).startAnim((EntityPlayer)player, stack, slot, type);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

