/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.config.CompatibilityConfig;
import com.hbm.handler.GunConfiguration;
import com.hbm.items.weapon.ItemGunBase;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.main.ResourceManager;
import com.hbm.packet.GunAnimationPacket;
import com.hbm.packet.GunFXPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.particle.vortex.ParticleVortexBeam;
import com.hbm.particle.vortex.ParticleVortexCircle;
import com.hbm.particle.vortex.ParticleVortexFireFlash;
import com.hbm.particle.vortex.ParticleVortexGlow;
import com.hbm.particle.vortex.ParticleVortexHit;
import com.hbm.particle.vortex.ParticleVortexParticle;
import com.hbm.render.RenderHelper;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.util.BobMathUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ItemGunVortex
extends ItemGunBase {
    @SideOnly(value=Side.CLIENT)
    private long lastFireTime;

    public ItemGunVortex(GunConfiguration config, String s) {
        super(config, s);
    }

    @Override
    protected void spawnProjectile(World world, EntityPlayer player, ItemStack stack, int config, EnumHand hand) {
        List entsOnBeam = (List)Library.rayTraceEntitiesOnLine(player, 100.0, 1.0f).getRight();
        for (Entity e : entsOnBeam) {
            if (!(e instanceof EntityLivingBase) || !CompatibilityConfig.isWarDim(world)) continue;
            float dmg = 30.0f;
            try {
                if (ItemGunBase.hurtResistantTime == null) {
                    ItemGunBase.hurtResistantTime = ReflectionHelper.findField(Entity.class, (String)"hurtResistantTime", (String)"field_70172_ad");
                }
                ItemGunBase.hurtResistantTime.setInt(e, 0);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            e.func_70097_a(ModDamageSource.radiation, dmg);
        }
        if (this.mainConfig.animations.containsKey((Object)HbmAnimations.AnimType.CYCLE) && player instanceof EntityPlayerMP) {
            PacketDispatcher.wrapper.sendTo((IMessage)new GunAnimationPacket(HbmAnimations.AnimType.CYCLE.ordinal(), hand), (EntityPlayerMP)player);
        }
        PacketDispatcher.wrapper.sendToAllTracking((IMessage)new GunFXPacket(player, hand, GunFXPacket.FXType.FIRE), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onFireClient(ItemStack stack, EntityPlayer player, boolean shouldDoThirdPerson) {
        NBTTagCompound tag = new NBTTagCompound();
        Vec3d pos = null;
        pos = stack == player.func_184614_ca() ? new Vec3d(-0.16, -0.2, 1.0).func_178789_a(-((float)Math.toRadians(player.field_70125_A))).func_178785_b(-((float)Math.toRadians(player.field_70759_as))) : new Vec3d(0.16, -0.2, 1.0).func_178789_a(-((float)Math.toRadians(player.field_70125_A))).func_178785_b(-((float)Math.toRadians(player.field_70759_as)));
        pos = pos.func_178787_e(player.func_174824_e(1.0f));
        Vec3d view = BobMathUtil.getVectorFromAngle(BobMathUtil.getEulerAngles(player.func_70040_Z()).func_72441_c(0.0, 3.0, 0.0));
        Vec3d hitPos = null;
        Vec3d hitNormal = null;
        RayTraceResult r = Library.rayTraceIncludeEntities(player, 100.0, MainRegistry.proxy.partialTicks());
        if (r == null || r.field_72313_a == RayTraceResult.Type.MISS) {
            hitPos = player.func_70676_i(MainRegistry.proxy.partialTicks()).func_186678_a(100.0).func_178787_e(pos);
        } else {
            hitPos = r.field_72307_f;
            hitNormal = new Vec3d((double)r.field_178784_b.func_82601_c(), (double)r.field_178784_b.func_96559_d(), (double)r.field_178784_b.func_82599_e());
        }
        tag.func_74778_a("type", "spark");
        tag.func_74778_a("mode", "coneBurst");
        tag.func_74780_a("posX", pos.field_72450_a - player.field_70159_w);
        tag.func_74780_a("posY", pos.field_72448_b - player.field_70181_x);
        tag.func_74780_a("posZ", pos.field_72449_c - player.field_70179_y);
        tag.func_74780_a("dirX", view.field_72450_a);
        tag.func_74780_a("dirY", view.field_72448_b);
        tag.func_74780_a("dirZ", view.field_72449_c);
        tag.func_74776_a("r", 0.2f);
        tag.func_74776_a("g", 0.8f);
        tag.func_74776_a("b", 0.9f);
        tag.func_74776_a("a", 1.5f);
        tag.func_74768_a("lifetime", 1);
        tag.func_74776_a("width", 0.01f);
        tag.func_74776_a("length", 2.0f);
        tag.func_74776_a("gravity", 0.0f);
        tag.func_74776_a("angle", 15.0f);
        tag.func_74768_a("count", 12);
        MainRegistry.proxy.effectNT(tag);
        ParticleVortexBeam beam = new ParticleVortexBeam(player.field_70170_p, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, hitPos.field_72450_a, hitPos.field_72448_b, hitPos.field_72449_c, shouldDoThirdPerson);
        beam.color(0.5f, 0.8f, 0.9f, 2.0f);
        beam.width(0.125f);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)beam);
        ParticleVortexFireFlash flash = new ParticleVortexFireFlash(player.field_70170_p, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, hitPos.field_72450_a, hitPos.field_72448_b, hitPos.field_72449_c);
        flash.color(0.5f, 0.8f, 0.9f, 1.0f);
        flash.width(0.5f);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)flash);
        Vec3d line = hitPos.func_178788_d(pos);
        int circleParticles = (int)line.func_72433_c();
        for (int i = 0; i < circleParticles; ++i) {
            Vec3d circlePos = line.func_186678_a((double)((float)i / (float)circleParticles)).func_178787_e(pos);
            ParticleVortexCircle c = new ParticleVortexCircle(player.field_70170_p, circlePos.field_72450_a, circlePos.field_72448_b, circlePos.field_72449_c, 0.5f + player.field_70170_p.field_73012_v.nextFloat() * 0.3f);
            c.color(0.5f, 0.8f, 0.9f, 0.15f);
            c.lifetime((int)(15.0f + (float)i / (float)circleParticles * 10.0f));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)c);
        }
        int extraParticles = (int)line.func_72433_c();
        for (int i = 0; i < extraParticles; ++i) {
            Vec3d circlePos = line.func_186678_a((double)((float)i / (float)circleParticles) * 0.25).func_178787_e(pos);
            float randX = (float)(player.field_70170_p.field_73012_v.nextGaussian() - 0.5) * 0.01f;
            float randY = (float)(player.field_70170_p.field_73012_v.nextGaussian() - 0.5) * 0.01f;
            float randZ = (float)(player.field_70170_p.field_73012_v.nextGaussian() - 0.5) * 0.01f;
            ParticleVortexParticle c = new ParticleVortexParticle(player.field_70170_p, circlePos.field_72450_a + (double)randX, circlePos.field_72448_b + (double)randY, circlePos.field_72449_c + (double)randZ, 0.5f);
            c.color(0.5f, 0.8f, 0.9f, 0.15f);
            c.lifetime(30);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)c);
        }
        ParticleVortexGlow glow = new ParticleVortexGlow(player.field_70170_p, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 2.0f);
        glow.color(0.3f, 0.7f, 1.0f, 0.5f);
        glow.lifetime(15);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)glow);
        if (hitNormal != null) {
            Vec3d sparkAxis = line.func_72432_b().func_186678_a(0.25);
            switch (r.field_178784_b.func_176740_k()) {
                case X: {
                    sparkAxis = new Vec3d(-sparkAxis.field_72450_a, sparkAxis.field_72448_b, sparkAxis.field_72449_c);
                    break;
                }
                case Y: {
                    sparkAxis = new Vec3d(sparkAxis.field_72450_a, -sparkAxis.field_72448_b, sparkAxis.field_72449_c);
                    break;
                }
                case Z: {
                    sparkAxis = new Vec3d(sparkAxis.field_72450_a, sparkAxis.field_72448_b, -sparkAxis.field_72449_c);
                }
            }
            tag = new NBTTagCompound();
            tag.func_74778_a("type", "spark");
            tag.func_74778_a("mode", "coneBurst");
            tag.func_74780_a("posX", hitPos.field_72450_a);
            tag.func_74780_a("posY", hitPos.field_72448_b);
            tag.func_74780_a("posZ", hitPos.field_72449_c);
            tag.func_74780_a("dirX", sparkAxis.field_72450_a);
            tag.func_74780_a("dirY", sparkAxis.field_72448_b + 0.1);
            tag.func_74780_a("dirZ", sparkAxis.field_72449_c);
            tag.func_74776_a("r", 0.2f);
            tag.func_74776_a("g", 0.8f);
            tag.func_74776_a("b", 0.9f);
            tag.func_74776_a("a", 1.5f);
            tag.func_74768_a("lifetime", 20);
            tag.func_74768_a("randLifetime", 30);
            tag.func_74776_a("width", 0.015f);
            tag.func_74776_a("length", 0.5f);
            tag.func_74776_a("gravity", 0.05f);
            tag.func_74776_a("angle", 70.0f);
            tag.func_74768_a("count", 15);
            tag.func_74776_a("randomVelocity", 0.1f);
            MainRegistry.proxy.effectNT(tag);
            ParticleVortexHit hit = new ParticleVortexHit(player.field_70170_p, hitPos.field_72450_a, hitPos.field_72448_b, hitPos.field_72449_c, 2.5f + player.field_70170_p.field_73012_v.nextFloat() * 0.5f, 90.0f);
            hit.color(0.4f, 0.8f, 1.0f, 0.25f);
            hit.lifetime(20);
            ParticleVortexHit hit2 = new ParticleVortexHit(player.field_70170_p, hitPos.field_72450_a, hitPos.field_72448_b, hitPos.field_72449_c, 2.5f + player.field_70170_p.field_73012_v.nextFloat() * 0.5f, -90.0f);
            hit2.color(0.4f, 0.8f, 1.0f, 0.25f);
            hit2.lifetime(20);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)hit);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)hit2);
        }
        MainRegistry.proxy.setRecoil(3.0f);
        this.lastFireTime = System.currentTimeMillis();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasCustomHudElement() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHud(ScaledResolution res, GuiIngame gui, ItemStack stack, float partialTicks) {
        float x = res.func_78326_a() / 2;
        float y = res.func_78328_b() / 2;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.vortex_hud_reticle);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GlStateManager.func_179131_c((float)0.4f, (float)0.9f, (float)0.9f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.drawGuiRect(x - 11.0f, y - 11.0f, 0.0f, 0.0f, 22.0f, 22.0f, 1.0f, 1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.vortex_hud_circle);
        long time = System.currentTimeMillis();
        float cooldown = MathHelper.func_76131_a((float)((float)(time - this.lastFireTime) / (float)(this.mainConfig.rateOfFire * 55)), (float)0.0f, (float)1.0f) + 0.05f;
        int SUBDIVISIONS = 64;
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        buf.func_181668_a(6, DefaultVertexFormats.field_181709_i);
        buf.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.5, 0.5).func_181666_a(0.4f, 0.9f, 0.9f, 0.4f).func_181675_d();
        for (int i = 0; i < 65; ++i) {
            float ratio = (float)i / 64.0f;
            float x2 = MathHelper.func_76126_a((float)((float)((double)ratio * Math.PI * 2.0 + 1.5707963267948966)));
            float y2 = MathHelper.func_76134_b((float)((float)((double)ratio * Math.PI * 2.0 + 1.5707963267948966)));
            float alphaMult = 1.0f - ratio < cooldown ? 1.0f : 0.0f;
            buf.func_181662_b((double)(x + x2 * 11.0f), (double)(y + y2 * 11.0f), 0.0).func_187315_a((double)BobMathUtil.remap01(x2, -1.0f, 1.0f), (double)BobMathUtil.remap01(y2, -1.0f, 1.0f)).func_181666_a(0.4f, 0.9f, 0.9f, 0.4f * alphaMult).func_181675_d();
        }
        tes.func_78381_a();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179084_k();
    }
}

