/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.animloader.AnimationWrapper;
import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.HbmShaderManager2;
import com.hbm.items.weapon.ItemGunBase;
import com.hbm.main.MainRegistry;
import com.hbm.main.ResourceManager;
import com.hbm.particle.ParticleBatchRenderer;
import com.hbm.particle.bullet_hit.ParticleSmokeAnim;
import com.hbm.render.LightRenderer;
import com.hbm.render.RenderHelper;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.item.weapon.ItemRenderJShotgun;
import com.hbm.util.BobMathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector4f;

public class ItemGunJShotty
extends ItemGunBase {
    public ItemGunJShotty(GunConfiguration config, String s) {
        super(config, s);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void startAnim(EntityPlayer player, ItemStack stack, int slot, HbmAnimations.AnimType type) {
        switch (type) {
            case RELOAD: {
                int bullets = ItemGunJShotty.getMag(stack);
                if (bullets == 1) {
                    HbmAnimations.hotbar[slot] = new HbmAnimations.BlenderAnimation(stack.func_77973_b().func_77658_a(), System.currentTimeMillis(), 1.0f, ResourceManager.jshotgun_anim0, new AnimationWrapper.EndResult(AnimationWrapper.EndType.END));
                    break;
                }
                if (bullets != 0) break;
                HbmAnimations.hotbar[slot] = new HbmAnimations.BlenderAnimation(stack.func_77973_b().func_77658_a(), System.currentTimeMillis(), 1.0f, ResourceManager.jshotgun_anim1, new AnimationWrapper.EndResult(AnimationWrapper.EndType.END));
                break;
            }
            case CYCLE: {
                if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                    MainRegistry.proxy.setRecoil(10.0f);
                }
                float partialTicks = MainRegistry.proxy.partialTicks();
                Vec3d start = new Vec3d(-0.28, -0.1, 2.0).func_178789_a(-((float)Math.toRadians(player.field_70125_A))).func_178785_b(-((float)Math.toRadians(player.field_70177_z))).func_178787_e(player.func_174824_e(partialTicks));
                Vec3d look = player.func_70676_i(partialTicks);
                look = BobMathUtil.randVecInCone(look, 20.0f);
                look = look.func_186678_a((double)0.1f);
                ParticleBatchRenderer.addParticle(new ParticleSmokeAnim(player.field_70170_p, start.field_72450_a, start.field_72448_b, start.field_72449_c, 0.05f, 4.0f, 0.15f, 5).gravity(-0.01f).motion((float)look.field_72450_a, (float)look.field_72448_b, (float)look.field_72449_c).color(1.0f, 1.0f, 1.0f, 0.5f));
            }
            default: {
                super.startAnim(player, stack, slot, type);
            }
        }
    }

    @Override
    protected EntityBulletBase getBulletEntity(World world, EntityPlayer player, ItemStack stack, int config, EnumHand hand) {
        EntityBulletBase b = super.getBulletEntity(world, player, stack, config, hand);
        b.overrideDamage = 4 + world.field_73012_v.nextInt(7);
        b.overrideMaxAge = 4 + world.field_73012_v.nextInt(3);
        b.overrideStyle(13);
        return b;
    }

    @Override
    protected int getBullets(World world, EntityPlayer player, EnumHand hand, BulletConfiguration config) {
        return 8 + world.field_73012_v.nextInt(5);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playerWorldRender(EntityPlayer player, RenderWorldLastEvent e, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            float partialTicks = e.getPartialTicks();
            Vec3d start = new Vec3d(-0.28, -0.1, 2.0).func_178789_a(-((float)Math.toRadians(player.field_70125_A))).func_178785_b(-((float)Math.toRadians(player.field_70177_z))).func_178787_e(player.func_174824_e(partialTicks));
            Vec3d direction = player.func_70676_i(partialTicks);
            if (ItemGunJShotty.getFlashlightActive(player.func_184614_ca())) {
                if (ItemRenderJShotgun.firstPersonFlashlightPos != null && player == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                    Vec3d world = RenderHelper.unproject_world(HbmShaderManager2.inv_ViewProjectionMatrix, ItemRenderJShotgun.firstPersonFlashlightPos[0], ItemRenderJShotgun.firstPersonFlashlightPos[1], 1.0f);
                    Vec3d eyePos = player.func_174824_e(partialTicks);
                    Entity ent = Minecraft.func_71410_x().func_175606_aa();
                    double rPosX = ent.field_70169_q + (ent.field_70165_t - ent.field_70169_q) * (double)partialTicks;
                    double rPosY = ent.field_70167_r + (ent.field_70163_u - ent.field_70167_r) * (double)partialTicks;
                    double rPosZ = ent.field_70166_s + (ent.field_70161_v - ent.field_70166_s) * (double)partialTicks;
                    Vec3d camPos = ActiveRenderInfo.getCameraPosition().func_72441_c(rPosX, rPosY, rPosZ);
                    start = camPos.func_178787_e(world.func_178788_d(eyePos).func_72432_b().func_186678_a(1.0));
                    Vec3d dir = BobMathUtil.viewToLocal(new Vector4f((float)ItemRenderJShotgun.flashlightDirection.field_72450_a, (float)ItemRenderJShotgun.flashlightDirection.field_72448_b, (float)ItemRenderJShotgun.flashlightDirection.field_72449_c, 0.0f))[0].func_72432_b();
                    direction = new Vec3d(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
                }
                LightRenderer.addFlashlight(start, start.func_178787_e(direction.func_186678_a(30.0)), 20.0f, 500.0f, ResourceManager.fl_cookie, true, true);
            }
            if (ItemGunJShotty.getDelay(player.func_184614_ca()) == this.mainConfig.rateOfFire && partialTicks < 0.9f) {
                LightRenderer.addPointLight(start, new Vec3d(1.0, 0.72, 0.46), 15.0f);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack;
        ItemGunJShotty.setFlashlightActive(stack, !ItemGunJShotty.getFlashlightActive(stack = playerIn.func_184586_b(handIn)));
        worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187750_dc, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(RenderGameOverlayEvent.Pre event, RenderGameOverlayEvent.ElementType type, EntityPlayer player, ItemStack stack, EnumHand hand) {
        super.renderHUD(event, type, player, stack, hand);
        if (type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            ScaledResolution res = event.getResolution();
            float x = res.func_78326_a() / 2;
            float y = res.func_78328_b() / 2;
            GL11.glPushMatrix();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.shotgun_crosshair);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179131_c((float)0.7f, (float)1.0f, (float)0.5f, (float)1.0f);
            RenderHelper.drawGuiRect(x - 20.0f, y - 20.0f, 0.0f, 0.0f, 40.0f, 40.0f, 1.0f, 1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179084_k();
            GL11.glPopMatrix();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
        }
    }

    public static void setFlashlightActive(ItemStack stack, boolean b) {
        ItemGunJShotty.writeNBT(stack, "flashlightActive", b ? 1 : 0);
    }

    public static boolean getFlashlightActive(ItemStack stack) {
        return ItemGunJShotty.readNBT(stack, "flashlightActive") == 1;
    }
}

