/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import api.hbm.energy.IBatteryItem;
import com.hbm.items.tool.ItemToolAbility;
import com.hbm.lib.Library;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemToolAbilityPower
extends ItemToolAbility
implements IBatteryItem {
    public long maxPower = 1L;
    public long chargeRate;
    public long consumption;

    public ItemToolAbilityPower(float damage, float attackSpeedIn, double movement, Item.ToolMaterial material, ItemToolAbility.EnumToolType type, long maxPower, long chargeRate, long consumption, String s) {
        super(damage, attackSpeedIn, movement, material, type, s);
        this.maxPower = maxPower;
        this.chargeRate = chargeRate;
        this.consumption = consumption;
        this.func_77656_e(1);
    }

    @Override
    public void chargeBattery(ItemStack stack, long i) {
        if (stack.func_77973_b() instanceof ItemToolAbilityPower) {
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_74772_a("charge", stack.func_77978_p().func_74763_f("charge") + i);
            } else {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74772_a("charge", i);
            }
        }
    }

    @Override
    public void setCharge(ItemStack stack, long i) {
        if (stack.func_77973_b() instanceof ItemToolAbilityPower) {
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_74772_a("charge", i);
            } else {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74772_a("charge", i);
            }
        }
    }

    @Override
    public void dischargeBattery(ItemStack stack, long i) {
        if (stack.func_77973_b() instanceof ItemToolAbilityPower) {
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_74772_a("charge", stack.func_77978_p().func_74763_f("charge") - i);
            } else {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74772_a("charge", this.maxPower - i);
            }
            if (stack.func_77978_p().func_74763_f("charge") < 0L) {
                stack.func_77978_p().func_74772_a("charge", 0L);
            }
        }
    }

    @Override
    public long getCharge(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemToolAbilityPower) {
            if (stack.func_77942_o()) {
                return stack.func_77978_p().func_74763_f("charge");
            }
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74772_a("charge", ((ItemToolAbilityPower)stack.func_77973_b()).maxPower);
            return stack.func_77978_p().func_74763_f("charge");
        }
        return 0L;
    }

    public static String getColor(long a, long b) {
        float fraction = 100.0f * (float)a / (float)b;
        if (fraction > 75.0f) {
            return "\u00a7a";
        }
        if (fraction > 25.0f) {
            return "\u00a7e";
        }
        return "\u00a7c";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        long power = this.getCharge(stack);
        list.add("Charge: " + ItemToolAbilityPower.getColor(power, this.maxPower) + Library.getShortNumber(power) + " \u00a72/ " + Library.getShortNumber(this.maxPower));
        super.func_77624_a(stack, worldIn, list, flagIn);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getCharge(stack) < this.maxPower;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getCharge(stack) / (double)this.maxPower;
    }

    @Override
    protected boolean canOperate(ItemStack stack) {
        return this.getCharge(stack) >= this.consumption;
    }

    @Override
    public long getMaxCharge(ItemStack stack) {
        return this.maxPower;
    }

    @Override
    public long getChargeRate() {
        return this.chargeRate;
    }

    @Override
    public long getDischargeRate() {
        return 0L;
    }

    public void setDamage(ItemStack stack, int damage) {
        this.dischargeBattery(stack, (long)damage * this.consumption);
    }

    public boolean func_77645_m() {
        return true;
    }
}

