/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import api.hbm.block.IToolable;
import com.hbm.handler.NTMToolHandler;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.material.Mats;
import com.hbm.items.IAnimatedItem;
import com.hbm.items.ModItems;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationKeyframe;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.util.EntityDamageUtil;
import com.hbm.util.InventoryUtil;
import com.hbm.util.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBoltgun
extends Item
implements IAnimatedItem {
    public static ItemStack[] bolts = new ItemStack[]{Mats.MAT_STEEL.make(ModItems.bolt), Mats.MAT_TUNGSTEN.make(ModItems.bolt), Mats.MAT_DURA.make(ModItems.bolt)};

    public ItemBoltgun(String s) {
        this.func_77655_b(s);
        this.setRegistryName(s);
        this.func_77625_d(1);
        this.func_77637_a(MainRegistry.consumableTab);
        IToolable.ToolType.BOLT.register(new ItemStack((Item)this));
        ModItems.ALL_ITEMS.add(this);
    }

    public boolean isBolt(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        for (ItemStack bolt : bolts) {
            if (!bolt.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        World world = player.field_70170_p;
        if (!entity.func_70089_S()) {
            return false;
        }
        boolean playingCreative = player.field_71075_bZ.field_75098_d;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack invStack = player.field_71071_by.func_70301_a(i);
            if (!playingCreative && !this.isBolt(invStack)) continue;
            if (!world.field_72995_K) {
                world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, HBMSoundHandler.boltgun, SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (!playingCreative) {
                    player.field_71071_by.func_70298_a(i, 1);
                    player.field_71069_bz.func_75142_b();
                }
                EntityDamageUtil.attackEntityFromIgnoreIFrame(entity, DamageSource.func_76365_a((EntityPlayer)player).func_76348_h(), 10.0f);
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "vanillaExt");
                data.func_74778_a("mode", "largeexplode");
                data.func_74776_a("size", 1.0f);
                data.func_74774_a("count", (byte)1);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 2.0f) - entity.func_70033_W(), entity.field_70161_v), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 50.0));
            } else {
                NBTTagCompound d0 = new NBTTagCompound();
                d0.func_74778_a("type", "anim");
                d0.func_74778_a("mode", "generic");
                MainRegistry.proxy.effectNT(d0);
            }
            return true;
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block b = world.func_180495_p(pos).func_177230_c();
        if (b instanceof IToolable && ((IToolable)b).onScrew(world, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), facing, hitX, hitY, hitZ, hand, IToolable.ToolType.BOLT)) {
            if (!world.field_72995_K) {
                this.processNetwork(world, pos, player, facing, hitX, hitY, hitZ);
            }
            return EnumActionResult.FAIL;
        }
        if (!world.field_72995_K && NTMToolHandler.getConversions().containsKey(new Tuple.Pair<IToolable.ToolType, RecipesCommon.MetaBlock>(IToolable.ToolType.BOLT, new RecipesCommon.MetaBlock(b, b.func_176201_c(world.func_180495_p(pos)))))) {
            Tuple.Pair<RecipesCommon.AStack[], RecipesCommon.MetaBlock> result = NTMToolHandler.getConversions().get(new Tuple.Pair<IToolable.ToolType, RecipesCommon.MetaBlock>(IToolable.ToolType.BOLT, new RecipesCommon.MetaBlock(b, b.func_176201_c(world.func_180495_p(pos)))));
            if (result == null) {
                return EnumActionResult.FAIL;
            }
            ArrayList<RecipesCommon.AStack> materials = new ArrayList<RecipesCommon.AStack>(Arrays.asList(result.getKey()));
            if ((materials.isEmpty() || InventoryUtil.doesPlayerHaveAStacks(player, materials, true)) && result.getValue().block != null) {
                IBlockState resultBlock = result.getValue().block.func_176203_a(result.getValue().meta);
                world.func_180501_a(pos, resultBlock, 3);
                this.processNetwork(world, pos, player, facing, hitX, hitY, hitZ);
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.FAIL;
    }

    private void processNetwork(World world, BlockPos pos, EntityPlayer player, EnumFacing facing, float hitX, float hitY, float hitZ) {
        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), HBMSoundHandler.boltgun, SoundCategory.PLAYERS, 1.0f, 1.0f);
        player.field_71069_bz.func_75142_b();
        ForgeDirection dir = ForgeDirection.getOrientation(facing.func_176745_a());
        double off = 0.25;
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "vanillaExt");
        data.func_74778_a("mode", "largeexplode");
        data.func_74776_a("size", 1.0f);
        data.func_74774_a("count", (byte)1);
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, (double)((float)pos.func_177958_n() + hitX) + (double)dir.offsetX * off, (double)((float)pos.func_177956_o() + hitY) + (double)dir.offsetY * off, (double)((float)pos.func_177952_p() + hitZ) + (double)dir.offsetZ * off), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 50.0));
        NBTTagCompound d0 = new NBTTagCompound();
        d0.func_74778_a("type", "anim");
        d0.func_74778_a("mode", "generic");
        PacketDispatcher.wrapper.sendTo((IMessage)new AuxParticlePacketNT(d0, 0.0, 0.0, 0.0), (EntityPlayerMP)player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BusAnimation getAnimation(NBTTagCompound data, ItemStack stack) {
        return new BusAnimation().addBus("RECOIL", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(1.0, 0.0, 1.0, 50)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 1.0, 100)));
    }
}

