/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemAutogen;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemScraps
extends ItemAutogen {
    public ItemScraps(String s) {
        super(s, null);
    }

    @Override
    public boolean isMaterialValid(NTMMaterial mat) {
        return mat.smeltable == NTMMaterial.SmeltingBehavior.SMELTABLE || mat.smeltable == NTMMaterial.SmeltingBehavior.ADDITIVE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flagIn) {
        Mats.MaterialStack contents = ItemScraps.getMats(stack);
        if (contents != null && contents.material.smeltable == NTMMaterial.SmeltingBehavior.ADDITIVE) {
            list.add("\u00a74Additive, not castable!");
        }
    }

    public static Mats.MaterialStack getMats(ItemStack stack) {
        if (stack.func_77973_b() != ModItems.scraps) {
            return null;
        }
        NTMMaterial mat = Mats.matById.get(stack.func_77952_i());
        if (mat == null) {
            return null;
        }
        int amount = MaterialShapes.INGOT.q(1);
        if (stack.func_77942_o()) {
            amount = stack.func_77978_p().func_74762_e("amount");
        }
        return new Mats.MaterialStack(mat, amount);
    }

    public static ItemStack create(Mats.MaterialStack stack) {
        return ItemScraps.create(stack, false);
    }

    public static ItemStack create(Mats.MaterialStack stack, boolean liquid) {
        if (stack.material == null) {
            return new ItemStack(ModItems.nothing);
        }
        ItemStack scrap = new ItemStack(ModItems.scraps, 1, stack.material.id);
        NBTTagCompound scrapNbt = new NBTTagCompound();
        scrapNbt.func_74768_a("amount", stack.amount);
        if (liquid) {
            scrapNbt.func_74757_a("liquid", true);
        }
        scrap.func_77982_d(scrapNbt);
        return scrap;
    }
}

