/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.items.ItemBase;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.util.I18nUtil;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemFuelRod
extends ItemBase {
    private int lifeTime;
    private int heat;

    public ItemFuelRod(int life, int heat, String s) {
        super(s);
        this.lifeTime = life;
        this.heat = heat;
        this.func_77656_e(100);
        this.canRepair = false;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GOLD + "[" + I18nUtil.resolveKey("trait.reactorrod", new Object[0]) + "]");
        tooltip.add(TextFormatting.DARK_AQUA + "  " + I18nUtil.resolveKey("desc.generates", new Object[0]) + " " + this.heat + " " + I18nUtil.resolveKey("desc.heatpt", new Object[0]));
        tooltip.add(TextFormatting.DARK_AQUA + "  " + I18nUtil.resolveKey("desc.lasts", new Object[0]) + " " + Library.getShortNumber(this.lifeTime) + " " + I18nUtil.resolveKey("desc.ticks", new Object[0]));
    }

    public static void setLifetime(ItemStack stack, int time) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("life", time);
    }

    public static void incrementTime(ItemStack stack, int time) {
        int l = time;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        } else {
            l += stack.func_77978_p().func_74762_e("life");
        }
        stack.func_77978_p().func_74768_a("life", l);
    }

    public static int getLifeTime(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("life");
    }

    public int getMaxLifeTime() {
        return this.lifeTime;
    }

    public int getHeatPerTick() {
        return this.heat;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)ItemFuelRod.getLifeTime(stack) / (double)((ItemFuelRod)stack.func_77973_b()).lifeTime;
    }

    public ItemStack getUncrafting() {
        if (this == ModItems.rod_uranium_fuel) {
            return new ItemStack(ModItems.billet_uranium_fuel);
        }
        if (this == ModItems.rod_dual_uranium_fuel) {
            return new ItemStack(ModItems.billet_uranium_fuel, 2);
        }
        if (this == ModItems.rod_quad_uranium_fuel) {
            return new ItemStack(ModItems.billet_uranium_fuel, 4);
        }
        if (this == ModItems.rod_thorium_fuel) {
            return new ItemStack(ModItems.billet_thorium_fuel);
        }
        if (this == ModItems.rod_dual_thorium_fuel) {
            return new ItemStack(ModItems.billet_thorium_fuel, 2);
        }
        if (this == ModItems.rod_quad_thorium_fuel) {
            return new ItemStack(ModItems.billet_thorium_fuel, 4);
        }
        if (this == ModItems.rod_plutonium_fuel) {
            return new ItemStack(ModItems.billet_plutonium_fuel);
        }
        if (this == ModItems.rod_dual_plutonium_fuel) {
            return new ItemStack(ModItems.billet_plutonium_fuel, 2);
        }
        if (this == ModItems.rod_quad_plutonium_fuel) {
            return new ItemStack(ModItems.billet_plutonium_fuel, 4);
        }
        if (this == ModItems.rod_mox_fuel) {
            return new ItemStack(ModItems.billet_mox_fuel);
        }
        if (this == ModItems.rod_dual_mox_fuel) {
            return new ItemStack(ModItems.billet_mox_fuel, 2);
        }
        if (this == ModItems.rod_quad_mox_fuel) {
            return new ItemStack(ModItems.billet_mox_fuel, 4);
        }
        if (this == ModItems.rod_schrabidium_fuel) {
            return new ItemStack(ModItems.billet_schrabidium_fuel);
        }
        if (this == ModItems.rod_dual_schrabidium_fuel) {
            return new ItemStack(ModItems.billet_schrabidium_fuel, 2);
        }
        if (this == ModItems.rod_quad_schrabidium_fuel) {
            return new ItemStack(ModItems.billet_schrabidium_fuel, 4);
        }
        return ItemStack.field_190927_a;
    }
}

