/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import com.hbm.handler.ArmorModHandler;
import com.hbm.handler.ArmorUtil;
import com.hbm.items.armor.ItemArmorMod;
import com.hbm.main.MainRegistry;
import com.hbm.render.model.ModelJetPack;
import com.hbm.util.I18nUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class JetpackBase
extends ItemArmorMod {
    private ModelJetPack model;
    public Fluid fuel;
    public int maxFuel;

    public JetpackBase(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn, Fluid fuel, int maxFuel, String s) {
        super(1, false, true, false, false, s);
        this.fuel = fuel;
        this.maxFuel = maxFuel;
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.LIGHT_PURPLE + I18nUtil.resolveKey(this.fuel.getUnlocalizedName(), new Object[0]) + ": " + JetpackBase.getFuel(stack) + "mB / " + this.maxFuel + "mB");
        tooltip.add("");
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(TextFormatting.GOLD + "Can be worn on its own!");
    }

    @Override
    public void addDesc(List<String> list, ItemStack stack, ItemStack armor) {
        ItemStack jetpack = ArmorModHandler.pryMods(armor)[1];
        if (jetpack == null) {
            return;
        }
        list.add(TextFormatting.RED + "  " + stack.func_82833_r() + " (" + I18nUtil.resolveKey(this.fuel.getUnlocalizedName(), new Object[0]) + ": " + JetpackBase.getFuel(jetpack) + "mB / " + this.maxFuel + "mB");
    }

    @Override
    public void modUpdate(EntityLivingBase entity, ItemStack armor) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        ItemStack jetpack = ArmorModHandler.pryMods(armor)[1];
        if (jetpack == null) {
            return;
        }
        this.onArmorTick(entity.field_70170_p, (EntityPlayer)entity, jetpack);
        ArmorUtil.resetFlightTime((EntityPlayer)entity);
        ArmorModHandler.applyMod(armor, jetpack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void modRender(RenderPlayerEvent.Pre event, ItemStack armor) {
        boolean isMe;
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_175149_v()) {
            return;
        }
        ModelBiped modelJetpack = this.getArmorModel(event.getEntityLiving(), null, EntityEquipmentSlot.CHEST, null);
        RenderPlayer renderer = event.getRenderer();
        ModelPlayer model = renderer.func_177087_b();
        modelJetpack.field_78117_n = model.field_78117_n;
        float interp = event.getPartialRenderTick();
        float yaw = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * interp;
        float yawWrapped = MathHelper.func_76142_g((float)(yaw + 180.0f));
        float pitch = player.field_70125_A;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(this.getArmorTexture(armor, event.getEntity(), this.getEquipmentSlot(armor), null)));
        EntityPlayer me = MainRegistry.proxy.me();
        boolean bl = isMe = player == me;
        if (!isMe) {
            GL11.glPushMatrix();
            this.offset(player, me, interp);
        }
        modelJetpack.func_78088_a((Entity)event.getEntityPlayer(), 0.0f, 0.0f, 0.0f, yawWrapped, pitch, 0.0625f);
        if (!isMe) {
            GL11.glPopMatrix();
        }
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return armorType == EntityEquipmentSlot.CHEST;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (armorSlot == EntityEquipmentSlot.CHEST) {
            if (this.model == null) {
                this.model = new ModelJetPack();
            }
            return this.model;
        }
        return null;
    }

    protected void useUpFuel(EntityPlayer player, ItemStack stack, int rate) {
        if (player.field_70173_aa % rate == 0) {
            JetpackBase.setFuel(stack, JetpackBase.getFuel(stack) - 1);
        }
    }

    public static int getFuel(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("fuel");
    }

    public static void setFuel(ItemStack stack, int i) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("fuel", i);
    }
}

