/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import com.google.common.collect.Multimap;
import com.hbm.handler.ArmorModHandler;
import com.hbm.items.ModItems;
import com.hbm.items.armor.ItemArmorMod;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ItemModInsert
extends ItemArmorMod {
    private float damageMod;
    private float projectileMod;
    private float explosionMod;
    private float speed;

    public ItemModInsert(int durability, float damageMod, float projectileMod, float explosionMod, float speed, String s) {
        super(6, false, true, false, false, s);
        this.damageMod = damageMod;
        this.projectileMod = projectileMod;
        this.explosionMod = explosionMod;
        this.speed = speed;
        this.func_77656_e(durability);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        if (this.damageMod != 1.0f) {
            list.add(TextFormatting.RED + (this.damageMod < 1.0f ? "-" : "+") + Math.abs(Math.round((1.0f - this.damageMod) * 100.0f)) + "% Damage");
        }
        if (this.projectileMod != 1.0f) {
            list.add(TextFormatting.YELLOW + "-" + Math.round((1.0f - this.projectileMod) * 100.0f) + "% Projectile Damage");
        }
        if (this.explosionMod != 1.0f) {
            list.add(TextFormatting.YELLOW + "-" + Math.round((1.0f - this.explosionMod) * 100.0f) + "% Explosion Damage");
        }
        if (this.speed != 1.0f) {
            list.add(TextFormatting.BLUE + "-" + Math.round((1.0f - this.speed) * 100.0f) + "% Speed");
        }
        list.add("Durability: " + (stack.func_77958_k() - stack.func_77952_i()) + " / " + stack.func_77958_k());
        list.add("");
        super.func_77624_a(stack, worldIn, list, flagIn);
    }

    @Override
    public void addDesc(List<String> list, ItemStack stack, ItemStack armor) {
        ArrayList<String> desc = new ArrayList<String>();
        if (this.damageMod != 1.0f) {
            desc.add((this.damageMod < 1.0f ? "-" : "+") + Math.abs(Math.round((1.0f - this.damageMod) * 100.0f)) + "% dmg");
        }
        if (this.projectileMod != 1.0f) {
            desc.add("-" + Math.round((1.0f - this.projectileMod) * 100.0f) + "% proj");
        }
        if (this.explosionMod != 1.0f) {
            desc.add("-" + Math.round((1.0f - this.explosionMod) * 100.0f) + "% exp");
        }
        if (this.explosionMod != 1.0f) {
            desc.add("-" + Math.round((1.0f - this.speed) * 100.0f) + "% speed");
        }
        String join = String.join((CharSequence)" / ", desc);
        list.add(TextFormatting.DARK_PURPLE + "  " + stack.func_82833_r() + " (" + join + " / " + (stack.func_77958_k() - stack.func_77952_i()) + "HP)");
    }

    @Override
    public void modDamage(LivingHurtEvent event, ItemStack armor) {
        ItemStack insert;
        event.setAmount(event.getAmount() * this.damageMod);
        if (event.getSource().func_76352_a()) {
            event.setAmount(event.getAmount() * this.projectileMod);
        }
        if (event.getSource().func_94541_c()) {
            event.setAmount(event.getAmount() * this.explosionMod);
        }
        if ((insert = ArmorModHandler.pryMods(armor)[6]) == null) {
            return;
        }
        insert.func_77964_b(insert.func_77952_i() + 1);
        if (!event.getEntity().field_70170_p.field_72995_K && this == ModItems.insert_era) {
            event.getEntity().field_70170_p.func_72885_a(event.getEntity(), event.getEntity().field_70165_t, event.getEntity().field_70163_u - event.getEntity().func_70033_W() + (double)event.getEntity().field_70131_O * 0.5, event.getEntity().field_70161_v, 0.05f, false, false);
        }
        if (insert.func_77952_i() >= insert.func_77958_k()) {
            ArmorModHandler.removeMod(armor, 6);
        } else {
            ArmorModHandler.applyMod(armor, insert);
        }
    }

    @Override
    public Multimap<String, AttributeModifier> getModifiers(EntityEquipmentSlot slot, ItemStack armor) {
        if (this.speed == 1.0f) {
            return null;
        }
        Multimap multimap = super.getAttributeModifiers(slot, armor);
        multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(ArmorModHandler.UUIDs[((ItemArmor)armor.func_77973_b()).field_77881_a.func_188454_b()], "NTM Armor Mod Speed", (double)(-1.0f + this.speed), 2));
        return multimap;
    }
}

