/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import api.hbm.item.IGasMask;
import com.hbm.handler.ArmorUtil;
import com.hbm.items.ModItems;
import com.hbm.items.armor.ItemArmorMod;
import com.hbm.main.MainRegistry;
import com.hbm.render.model.ModelM65;
import com.hbm.util.ArmorRegistry;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ItemModGasmask
extends ItemArmorMod
implements IGasMask {
    @SideOnly(value=Side.CLIENT)
    private ModelM65 modelM65;
    private ResourceLocation tex = new ResourceLocation("hbm:textures/armor/ModelM65.png");
    private ResourceLocation tex_mono = new ResourceLocation("hbm:textures/armor/ModelM65Mono.png");

    public ItemModGasmask(String s) {
        super(0, true, false, false, false, s);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        if (this == ModItems.attachment_mask) {
            list.add(TextFormatting.GREEN + "Gas protection");
        }
        list.add("");
        super.func_77624_a(stack, worldIn, list, flagIn);
        ArmorUtil.addGasMaskTooltip(stack, worldIn, list, flagIn);
        ArrayList<ArmorRegistry.HazardClass> haz = this.getBlacklist(stack);
        if (!haz.isEmpty()) {
            list.add("\u00a7c" + I18nUtil.resolveKey("hazard.neverProtects", new Object[0]));
            for (ArmorRegistry.HazardClass clazz : haz) {
                list.add("\u00a74 -" + I18nUtil.resolveKey(clazz.lang, new Object[0]));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDesc(List<String> list, ItemStack stack, ItemStack armor) {
        list.add("\u00a7a  " + stack.func_82833_r() + " (gas protection)");
        ArmorUtil.addGasMaskTooltip(stack, null, list, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void modRender(RenderPlayerEvent.Pre event, ItemStack armor) {
        EntityPlayer me;
        boolean isMe;
        if (this.modelM65 == null) {
            this.modelM65 = new ModelM65();
        }
        RenderPlayer renderer = event.getRenderer();
        ModelPlayer model = renderer.func_177087_b();
        EntityPlayer player = event.getEntityPlayer();
        this.copyRot(this.modelM65, (ModelBiped)model);
        float interp = event.getPartialRenderTick();
        float yawWrapped = MathHelper.func_76142_g((float)(player.field_70758_at + (player.field_70759_as - player.field_70758_at) * interp + 180.0f));
        float pitch = player.field_70125_A;
        if (this == ModItems.attachment_mask) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.tex);
        }
        if (this == ModItems.attachment_mask_mono) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.tex_mono);
        }
        boolean bl = isMe = player == (me = MainRegistry.proxy.me());
        if (!isMe) {
            GL11.glPushMatrix();
            this.offset(player, me, interp);
        }
        if (model.field_78117_n) {
            GL11.glTranslatef((float)0.0f, (float)-0.1875f, (float)0.0f);
        }
        this.modelM65.func_78088_a((Entity)player, 0.0f, 0.0f, 0.0f, yawWrapped, pitch, 0.0625f);
        if (!isMe) {
            GL11.glPopMatrix();
        }
    }

    @Override
    public ArrayList<ArmorRegistry.HazardClass> getBlacklist(ItemStack stack) {
        if (this == ModItems.attachment_mask_mono) {
            return new ArrayList<ArmorRegistry.HazardClass>(Arrays.asList(ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.GAS_CORROSIVE, ArmorRegistry.HazardClass.BACTERIA));
        }
        return new ArrayList<ArmorRegistry.HazardClass>(Arrays.asList(ArmorRegistry.HazardClass.GAS_CORROSIVE));
    }

    @Override
    public ItemStack getFilter(ItemStack stack) {
        return ArmorUtil.getGasMaskFilter(stack);
    }

    @Override
    public void installFilter(ItemStack stack, ItemStack filter) {
        ArmorUtil.installGasMaskFilter(stack, filter);
    }

    @Override
    public void damageFilter(EntityLivingBase entity, ItemStack stack, int damage) {
        ArmorUtil.damageGasMaskFilter(entity, stack, damage);
    }

    @Override
    public boolean isFilterApplicable(ItemStack stack, ItemStack filter) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack;
        ItemStack filter;
        if (player.func_70093_af() && (filter = this.getFilter(stack = player.func_184586_b(hand))) != null) {
            ArmorUtil.removeFilter(stack);
            if (!player.field_71071_by.func_70441_a(filter)) {
                player.func_146097_a(filter, true, false);
            }
        }
        return super.func_77659_a(world, player, hand);
    }
}

