/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.material;

import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class NTMMaterial
implements Comparable<NTMMaterial> {
    public final int id;
    public String[] names;
    public Set<MaterialShapes> shapes = new HashSet<MaterialShapes>();
    public SmeltingBehavior smeltable = SmeltingBehavior.NOT_SMELTABLE;
    public int solidColorLight = 16730624;
    public int solidColorDark = 0x802000;
    public int moltenColor = 16730624;
    public NTMMaterial smeltsInto;
    public int convIn;
    public int convOut;
    public OreDictManager.DictFrame dict;

    public NTMMaterial(int id, OreDictManager.DictFrame dict) {
        this.dict = dict;
        this.names = dict.mats;
        this.id = id;
        this.smeltsInto = this;
        this.convIn = 1;
        this.convOut = 1;
        for (String name : dict.mats) {
            Mats.matByName.put(name, this);
        }
        Mats.orderedList.add(this);
        Mats.matById.put(id, this);
    }

    public String getTranslationKey() {
        return "hbmmat." + this.names[0].toLowerCase(Locale.US);
    }

    public NTMMaterial setConversion(NTMMaterial mat, int in, int out) {
        this.smeltsInto = mat;
        this.convIn = in;
        this.convOut = out;
        return this;
    }

    public NTMMaterial setShapes(MaterialShapes ... shapes) {
        this.shapes.addAll(Arrays.asList(shapes));
        return this;
    }

    public NTMMaterial smeltable(SmeltingBehavior behavior) {
        this.smeltable = behavior;
        return this;
    }

    public NTMMaterial setSolidColor(int colorLight, int colorDark) {
        this.solidColorLight = colorLight;
        this.solidColorDark = colorDark;
        return this;
    }

    public NTMMaterial setMoltenColor(int color) {
        this.moltenColor = color;
        return this;
    }

    public boolean hasDust() {
        return this.shapes.contains(MaterialShapes.DUST);
    }

    public boolean hasTinyDust() {
        return this.shapes.contains(MaterialShapes.DUSTTINY);
    }

    public ItemStack make(Item item, int amount) {
        return new ItemStack(item, amount, this.id);
    }

    public ItemStack make(Item item) {
        return this.make(item, 1);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NTMMaterial)) {
            return false;
        }
        NTMMaterial mat = (NTMMaterial)obj;
        return this.id == mat.id;
    }

    @Override
    public int compareTo(NTMMaterial mat) {
        if (mat == null) {
            return 0;
        }
        return Integer.compare(this.id, mat.id);
    }

    public static enum SmeltingBehavior {
        NOT_SMELTABLE,
        VAPORIZES,
        BREAKS,
        SMELTABLE,
        ADDITIVE;

    }
}

