/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.items.tool.ItemGuideBook;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import org.apache.commons.lang3.math.NumberUtils;
import org.lwjgl.opengl.GL11;

public class GUIScreenGuide
extends GuiScreen {
    private static final ResourceLocation texture = new ResourceLocation("hbm:textures/gui/book/book.png");
    private static final ResourceLocation texture_cover = new ResourceLocation("hbm:textures/gui/book/book_cover.png");
    protected int xSize;
    protected int ySize;
    protected int guiLeft;
    protected int guiTop;
    private ItemGuideBook.BookType type;
    int page;
    int maxPage;

    public GUIScreenGuide(EntityPlayer player) {
        this.type = ItemGuideBook.BookType.getType(player.func_184586_b(EnumHand.MAIN_HAND).func_77952_i());
        this.page = -1;
        this.maxPage = (int)Math.ceil((double)this.type.pages.size() / 2.0) - 1;
        this.xSize = 272;
        this.ySize = 182;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GlStateManager.func_179140_f();
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GlStateManager.func_179145_e();
    }

    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        boolean overRight;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.page < 0) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(texture_cover);
            GUIScreenGuide.func_146110_a((int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (float)512.0f, (float)512.0f);
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        GUIScreenGuide.func_146110_a((int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (float)512.0f, (float)512.0f);
        boolean overLeft = i >= this.guiLeft + 24 && i < this.guiLeft + 42 && j >= this.guiTop + 155 && j < this.guiTop + 165;
        boolean bl = overRight = i >= this.guiLeft + 230 && i < this.guiLeft + 248 && j >= this.guiTop + 155 && j < this.guiTop + 165;
        if (this.page > 0) {
            if (!overLeft) {
                GUIScreenGuide.func_146110_a((int)(this.guiLeft + 24), (int)(this.guiTop + 155), (float)3.0f, (float)207.0f, (int)18, (int)10, (float)512.0f, (float)512.0f);
            } else {
                GUIScreenGuide.func_146110_a((int)(this.guiLeft + 24), (int)(this.guiTop + 155), (float)26.0f, (float)207.0f, (int)18, (int)10, (float)512.0f, (float)512.0f);
            }
        }
        if (this.page < this.maxPage) {
            if (!overRight) {
                GUIScreenGuide.func_146110_a((int)(this.guiLeft + 230), (int)(this.guiTop + 155), (float)3.0f, (float)194.0f, (int)18, (int)10, (float)512.0f, (float)512.0f);
            } else {
                GUIScreenGuide.func_146110_a((int)(this.guiLeft + 230), (int)(this.guiTop + 155), (float)26.0f, (float)194.0f, (int)18, (int)10, (float)512.0f, (float)512.0f);
            }
        }
    }

    public static void drawImage(int x, int y, int dimX, int dimY) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buf = tessellator.func_178180_c();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b((double)x, (double)(y + dimY), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b((double)(x + dimX), (double)(y + dimY), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b((double)(x + dimX), (double)y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void drawGuiContainerForegroundLayer(int x, int y) {
        if (this.page < 0) {
            float scale = this.type.titleScale;
            String[] coverLines = I18nUtil.resolveKeyArray(this.type.title, new Object[0]);
            for (int i = 0; i < coverLines.length; ++i) {
                String cover = coverLines[i];
                GL11.glPushMatrix();
                GL11.glScalef((float)scale, (float)scale, (float)1.0f);
                this.field_146289_q.func_78276_b(cover, (int)(((float)this.guiLeft + ((float)(this.xSize / 2) - (float)(this.field_146289_q.func_78256_a(cover) / 2) * scale)) / scale), (int)(((float)(this.guiTop + 50) + (float)(i * 10) * scale) / scale), 16698880);
                GL11.glPopMatrix();
            }
            return;
        }
        int sideOffset = 130;
        for (int i = 0; i < 2; ++i) {
            int defacto = this.page * 2 + i;
            if (defacto >= this.type.pages.size()) continue;
            ItemGuideBook.GuidePage page = this.type.pages.get(defacto);
            float scale = page.scale;
            String text = I18nUtil.resolveKey(page.text, new Object[0]);
            int width = 100;
            int widthScaled = (int)((float)width * scale);
            ArrayList<String> lines = new ArrayList<String>();
            String[] words = text.split(" ");
            lines.add(words[0]);
            int indent = this.field_146289_q.func_78256_a(words[0]);
            for (int w = 1; w < words.length; ++w) {
                if ((indent += this.field_146289_q.func_78256_a(" " + words[w])) <= widthScaled) {
                    String last = (String)lines.get(lines.size() - 1);
                    last = last + " " + words[w];
                    lines.set(lines.size() - 1, last);
                    continue;
                }
                lines.add(words[w]);
                indent = this.field_146289_q.func_78256_a(words[w]);
            }
            float titleScale = this.getOverrideScale(page.titleScale, page.title + ".scale");
            GL11.glPushMatrix();
            GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)1.0f);
            float topOffset = page.title == null ? 0.0f : 6.0f / titleScale;
            for (int l = 0; l < lines.size(); ++l) {
                this.field_146289_q.func_78276_b((String)lines.get(l), (int)((float)(this.guiLeft + 20 + i * sideOffset) * scale), (int)(((float)(this.guiTop + 30) + topOffset) * scale + (float)(12 * l)), 0x404040);
            }
            GL11.glPopMatrix();
            if (page.title != null) {
                String titleLoc = I18nUtil.resolveKey(page.title, new Object[0]);
                GL11.glPushMatrix();
                GL11.glScalef((float)(1.0f / titleScale), (float)(1.0f / titleScale), (float)1.0f);
                this.field_146289_q.func_78276_b(titleLoc, (int)(((float)(this.guiLeft + 20 + i * sideOffset) + ((float)(width / 2) - (float)(this.field_146289_q.func_78256_a(titleLoc) / 2) / titleScale)) * titleScale), (int)((float)(this.guiTop + 20) * titleScale), page.titleColor);
                GL11.glPopMatrix();
            }
            if (page.image != null) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(page.image);
                int ix = page.x;
                if (ix == -1) {
                    ix = width / 2 - page.sizeX / 2;
                }
                GUIScreenGuide.drawImage(this.guiLeft + 20 + ix + sideOffset * i, this.guiTop + page.y, page.sizeX, page.sizeY);
            }
            String pageLabel = defacto + 1 + "/" + this.type.pages.size();
            this.field_146289_q.func_78276_b(pageLabel, this.guiLeft + 44 + i * 185 - i * this.field_146289_q.func_78256_a(pageLabel), this.guiTop + 156, 0x404040);
        }
    }

    private float getOverrideScale(float def, String tag) {
        String scale = I18nUtil.resolveKey(tag, new Object[0]);
        if (NumberUtils.isCreatable((String)scale)) {
            return 1.0f / NumberUtils.toFloat((String)scale);
        }
        return def;
    }

    protected void func_73864_a(int i, int j, int k) {
        boolean overRight;
        if (this.page < 0) {
            this.page = 0;
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return;
        }
        boolean overLeft = i >= this.guiLeft + 24 && i < this.guiLeft + 42 && j >= this.guiTop + 155 && j < this.guiTop + 165;
        boolean bl = overRight = i >= this.guiLeft + 230 && i < this.guiLeft + 248 && j >= this.guiTop + 155 && j < this.guiTop + 165;
        if (overLeft && this.page > 0) {
            --this.page;
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
        if (overRight && this.page < this.maxPage) {
            ++this.page;
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        if (p_73869_2_ == 1 || p_73869_2_ == Minecraft.func_71410_x().field_71474_y.field_151445_Q.func_151463_i()) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        }
    }
}

