/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.inventory.container.ContainerReactorMultiblock;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.packet.AuxButtonPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.machine.TileEntityMachineReactorLarge;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GUIReactorMultiblock
extends GuiInfoContainer {
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/gui_reactor_large_experimental.png");
    private TileEntityMachineReactorLarge diFurnace;
    private boolean barGrabbed = false;

    public GUIReactorMultiblock(InventoryPlayer invPlayer, TileEntityMachineReactorLarge tedf) {
        super(new ContainerReactorMultiblock(invPlayer, tedf));
        this.diFurnace = tedf;
        this.field_146999_f = 176;
        this.field_147000_g = 222;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        super.func_73863_a(mouseX, mouseY, f);
        FFUtils.renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 6, this.field_147009_r + 5, 16, 52, this.diFurnace.tanks[0], this.diFurnace.tankTypes[0]);
        FFUtils.renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 24, this.field_147009_r + 5, 16, 52, this.diFurnace.tanks[1], this.diFurnace.tankTypes[1]);
        FFUtils.renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 22, this.field_147009_r + 107, 10, 16, this.diFurnace.tanks[2], this.diFurnace.tankTypes[2]);
        this.drawCustomInfo(this, mouseX, mouseY, this.field_147003_i + 42, this.field_147009_r + 5, 4, 88, new String[]{"Core Temperature:", "   " + Math.round((double)this.diFurnace.coreHeat * 2.0E-5 * 980.0 + 20.0) + "\u00b0C"});
        this.drawCustomInfo(this, mouseX, mouseY, this.field_147003_i + 48, this.field_147009_r + 5, 4, 88, new String[]{"Hull Temperature:", "   " + Math.round((double)this.diFurnace.hullHeat * 1.0E-5 * 980.0 + 20.0) + "\u00b0C"});
        this.drawCustomInfo(this, mouseX, mouseY, this.field_147003_i + 115, this.field_147009_r + 17, 18, 90, new String[]{"Control Rods: " + this.diFurnace.rods + "%"});
        String[] text = new String[]{"Coolant will move heat from the core to", "the hull. Water will use that heat and", "generate steam.", "Water consumption rate:", " 100 mB/t", " 2000 mB/s", "Coolant consumption rate:", " 10 mB/t", " 200 mB/s", "Water next to the reactor's open", "sides will pour into the tank."};
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i - 16, this.field_147009_r + 36, 16, 16, this.field_147003_i - 8, this.field_147009_r + 36 + 16, text);
        String fuel = "";
        switch (this.diFurnace.type) {
            case URANIUM: {
                fuel = "Uranium";
                break;
            }
            case MOX: {
                fuel = "MOX";
                break;
            }
            case PLUTONIUM: {
                fuel = "Plutonium";
                break;
            }
            case SCHRABIDIUM: {
                fuel = "Schrabidium";
                break;
            }
            case THORIUM: {
                fuel = "Thorium";
                break;
            }
            default: {
                fuel = "ERROR";
            }
        }
        this.drawCustomInfo(this, mouseX, mouseY, this.field_147003_i + 100, this.field_147009_r + 16, 10, 88, new String[]{fuel + " Rod", "Fuel: " + Math.round(100.0f * (float)this.diFurnace.fuel / (float)this.diFurnace.maxFuel) + "%"});
        this.drawCustomInfo(this, mouseX, mouseY, this.field_147003_i + 128, this.field_147009_r + 16, 10, 88, new String[]{"Depleted " + fuel + " Rod", "Depleted Fuel: " + Math.round(100.0f * (float)this.diFurnace.waste / (float)this.diFurnace.maxWaste) + "%"});
        String[] text0 = new String[]{this.diFurnace.rods > 0 ? "Reactor is ON" : "Reactor is OFF"};
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 35, this.field_147009_r + 107, 18, 18, mouseX, mouseY, text0);
        if (this.diFurnace.tanks[0].getFluidAmount() <= 0) {
            String[] text2 = new String[]{"Error: Water is required for", "the reactor to function properly!"};
            this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i - 16, this.field_147009_r + 36 + 32, 16, 16, this.field_147003_i - 8, this.field_147009_r + 36 + 32 + 16, text2);
        }
        if (this.diFurnace.tanks[1].getFluidAmount() <= 0) {
            String[] text3 = new String[]{"Error: Coolant is required for", "the reactor to function properly!"};
            this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i - 16, this.field_147009_r + 36 + 32 + 16, 16, 16, this.field_147003_i - 8, this.field_147009_r + 36 + 32 + 16, text3);
        }
        String s = "0";
        if (this.diFurnace.tankTypes[2] == ModForgeFluids.STEAM) {
            s = "1x";
        } else if (this.diFurnace.tankTypes[2] == ModForgeFluids.HOTSTEAM) {
            s = "10x";
        } else if (this.diFurnace.tankTypes[2] == ModForgeFluids.SUPERHOTSTEAM) {
            s = "100x";
        }
        String[] text4 = new String[]{"Steam compression switch", "Current compression level: " + s};
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 4, this.field_147009_r + 105, 16, 20, mouseX, mouseY, text4);
        super.func_191948_b(mouseX, mouseY);
    }

    protected void func_73864_a(int x, int y, int i) throws IOException {
        super.func_73864_a(x, y, i);
        if (this.field_147003_i + 114 <= x && this.field_147003_i + 114 + 10 > x && this.field_147009_r + 16 < y && this.field_147009_r + 16 + 88 >= y) {
            this.barGrabbed = true;
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            int rods = (y - (this.field_147009_r + 23)) * 100 / 77;
            if (rods < 0) {
                rods = 0;
            }
            if (rods > 100) {
                rods = 100;
            }
            rods = 100 - rods;
            PacketDispatcher.wrapper.sendToServer((IMessage)new AuxButtonPacket(this.diFurnace.func_174877_v(), rods, 0));
        }
        if (this.field_147003_i + 5 <= x && this.field_147003_i + 5 + 14 > x && this.field_147009_r + 107 < y && this.field_147009_r + 107 + 18 >= y) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            int c = 0;
            if (this.diFurnace.tankTypes[2] == ModForgeFluids.STEAM) {
                this.diFurnace.tankTypes[2] = ModForgeFluids.HOTSTEAM;
                c = 1;
            } else if (this.diFurnace.tankTypes[2] == ModForgeFluids.HOTSTEAM) {
                this.diFurnace.tankTypes[2] = ModForgeFluids.SUPERHOTSTEAM;
                c = 2;
            } else if (this.diFurnace.tankTypes[2] == ModForgeFluids.SUPERHOTSTEAM) {
                this.diFurnace.tankTypes[2] = ModForgeFluids.STEAM;
                c = 0;
            }
            PacketDispatcher.wrapper.sendToServer((IMessage)new AuxButtonPacket(this.diFurnace.func_174877_v(), c, 1));
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.barGrabbed) {
            int rods = MathHelper.func_76125_a((int)((mouseY - (this.field_147009_r + 23)) * 100 / 77), (int)0, (int)100);
            rods = 100 - rods;
            PacketDispatcher.wrapper.sendToServer((IMessage)new AuxButtonPacket(this.diFurnace.func_174877_v(), rods, 0));
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        this.barGrabbed = false;
        super.func_146286_b(mouseX, mouseY, state);
    }

    protected void func_146979_b(int i, int j) {
        this.field_146289_q.func_78276_b("Size", 68, 10, 0x7F7F7F);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), this.field_146999_f - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0])) - 6, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        int i;
        super.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int k = this.diFurnace.rods;
        this.func_73729_b(this.field_147003_i + 115, this.field_147009_r + 107 - 14 - k * 76 / 100, 208, 36, 18, 14);
        int f = this.diFurnace.getRodsScaled(88);
        this.func_73729_b(this.field_147003_i + 115, this.field_147009_r + 16, 200, 36 + f, 8, 88 - f);
        if (this.diFurnace.rods > 0) {
            this.func_73729_b(this.field_147003_i + 35, this.field_147009_r + 107, 176, 0, 18, 18);
        }
        int q = this.diFurnace.getFuelScaled(88);
        this.func_73729_b(this.field_147003_i + 101, this.field_147009_r + 16 + 88 - q, 184, 36, 8, q);
        int j = this.diFurnace.getWasteScaled(88);
        this.func_73729_b(this.field_147003_i + 129, this.field_147009_r + 16 + 88 - j, 192, 36, 8, j);
        int s = this.diFurnace.size;
        if (s < 8) {
            this.func_73729_b(this.field_147003_i + 67, this.field_147009_r + 18, 208, 50 + s * 18, 22, 18);
        } else {
            this.func_73729_b(this.field_147003_i + 67, this.field_147009_r + 18, 230, 50 + (s - 8) * 18, 22, 18);
        }
        if (this.diFurnace.tankTypes[2] == ModForgeFluids.STEAM) {
            this.func_73729_b(this.field_147003_i + 5, this.field_147009_r + 107, 176, 18, 14, 18);
        } else if (this.diFurnace.tankTypes[2] == ModForgeFluids.HOTSTEAM) {
            this.func_73729_b(this.field_147003_i + 5, this.field_147009_r + 107, 190, 18, 14, 18);
        } else if (this.diFurnace.tankTypes[2] == ModForgeFluids.SUPERHOTSTEAM) {
            this.func_73729_b(this.field_147003_i + 5, this.field_147009_r + 107, 204, 18, 14, 18);
        }
        if (this.diFurnace.hasCoreHeat()) {
            i = this.diFurnace.getCoreHeatScaled(88);
            i = Math.min(i, 88);
            this.func_73729_b(this.field_147003_i + 42, this.field_147009_r + 94 - i, 176, 124 - i, 4, i);
        }
        if (this.diFurnace.hasHullHeat()) {
            i = this.diFurnace.getHullHeatScaled(88);
            i = Math.min(i, 88);
            this.func_73729_b(this.field_147003_i + 48, this.field_147009_r + 94 - i, 180, 124 - i, 4, i);
        }
        if (this.diFurnace.tanks[0].getFluidAmount() <= 0) {
            this.drawInfoPanel(this.field_147003_i - 16, this.field_147009_r + 36 + 32, 16, 16, 6);
        }
        if (this.diFurnace.tanks[1].getFluidAmount() <= 0) {
            this.drawInfoPanel(this.field_147003_i - 16, this.field_147009_r + 36 + 32 + 16, 16, 16, 7);
        }
        FFUtils.drawLiquid(this.diFurnace.tanks[0], this.field_147003_i, this.field_147009_r, this.field_73735_i, 16, 52, 6, 86);
        FFUtils.drawLiquid(this.diFurnace.tanks[1], this.field_147003_i, this.field_147009_r, this.field_73735_i, 16, 52, 24, 86);
        FFUtils.drawLiquid(this.diFurnace.tanks[2], this.field_147003_i, this.field_147009_r, this.field_73735_i, 10, 16, 22, 152);
    }
}

