/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.inventory.AnvilRecipes;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.container.ContainerAnvil;
import com.hbm.packet.AnvilCraftPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.util.I18nUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GUIAnvil
extends GuiContainer {
    public static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/processing/gui_anvil.png");
    private int tier;
    private List<AnvilRecipes.AnvilConstructionRecipe> originList = new ArrayList<AnvilRecipes.AnvilConstructionRecipe>();
    private List<AnvilRecipes.AnvilConstructionRecipe> recipes = new ArrayList<AnvilRecipes.AnvilConstructionRecipe>();
    int index;
    int size;
    int selection;
    private GuiTextField search;
    private EntityPlayer player;
    int lastSize = 1;

    public GUIAnvil(EntityPlayer player, int tier) {
        super((Container)new ContainerAnvil(player.field_71071_by, tier));
        this.player = player;
        this.tier = tier;
        this.field_146999_f = 176;
        this.field_147000_g = 222;
        for (AnvilRecipes.AnvilConstructionRecipe recipe : AnvilRecipes.getConstruction()) {
            if (!recipe.isTierValid(this.tier)) continue;
            this.originList.add(recipe);
        }
        this.regenerateRecipes();
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.search = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 10, this.field_147009_r + 111, 84, 12);
        this.search.func_146193_g(-1);
        this.search.func_146204_h(-1);
        this.search.func_146185_a(false);
        this.search.func_146203_f(25);
    }

    private void regenerateRecipes() {
        this.recipes.clear();
        this.recipes.addAll(this.originList);
        this.resetPaging();
    }

    private void search(String search) {
        search = search.toLowerCase();
        this.recipes.clear();
        if (search.isEmpty()) {
            this.recipes.addAll(this.originList);
        } else {
            block0: for (AnvilRecipes.AnvilConstructionRecipe recipe : this.originList) {
                List<String> list = this.recipeToSearchList(recipe);
                for (String s : list) {
                    if (!s.contains(search)) continue;
                    this.recipes.add(recipe);
                    continue block0;
                }
            }
        }
        this.resetPaging();
    }

    private void resetPaging() {
        this.index = 0;
        this.selection = -1;
        this.size = Math.max(0, (int)Math.ceil((double)(this.recipes.size() - 10) / 2.0));
    }

    protected void func_73864_a(int x, int y, int k) throws IOException {
        super.func_73864_a(x, y, k);
        this.search.func_146192_a(x, y, k);
        if (this.field_147003_i + 7 <= x && this.field_147003_i + 7 + 9 > x && this.field_147009_r + 71 < y && this.field_147009_r + 71 + 36 >= y) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            if (this.index > 0) {
                --this.index;
            }
            return;
        }
        if (this.field_147003_i + 106 <= x && this.field_147003_i + 106 + 9 > x && this.field_147009_r + 71 < y && this.field_147009_r + 71 + 36 >= y) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            if (this.index < this.size) {
                ++this.index;
            }
            return;
        }
        if (this.field_147003_i + 52 <= x && this.field_147003_i + 52 + 18 > x && this.field_147009_r + 53 < y && this.field_147009_r + 53 + 18 >= y) {
            if (this.selection == -1) {
                return;
            }
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            PacketDispatcher.wrapper.sendToServer((IMessage)new AnvilCraftPacket(this.recipes.get(this.selection), Keyboard.isKeyDown((int)42) ? 1 : 0));
            return;
        }
        if (this.field_147003_i + 97 <= x && this.field_147003_i + 97 + 18 > x && this.field_147009_r + 107 < y && this.field_147009_r + 107 + 18 >= y) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.search(this.search.func_146179_b());
            return;
        }
        for (int i = this.index * 2; i < this.index * 2 + 10 && i < this.recipes.size(); ++i) {
            int ind = i - this.index * 2;
            int ix = 16 + 18 * (ind / 2);
            int iy = 71 + 18 * (ind % 2);
            if (this.field_147003_i + ix > x || this.field_147003_i + ix + 18 <= x || this.field_147009_r + iy >= y || this.field_147009_r + iy + 18 < y) continue;
            this.selection = this.selection != i ? i : -1;
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return;
        }
    }

    protected void func_146979_b(int mX, int mY) {
        String name = I18n.func_135052_a((String)"container.anvil", (Object[])new Object[]{this.tier});
        this.field_146289_q.func_78276_b(name, 61 - this.field_146289_q.func_78256_a(name) / 2, 8, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        if (this.selection >= 0) {
            AnvilRecipes.AnvilConstructionRecipe recipe = this.recipes.get(this.selection);
            List<String> list = this.recipeToList(recipe);
            int longest = 0;
            for (String s : list) {
                int length = this.field_146289_q.func_78256_a(s);
                if (length <= longest) continue;
                longest = length;
            }
            double scale = 0.5;
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            int offset2 = 0;
            for (String s : list) {
                this.field_146289_q.func_78276_b(s, 260, 50 + offset2, 0xFFFFFF);
                offset2 += 9;
            }
            this.lastSize = (int)((double)longest * scale);
            GL11.glScaled((double)(1.0 / scale), (double)(1.0 / scale), (double)(1.0 / scale));
        } else {
            this.lastSize = 0;
        }
    }

    public List<String> recipeToList(AnvilRecipes.AnvilConstructionRecipe recipe) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TextFormatting.YELLOW + I18nUtil.resolveKey("info.template_in_p", new Object[0]));
        for (RecipesCommon.AStack aStack : recipe.input) {
            Object input;
            if (aStack instanceof RecipesCommon.ComparableStack) {
                input = ((RecipesCommon.ComparableStack)aStack).toStack();
                list.add(">" + input.func_190916_E() + "x " + input.func_82833_r());
                continue;
            }
            if (!(aStack instanceof RecipesCommon.OreDictStack)) continue;
            input = (RecipesCommon.OreDictStack)aStack;
            NonNullList ores = OreDictionary.getOres((String)((RecipesCommon.OreDictStack)input).name);
            if (!ores.isEmpty()) {
                ItemStack inStack = (ItemStack)ores.get((int)(Math.abs(System.currentTimeMillis() / 1000L) % (long)ores.size()));
                list.add(">" + ((RecipesCommon.AStack)input).count() + "x " + inStack.func_82833_r());
                continue;
            }
            list.add("I AM ERROR");
        }
        list.add("");
        list.add(TextFormatting.YELLOW + I18nUtil.resolveKey("info.template_out_p", new Object[0]));
        for (AnvilRecipes.AnvilOutput anvilOutput : recipe.output) {
            list.add(">" + anvilOutput.stack.func_190916_E() + "x " + anvilOutput.stack.func_82833_r() + (anvilOutput.chance != 1.0f ? " (" + anvilOutput.chance * 100.0f + "%)" : ""));
        }
        return list;
    }

    public List<String> recipeToSearchList(AnvilRecipes.AnvilConstructionRecipe recipe) {
        ArrayList<String> list = new ArrayList<String>();
        for (RecipesCommon.AStack aStack : recipe.input) {
            Object input;
            if (aStack instanceof RecipesCommon.ComparableStack) {
                input = ((RecipesCommon.ComparableStack)aStack).toStack();
                list.add(input.func_82833_r().toLowerCase());
                continue;
            }
            if (!(aStack instanceof RecipesCommon.OreDictStack)) continue;
            input = (RecipesCommon.OreDictStack)aStack;
            NonNullList ores = OreDictionary.getOres((String)input.name);
            if (ores.isEmpty()) continue;
            for (ItemStack ore : ores) {
                list.add(ore.func_82833_r().toLowerCase());
            }
        }
        for (AnvilRecipes.AnvilOutput anvilOutput : recipe.output) {
            list.add(anvilOutput.stack.func_82833_r().toLowerCase());
        }
        return list;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        super.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float inter, int mX, int mY) {
        super.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int slide = MathHelper.func_76125_a((int)(this.lastSize - 42), (int)0, (int)1000);
        int mul = 1;
        while (slide >= 51 * mul) {
            this.func_73729_b(this.field_147003_i + 125 + 51 * mul, this.field_147009_r + 17, 125, 17, 54, 108);
            ++mul;
        }
        this.func_73729_b(this.field_147003_i + 125 + slide, this.field_147009_r + 17, 125, 17, 54, 108);
        if (this.search.func_146206_l()) {
            this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 108, 168, 222, 88, 16);
        }
        if (this.field_147003_i + 7 <= mX && this.field_147003_i + 7 + 9 > mX && this.field_147009_r + 71 < mY && this.field_147009_r + 71 + 36 >= mY) {
            this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 71, 176, 186, 9, 36);
        }
        if (this.field_147003_i + 106 <= mX && this.field_147003_i + 106 + 9 > mX && this.field_147009_r + 71 < mY && this.field_147009_r + 71 + 36 >= mY) {
            this.func_73729_b(this.field_147003_i + 106, this.field_147009_r + 71, 185, 186, 9, 36);
        }
        if (this.field_147003_i + 52 <= mX && this.field_147003_i + 52 + 18 > mX && this.field_147009_r + 53 < mY && this.field_147009_r + 53 + 18 >= mY) {
            this.func_73729_b(this.field_147003_i + 52, this.field_147009_r + 53, 176, 150, 18, 18);
        }
        if (this.field_147003_i + 97 <= mX && this.field_147003_i + 97 + 18 > mX && this.field_147009_r + 107 < mY && this.field_147009_r + 107 + 18 >= mY) {
            this.func_73729_b(this.field_147003_i + 97, this.field_147009_r + 107, 176, 168, 18, 18);
        }
        for (int i = this.index * 2; i < this.index * 2 + 10 && i < this.recipes.size(); ++i) {
            int ind = i - this.index * 2;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.func_74520_c();
            GlStateManager.func_179140_f();
            AnvilRecipes.AnvilConstructionRecipe recipe = this.recipes.get(i);
            ItemStack display = recipe.getDisplay();
            FontRenderer font = null;
            if (display != null) {
                font = display.func_77973_b().getFontRenderer(display);
            }
            if (font == null) {
                font = this.field_146289_q;
            }
            this.field_146296_j.field_77023_b = 100.0f;
            this.field_146296_j.func_184391_a((EntityLivingBase)this.player, recipe.getDisplay(), this.field_147003_i + 17 + 18 * (ind / 2), this.field_147009_r + 72 + 18 * (ind % 2));
            this.field_146296_j.field_77023_b = 0.0f;
            GlStateManager.func_179141_d();
            GlStateManager.func_179140_f();
            this.field_146297_k.func_110434_K().func_110577_a(texture);
            this.field_73735_i = 300.0f;
            this.func_73729_b(this.field_147003_i + 16 + 18 * (ind / 2), this.field_147009_r + 71 + 18 * (ind % 2), 18 + 18 * recipe.getOverlay().ordinal(), 222, 18, 18);
            if (this.selection != i) continue;
            this.func_73729_b(this.field_147003_i + 16 + 18 * (ind / 2), this.field_147009_r + 71 + 18 * (ind % 2), 0, 222, 18, 18);
        }
        this.search.func_146194_f();
    }

    protected void func_73869_a(char c, int key) throws IOException {
        if (this.search.func_146201_a(c, key)) {
            this.search(this.search.func_146179_b());
        } else {
            super.func_73869_a(c, key);
        }
    }
}

