/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel.nodes;

import com.hbm.inventory.control_panel.Control;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.IControllable;
import com.hbm.inventory.control_panel.NodeConnection;
import com.hbm.inventory.control_panel.NodeDropdown;
import com.hbm.inventory.control_panel.NodeSystem;
import com.hbm.inventory.control_panel.NodeType;
import com.hbm.inventory.control_panel.nodes.Node;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class NodeQueryBlock
extends Node {
    public Control ctrl;
    public String blockPos = "";
    public String dataName = "";
    public NodeDropdown dataSelector;

    public NodeQueryBlock(float x, float y, Control ctrl) {
        super(x, y);
        this.ctrl = ctrl;
        this.outputs.add(new NodeConnection("Output", this, this.outputs.size(), false, DataValue.DataType.GENERIC, new DataValueFloat(0.0f)));
        NodeDropdown blockPosSelector = new NodeDropdown(this, this.otherElements.size(), s -> {
            this.blockPos = s;
            this.dataName = "";
            this.setDataSelector();
            return null;
        }, () -> this.blockPos);
        this.otherElements.add(blockPosSelector);
        for (BlockPos pos : ctrl.connectedSet) {
            blockPosSelector.list.addItems(pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p());
        }
        this.dataSelector = new NodeDropdown(this, this.otherElements.size(), s -> {
            this.dataName = s;
            ((NodeConnection)this.outputs.get((int)0)).type = this.evaluate(0).getType();
            return null;
        }, () -> this.dataName);
        this.setDataSelector();
        this.otherElements.add(this.dataSelector);
        this.dataName = "";
        this.recalcSize();
    }

    private BlockPos getPos(String pos) {
        String[] coords = pos.split(", ");
        return new BlockPos(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
    }

    private void setDataSelector() {
        TileEntity tile;
        this.dataSelector.list.itemNames.clear();
        if (this.blockPos != null && !this.blockPos.isEmpty() && (tile = this.ctrl.panel.parent.getControlWorld().func_175625_s(this.getPos(this.blockPos))) instanceof IControllable) {
            IControllable te = (IControllable)tile;
            for (Map.Entry<String, DataValue> var : te.getQueryData().entrySet()) {
                this.dataSelector.list.addItems(var.getKey());
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag, NodeSystem sys) {
        tag.func_74778_a("nodeType", "queryBlock");
        tag.func_74768_a("controlIdx", sys.parent.panel.controls.indexOf(sys.parent));
        tag.func_74778_a("blockPos", this.blockPos);
        tag.func_74778_a("dataName", this.dataName);
        return super.writeToNBT(tag, sys);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, NodeSystem sys) {
        this.blockPos = tag.func_74779_i("blockPos");
        this.dataName = tag.func_74779_i("dataName");
        super.readFromNBT(tag, sys);
    }

    @Override
    public DataValue evaluate(int inx) {
        if (!this.dataName.isEmpty()) {
            IControllable te;
            TileEntity tile = this.ctrl.panel.parent.getControlWorld().func_175625_s(this.getPos(this.blockPos));
            if (tile instanceof IControllable && (te = (IControllable)tile).getQueryData().containsKey(this.dataName)) {
                return te.getQueryData().get(this.dataName);
            }
            this.setDataSelector();
        }
        return new DataValueFloat(0.0f);
    }

    public NodeQueryBlock setData(String blockPos) {
        this.blockPos = blockPos;
        return this;
    }

    @Override
    public NodeType getType() {
        return NodeType.INPUT;
    }

    @Override
    public String getDisplayName() {
        return "Query Block";
    }
}

