/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel.nodes;

import com.hbm.inventory.control_panel.Control;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.NodeConnection;
import com.hbm.inventory.control_panel.NodeDropdown;
import com.hbm.inventory.control_panel.NodeSystem;
import com.hbm.inventory.control_panel.NodeType;
import com.hbm.inventory.control_panel.nodes.Node;
import net.minecraft.nbt.NBTTagCompound;

public class NodeGetVar
extends Node {
    public Control ctrl;
    public boolean global = false;
    public String varName;
    public NodeDropdown varSelector;

    public NodeGetVar(float x, float y, Control ctrl) {
        super(x, y);
        this.ctrl = ctrl;
        this.outputs.add(new NodeConnection("Output", this, this.outputs.size(), false, DataValue.DataType.GENERIC, new DataValueFloat(0.0f)));
        NodeDropdown globalSelector = new NodeDropdown(this, this.otherElements.size(), s -> {
            if (s.equals("Global") && !this.global) {
                this.global = true;
                this.varName = "";
            }
            if (s.equals("Local") && this.global) {
                this.global = false;
                this.varName = "";
            }
            this.setVarSelector();
            return null;
        }, () -> this.global ? "Global" : "Local");
        globalSelector.list.addItems("Global", "Local");
        this.otherElements.add(globalSelector);
        this.varSelector = new NodeDropdown(this, this.otherElements.size(), s -> {
            this.varName = s;
            ((NodeConnection)this.outputs.get((int)0)).type = this.evaluate(0).getType();
            return null;
        }, () -> this.varName);
        this.setVarSelector();
        this.otherElements.add(this.varSelector);
        this.varName = "";
        this.recalcSize();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag, NodeSystem sys) {
        tag.func_74778_a("nodeType", "getVar");
        tag.func_74768_a("controlIdx", sys.parent.panel.controls.indexOf(sys.parent));
        tag.func_74757_a("global", this.global);
        tag.func_74778_a("varName", this.varName);
        return super.writeToNBT(tag, sys);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, NodeSystem sys) {
        this.global = tag.func_74767_n("global");
        this.varName = tag.func_74779_i("varName");
        super.readFromNBT(tag, sys);
    }

    public void setVarSelector() {
        this.varSelector.list.itemNames.clear();
        if (this.global) {
            for (String name : this.ctrl.panel.globalVars.keySet()) {
                this.varSelector.list.addItems(name);
            }
        } else {
            for (String name : this.ctrl.vars.keySet()) {
                this.varSelector.list.addItems(name);
            }
        }
    }

    @Override
    public DataValue evaluate(int idx) {
        if (this.varName.isEmpty()) {
            return new DataValueFloat(0.0f);
        }
        if (this.global) {
            return this.ctrl.getGlobalVar(this.varName);
        }
        return this.ctrl.getVar(this.varName);
    }

    public NodeGetVar setData(String varName, boolean isGlobal) {
        this.varName = varName;
        this.global = isGlobal;
        ((NodeConnection)this.outputs.get((int)0)).type = this.evaluate(0).getType();
        return this;
    }

    @Override
    public NodeType getType() {
        return NodeType.INPUT;
    }

    @Override
    public String getDisplayName() {
        return "Get Variable";
    }
}

