/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel.controls;

import com.hbm.inventory.control_panel.Control;
import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.ControlPanel;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.NodeConnection;
import com.hbm.inventory.control_panel.NodeSystem;
import com.hbm.inventory.control_panel.controls.ControlType;
import com.hbm.inventory.control_panel.nodes.NodeConditional;
import com.hbm.inventory.control_panel.nodes.NodeGetVar;
import com.hbm.inventory.control_panel.nodes.NodeInput;
import com.hbm.inventory.control_panel.nodes.NodeMath;
import com.hbm.inventory.control_panel.nodes.NodeSetVar;
import com.hbm.main.ResourceManager;
import com.hbm.render.amlfrom1710.IModelCustom;
import com.hbm.render.amlfrom1710.Tessellator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SliderVertical
extends Control {
    public SliderVertical(String name, ControlPanel panel) {
        super(name, panel);
        this.vars.put("value", new DataValueFloat(0.0f));
    }

    @Override
    public ControlType getControlType() {
        return ControlType.SLIDER;
    }

    @Override
    public float[] getSize() {
        return new float[]{0.8125f, 2.3125f, 0.31f};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render() {
        GlStateManager.func_179103_j((int)7425);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.ctrl_slider_vertical_tex);
        Tessellator tes = Tessellator.instance;
        IModelCustom model = this.getModel();
        int position = (int)Math.abs(this.getVar("value").getNumber()) % 6;
        tes.startDrawing(4, DefaultVertexFormats.field_181712_l);
        tes.setTranslation(this.posX, 0.0, this.posY);
        tes.setColorRGBA_F(1.0f, 1.0f, 1.0f, 1.0f);
        model.tessellatePart(tes, "base");
        tes.draw();
        GlStateManager.func_179090_x();
        tes.startDrawing(4, DefaultVertexFormats.field_181712_l);
        tes.setTranslation(this.posX, 0.0, this.posY - 0.3125f * (float)position);
        tes.setColorRGBA_F(0.2f, 0.2f, 0.2f, 1.0f);
        model.tessellatePart(tes, "slider");
        tes.draw();
        float lX = OpenGlHelper.lastBrightnessX;
        float lY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        for (int i = 0; i <= position; ++i) {
            tes.startDrawing(4, DefaultVertexFormats.field_181712_l);
            tes.setTranslation(this.posX, 0.0, this.posY);
            tes.setColorRGBA_F(0.0f, 1.0f, 0.0f, 1.0f);
            model.tessellatePart(tes, "light" + i);
            tes.draw();
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lX, (float)lY);
        GlStateManager.func_179098_w();
        GlStateManager.func_179103_j((int)7424);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IModelCustom getModel() {
        return ResourceManager.ctrl_slider_vertical;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getGuiTexture() {
        return ResourceManager.ctrl_slider_vertical_gui_tex;
    }

    @Override
    public List<String> getOutEvents() {
        return Collections.singletonList("ctrl_press");
    }

    @Override
    public void populateDefaultNodes(List<ControlEvent> receiveEvents) {
        NodeSystem ctrl_press = new NodeSystem(this);
        HashMap<String, DataValue> vars = new HashMap<String, DataValue>(receiveEvents.get((int)0).vars);
        vars.put("from index", new DataValueFloat(0.0f));
        NodeInput node0 = new NodeInput(170.0f, 100.0f, "Event Data").setVars(vars);
        ctrl_press.addNode(node0);
        NodeGetVar node1 = new NodeGetVar(170.0f, 150.0f, this).setData("value", false);
        ctrl_press.addNode(node1);
        NodeConditional node2 = new NodeConditional(230.0f, 110.0f);
        ((NodeConnection)node2.inputs.get(0)).setData(node0, 1, true);
        ((NodeConnection)node2.inputs.get(1)).setDefault(new DataValueFloat(-1.0f));
        ((NodeConnection)node2.inputs.get(2)).setDefault(new DataValueFloat(1.0f));
        ctrl_press.addNode(node2);
        NodeMath node3 = new NodeMath(290.0f, 130.0f).setData(NodeMath.Operation.ADD);
        ((NodeConnection)node3.inputs.get(0)).setData(node2, 0, true);
        ((NodeConnection)node3.inputs.get(1)).setData(node1, 0, true);
        ctrl_press.addNode(node3);
        NodeMath node4 = new NodeMath(350.0f, 130.0f).setData(NodeMath.Operation.CLAMP);
        ((NodeConnection)node4.inputs.get(0)).setData(node3, 0, true);
        ((NodeConnection)node4.inputs.get(1)).setDefault(new DataValueFloat(0.0f));
        ((NodeConnection)node4.inputs.get(2)).setDefault(new DataValueFloat(5.0f));
        ctrl_press.addNode(node4);
        NodeSetVar node5 = new NodeSetVar(410.0f, 110.0f, this).setData("value", false);
        ((NodeConnection)node5.inputs.get(0)).setData(node4, 0, true);
        ctrl_press.addNode(node5);
        this.receiveNodeMap.put("ctrl_press", ctrl_press);
    }

    @Override
    public Control newControl(ControlPanel panel) {
        return new SliderVertical(this.name, panel);
    }
}

