/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel.controls;

import com.hbm.inventory.control_panel.Control;
import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.ControlPanel;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.NodeConnection;
import com.hbm.inventory.control_panel.NodeSystem;
import com.hbm.inventory.control_panel.controls.ControlType;
import com.hbm.inventory.control_panel.nodes.NodeConditional;
import com.hbm.inventory.control_panel.nodes.NodeGetVar;
import com.hbm.inventory.control_panel.nodes.NodeInput;
import com.hbm.inventory.control_panel.nodes.NodeMath;
import com.hbm.inventory.control_panel.nodes.NodeSetVar;
import com.hbm.main.ClientProxy;
import com.hbm.main.ResourceManager;
import com.hbm.render.amlfrom1710.IModelCustom;
import com.hbm.render.amlfrom1710.Tessellator;
import java.nio.FloatBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class KnobControl
extends Control {
    private int positions = 2;

    public KnobControl(String name, ControlPanel panel) {
        super(name, panel);
        this.vars.put("value", new DataValueFloat(0.0f));
        this.configMap.put("positions", new DataValueFloat(this.positions));
    }

    @Override
    public ControlType getControlType() {
        return ControlType.KNOB;
    }

    @Override
    public float[] getSize() {
        return new float[]{2.0f, 2.0f, 0.4f};
    }

    @Override
    public void applyConfigs(Map<String, DataValue> configs) {
        super.applyConfigs(configs);
        for (Map.Entry e : this.configMap.entrySet()) {
            switch ((String)e.getKey()) {
                case "positions": {
                    this.positions = (int)((DataValue)e.getValue()).getNumber();
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render() {
        GlStateManager.func_179103_j((int)7425);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.ctrl_knob_control_tex);
        Tessellator tes = Tessellator.instance;
        IModelCustom model = this.getModel();
        int value = (int)this.getVar("value").getNumber();
        tes.startDrawing(4, DefaultVertexFormats.field_181712_l);
        tes.setTranslation(this.posX, 0.0, this.posY);
        tes.setColorRGBA_F(1.0f, 1.0f, 1.0f, 1.0f);
        model.tessellatePart(tes, "base");
        tes.draw();
        GL11.glPushMatrix();
        Matrix4f rot_mat = new Matrix4f().rotate((float)(-((double)value * 0.5711986642890533)), new Vector3f(0.0f, 1.0f, 0.0f));
        Matrix4f.mul((Matrix4f)new Matrix4f().translate(new Vector3f(this.posX, -0.04f, this.posY)), (Matrix4f)rot_mat, (Matrix4f)new Matrix4f()).store(ClientProxy.AUX_GL_BUFFER);
        ClientProxy.AUX_GL_BUFFER.rewind();
        GlStateManager.func_179110_a((FloatBuffer)ClientProxy.AUX_GL_BUFFER);
        tes.startDrawing(4, DefaultVertexFormats.field_181712_l);
        tes.setColorRGBA_F(1.0f, 1.0f, 1.0f, 1.0f);
        model.tessellatePart(tes, "knob");
        tes.draw();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GlStateManager.func_179109_b((float)this.posX, (float)0.07f, (float)this.posY);
        GL11.glScalef((float)0.028f, (float)0.028f, (float)0.028f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        for (int i = 0; i < this.positions; ++i) {
            double angle = 0.5711986642890533 * (double)i;
            float r = 28.0f;
            double x = (double)r * Math.cos(angle - 1.5707963267948966);
            double y = (double)r * Math.sin(angle - 1.5707963267948966);
            font.func_175065_a(Integer.toString(i), (float)((i == 10 ? -6.5 : -2.5) + x), (float)(-3.0 + y), 0x282828, false);
        }
        GL11.glPopMatrix();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IModelCustom getModel() {
        return ResourceManager.ctrl_knob_control;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getGuiTexture() {
        return ResourceManager.ctrl_knob_control_gui_tex;
    }

    @Override
    public List<String> getOutEvents() {
        return Collections.singletonList("ctrl_press");
    }

    @Override
    public void populateDefaultNodes(List<ControlEvent> receiveEvents) {
        NodeSystem ctrl_press = new NodeSystem(this);
        HashMap<String, DataValue> vars = new HashMap<String, DataValue>(receiveEvents.get((int)0).vars);
        vars.put("from index", new DataValueFloat(0.0f));
        NodeInput node0 = new NodeInput(170.0f, 100.0f, "Event Data").setVars(vars);
        ctrl_press.addNode(node0);
        NodeConditional node1 = new NodeConditional(230.0f, 120.0f);
        ((NodeConnection)node1.inputs.get(0)).setData(node0, 1, true);
        ((NodeConnection)node1.inputs.get(1)).setDefault(new DataValueFloat(-1.0f));
        ((NodeConnection)node1.inputs.get(2)).setDefault(new DataValueFloat(1.0f));
        ctrl_press.addNode(node1);
        NodeGetVar node2 = new NodeGetVar(170.0f, 160.0f, this).setData("value", false);
        ctrl_press.addNode(node2);
        NodeMath node3 = new NodeMath(290.0f, 140.0f).setData(NodeMath.Operation.ADD);
        ((NodeConnection)node3.inputs.get(0)).setData(node1, 0, true);
        ((NodeConnection)node3.inputs.get(1)).setData(node2, 0, true);
        ctrl_press.addNode(node3);
        NodeMath node4 = new NodeMath(350.0f, 140.0f).setData(NodeMath.Operation.CLAMP);
        ((NodeConnection)node4.inputs.get(0)).setData(node3, 0, true);
        ((NodeConnection)node4.inputs.get(1)).setDefault(new DataValueFloat(0.0f));
        ((NodeConnection)node4.inputs.get(2)).setDefault(new DataValueFloat(10.0f));
        ctrl_press.addNode(node4);
        NodeSetVar node5 = new NodeSetVar(410.0f, 145.0f, this).setData("value", false);
        ((NodeConnection)node5.inputs.get(0)).setData(node4, 0, true);
        ctrl_press.addNode(node5);
        this.receiveNodeMap.put("ctrl_press", ctrl_press);
    }

    @Override
    public Control newControl(ControlPanel panel) {
        return new KnobControl(this.name, panel);
    }
}

