/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel.controls;

import com.hbm.inventory.control_panel.Control;
import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.ControlPanel;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.controls.ControlType;
import com.hbm.main.ResourceManager;
import com.hbm.render.amlfrom1710.IModelCustom;
import com.hbm.render.amlfrom1710.Tessellator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DisplaySevenSeg
extends Control {
    private float[] color = new float[]{1.0f, 1.0f, 1.0f};
    private int digitCount = 1;
    private boolean isDecimal = false;
    private static final byte[] chars = new byte[]{126, 48, 109, 121, 51, 91, 95, 112, 127, 123, 119, 31, 78, 61, 79, 71};

    public DisplaySevenSeg(String name, ControlPanel panel) {
        super(name, panel);
        this.vars.put("value", new DataValueFloat(0.0f));
        this.configMap.put("colorR", new DataValueFloat(this.color[0]));
        this.configMap.put("colorG", new DataValueFloat(this.color[1]));
        this.configMap.put("colorB", new DataValueFloat(this.color[2]));
        this.configMap.put("digitCount", new DataValueFloat(this.digitCount));
        this.configMap.put("isDecimal", new DataValueFloat(0.0f));
    }

    @Override
    public ControlType getControlType() {
        return ControlType.DISPLAY;
    }

    @Override
    public float[] getSize() {
        return new float[]{0.75f, 1.125f, 0.06f};
    }

    @Override
    public float[] getBox() {
        float width = this.getSize()[0];
        float length = this.getSize()[1];
        return new float[]{this.posX - (width * (float)this.digitCount - (float)(this.digitCount - 1) * 0.125f) + width, this.posY, this.posX + width, this.posY + length};
    }

    @Override
    public void applyConfigs(Map<String, DataValue> configs) {
        super.applyConfigs(configs);
        for (Map.Entry e : this.configMap.entrySet()) {
            switch ((String)e.getKey()) {
                case "colorR": {
                    this.color[0] = ((DataValue)e.getValue()).getNumber();
                    break;
                }
                case "colorG": {
                    this.color[1] = ((DataValue)e.getValue()).getNumber();
                    break;
                }
                case "colorB": {
                    this.color[2] = ((DataValue)e.getValue()).getNumber();
                    break;
                }
                case "digitCount": {
                    this.digitCount = (int)((DataValue)e.getValue()).getNumber();
                    break;
                }
                case "isDecimal": {
                    this.isDecimal = ((DataValue)e.getValue()).getBoolean();
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render() {
        GlStateManager.func_179103_j((int)7425);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.ctrl_display_seven_seg_tex);
        Tessellator tes = Tessellator.instance;
        IModelCustom model = this.getModel();
        int value = Math.max(0, (int)this.getVar("value").getNumber());
        float lX = OpenGlHelper.lastBrightnessX;
        float lY = OpenGlHelper.lastBrightnessY;
        int base = this.isDecimal ? 10 : 16;
        for (int i = 0; i < this.digitCount; ++i) {
            byte character = chars[value % base];
            value /= base;
            float t_off = (float)i * this.getSize()[0] - (float)i * (i > 0 ? 0.125f : 0.0f);
            tes.startDrawing(4, DefaultVertexFormats.field_181712_l);
            tes.setTranslation(this.posX - t_off, 0.0, this.posY);
            tes.setColorRGBA_F(1.0f, 1.0f, 1.0f, 1.0f);
            model.tessellatePart(tes, "base");
            tes.draw();
            GlStateManager.func_179090_x();
            tes.startDrawing(4, DefaultVertexFormats.field_181712_l);
            tes.setTranslation(this.posX - t_off, 0.0, this.posY);
            tes.setColorRGBA_F(0.31f, 0.31f, 0.31f, 1.0f);
            model.tessellatePart(tes, "border");
            tes.draw();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            for (int j = 0; j < 7; ++j) {
                boolean enabled = (character & 1 << j) != 0;
                float cMul = enabled ? 1.0f : 0.1f;
                tes.startDrawing(4, DefaultVertexFormats.field_181712_l);
                tes.setTranslation(this.posX - t_off, 0.0, this.posY);
                tes.setColorRGBA_F(this.color[0] * cMul, this.color[1] * cMul, this.color[2] * cMul, 1.0f);
                model.tessellatePart(tes, "seg_" + (6 - j));
                tes.draw();
            }
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lX, (float)lY);
            GlStateManager.func_179098_w();
        }
        GlStateManager.func_179103_j((int)7424);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IModelCustom getModel() {
        return ResourceManager.ctrl_display_seven_seg;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getGuiTexture() {
        return ResourceManager.ctrl_display_seven_seg_gui_tex;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    @Override
    public void populateDefaultNodes(List<ControlEvent> receiveEvents) {
    }

    @Override
    public Control newControl(ControlPanel panel) {
        return new DisplaySevenSeg(this.name, panel);
    }
}

