/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel.controls;

import com.hbm.inventory.control_panel.Control;
import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.ControlPanel;
import com.hbm.inventory.control_panel.DataValueEnum;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.NodeConnection;
import com.hbm.inventory.control_panel.NodeSystem;
import com.hbm.inventory.control_panel.controls.ControlType;
import com.hbm.inventory.control_panel.nodes.NodeBoolean;
import com.hbm.inventory.control_panel.nodes.NodeBuffer;
import com.hbm.inventory.control_panel.nodes.NodeFunction;
import com.hbm.inventory.control_panel.nodes.NodeGetVar;
import com.hbm.inventory.control_panel.nodes.NodeSetVar;
import com.hbm.main.ResourceManager;
import com.hbm.render.amlfrom1710.IModelCustom;
import com.hbm.render.amlfrom1710.Tessellator;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ButtonPush
extends Control {
    public ButtonPush(String name, ControlPanel panel) {
        super(name, panel);
        this.vars.put("isPushed", new DataValueFloat(0.0f));
        this.vars.put("isLit", new DataValueFloat(0.0f));
        this.vars.put("color", new DataValueEnum(EnumDyeColor.RED));
    }

    @Override
    public ControlType getControlType() {
        return ControlType.BUTTON;
    }

    @Override
    public float[] getSize() {
        return new float[]{1.0f, 1.0f, 0.4f};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render() {
        GlStateManager.func_179103_j((int)7425);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.ctrl_button_push_tex);
        Tessellator tes = Tessellator.instance;
        IModelCustom model = this.getModel();
        boolean isPushed = this.getVar("isPushed").getBoolean();
        boolean isLit = this.getVar("isLit").getBoolean();
        float[] color = this.getVar("color").getEnum(EnumDyeColor.class).func_193349_f();
        float lX = OpenGlHelper.lastBrightnessX;
        float lY = OpenGlHelper.lastBrightnessY;
        tes.startDrawing(4, DefaultVertexFormats.field_181712_l);
        tes.setTranslation(this.posX, 0.0, this.posY);
        tes.setColorRGBA_F(1.0f, 1.0f, 1.0f, 1.0f);
        model.tessellatePart(tes, "base");
        tes.draw();
        tes.startDrawing(4, DefaultVertexFormats.field_181712_l);
        tes.setTranslation(this.posX, 0.0, this.posY);
        tes.setColorRGBA_F(1.0f, 1.0f, 1.0f, 1.0f);
        model.tessellatePart(tes, "btn_base");
        tes.draw();
        if (isLit) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        }
        float cMul = 0.6f;
        if (isLit) {
            cMul = 1.0f;
        }
        tes.startDrawing(4, DefaultVertexFormats.field_181712_l);
        tes.setTranslation(this.posX, isPushed ? (double)-0.1f : 0.0, this.posY);
        tes.setColorRGBA_F(color[0] * cMul, color[1] * cMul, color[2] * cMul, 1.0f);
        model.tessellatePart(tes, "btn_top");
        tes.draw();
        tes.startDrawing(4, DefaultVertexFormats.field_181712_l);
        tes.setTranslation(this.posX, isPushed ? (double)-0.1f : 0.0, this.posY);
        tes.setColorRGBA_F(color[0] * cMul, color[1] * cMul, color[2] * cMul, 1.0f);
        model.tessellatePart(tes, "btn_top_top");
        tes.draw();
        if (isLit) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lX, (float)lY);
        }
        GlStateManager.func_179103_j((int)7424);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IModelCustom getModel() {
        return ResourceManager.ctrl_button_push;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getGuiTexture() {
        return ResourceManager.ctrl_button_push_gui_tex;
    }

    @Override
    public List<String> getOutEvents() {
        return Collections.singletonList("ctrl_press");
    }

    @Override
    public void populateDefaultNodes(List<ControlEvent> receiveEvents) {
        NodeSystem ctrl_press = new NodeSystem(this);
        NodeGetVar node0 = new NodeGetVar(170.0f, 100.0f, this).setData("isPushed", false);
        ctrl_press.addNode(node0);
        NodeBoolean node1 = new NodeBoolean(230.0f, 120.0f).setData(NodeBoolean.BoolOperation.NOT);
        ((NodeConnection)node1.inputs.get(0)).setData(node0, 0, true);
        ctrl_press.addNode(node1);
        NodeSetVar node2 = new NodeSetVar(290.0f, 140.0f, this).setData("isLit", false);
        ((NodeConnection)node2.inputs.get(0)).setData(node1, 0, true);
        ctrl_press.addNode(node2);
        NodeSetVar node3 = new NodeSetVar(290.0f, 90.0f, this).setData("isPushed", false);
        ((NodeConnection)node3.inputs.get(0)).setData(node1, 0, true);
        ctrl_press.addNode(node3);
        this.receiveNodeMap.put("ctrl_press", ctrl_press);
        NodeSystem tick = new NodeSystem(this);
        NodeGetVar node02 = new NodeGetVar(170.0f, 100.0f, this).setData("isPushed", false);
        tick.addNode(node02);
        NodeBuffer node12 = new NodeBuffer(230.0f, 120.0f);
        ((NodeConnection)node12.inputs.get(0)).setData(node02, 0, true);
        ((NodeConnection)node12.inputs.get(1)).setDefault(new DataValueFloat(10.0f));
        tick.addNode(node12);
        NodeFunction node22 = new NodeFunction(290.0f, 130.0f);
        NodeSystem node2_subsystem = new NodeSystem(this);
        node2_subsystem.addNode(new NodeSetVar(290.0f, 90.0f, this).setData("isPushed", false));
        node2_subsystem.addNode(new NodeSetVar(290.0f, 140.0f, this).setData("isLit", false));
        ((NodeConnection)node22.inputs.get(0)).setData(node12, 0, true);
        tick.subSystems.put(node22, node2_subsystem);
        tick.addNode(node22);
        this.receiveNodeMap.put("tick", tick);
    }

    @Override
    public Control newControl(ControlPanel panel) {
        return new ButtonPush(this.name, panel);
    }
}

