/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel.controls;

import com.hbm.inventory.control_panel.Control;
import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.ControlPanel;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.NodeConnection;
import com.hbm.inventory.control_panel.NodeSystem;
import com.hbm.inventory.control_panel.controls.ControlType;
import com.hbm.inventory.control_panel.nodes.Node;
import com.hbm.inventory.control_panel.nodes.NodeBoolean;
import com.hbm.inventory.control_panel.nodes.NodeBuffer;
import com.hbm.inventory.control_panel.nodes.NodeFunction;
import com.hbm.inventory.control_panel.nodes.NodeGetVar;
import com.hbm.inventory.control_panel.nodes.NodeInput;
import com.hbm.inventory.control_panel.nodes.NodeSetVar;
import com.hbm.main.ClientProxy;
import com.hbm.main.ResourceManager;
import com.hbm.render.amlfrom1710.IModelCustom;
import com.hbm.render.amlfrom1710.Tessellator;
import java.nio.FloatBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class ButtonEncasedPush
extends Control {
    public ButtonEncasedPush(String name, ControlPanel panel) {
        super(name, panel);
        this.vars.put("isPushed", new DataValueFloat(0.0f));
        this.vars.put("isLit", new DataValueFloat(0.0f));
        this.vars.put("isCoverOpen", new DataValueFloat(0.0f));
    }

    @Override
    public ControlType getControlType() {
        return ControlType.BUTTON;
    }

    @Override
    public float[] getSize() {
        return new float[]{1.5f, 1.5f, 1.0f};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render() {
        GlStateManager.func_179103_j((int)7425);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.ctrl_button_encased_push_tex);
        Tessellator tes = Tessellator.instance;
        IModelCustom model = this.getModel();
        boolean isPushed = this.getVar("isPushed").getBoolean();
        boolean isLit = this.getVar("isLit").getBoolean();
        boolean isCoverOpen = this.getVar("isCoverOpen").getBoolean();
        float lX = OpenGlHelper.lastBrightnessX;
        float lY = OpenGlHelper.lastBrightnessY;
        tes.startDrawing(4, DefaultVertexFormats.field_181712_l);
        tes.setTranslation(this.posX, 0.0, this.posY);
        tes.setColorRGBA_F(1.0f, 1.0f, 1.0f, 1.0f);
        model.tessellatePart(tes, "base");
        tes.draw();
        if (isLit) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        }
        float[] color = EnumDyeColor.RED.func_193349_f();
        float cMul = 0.6f;
        if (isLit) {
            cMul = 1.0f;
        }
        tes.startDrawing(4, DefaultVertexFormats.field_181712_l);
        tes.setTranslation(this.posX, isPushed ? (double)-0.1f : 0.0, this.posY);
        tes.setColorRGBA_F(color[0] * cMul, color[1] * cMul, color[2] * cMul, 1.0f);
        model.tessellatePart(tes, "btn_top");
        tes.draw();
        tes.startDrawing(4, DefaultVertexFormats.field_181712_l);
        tes.setTranslation(this.posX, isPushed ? (double)-0.1f : 0.0, this.posY);
        tes.setColorRGBA_F(color[0] * cMul, color[1] * cMul, color[2] * cMul, 1.0f);
        model.tessellatePart(tes, "btn_top_top");
        tes.draw();
        if (isLit) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lX, (float)lY);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Matrix4f rot_mat = new Matrix4f().rotate((float)(isCoverOpen ? Math.toRadians(-75.0) : 0.0), new Vector3f(1.0f, 0.0f, 0.0f));
        Matrix4f trans_mat = new Matrix4f().translate(new Vector3f(this.posX, 0.625f, this.posY - 0.75f));
        Matrix4f transform_mat = new Matrix4f();
        Matrix4f.mul((Matrix4f)trans_mat, (Matrix4f)rot_mat, (Matrix4f)transform_mat);
        transform_mat.store(ClientProxy.AUX_GL_BUFFER);
        ClientProxy.AUX_GL_BUFFER.rewind();
        GlStateManager.func_179110_a((FloatBuffer)ClientProxy.AUX_GL_BUFFER);
        tes.startDrawing(4, DefaultVertexFormats.field_181712_l);
        tes.setColorRGBA_F(1.0f, 1.0f, 1.0f, 1.0f);
        model.tessellatePart(tes, "cover");
        tes.draw();
        tes.startDrawing(4, DefaultVertexFormats.field_181712_l);
        tes.setColorRGBA_F(1.0f, 1.0f, 1.0f, 1.0f);
        model.tessellatePart(tes, "cover2");
        tes.draw();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7424);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IModelCustom getModel() {
        return ResourceManager.ctrl_button_encased_push;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getGuiTexture() {
        return ResourceManager.ctrl_button_encased_push_gui_tex;
    }

    @Override
    public List<String> getOutEvents() {
        return Collections.singletonList("ctrl_press");
    }

    @Override
    public void populateDefaultNodes(List<ControlEvent> receiveEvents) {
        NodeSystem ctrl_press = new NodeSystem(this);
        HashMap<String, DataValue> vars = new HashMap<String, DataValue>(receiveEvents.get((int)0).vars);
        vars.put("from index", new DataValueFloat(0.0f));
        Node node0 = new NodeInput(170.0f, 100.0f, "Event Data").setVars(vars);
        ctrl_press.addNode(node0);
        Node node1 = new NodeFunction(230.0f, 80.0f);
        NodeSystem node1_subsystem = new NodeSystem(this);
        NodeGetVar node1_0 = new NodeGetVar(170.0f, 100.0f, this).setData("isCoverOpen", false);
        node1_subsystem.addNode(node1_0);
        NodeBoolean node1_1 = new NodeBoolean(230.0f, 120.0f).setData(NodeBoolean.BoolOperation.NOT);
        ((NodeConnection)node1_1.inputs.get(0)).setData(node1_0, 0, true);
        node1_subsystem.addNode(node1_1);
        NodeSetVar node1_2 = new NodeSetVar(290.0f, 140.0f, this).setData("isCoverOpen", false);
        ((NodeConnection)node1_2.inputs.get(0)).setData(node1_1, 0, true);
        node1_subsystem.addNode(node1_2);
        ((NodeConnection)node1.inputs.get(0)).setData(node0, 1, true);
        ctrl_press.subSystems.put(node1, node1_subsystem);
        ctrl_press.addNode(node1);
        NodeBoolean node2 = new NodeBoolean(230.0f, 120.0f).setData(NodeBoolean.BoolOperation.NOT);
        ((NodeConnection)node2.inputs.get(0)).setData(node0, 1, true);
        ctrl_press.addNode(node2);
        NodeGetVar node3 = new NodeGetVar(170.0f, 160.0f, this).setData("isCoverOpen", false);
        ctrl_press.addNode(node3);
        NodeBoolean node4 = new NodeBoolean(290.0f, 130.0f).setData(NodeBoolean.BoolOperation.AND);
        ((NodeConnection)node4.inputs.get(0)).setData(node2, 0, true);
        ((NodeConnection)node4.inputs.get(1)).setData(node3, 0, true);
        ctrl_press.addNode(node4);
        NodeFunction node5 = new NodeFunction(350.0f, 140.0f);
        NodeSystem node5_subsystem = new NodeSystem(this);
        NodeGetVar node5_0 = new NodeGetVar(170.0f, 100.0f, this).setData("isPushed", false);
        node5_subsystem.addNode(node5_0);
        NodeBoolean node5_1 = new NodeBoolean(230.0f, 120.0f).setData(NodeBoolean.BoolOperation.NOT);
        ((NodeConnection)node5_1.inputs.get(0)).setData(node5_0, 0, true);
        node5_subsystem.addNode(node5_1);
        NodeSetVar node5_2 = new NodeSetVar(290.0f, 140.0f, this).setData("isPushed", false);
        ((NodeConnection)node5_2.inputs.get(0)).setData(node5_1, 0, true);
        node5_subsystem.addNode(node5_2);
        NodeSetVar node5_3 = new NodeSetVar(290.0f, 100.0f, this).setData("isLit", false);
        ((NodeConnection)node5_3.inputs.get(0)).setDefault(new DataValueFloat(1.0f));
        node5_subsystem.addNode(node5_3);
        ((NodeConnection)node5.inputs.get(0)).setData(node4, 0, true);
        ctrl_press.subSystems.put(node5, node5_subsystem);
        ctrl_press.addNode(node5);
        this.receiveNodeMap.put("ctrl_press", ctrl_press);
        NodeSystem tick = new NodeSystem(this);
        node0 = new NodeGetVar(170.0f, 100.0f, this).setData("isPushed", false);
        tick.addNode(node0);
        node1 = new NodeBuffer(230.0f, 120.0f);
        ((NodeConnection)((NodeBuffer)node1).inputs.get(0)).setData(node0, 0, true);
        ((NodeConnection)((NodeBuffer)node1).inputs.get(1)).setDefault(new DataValueFloat(15.0f));
        tick.addNode(node1);
        NodeFunction node22 = new NodeFunction(290.0f, 140.0f);
        NodeSystem node2_subsystem = new NodeSystem(this);
        NodeSetVar node2_0 = new NodeSetVar(290.0f, 100.0f, this).setData("isPushed", false);
        node2_subsystem.addNode(node2_0);
        NodeSetVar node2_1 = new NodeSetVar(290.0f, 140.0f, this).setData("isLit", false);
        node2_subsystem.addNode(node2_1);
        ((NodeConnection)node22.inputs.get(0)).setData(node1, 0, true);
        tick.subSystems.put(node22, node2_subsystem);
        tick.addNode(node22);
        this.receiveNodeMap.put("tick", tick);
    }

    @Override
    public Control newControl(ControlPanel panel) {
        return new ButtonEncasedPush(this.name, panel);
    }
}

