/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.DataValueString;
import com.hbm.inventory.control_panel.GuiControlEdit;
import com.hbm.inventory.control_panel.SubElement;
import com.hbm.render.RenderHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Keyboard;

public class SubElementVariables
extends SubElement {
    public static ResourceLocation list_bg = new ResourceLocation("hbm:textures/gui/control_panel/gui_variable_list_front.png");
    GuiButton btn_clearAll;
    GuiButton btn_back;
    GuiButton btn_newNumber;
    GuiButton btn_newString;
    GuiButton btn_local;
    GuiButton btn_global;
    GuiButton btn_confirmNewVar;
    GuiButton btn_nextPage;
    GuiButton btn_prevPage;
    GuiTextField txt_newVarName;
    GuiTextField txt_newVarData;
    DataValue newVarData;
    public int numPages = 1;
    public int currentPage = 1;
    int list_offset = 0;
    boolean isGlobalScope = true;
    boolean isCreatingNewVar = false;
    Map<String, GuiButton> btns_var_delete = new HashMap<String, GuiButton>();
    Map<String, GuiTextField> txts_var_data = new HashMap<String, GuiTextField>();

    public SubElementVariables(GuiControlEdit gui) {
        super(gui);
        this.newVarData = new DataValueFloat(0.0f);
    }

    @Override
    protected void initGui() {
        int cY = this.gui.field_146295_m / 2;
        int gLeft = this.gui.getGuiLeft();
        int gTop = this.gui.getGuiTop();
        this.btn_back = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), gLeft + 7, gTop + 13, 30, 20, "Back"));
        this.btn_newString = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), gLeft + 7, gTop + 68, 43, 20, "String"));
        this.btn_newNumber = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), gLeft + 7, gTop + 91, 43, 20, "Number"));
        this.btn_local = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), gLeft + 59, gTop + 17, 65, 20, "Local"));
        this.btn_global = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), gLeft + 59, gTop + 17, 65, 20, "Global"));
        this.btn_clearAll = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), gLeft + 132, gTop + 17, 43, 20, "Clear"));
        this.btn_prevPage = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), gLeft + 186, gTop + 17, 15, 20, "<"));
        this.btn_nextPage = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), gLeft + 231, gTop + 17, 15, 20, ">"));
        this.btn_confirmNewVar = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), gLeft + 223, cY - 80, 20, 20, "+"));
        this.btn_confirmNewVar.packedFGColour = 6138973;
        Keyboard.enableRepeatEvents((boolean)true);
        this.txt_newVarName = new GuiTextField(this.gui.currentButtonId(), this.gui.getFontRenderer(), gLeft + 77, cY - 80, 60, 20);
        this.txt_newVarName.func_146180_a("name");
        this.txt_newVarData = new GuiTextField(this.gui.currentButtonId(), this.gui.getFontRenderer(), gLeft + 152, cY - 80, 65, 20);
        super.initGui();
    }

    @Override
    protected void renderBackground() {
        this.gui.field_146297_k.func_110434_K().func_110577_a(list_bg);
        this.gui.func_73729_b(this.gui.getGuiLeft(), this.gui.getGuiTop(), 0, 0, this.gui.getXSize(), this.gui.getYSize());
    }

    @Override
    protected void update() {
        super.update();
        for (Map.Entry<String, GuiTextField> e : this.txts_var_data.entrySet()) {
            e.getValue().func_146178_a();
        }
    }

    @Override
    protected void drawScreen() {
        int cY = this.gui.field_146295_m / 2;
        String text = this.currentPage + "/" + this.numPages;
        this.gui.getFontRenderer().func_175065_a(text, (float)(this.gui.getGuiLeft() + 216) - (float)this.gui.getFontRenderer().func_78256_a(text) / 2.0f, (float)(cY - 103), -8947849, false);
        if (this.isGlobalScope) {
            this.drawVarList(this.gui.control.panel.globalVars);
        } else {
            this.drawVarList(this.gui.currentEditControl.vars);
        }
        if (this.isCreatingNewVar) {
            this.drawCreateVar();
        }
        this.btn_confirmNewVar.field_146124_l = this.isCreatingNewVar;
        if (this.gui.currentEditControl != null) {
            this.btn_global.field_146124_l = this.isGlobalScope;
            this.btn_global.field_146125_m = this.isGlobalScope;
            this.btn_local.field_146124_l = !this.isGlobalScope;
            this.btn_local.field_146125_m = !this.isGlobalScope;
        } else {
            this.btn_global.field_146124_l = false;
            this.btn_global.field_146125_m = true;
            this.btn_local.field_146124_l = false;
            this.btn_local.field_146125_m = false;
        }
    }

    protected void drawVarList(Map<String, DataValue> varList) {
        int cY = this.gui.field_146295_m / 2 + this.list_offset;
        this.gui.getButtons().removeAll(this.btns_var_delete.values());
        this.btns_var_delete.clear();
        int i = 0;
        for (Map.Entry<String, DataValue> entry : varList.entrySet()) {
            int j = i % 6;
            String text = entry.getKey();
            this.btns_var_delete.put(entry.getKey(), new GuiButton(this.gui.currentButtonId(), this.gui.getGuiLeft() + 60, cY - 52 + j * 28, 20, 20, "X"));
            GuiButton btn_del = this.btns_var_delete.get(entry.getKey());
            btn_del.field_146124_l = false;
            btn_del.field_146125_m = false;
            if (i >= (this.currentPage - 1) * 6 && i < (this.currentPage - 1) * 6 + 6) {
                GlStateManager.func_179090_x();
                GlStateManager.func_179131_c((float)0.15f, (float)0.19f, (float)0.14f, (float)0.2f);
                RenderHelper.drawGuiRect(this.gui.getGuiLeft() + 55, (float)cY - 54.5f + (float)(j * 28), 0.0f, 0.0f, 193.0f, 25.0f, 0.0f, 0.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179098_w();
                if (this.isGlobalScope || this.gui.currentEditControl.customVarNames.contains(entry.getKey())) {
                    btn_del.field_146124_l = true;
                }
                btn_del.field_146125_m = true;
                this.gui.getFontRenderer().func_175065_a(this.gui.getFontRenderer().func_78256_a(text) > 70 ? text.substring(0, 10) + "..." : text, (float)(this.gui.getGuiLeft() + 87), (float)(cY - 46 + j * 28), -1, false);
                this.gui.getFontRenderer().func_175065_a(" = ", (float)(this.gui.getGuiLeft() + 154), (float)(cY - 46 + j * 28), -1, false);
                if (this.txts_var_data.containsKey(entry.getKey())) {
                    if (this.txts_var_data.get(entry.getKey()).func_146206_l()) {
                        DataValue.DataType type = varList.get(entry.getKey()).getType();
                        switch (type) {
                            case NUMBER: {
                                varList.put(entry.getKey(), new DataValueFloat(Float.parseFloat(this.txts_var_data.get(entry.getKey()).func_146179_b().isEmpty() ? "0" : this.txts_var_data.get(entry.getKey()).func_146179_b())));
                                break;
                            }
                            case STRING: {
                                varList.put(entry.getKey(), new DataValueString(this.txts_var_data.get(entry.getKey()).func_146179_b()));
                            }
                        }
                    }
                } else {
                    GuiTextField txt = new GuiTextField(3000 + i, this.gui.getFontRenderer(), this.gui.getGuiLeft() + 167, cY - 52 + j * 28, 75, 20);
                    txt.func_146180_a(entry.getValue().toString());
                    txt.func_146193_g(entry.getValue().getType() == DataValue.DataType.NUMBER ? 0x99CCFF : 0xFFFF99);
                    this.txts_var_data.put(entry.getKey(), txt);
                }
            }
            ++i;
        }
        this.numPages = (int)Math.ceil((float)Math.max(1, this.btns_var_delete.size()) / 6.0f);
        this.currentPage = MathHelper.func_76125_a((int)this.currentPage, (int)1, (int)this.numPages);
        this.gui.getButtons().addAll(this.btns_var_delete.values());
        for (Map.Entry<String, DataValue> entry : this.txts_var_data.entrySet()) {
            ((GuiTextField)entry.getValue()).func_146194_f();
        }
    }

    protected void drawCreateVar() {
        int cY = this.gui.field_146295_m / 2;
        String text = "";
        switch (this.newVarData.getType()) {
            case NUMBER: {
                text = "N : ";
                break;
            }
            case STRING: {
                text = "S : ";
            }
        }
        this.gui.getFontRenderer().func_175065_a(text, (float)(this.gui.getGuiLeft() + 60), (float)(cY - 74), -1, false);
        this.txt_newVarName.func_146194_f();
        this.gui.getFontRenderer().func_175065_a(" = ", (float)(this.gui.getGuiLeft() + 138), (float)(cY - 74), -1, false);
        this.txt_newVarData.func_146194_f();
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        this.txt_newVarName.func_146192_a(mouseX, mouseY, button);
        this.txt_newVarData.func_146192_a(mouseX, mouseY, button);
        for (Map.Entry<String, GuiTextField> field : this.txts_var_data.entrySet()) {
            if (!this.isGlobalScope && this.gui.currentEditControl.vars.get(field.getKey()).getType() == DataValue.DataType.ENUM) continue;
            field.getValue().func_146192_a(mouseX, mouseY, button);
        }
    }

    @Override
    protected void keyTyped(char typedChar, int keyCode) {
        super.keyTyped(typedChar, keyCode);
        this.txt_newVarName.func_146201_a(typedChar, keyCode);
        this.txt_newVarData.func_146201_a(typedChar, keyCode);
        boolean isDigitOrControlChar = Character.isDigit(typedChar) || Character.getType(typedChar) == 15;
        for (Map.Entry<String, GuiTextField> field : this.txts_var_data.entrySet()) {
            boolean isNumberType;
            boolean bl = isNumberType = this.isGlobalScope && this.gui.control.panel.globalVars.get(field.getKey()).getType() == DataValue.DataType.NUMBER || !this.isGlobalScope && this.gui.currentEditControl.vars.get(field.getKey()).getType() == DataValue.DataType.NUMBER;
            if (isNumberType && !isDigitOrControlChar) continue;
            field.getValue().func_146201_a(typedChar, keyCode);
        }
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button == this.btn_newNumber) {
            this.newVarData = new DataValueFloat(0.0f);
            this.txt_newVarData.func_146180_a(this.newVarData.toString());
            this.isCreatingNewVar = true;
        } else if (button == this.btn_newString) {
            this.newVarData = new DataValueString("");
            this.txt_newVarData.func_146180_a(this.newVarData.toString());
            this.isCreatingNewVar = true;
        } else if (button == this.btn_prevPage) {
            this.currentPage = Math.max(1, this.currentPage - 1);
            this.txts_var_data.clear();
        } else if (button == this.btn_nextPage) {
            this.currentPage = Math.min(this.numPages, this.currentPage + 1);
            this.txts_var_data.clear();
        } else if (button == this.btn_clearAll) {
            if (this.isGlobalScope) {
                this.gui.control.panel.globalVars.clear();
            } else {
                for (String s : this.gui.currentEditControl.customVarNames) {
                    this.gui.currentEditControl.vars.remove(s);
                }
            }
            this.txts_var_data.clear();
        } else if (button == this.btn_local || button == this.btn_global) {
            this.isGlobalScope = !this.isGlobalScope;
            this.txts_var_data.clear();
        } else if (button == this.btn_back) {
            if (!this.gui.subElementStack.contains(this.gui.linker)) {
                this.gui.currentEditControl = null;
            }
            this.gui.popElement();
        } else if (button == this.btn_confirmNewVar) {
            if (this.txt_newVarName.func_146179_b().isEmpty() || this.txt_newVarData.func_146179_b().isEmpty()) {
                return;
            }
            this.isCreatingNewVar = false;
            if (this.isGlobalScope) {
                switch (this.newVarData.getType()) {
                    case NUMBER: {
                        this.gui.control.panel.globalVars.put(this.txt_newVarName.func_146179_b(), new DataValueFloat(Float.parseFloat(this.txt_newVarData.func_146179_b())));
                        break;
                    }
                    case STRING: {
                        this.gui.control.panel.globalVars.put(this.txt_newVarName.func_146179_b(), new DataValueString(this.txt_newVarData.func_146179_b()));
                    }
                }
            } else {
                switch (this.newVarData.getType()) {
                    case NUMBER: {
                        this.gui.currentEditControl.vars.put(this.txt_newVarName.func_146179_b(), new DataValueFloat(Float.parseFloat(this.txt_newVarData.func_146179_b())));
                        this.gui.currentEditControl.customVarNames.add(this.txt_newVarName.func_146179_b());
                        break;
                    }
                    case STRING: {
                        this.gui.currentEditControl.vars.put(this.txt_newVarName.func_146179_b(), new DataValueString(this.txt_newVarData.func_146179_b()));
                        this.gui.currentEditControl.customVarNames.add(this.txt_newVarName.func_146179_b());
                    }
                }
            }
            this.txt_newVarName.func_146180_a("name");
            this.txts_var_data.clear();
        } else if (this.btns_var_delete.containsValue(button)) {
            for (Map.Entry<String, GuiButton> e : this.btns_var_delete.entrySet()) {
                if (!e.getValue().equals(button)) continue;
                if (this.isGlobalScope) {
                    this.gui.control.panel.globalVars.remove(e.getKey());
                } else {
                    this.gui.currentEditControl.vars.remove(e.getKey());
                    this.gui.currentEditControl.customVarNames.remove(e.getKey());
                }
                this.txts_var_data.clear();
            }
        }
    }

    @Override
    protected void enableButtons(boolean enable) {
        this.btn_clearAll.field_146124_l = enable;
        this.btn_clearAll.field_146125_m = enable;
        this.btn_back.field_146124_l = enable;
        this.btn_back.field_146125_m = enable;
        this.btn_nextPage.field_146124_l = enable;
        this.btn_nextPage.field_146125_m = enable;
        this.btn_prevPage.field_146124_l = enable;
        this.btn_prevPage.field_146125_m = enable;
        this.btn_newNumber.field_146124_l = enable;
        this.btn_newNumber.field_146125_m = enable;
        this.btn_newString.field_146124_l = enable;
        this.btn_newString.field_146125_m = enable;
        this.btn_local.field_146124_l = enable;
        this.btn_local.field_146125_m = enable;
        this.btn_global.field_146124_l = enable;
        this.btn_global.field_146125_m = enable;
        this.btn_confirmNewVar.field_146124_l = enable;
        this.btn_confirmNewVar.field_146125_m = enable;
        this.txt_newVarName.func_146184_c(enable);
        this.txt_newVarName.func_146189_e(enable);
        this.txt_newVarData.func_146184_c(enable);
        this.txt_newVarData.func_146189_e(enable);
        for (Map.Entry<String, GuiTextField> entry : this.txts_var_data.entrySet()) {
            entry.getValue().func_146184_c(enable);
            entry.getValue().func_146189_e(enable);
        }
        for (Map.Entry<String, GuiTextField> entry : this.btns_var_delete.entrySet()) {
            ((GuiButton)entry.getValue()).field_146124_l = enable;
            ((GuiButton)entry.getValue()).field_146125_m = enable;
        }
    }
}

