/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.blocks.BlockDummyable;
import com.hbm.inventory.control_panel.ButtonHoverText;
import com.hbm.inventory.control_panel.ContainerControlEdit;
import com.hbm.inventory.control_panel.GuiControlEdit;
import com.hbm.inventory.control_panel.IControllable;
import com.hbm.inventory.control_panel.SubElement;
import com.hbm.items.tool.ItemMultiDetonator;
import com.hbm.tileentity.machine.TileEntityDummy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SubElementLinker
extends SubElement {
    public static ResourceLocation inv_tex = new ResourceLocation("hbm:textures/gui/control_panel/gui_linker_add_element.png");
    public GuiButton clear;
    public GuiButton accept;
    public GuiButton pageLeft;
    public GuiButton pageRight;
    public GuiButton cont;
    public GuiButton back;
    public List<IControllable> linked = new ArrayList<IControllable>();
    public List<GuiButton> linkedButtons = new ArrayList<GuiButton>();
    public int numPages = 1;
    public int currentPage = 1;

    public SubElementLinker(GuiControlEdit gui) {
        super(gui);
    }

    @Override
    protected void initGui() {
        int cX = this.gui.field_146294_l / 2;
        int cY = this.gui.field_146295_m / 2;
        this.clear = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX - 121, cY - 93, 40, 20, "Clear"));
        this.accept = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX - 101, cY - 116, 20, 20, ">"));
        this.pageLeft = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX - 60, cY - 16, 20, 20, "<"));
        this.pageRight = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX + 90, cY - 16, 20, 20, ">"));
        this.cont = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX - 60, cY + 6, 170, 20, "Continue"));
        super.initGui();
    }

    @Override
    protected void drawScreen() {
        int cX = this.gui.field_146294_l / 2;
        int cY = this.gui.field_146295_m / 2;
        ItemStack stack = ((Slot)this.gui.container.field_75151_b.get(0)).func_75211_c();
        this.accept.field_146124_l = !stack.func_190926_b() && stack.func_77973_b() instanceof ItemMultiDetonator;
        String text = this.currentPage + "/" + this.numPages;
        this.gui.getFontRenderer().func_175065_a(text, (float)(cX + 16), (float)(cY - 10), -8947849, false);
        text = "Create Links";
        this.gui.getFontRenderer().func_175065_a(text, (float)cX - (float)this.gui.getFontRenderer().func_78256_a(text) / 2.0f + 10.0f, (float)(cY - 110), -8947849, false);
    }

    @Override
    protected void renderBackground() {
        this.gui.field_146297_k.func_110434_K().func_110577_a(inv_tex);
        this.gui.func_73729_b(this.gui.getGuiLeft(), this.gui.getGuiTop(), 0, 0, this.gui.getXSize(), this.gui.getYSize());
    }

    private void recalculateVisibleButtons() {
        int idx;
        for (GuiButton b : this.linkedButtons) {
            b.field_146125_m = false;
            b.field_146124_l = false;
        }
        for (int i = idx = (this.currentPage - 1) * 3; i < idx + 3 && i < this.linkedButtons.size() && i >= 1; ++i) {
            this.linkedButtons.get((int)i).field_146125_m = true;
            this.linkedButtons.get((int)i).field_146124_l = true;
        }
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        World world = this.gui.control.func_145831_w();
        if (button == this.accept) {
            int[][] locs;
            ItemStack stack = ((Slot)this.gui.container.field_75151_b.get(0)).func_75211_c();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemMultiDetonator && (locs = ItemMultiDetonator.getLocations(stack)) != null) {
                for (int i = 0; i < locs[0].length; ++i) {
                    BlockPos bpos;
                    TileEntity te;
                    int[] core;
                    BlockPos pos = new BlockPos(locs[0][i], locs[1][i], locs[2][i]);
                    Block b = world.func_180495_p(pos).func_177230_c();
                    if (b instanceof BlockDummyable && (core = ((BlockDummyable)b).findCore((IBlockAccess)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) != null) {
                        pos = new BlockPos(core[0], core[1], core[2]);
                    }
                    if ((te = world.func_175625_s(pos)) instanceof TileEntityDummy && (bpos = ((TileEntityDummy)te).target) != null) {
                        te = world.func_175625_s(((TileEntityDummy)te).target);
                    }
                    if (!(te instanceof IControllable) || this.linked.contains(te)) continue;
                    this.linked.add((IControllable)te);
                }
                this.refreshButtons();
            }
        } else if (button == this.clear) {
            this.linked.clear();
            this.gui.currentEditControl.connectedSet.clear();
            this.refreshButtons();
        } else if (button == this.cont) {
            this.gui.eventEditor.accumulateEventTypes(this.linked);
            this.gui.eventEditor.populateDefaultNodes();
            for (IControllable c : this.gui.linker.linked) {
                if (this.gui.currentEditControl.connectedSet.contains(c.getControlPos())) continue;
                this.gui.currentEditControl.connectedSet.add(c.getControlPos());
            }
            this.gui.pushElement(this.gui.eventEditor);
        } else if (button == this.pageLeft) {
            this.currentPage = Math.max(1, this.currentPage - 1);
            this.recalculateVisibleButtons();
        } else if (button == this.pageRight) {
            this.currentPage = Math.min(this.numPages, this.currentPage + 1);
            this.recalculateVisibleButtons();
        } else if (this.linkedButtons.contains(button)) {
            int idx = this.linkedButtons.indexOf(button);
            this.gui.currentEditControl.connectedSet.remove(this.linked.get(idx).getControlPos());
            this.linked.remove(idx);
            this.refreshButtons();
        }
    }

    protected void refreshButtons() {
        this.gui.getButtons().removeAll(this.linkedButtons);
        this.linkedButtons.clear();
        int i = 0;
        int cX = this.gui.field_146294_l / 2;
        int cY = this.gui.field_146295_m / 2;
        for (IControllable c : this.linked) {
            BlockPos pos = c.getControlPos();
            this.linkedButtons.add(new ButtonHoverText(this.gui.currentButtonId(), cX - 73, cY - 90 + i * 22, 170, 20, "(" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ")", "<Click to remove>"));
            i = (i + 1) % 3;
        }
        for (GuiButton b : this.linkedButtons) {
            this.gui.func_189646_b(b);
        }
        this.numPages = (this.linked.size() + 2) / 3;
        this.currentPage = MathHelper.func_76125_a((int)this.currentPage, (int)1, (int)this.numPages);
    }

    @Override
    protected void enableButtons(boolean enable) {
        if (enable) {
            this.recalculateVisibleButtons();
        } else {
            for (GuiButton b : this.linkedButtons) {
                b.field_146125_m = false;
                b.field_146124_l = false;
            }
        }
        this.clear.field_146124_l = enable;
        this.clear.field_146125_m = enable;
        this.accept.field_146124_l = enable;
        this.accept.field_146125_m = enable;
        this.pageLeft.field_146124_l = enable;
        this.pageLeft.field_146125_m = enable;
        this.pageRight.field_146124_l = enable;
        this.pageRight.field_146125_m = enable;
        this.cont.field_146124_l = enable;
        this.cont.field_146125_m = enable;
        ContainerControlEdit.SlotItemHandlerDisableable s = (ContainerControlEdit.SlotItemHandlerDisableable)((Object)this.gui.container.field_75151_b.get(0));
        s.isEnabled = enable;
        for (ContainerControlEdit.SlotDisableable slot : this.gui.container.invSlots) {
            slot.isEnabled = enable;
        }
    }
}

