/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueEnum;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.DataValueString;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ControlEvent {
    private static final HashMap<String, ControlEvent> REGISTRY = new HashMap();
    public String name;
    public Map<String, DataValue> vars = new HashMap<String, DataValue>();

    public ControlEvent(String name) {
        this.name = name;
    }

    public ControlEvent setVar(String key, DataValue val) {
        this.vars.put(key, val);
        return this;
    }

    public ControlEvent setVar(String key, float f) {
        this.vars.put(key, new DataValueFloat(f));
        return this;
    }

    public ControlEvent setVar(String key, boolean b) {
        this.vars.put(key, new DataValueFloat(b ? 1.0f : 0.0f));
        return this;
    }

    public ControlEvent setVar(String key, String str) {
        this.vars.put(key, new DataValueString(str));
        return this;
    }

    public <E extends Enum<E>> ControlEvent setVar(String key, E enm) {
        this.vars.put(key, new DataValueEnum(enm));
        return this;
    }

    public ControlEvent copy() {
        ControlEvent evt = new ControlEvent(this.name);
        evt.vars.putAll(this.vars);
        return evt;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("name", this.name);
        NBTTagCompound vars = new NBTTagCompound();
        for (Map.Entry<String, DataValue> e : this.vars.entrySet()) {
            vars.func_74782_a(e.getKey(), e.getValue().writeToNBT());
        }
        tag.func_74782_a("vars", (NBTBase)vars);
        return tag;
    }

    public static ControlEvent readFromNBT(NBTTagCompound tag) {
        ControlEvent evt = ControlEvent.newEvent(tag.func_74779_i("name"));
        NBTTagCompound vars = tag.func_74775_l("vars");
        for (String k : vars.func_150296_c()) {
            DataValue val = DataValue.newFromNBT(vars.func_74781_a(k));
            if (val == null) continue;
            evt.vars.put(k, val);
        }
        return evt;
    }

    public static ControlEvent newEvent(String name) {
        return ControlEvent.getRegisteredEvent(name).copy();
    }

    public static ControlEvent getRegisteredEvent(String name) {
        ControlEvent e = REGISTRY.get(name);
        if (e == null) {
            throw new RuntimeException("Unregistered control event: " + name);
        }
        return e;
    }

    public static void register(ControlEvent c) {
        REGISTRY.put(c.name, c);
    }

    public static void init() {
        ControlEvent.register(new ControlEvent("tick").setVar("time", 0.0f));
        ControlEvent.register(new ControlEvent("door_open_state").setVar("state", 0.0f));
        ControlEvent.register(new ControlEvent("door_toggle").setVar("passcode", 0.0f));
        ControlEvent.register(new ControlEvent("turret_set_target").setVar("players", false).setVar("passive", false).setVar("hostile", true).setVar("machines", true));
        ControlEvent.register(new ControlEvent("turret_switch").setVar("isOn", true));
        ControlEvent.register(new ControlEvent("lever_toggle").setVar("isOn", false));
        ControlEvent.register(new ControlEvent("spinny_light_power").setVar("isOn", false));
        ControlEvent.register(new ControlEvent("siren_set_state").setVar("isOn", false));
        ControlEvent.register(new ControlEvent("tank_set_mode").setVar("mode", 0.0f));
        ControlEvent.register(new ControlEvent("rbmk_ctrl_set_color").setVar("color", 0.0f));
        ControlEvent.register(new ControlEvent("rbmk_ctrl_set_level").setVar("level", 0.0f));
        ControlEvent.register(new ControlEvent("rbmk_crane_move").setVar("up", 0.0f).setVar("down", 0.0f).setVar("left", 0.0f).setVar("right", 0.0f));
        ControlEvent.register(new ControlEvent("rbmk_crane_load"));
        ControlEvent.register(new ControlEvent("ctrl_press").setVar("isSneaking", false));
        ControlEvent.register(new ControlEvent("initialize"));
    }
}

