/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.items.machine.ItemMachineUpgrade;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraftforge.items.IItemHandler;

public class UpgradeManager {
    private final Map<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new EnumMap<ItemMachineUpgrade.UpgradeType, Integer>(ItemMachineUpgrade.UpgradeType.class);
    private ItemMachineUpgrade.UpgradeType mutexType = null;

    public void eval(IItemHandler inv, int start, int end) {
        this.upgrades.clear();
        for (int i = start; i <= end; ++i) {
            Item item = inv.getStackInSlot(i).func_77973_b();
            if (!(item instanceof ItemMachineUpgrade)) continue;
            ItemMachineUpgrade upgrade = (ItemMachineUpgrade)item;
            if (!upgrade.type.mutex) {
                if (upgrade.type == ItemMachineUpgrade.UpgradeType.SPEED || upgrade.type == ItemMachineUpgrade.UpgradeType.SCREAM) {
                    this.upgrades.compute(upgrade.type, (type, level) -> level == null ? upgrade.getSpeed() : level + upgrade.getSpeed());
                    continue;
                }
                this.upgrades.compute(upgrade.type, (type, level) -> level == null ? upgrade.tier : level + upgrade.tier);
                continue;
            }
            if (this.mutexType != null && this.mutexType.ordinal() >= upgrade.type.ordinal()) continue;
            this.mutexType = upgrade.type;
        }
    }

    public int getLevel(ItemMachineUpgrade.UpgradeType type) {
        return this.upgrades.getOrDefault((Object)type, 0);
    }
}

