/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemCircuit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class SolderingRecipes {
    public static List<SolderingRecipe> recipes = new ArrayList<SolderingRecipe>();
    public static HashSet<RecipesCommon.AStack> toppings = new HashSet();
    public static HashSet<RecipesCommon.AStack> pcb = new HashSet();
    public static HashSet<RecipesCommon.AStack> solder = new HashSet();
    public static HashSet<Fluid> fluids = new HashSet();

    public static void registerDefaults() {
        boolean lbsm = false;
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ANALOG.ordinal()), 100, 100L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 3, ItemCircuit.EnumCircuitType.VACUUM_TUBE.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.CAPACITOR.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.PCB.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wire(), 4)}));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.BASIC.ordinal()), 200, 250L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.CHIP.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.PCB.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wire(), 4)}));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED.ordinal()), 300, 1000L, new FluidStack(ModForgeFluids.SULFURIC_ACID, 1000), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 4 : 16, ItemCircuit.EnumCircuitType.CHIP.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.CAPACITOR.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 8, ItemCircuit.EnumCircuitType.PCB.ordinal()), new RecipesCommon.OreDictStack(OreDictManager.POLYMER.ingot(), 2)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wire(), 8)}));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CAPACITOR_BOARD.ordinal()), 200, 300L, new FluidStack(ModForgeFluids.ACID, 250), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 3, ItemCircuit.EnumCircuitType.CAPACITOR_TANTALIUM.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.PCB.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wire(), 3)}));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.BISMOID.ordinal()), 400, 10000L, new FluidStack(ModForgeFluids.SOLVENT, 1000), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.CHIP_BISMOID.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 4 : 16, ItemCircuit.EnumCircuitType.CHIP.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 8 : 24, ItemCircuit.EnumCircuitType.CAPACITOR.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 12, ItemCircuit.EnumCircuitType.PCB.ordinal()), new RecipesCommon.OreDictStack(OreDictManager.CMB.plateCast(), 2)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wire(), 12)}));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.QUANTUM.ordinal()), 400, 100000L, new FluidStack(ModForgeFluids.IONGEL, 1000), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.CHIP_QUANTUM.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 4 : 16, ItemCircuit.EnumCircuitType.CHIP_BISMOID.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 1 : 4, ItemCircuit.EnumCircuitType.ATOMIC_CLOCK.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 16, ItemCircuit.EnumCircuitType.PCB.ordinal()), new RecipesCommon.OreDictStack(OreDictManager.ANY_HARDPLASTIC.ingot(), 4)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.SA326.wire(), 16)}));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CONTROLLER.ordinal()), 400, 15000L, new FluidStack(ModForgeFluids.PERFLUOROMETHYL, 1000), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 8 : 32, ItemCircuit.EnumCircuitType.CHIP.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 8 : 32, ItemCircuit.EnumCircuitType.CAPACITOR.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 4 : 8, ItemCircuit.EnumCircuitType.CRT_TUBE.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CONTROLLER_CHASSIS.ordinal()), new RecipesCommon.ComparableStack(ModItems.upgrade_speed_1)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wire(), 16)}));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED.ordinal()), 600, 25000L, new FluidStack(ModForgeFluids.PERFLUOROMETHYL, 4000), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 8 : 16, ItemCircuit.EnumCircuitType.CHIP_BISMOID.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 16 : 48, ItemCircuit.EnumCircuitType.CAPACITOR_TANTALIUM.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ATOMIC_CLOCK.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CONTROLLER_CHASSIS.ordinal()), new RecipesCommon.ComparableStack(ModItems.upgrade_speed_3)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wire(), 24)}));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CONTROLLER_QUANTUM.ordinal()), 600, 250000L, new FluidStack(ModForgeFluids.MUD_FLUID, 8000), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 8 : 16, ItemCircuit.EnumCircuitType.CHIP_QUANTUM.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 16 : 48, ItemCircuit.EnumCircuitType.CHIP_BISMOID.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 1 : 8, ItemCircuit.EnumCircuitType.ATOMIC_CLOCK.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED.ordinal()), new RecipesCommon.ComparableStack(ModItems.upgrade_overdrive_1)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.SA326.wire(), 32)}));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.upgrade_speed_1), 200, 1000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.VACUUM_TUBE.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CAPACITOR.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.upgrade_template), new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.dust(), 4)}, new RecipesCommon.AStack[0]));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.upgrade_effect_1), 200, 1000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.VACUUM_TUBE.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CAPACITOR.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.upgrade_template), new RecipesCommon.OreDictStack(OreDictManager.EMERALD.dust(), 4)}, new RecipesCommon.AStack[0]));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.upgrade_power_1), 200, 1000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.VACUUM_TUBE.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CAPACITOR.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.upgrade_template), new RecipesCommon.OreDictStack(OreDictManager.GOLD.dust(), 4)}, new RecipesCommon.AStack[0]));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.upgrade_fortune_1), 200, 1000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.VACUUM_TUBE.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CAPACITOR.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.upgrade_template), new RecipesCommon.OreDictStack(OreDictManager.NB.dust(), 4)}, new RecipesCommon.AStack[0]));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.upgrade_afterburn_1), 200, 1000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.VACUUM_TUBE.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CAPACITOR.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.upgrade_template), new RecipesCommon.OreDictStack(OreDictManager.W.dust(), 4)}, new RecipesCommon.AStack[0]));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.upgrade_radius), 200, 1000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.CHIP.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.CAPACITOR.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.upgrade_template), new RecipesCommon.OreDictStack("dustGlowstone", 4)}, new RecipesCommon.AStack[0]));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.upgrade_health), 200, 1000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.CHIP.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.CAPACITOR.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.upgrade_template), new RecipesCommon.OreDictStack(OreDictManager.LI.dust(), 4)}, new RecipesCommon.AStack[0]));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.upgrade_gc_speed), 400, 2000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.ADVANCED.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.CAPACITOR_TANTALIUM.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.upgrade_template), new RecipesCommon.OreDictStack(OreDictManager.UF.ingot(), 4)}, new RecipesCommon.AStack[0]));
        SolderingRecipes.addFirstUpgrade(ModItems.upgrade_speed_1, ModItems.upgrade_speed_2);
        SolderingRecipes.addSecondUpgrade(ModItems.upgrade_speed_2, ModItems.upgrade_speed_3);
        SolderingRecipes.addFirstUpgrade(ModItems.upgrade_effect_1, ModItems.upgrade_effect_2);
        SolderingRecipes.addSecondUpgrade(ModItems.upgrade_effect_2, ModItems.upgrade_effect_3);
        SolderingRecipes.addFirstUpgrade(ModItems.upgrade_power_1, ModItems.upgrade_power_2);
        SolderingRecipes.addSecondUpgrade(ModItems.upgrade_power_2, ModItems.upgrade_power_3);
        SolderingRecipes.addFirstUpgrade(ModItems.upgrade_fortune_1, ModItems.upgrade_fortune_2);
        SolderingRecipes.addSecondUpgrade(ModItems.upgrade_fortune_2, ModItems.upgrade_fortune_3);
        SolderingRecipes.addFirstUpgrade(ModItems.upgrade_afterburn_1, ModItems.upgrade_afterburn_2);
        SolderingRecipes.addSecondUpgrade(ModItems.upgrade_afterburn_2, ModItems.upgrade_afterburn_3);
    }

    public static void addFirstUpgrade(Item lower, Item higher) {
        boolean lbsm = false;
        recipes.add(new SolderingRecipe(new ItemStack(higher), 300, 10000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 4 : 8, ItemCircuit.EnumCircuitType.CHIP.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 2 : 4, ItemCircuit.EnumCircuitType.CAPACITOR.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(lower), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 4)}, new RecipesCommon.AStack[0]));
    }

    public static void addSecondUpgrade(Item lower, Item higher) {
        boolean lbsm = false;
        recipes.add(new SolderingRecipe(new ItemStack(higher), 400, 25000L, new FluidStack(ModForgeFluids.SOLVENT, 500), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 6 : 16, ItemCircuit.EnumCircuitType.CHIP.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 4 : 16, ItemCircuit.EnumCircuitType.CAPACITOR.ordinal())}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(lower), new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 4)}, new RecipesCommon.AStack[0]));
    }

    public static boolean matchesIngredients(ItemStack[] inputs, RecipesCommon.AStack[] recipe) {
        ArrayList<RecipesCommon.AStack> recipeList = new ArrayList<RecipesCommon.AStack>(Arrays.asList(recipe));
        for (ItemStack inputStack : inputs) {
            if (inputStack.func_190926_b()) continue;
            boolean hasMatch = false;
            for (RecipesCommon.AStack recipeStack : recipeList) {
                if (!recipeStack.matchesRecipe(inputStack, true) || inputStack.func_190916_E() < recipeStack.stacksize) continue;
                hasMatch = true;
                recipeList.remove(recipeStack);
                break;
            }
            if (hasMatch) continue;
            return false;
        }
        return recipeList.isEmpty();
    }

    public static SolderingRecipe getRecipe(ItemStack[] inputs) {
        for (SolderingRecipe recipe : recipes) {
            if (!SolderingRecipes.matchesIngredients(new ItemStack[]{inputs[0], inputs[1], inputs[2]}, recipe.toppings) || !SolderingRecipes.matchesIngredients(new ItemStack[]{inputs[3], inputs[4]}, recipe.pcb) || !SolderingRecipes.matchesIngredients(new ItemStack[]{inputs[5]}, recipe.solder)) continue;
            return recipe;
        }
        return null;
    }

    public static class SolderingRecipe {
        public RecipesCommon.AStack[] toppings;
        public RecipesCommon.AStack[] pcb;
        public RecipesCommon.AStack[] solder;
        public FluidStack fluid;
        public ItemStack output;
        public int duration;
        public long consumption;

        public SolderingRecipe(ItemStack output, int duration, long consumption, FluidStack fluid, RecipesCommon.AStack[] toppings, RecipesCommon.AStack[] pcb, RecipesCommon.AStack[] solder) {
            this.toppings = toppings;
            this.pcb = pcb;
            this.solder = solder;
            this.fluid = fluid;
            this.output = output;
            this.duration = duration;
            this.consumption = consumption;
            SolderingRecipes.toppings.addAll(Arrays.asList(toppings));
            SolderingRecipes.pcb.addAll(Arrays.asList(pcb));
            SolderingRecipes.solder.addAll(Arrays.asList(solder));
            if (fluid != null) {
                fluids.add(fluid.getFluid());
            }
        }

        public SolderingRecipe(ItemStack output, int duration, long consumption, RecipesCommon.AStack[] toppings, RecipesCommon.AStack[] pcb, RecipesCommon.AStack[] solder) {
            this(output, duration, consumption, null, toppings, pcb, solder);
        }
    }
}

