/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.blocks.BlockBaseVisualFluidConnectable;
import com.hbm.blocks.ModBlocks;
import com.hbm.forgefluid.ModForgeFluids;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class HeatRecipes {
    public static HashMap<String, Fluid> hotFluids = new HashMap();
    public static HashMap<String, Integer> requiredTU = new HashMap();
    public static HashMap<String, Integer> inputAmountHot = new HashMap();
    public static HashMap<String, Integer> outputAmountHot = new HashMap();
    public static HashMap<String, Fluid> coolFluids = new HashMap();
    public static HashMap<String, Integer> resultingTU = new HashMap();
    public static HashMap<String, Integer> inputAmountCold = new HashMap();
    public static HashMap<String, Integer> outputAmountCold = new HashMap();

    public static void registerHeatRecipes() {
        HeatRecipes.addBoilRecipe(FluidRegistry.WATER, 1, ModForgeFluids.STEAM, 100, 100);
        HeatRecipes.addCoolRecipe(ModForgeFluids.STEAM, 100, ModForgeFluids.SPENTSTEAM, 1, 100);
        HeatRecipes.addBoilAndCoolRecipe(ModForgeFluids.STEAM, 10, ModForgeFluids.HOTSTEAM, 1, 15);
        HeatRecipes.addBoilAndCoolRecipe(ModForgeFluids.HOTSTEAM, 10, ModForgeFluids.SUPERHOTSTEAM, 1, 30);
        HeatRecipes.addBoilAndCoolRecipe(ModForgeFluids.SUPERHOTSTEAM, 10, ModForgeFluids.ULTRAHOTSTEAM, 1, 120);
        HeatRecipes.addBoilAndCoolRecipe(ModForgeFluids.OIL, 1, ModForgeFluids.HOTOIL, 1, 300);
        HeatRecipes.addBoilAndCoolRecipe(ModForgeFluids.CRACKOIL, 1, ModForgeFluids.HOTCRACKOIL, 1, 300);
        HeatRecipes.addBoilAndCoolRecipe(ModForgeFluids.OIL_DS, 1, ModForgeFluids.HOTOIL_DS, 1, 300);
        HeatRecipes.addBoilAndCoolRecipe(ModForgeFluids.CRACKOIL_DS, 1, ModForgeFluids.HOTCRACKOIL_DS, 1, 300);
        HeatRecipes.addBoilAndCoolRecipe(ModForgeFluids.COOLANT, 1, ModForgeFluids.HOTCOOLANT, 1, 500);
        HeatRecipes.addBoilRecipe("crude_oil", 1, "hotoil", 1, 300);
        HeatRecipes.addBoilRecipe("oil_medium", 1, "hotoil", 1, 300);
        HeatRecipes.addBoilRecipe("oilgc", 1, "hotoil", 1, 300);
        HeatRecipes.addBoilRecipe("biofuel", 1, "fuel", 1, 100);
        HeatRecipes.addBoilRecipe("refined_fuel", 1, "petroil", 1, 100);
        HeatRecipes.addBoilRecipe("sulphuricacid", 1, "sulfuric_acid", 1, 100);
        HeatRecipes.addBoilRecipe("sulfuricacid", 1, "sulfuric_acid", 1, 100);
        HeatRecipes.addBoilAndCoolRecipe("liquidoxygen", 1, "oxygen", 1, 1);
        HeatRecipes.addBoilAndCoolRecipe("liquidtritium", 1, "tritium", 1, 1);
        HeatRecipes.addBoilAndCoolRecipe("liquiddeuterium", 1, "deuterium", 1, 1);
        HeatRecipes.addBoilAndCoolRecipe("liquidhydrogen", 1, "hydrogen", 1, 1);
        HeatRecipes.addBoilRecipe("refined_biofuel", 1, "biofuel", 1, 10);
        HeatRecipes.addBoilAndCoolRecipe("ic2coolant", 1, "ic2hot_coolant", 1, 450);
    }

    public static void setFluidsForRBMKLoader() {
        HashSet<Fluid> fluids = new HashSet<Fluid>();
        for (Map.Entry<String, Fluid> entry : hotFluids.entrySet()) {
            fluids.add(FluidRegistry.getFluid((String)entry.getKey()));
            fluids.add(entry.getValue());
        }
        ((BlockBaseVisualFluidConnectable)ModBlocks.rbmk_loader).addFluids(fluids.toArray(new Fluid[0]));
    }

    public static Fluid getBoilFluid(Fluid f) {
        if (f != null) {
            return hotFluids.get(f.getName());
        }
        return null;
    }

    public static int getRequiredHeat(Fluid f) {
        Integer heat = requiredTU.get(f.getName());
        if (heat != null) {
            return heat;
        }
        return -1;
    }

    public static int getInputAmountHot(Fluid f) {
        Integer heat = inputAmountHot.get(f.getName());
        if (heat != null) {
            return heat;
        }
        return -1;
    }

    public static int getOutputAmountHot(Fluid f) {
        Integer heat = outputAmountHot.get(f.getName());
        if (heat != null) {
            return heat;
        }
        return -1;
    }

    public static Fluid getCoolFluid(Fluid f) {
        if (f != null) {
            return coolFluids.get(f.getName());
        }
        return null;
    }

    public static int getResultingHeat(Fluid f) {
        Integer heat = resultingTU.get(f.getName());
        if (heat != null) {
            return heat;
        }
        return -1;
    }

    public static int getInputAmountCold(Fluid f) {
        Integer heat = inputAmountCold.get(f.getName());
        if (heat != null) {
            return heat;
        }
        return -1;
    }

    public static int getOutputAmountCold(Fluid f) {
        Integer heat = outputAmountCold.get(f.getName());
        if (heat != null) {
            return heat;
        }
        return -1;
    }

    public static boolean hasBoilRecipe(Fluid cold) {
        if (cold == null) {
            return false;
        }
        return hotFluids.containsKey(cold.getName());
    }

    public static boolean hasCoolRecipe(Fluid hot) {
        return coolFluids.containsKey(hot.getName());
    }

    public static void addBoilRecipe(Fluid cold, int coldAmount, Fluid hot, int hotAmount, int heat) {
        HeatRecipes.addBoilRecipe(cold.getName(), coldAmount, hot.getName(), hotAmount, heat);
    }

    public static void addBoilRecipe(String cold, int coldAmount, String hot, int hotAmount, int heat) {
        if (FluidRegistry.isFluidRegistered((String)hot) && FluidRegistry.isFluidRegistered((String)cold)) {
            hotFluids.put(cold, FluidRegistry.getFluid((String)hot));
            requiredTU.put(cold, heat);
            inputAmountHot.put(cold, coldAmount);
            outputAmountHot.put(cold, hotAmount);
        }
    }

    public static void addCoolRecipe(Fluid hot, int hotAmount, Fluid cold, int coldAmount, int heat) {
        HeatRecipes.addCoolRecipe(hot.getName(), hotAmount, cold.getName(), coldAmount, heat);
    }

    public static void addCoolRecipe(String hot, int hotAmount, String cold, int coldAmount, int heat) {
        if (FluidRegistry.isFluidRegistered((String)hot) && FluidRegistry.isFluidRegistered((String)cold)) {
            coolFluids.put(hot, FluidRegistry.getFluid((String)cold));
            resultingTU.put(hot, heat);
            inputAmountCold.put(hot, hotAmount);
            outputAmountCold.put(hot, coldAmount);
        }
    }

    public static void addBoilAndCoolRecipe(Fluid cold, int coldAmount, Fluid hot, int hotAmount, int heat) {
        HeatRecipes.addBoilAndCoolRecipe(cold.getName(), coldAmount, hot.getName(), hotAmount, heat);
    }

    public static void addBoilAndCoolRecipe(String cold, int coldAmount, String hot, int hotAmount, int heat) {
        if (FluidRegistry.isFluidRegistered((String)hot) && FluidRegistry.isFluidRegistered((String)cold)) {
            HeatRecipes.addBoilRecipe(cold, coldAmount, hot, hotAmount, heat);
            HeatRecipes.addCoolRecipe(hot, hotAmount, cold, coldAmount, heat);
        }
    }

    public static void removeBoilRecipe(String cold) {
        if (FluidRegistry.isFluidRegistered((String)cold)) {
            hotFluids.remove(cold);
            requiredTU.remove(cold);
            inputAmountHot.remove(cold);
            outputAmountHot.remove(cold);
        }
    }

    public static void removeCoolRecipe(String hot) {
        if (FluidRegistry.isFluidRegistered((String)hot)) {
            coolFluids.remove(hot);
            resultingTU.remove(hot);
            inputAmountCold.remove(hot);
            outputAmountCold.remove(hot);
        }
    }

    public static Object[] getBoilerOutput(Fluid type) {
        if (HeatRecipes.hasBoilRecipe(type)) {
            return new Object[]{HeatRecipes.getBoilFluid(type), HeatRecipes.getOutputAmountHot(type), HeatRecipes.getInputAmountHot(type), (HeatRecipes.getBoilFluid(type).getTemperature() - 273) * 100};
        }
        return null;
    }
}

