/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.google.gson.Gson;
import com.hbm.blocks.ModBlocks;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemAssemblyTemplate;
import com.hbm.items.machine.ItemCircuit;
import com.hbm.items.machine.ItemFluidTank;
import com.hbm.items.special.ItemCell;
import com.hbm.items.tool.ItemFluidCanister;
import com.hbm.items.tool.ItemGasCanister;
import com.hbm.main.MainRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Level;

public class AssemblerRecipes {
    public static File config;
    public static File template;
    private static final Gson gson;
    private static IForgeRegistry<Item> itemRegistry;
    private static IForgeRegistry<Block> blockRegistry;
    public static LinkedHashMap<RecipesCommon.ComparableStack, RecipesCommon.AStack[]> recipes;
    public static HashMap<RecipesCommon.ComparableStack, Integer> time;
    public static List<RecipesCommon.ComparableStack> recipeList;
    public static HashSet<RecipesCommon.ComparableStack> hidden;
    public static LinkedHashMap<RecipesCommon.ComparableStack, RecipesCommon.AStack[]> backupRecipes;
    public static HashMap<RecipesCommon.ComparableStack, Integer> backupTime;
    public static List<RecipesCommon.ComparableStack> backupRecipeList;
    public static HashSet<RecipesCommon.ComparableStack> backupHidden;

    public static void preInit(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        template = dir;
        List<File> files = Arrays.asList(dir.listFiles());
        for (File file : files) {
            if (!file.getName().equals("hbmAssembler.json")) continue;
            config = file;
        }
    }

    public static void loadRecipes() {
        AssemblerRecipes.registerDefaults();
        AssemblerRecipes.loadRecipesFromConfig();
        AssemblerRecipes.generateList();
    }

    public static ItemStack getOutputFromTempate(ItemStack stack) {
        int i;
        if (stack != null && stack.func_77973_b() instanceof ItemAssemblyTemplate && (i = ItemAssemblyTemplate.getRecipeIndex(stack)) >= 0 && i < recipeList.size()) {
            return recipeList.get(i).toStack();
        }
        return null;
    }

    public static List<RecipesCommon.AStack> getRecipeFromTempate(ItemStack stack) {
        ItemStack out;
        int i;
        if (stack != null && stack.func_77973_b() instanceof ItemAssemblyTemplate && (i = ItemAssemblyTemplate.getRecipeIndex(stack)) >= 0 && i < recipeList.size() && (out = recipeList.get(i).toStack()) != null) {
            RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(out);
            RecipesCommon.AStack[] ret = recipes.get(comp);
            return Arrays.asList(ret);
        }
        return null;
    }

    public static void generateList() {
        ArrayList<RecipesCommon.ComparableStack> list = new ArrayList<RecipesCommon.ComparableStack>(recipes.keySet());
        Collections.sort(list);
        recipeList = list;
    }

    /*
     * Opcode count of 17812 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void registerDefaults() {
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.watz_element, 3), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateCast(), 2), new RecipesCommon.OreDictStack(OreDictManager.ZR.ingot(), 2), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.ingot(), 2), new RecipesCommon.OreDictStack(OreDictManager.ANY_HARDPLASTIC.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.PB.pipe(), 2)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.watz_cooler, 3), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateCast(), 2), new RecipesCommon.OreDictStack(OreDictManager.CU.plateCast(), 4), new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 2)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.watz_casing, 3), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_RESISTANTALLOY.plateWelded()), new RecipesCommon.OreDictStack(OreDictManager.B.ingot(), 3), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateWelded(), 2)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.plate_iron, 2), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot(), 3)}, 30);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.plate_gold, 2), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.GOLD.ingot(), 3)}, 30);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.plate_titanium, 2), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.TI.ingot(), 3)}, 30);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.plate_aluminium, 2), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.AL.ingot(), 3)}, 30);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.plate_steel, 2), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 3)}, 30);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.plate_lead, 2), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.ingot(), 3)}, 30);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.plate_copper, 2), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 3)}, 30);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.plate_advanced_alloy, 2), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ALLOY.ingot(), 3)}, 30);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.plate_schrabidium, 2), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.SA326.ingot(), 3)}, 30);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.plate_combine_steel, 2), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.CMB.ingot(), 3)}, 30);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.plate_saturnite, 2), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.BIGMT.ingot(), 3)}, 30);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.plate_mixed, 4), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plateCast(), 1), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 1), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.plate(), 1)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.hazmat_cloth, 4), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.dust(), 4), new RecipesCommon.ComparableStack(Items.field_151007_F, 8)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.asbestos_cloth, 4), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ASBESTOS.ingot(), 2), new RecipesCommon.ComparableStack(Items.field_151007_F, 6), new RecipesCommon.ComparableStack(Blocks.field_150325_L, 1)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.filter_coal, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.COAL.dust(), 4), new RecipesCommon.ComparableStack(Items.field_151007_F, 6), new RecipesCommon.ComparableStack(Items.field_151121_aF, 1)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.centrifuge_element, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 4), new RecipesCommon.ComparableStack(ModItems.motor, 1)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.reactor_core, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.plateCast(), 4), new RecipesCommon.OreDictStack(OreDictManager.BE.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 8), new RecipesCommon.OreDictStack(OreDictManager.FIBER.ingot(), 4)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.rtg_unit, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.thermo_element, 2), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.PB.plate(), 2), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CAPACITOR.ordinal())}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.thermo_unit_empty, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.coil_copper_torus, 3), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 3), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 6), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 12), new RecipesCommon.OreDictStack(OreDictManager.BR.ingot(), 2)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.levitation_unit, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.coil_copper, 4), new RecipesCommon.ComparableStack(ModItems.coil_tungsten, 2), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.SA326.nugget(), 2)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.drill_titanium, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 2), new RecipesCommon.OreDictStack(OreDictManager.DURA.ingot(), 2), new RecipesCommon.OreDictStack(OreDictManager.DURA.bolt(), 4), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 6)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_excavator, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(Blocks.field_150417_aV, 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot(), 8), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ANALOG.ordinal())}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.drillbit_steel), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 4)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.drillbit_steel_diamond), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.drillbit_steel), new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.dust(), 16)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.drillbit_hss), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.DURA.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.TI.ingot(), 8)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.drillbit_hss_diamond), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.drillbit_hss), new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.dust(), 24)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.drillbit_desh), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.NB.ingot(), 4)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.drillbit_desh_diamond), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.drillbit_desh), new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.dust(), 32)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.drillbit_tcalloy), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.TCALLOY.ingot(), 20), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 8)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.drillbit_tcalloy_diamond), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.drillbit_tcalloy), new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.dust(), 48)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.drillbit_ferro), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.FERRO.ingot(), 24), new RecipesCommon.OreDictStack(OreDictManager.CDALLOY.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.ANY_BISMOID.ingot(), 4)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.drillbit_ferro_diamond), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.drillbit_ferro), new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.dust(), 64)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.drillbit_dnt), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_dineutronium, 32), new RecipesCommon.OreDictStack(OreDictManager.GH336.ingot(), 24), new RecipesCommon.ComparableStack(ModItems.ingot_chainsteel, 8)}, 2000);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.telepad, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.SA326.plateCast(), 2), new RecipesCommon.OreDictStack(OreDictManager.CMB.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 2), new RecipesCommon.ComparableStack(ModItems.wire, 6, Mats.MAT_GOLD.id), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.QUANTUM)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.entanglement_kit, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.DURA.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 24), new RecipesCommon.OreDictStack(OreDictManager.GOLD.wireDense(), 16), new RecipesCommon.NbtComparableStack(ItemFluidTank.getFullTank(ModForgeFluids.XENON))}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.dysfunctional_reactor, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 15), new RecipesCommon.OreDictStack(OreDictManager.PB.ingot(), 5), new RecipesCommon.ComparableStack(ModItems.rod_quad_empty, 10), new RecipesCommon.OreDictStack("dyeBrown", 3)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.missile_assembly, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.AL.pipe(), 2), new RecipesCommon.OreDictStack(OreDictManager.AL.shell(), 2), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 8), new RecipesCommon.ComparableStack(ModItems.rocket_fuel, 8), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.BASIC.ordinal())}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.missile_carrier, 1), new RecipesCommon.AStack[]{new RecipesCommon.NbtComparableStack(ItemFluidTank.getFullBarrel(ModForgeFluids.KEROSENE, 16)), new RecipesCommon.ComparableStack(ModItems.thruster_medium, 4), new RecipesCommon.ComparableStack(ModItems.thruster_large, 1), new RecipesCommon.ComparableStack(ModItems.hull_big_titanium, 6), new RecipesCommon.ComparableStack(ModItems.hull_big_steel, 2), new RecipesCommon.ComparableStack(ModItems.hull_small_aluminium, 12), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 24), new RecipesCommon.OreDictStack(OreDictManager.ANY_RUBBER.ingot(), 64), new RecipesCommon.OreDictStack(OreDictManager.ANY_RUBBER.ingot(), 64), new RecipesCommon.ComparableStack(ModBlocks.det_cord, 8), new RecipesCommon.ComparableStack(ModItems.circuit, 12, ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.ComparableStack(ModItems.circuit, 3, ItemCircuit.EnumCircuitType.CHIP_BISMOID)}, 4800);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_generic_small, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 5), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 3), new RecipesCommon.ComparableStack(ModItems.ball_dynamite, 2), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CHIP)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_generic_medium, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 5), new RecipesCommon.OreDictStack(OreDictManager.ANY_HIGHEXPLOSIVE.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.BASIC)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_generic_large, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 15), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.ANY_HIGHEXPLOSIVE.ingot(), 8), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_incendiary_small, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.warhead_generic_small, 1), new RecipesCommon.OreDictStack(OreDictManager.P_RED.dust(), 4)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_incendiary_medium, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.warhead_generic_medium, 1), new RecipesCommon.OreDictStack(OreDictManager.P_RED.dust(), 8)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_incendiary_large, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.warhead_generic_large, 1), new RecipesCommon.OreDictStack(OreDictManager.P_RED.dust(), 16)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_cluster_small, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.warhead_generic_small, 1), new RecipesCommon.ComparableStack(ModItems.pellet_cluster, 4)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_cluster_medium, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.warhead_generic_medium, 1), new RecipesCommon.ComparableStack(ModItems.pellet_cluster, 8)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_cluster_large, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.warhead_generic_large, 1), new RecipesCommon.ComparableStack(ModItems.pellet_cluster, 16)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_buster_small, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.warhead_generic_small, 1), new RecipesCommon.ComparableStack(ModBlocks.det_cord, 8)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_buster_medium, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.warhead_generic_medium, 1), new RecipesCommon.ComparableStack(ModBlocks.det_cord, 4), new RecipesCommon.ComparableStack(ModBlocks.det_charge, 4)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_buster_large, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.warhead_generic_large, 1), new RecipesCommon.ComparableStack(ModBlocks.det_charge, 8)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_nuclear, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.boy_shielding, 1), new RecipesCommon.ComparableStack(ModItems.boy_target, 1), new RecipesCommon.ComparableStack(ModItems.boy_bullet, 1), new RecipesCommon.ComparableStack(ModItems.boy_propellant, 1), new RecipesCommon.OreDictStack(OreDictManager.TI.plateCast(), 12), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CONTROLLER)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_mirv, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.TI.plateCast(), 12), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 12), new RecipesCommon.ComparableStack(ModItems.man_core, 1), new RecipesCommon.ComparableStack(ModItems.ball_tatb, 8), new RecipesCommon.OreDictStack(OreDictManager.LI.ingot(), 8), new RecipesCommon.NbtComparableStack(ItemCell.getFullCell(ModForgeFluids.DEUTERIUM, 8)), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_volcano, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 24), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 16), new RecipesCommon.ComparableStack(ModBlocks.det_nuke, 3), new RecipesCommon.OreDictStack(OreDictManager.U238.block(), 24), new RecipesCommon.ComparableStack(ModItems.circuit, 5, ItemCircuit.EnumCircuitType.CAPACITOR_BOARD.ordinal())}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_n2, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.n2_charge, 5), new RecipesCommon.ComparableStack(ModItems.hull_big_steel, 2), new RecipesCommon.ComparableStack(ModItems.hull_small_steel, 1), new RecipesCommon.ComparableStack(ModItems.wire, 6, Mats.MAT_COPPER.id), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 20), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 12), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CONTROLLER)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_mirvlet, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 3), new RecipesCommon.OreDictStack(OreDictManager.PU239.ingot(), 1), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTICEXPLOSIVE.ingot(), 1)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_thermo_endo, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.therm_endo, 2), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 12), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.warhead_thermo_exo, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.therm_exo, 2), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 12), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.thruster_nuclear, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.DURA.ingot(), 32), new RecipesCommon.OreDictStack(OreDictManager.B.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.PB.plate(), 16), new RecipesCommon.ComparableStack(ModItems.pipes_steel), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED.ordinal())}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.sat_base, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.TI.shell(), 3), new RecipesCommon.ComparableStack(ModItems.thruster_large, 1), new RecipesCommon.ComparableStack(ModItems.low_density_element, 8), new RecipesCommon.ComparableStack(ModItems.plate_desh, 4), new RecipesCommon.NbtComparableStack(ItemFluidTank.getFullBarrel(ModForgeFluids.KEROSENE_REFORM)), new RecipesCommon.ComparableStack(ModItems.photo_panel, 24), new RecipesCommon.ComparableStack(ModItems.circuit, 12, ItemCircuit.EnumCircuitType.BASIC.ordinal()), new RecipesCommon.ComparableStack(ModBlocks.machine_lithium_battery, 1)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.sat_head_mapper, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 3), new RecipesCommon.ComparableStack(ModItems.plate_desh, 4), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.ADVANCED.ordinal()), new RecipesCommon.ComparableStack(ModBlocks.glass_quartz, 8)}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.sat_head_scanner, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 3), new RecipesCommon.OreDictStack(OreDictManager.TI.plateCast(), 8), new RecipesCommon.ComparableStack(ModItems.plate_desh, 4), new RecipesCommon.ComparableStack(ModItems.magnetron, 8), new RecipesCommon.ComparableStack(ModItems.circuit, 8, ItemCircuit.EnumCircuitType.ADVANCED.ordinal())}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.sat_head_radar, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 3), new RecipesCommon.OreDictStack(OreDictManager.TI.plateCast(), 12), new RecipesCommon.ComparableStack(ModItems.magnetron, 12), new RecipesCommon.ComparableStack(ModItems.coil_gold, 16), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.ADVANCED.ordinal())}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.sat_head_laser, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 6), new RecipesCommon.OreDictStack(OreDictManager.CU.plateCast(), 24), new RecipesCommon.OreDictStack(OreDictManager.ANY_HARDPLASTIC.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.circuit, 8, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED.ordinal()), new RecipesCommon.ComparableStack(ModItems.circuit, 16, ItemCircuit.EnumCircuitType.CAPACITOR_BOARD.ordinal()), new RecipesCommon.ComparableStack(ModItems.crystal_diamond, 8), new RecipesCommon.ComparableStack(ModBlocks.glass_quartz, 8)}, 450);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.sat_head_resonator, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateCast(), 6), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 48), new RecipesCommon.ComparableStack(ModItems.crystal_xen, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 16, ItemCircuit.EnumCircuitType.ADVANCED.ordinal())}, 1000);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.sat_foeq, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.TI.shell(), 3), new RecipesCommon.ComparableStack(ModItems.plate_desh, 8), new RecipesCommon.NbtComparableStack(ItemGasCanister.getFullCanister(ModForgeFluids.HYDROGEN)), new RecipesCommon.ComparableStack(ModItems.photo_panel, 16), new RecipesCommon.ComparableStack(ModItems.thruster_nuclear, 1), new RecipesCommon.ComparableStack(ModItems.ingot_uranium_fuel, 6), new RecipesCommon.ComparableStack(ModItems.circuit, 24, ItemCircuit.EnumCircuitType.BASIC.ordinal()), new RecipesCommon.ComparableStack(ModItems.magnetron, 3), new RecipesCommon.ComparableStack(ModBlocks.machine_lithium_battery, 1)}, 1200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.sat_miner, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.BIGMT.plate(), 24), new RecipesCommon.ComparableStack(ModItems.motor_desh, 2), new RecipesCommon.ComparableStack(ModItems.drill_titanium, 2), new RecipesCommon.ComparableStack(ModItems.circuit, 12, ItemCircuit.EnumCircuitType.ADVANCED.ordinal()), new RecipesCommon.NbtComparableStack(ItemFluidCanister.getFullCanister(ModForgeFluids.KEROSENE)), new RecipesCommon.ComparableStack(ModItems.thruster_small, 1), new RecipesCommon.ComparableStack(ModItems.photo_panel, 12), new RecipesCommon.ComparableStack(ModItems.centrifuge_element, 4), new RecipesCommon.ComparableStack(ModBlocks.machine_lithium_battery, 1)}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.chopper_head, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.reinforced_glass, 2), new RecipesCommon.ComparableStack(ModBlocks.fwatz_computer, 1), new RecipesCommon.OreDictStack(OreDictManager.CMB.ingot(), 22), new RecipesCommon.ComparableStack(ModItems.wire, 4, Mats.MAT_MAGTUNG.id)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.chopper_gun, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.CMB.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.CMB.ingot(), 2), new RecipesCommon.ComparableStack(ModItems.wire, 6, Mats.MAT_TUNGSTEN.id), new RecipesCommon.ComparableStack(ModItems.coil_magnetized_tungsten, 1), new RecipesCommon.ComparableStack(ModItems.motor, 1)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.chopper_torso, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.CMB.ingot(), 26), new RecipesCommon.ComparableStack(ModBlocks.fwatz_computer, 1), new RecipesCommon.ComparableStack(ModItems.wire, 4, Mats.MAT_MAGTUNG.id), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.ComparableStack(ModItems.chopper_blades, 2)}, 350);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.chopper_tail, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.CMB.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.CMB.ingot(), 5), new RecipesCommon.ComparableStack(ModItems.wire, 4, Mats.MAT_MAGTUNG.id), new RecipesCommon.ComparableStack(ModItems.motor, 1), new RecipesCommon.ComparableStack(ModItems.chopper_blades, 2)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.chopper_wing, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.CMB.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.CMB.ingot(), 3), new RecipesCommon.ComparableStack(ModItems.wire, 2, Mats.MAT_MAGTUNG.id)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.chopper_blades, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.CMB.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 2), new RecipesCommon.OreDictStack(OreDictManager.CMB.ingot(), 2)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.tritium_deuterium_cake, 1), new RecipesCommon.AStack[]{new RecipesCommon.NbtComparableStack(ItemCell.getFullCell(ModForgeFluids.DEUTERIUM, 6)), new RecipesCommon.NbtComparableStack(ItemCell.getFullCell(ModForgeFluids.TRITIUM, 2)), new RecipesCommon.ComparableStack(ModItems.lithium, 4)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.pellet_cluster, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 4), new RecipesCommon.ComparableStack(Blocks.field_150335_W, 1)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.pellet_buckshot, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.nugget(), 6)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.australium_iii, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.rod_australium, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 2), new RecipesCommon.ComparableStack(ModItems.wire, 6, Mats.MAT_COPPER.id)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.magnetron, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 3), new RecipesCommon.OreDictStack(OreDictManager.W.wire(), 4)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.redcoil_capacitor, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.GOLD.plate(), 3), new RecipesCommon.ComparableStack(ModItems.fuse, 1), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.wire(), 4), new RecipesCommon.ComparableStack(ModItems.coil_advanced_alloy, 6), new RecipesCommon.ComparableStack(Blocks.field_150451_bX, 2)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_lithium, 4), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_RUBBER.ingot(), 1), new RecipesCommon.OreDictStack(OreDictManager.LI.dust(), 1)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_beryllium, 4), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_RUBBER.ingot(), 1), new RecipesCommon.OreDictStack(OreDictManager.BE.dust(), 1)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_carbon, 4), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_RUBBER.ingot(), 1), new RecipesCommon.OreDictStack(OreDictManager.COAL.dust(), 1)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_copper, 4), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_RUBBER.ingot(), 1), new RecipesCommon.OreDictStack(OreDictManager.CU.dust(), 1)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_plutonium, 4), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_RUBBER.ingot(), 1), new RecipesCommon.OreDictStack(OreDictManager.PU.dust(), 1)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.thermo_element, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 1), new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.wire(), 2), new RecipesCommon.OreDictStack(OreDictManager.NETHERQUARTZ.dust(), 2)}, 60);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.plate_dalekanium, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.block_meteor, 1)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.block_meteor, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.fragment_meteorite, 64), new RecipesCommon.ComparableStack(ModItems.fragment_meteorite, 36)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.cmb_brick, 8), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_CONCRETE.any(), 4), new RecipesCommon.OreDictStack(OreDictManager.CMB.plate(), 4)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.cmb_brick_reinforced, 8), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.block_magnetized_tungsten, 4), new RecipesCommon.ComparableStack(ModBlocks.brick_concrete, 4), new RecipesCommon.ComparableStack(ModBlocks.cmb_brick, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 4)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.seal_frame, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 3), new RecipesCommon.OreDictStack(OreDictManager.AL.wire(), 4), new RecipesCommon.OreDictStack(OreDictManager.REDSTONE.dust(), 2), new RecipesCommon.ComparableStack(ModBlocks.steel_roof, 5)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.seal_controller, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 3), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.ingot(), 1), new RecipesCommon.OreDictStack(OreDictManager.REDSTONE.dust(), 4), new RecipesCommon.ComparableStack(ModBlocks.steel_roof, 5)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.vault_door, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 32), new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 32), new RecipesCommon.OreDictStack(OreDictManager.PB.plate(), 16), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plateCast(), 4), new RecipesCommon.OreDictStack(OreDictManager.ANY_RUBBER.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.W.bolt(), 16), new RecipesCommon.OreDictStack(OreDictManager.DURA.bolt(), 16), new RecipesCommon.ComparableStack(ModItems.motor, 3)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.blast_door, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.PB.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plateCast(), 3), new RecipesCommon.OreDictStack(OreDictManager.ANY_RUBBER.ingot(), 3), new RecipesCommon.OreDictStack(OreDictManager.W.bolt(), 4), new RecipesCommon.OreDictStack(OreDictManager.DURA.bolt(), 4), new RecipesCommon.ComparableStack(ModItems.motor, 1)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.sliding_blast_door_2, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 8), new RecipesCommon.ComparableStack(ModItems.circuit, 3, ItemCircuit.EnumCircuitType.BASIC), new RecipesCommon.OreDictStack(OreDictManager.ANY_RUBBER.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.bolt, 16, Mats.MAT_DURA.id), new RecipesCommon.ComparableStack(ModItems.motor, 2)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.sliding_blast_door, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 8), new RecipesCommon.ComparableStack(ModBlocks.reinforced_glass, 4), new RecipesCommon.OreDictStack(OreDictManager.ANY_RUBBER.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.bolt, 16, Mats.MAT_DURA.id), new RecipesCommon.ComparableStack(ModItems.motor, 2)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_centrifuge, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.centrifuge_element, 1), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 2), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 8), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ANALOG.ordinal())}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_gascent, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.centrifuge_element, 4), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 2), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8), new RecipesCommon.ComparableStack(ModItems.coil_tungsten, 4), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED.ordinal())}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_reactor, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.reactor_core, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.PB.plate(), 16), new RecipesCommon.ComparableStack(ModBlocks.reinforced_glass, 4), new RecipesCommon.OreDictStack(OreDictManager.ASBESTOS.ingot(), 4)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_rtg_furnace_off, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(Blocks.field_150460_al, 1), new RecipesCommon.ComparableStack(ModItems.rtg_unit, 3), new RecipesCommon.OreDictStack(OreDictManager.PB.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 2)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_difurnace_rtg_off, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.machine_difurnace_off, 1), new RecipesCommon.ComparableStack(ModItems.rtg_unit, 3), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.PB.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 8), new RecipesCommon.OreDictStack(OreDictManager.CU.plateCast(), 4)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_radgen, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 32), new RecipesCommon.ComparableStack(ModItems.coil_magnetized_tungsten, 6), new RecipesCommon.ComparableStack(ModItems.wire, 24, Mats.MAT_MAGTUNG.id), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.BASIC), new RecipesCommon.ComparableStack(ModItems.reactor_core, 3), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot(), 1), new RecipesCommon.OreDictStack("dyeRed", 1)}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_diesel, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 1), new RecipesCommon.ComparableStack(ModItems.piston_selenium, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateCast(), 1), new RecipesCommon.ComparableStack(ModItems.coil_copper, 4)}, 60);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_selenium, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 8), new RecipesCommon.ComparableStack(ModItems.hull_big_steel, 1), new RecipesCommon.ComparableStack(ModItems.hull_small_steel, 9), new RecipesCommon.ComparableStack(ModItems.pedestal_steel, 1), new RecipesCommon.ComparableStack(ModItems.coil_copper, 4)}, 250);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_reactor_small, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.hull_big_steel, 4), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 4), new RecipesCommon.ComparableStack(ModBlocks.brick_compound, 16), new RecipesCommon.ComparableStack(ModBlocks.deco_pipe_quad, 8), new RecipesCommon.ComparableStack(ModItems.motor, 4), new RecipesCommon.OreDictStack(OreDictManager.B.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.GRAPHITE.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.circuit, 3, ItemCircuit.EnumCircuitType.BASIC)}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_rtg_grey, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.rtg_unit, 3), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 4), new RecipesCommon.ComparableStack(ModItems.wire, 4, Mats.MAT_MINGRADE.id), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 3)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_battery, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.S.dust(), 12), new RecipesCommon.OreDictStack(OreDictManager.PB.dust(), 12), new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.ingot(), 2), new RecipesCommon.ComparableStack(ModItems.wire, 4, Mats.MAT_MINGRADE.id)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_lithium_battery, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.POLYMER.ingot(), 6), new RecipesCommon.OreDictStack(OreDictManager.CO.dust(), 12), new RecipesCommon.OreDictStack(OreDictManager.LI.dust(), 12), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.ingot(), 3), new RecipesCommon.ComparableStack(ModItems.wire, 4, Mats.MAT_MINGRADE.id)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_desh_battery, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.BAKELITE.dust(), 12), new RecipesCommon.OreDictStack(OreDictManager.P_RED.dust(), 12), new RecipesCommon.OreDictStack(OreDictManager.GRAPHITE.ingot(), 6), new RecipesCommon.OreDictStack(OreDictManager.RA226.nugget(), 2)}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_saturnite_battery, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.BIGMT.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.DURA.dust(), 12), new RecipesCommon.OreDictStack(OreDictManager.ZR.dust(), 12), new RecipesCommon.OreDictStack(OreDictManager.PU238.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.TC99.nugget(), 2)}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_schrabidium_battery, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.SA326.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.SA326.dust(), 12), new RecipesCommon.OreDictStack(OreDictManager.NP237.dust(), 12), new RecipesCommon.OreDictStack(OreDictManager.REIIUM.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.ANY_BISMOID.nugget(), 2)}, 800);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_euphemium_battery, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.EUPH.ingot(), 24), new RecipesCommon.OreDictStack(OreDictManager.XE135.dust(), 16), new RecipesCommon.OreDictStack(OreDictManager.SBD.dust(), 16), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.GH336.nugget(), 8)}, 1600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_radspice_battery, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_radspice, 32), new RecipesCommon.ComparableStack(ModItems.powder_chlorophyte, 24), new RecipesCommon.ComparableStack(ModItems.powder_balefire, 24), new RecipesCommon.OreDictStack(OreDictManager.VERTICIUM.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.AS.nugget(), 8)}, 3200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_dineutronium_battery, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.DNT.ingot(), 48), new RecipesCommon.ComparableStack(ModItems.powder_spark_mix, 32), new RecipesCommon.ComparableStack(ModItems.battery_spark_cell_1000, 1), new RecipesCommon.OreDictStack(OreDictManager.CMB.ingot(), 24), new RecipesCommon.ComparableStack(ModItems.coil_magnetized_tungsten, 12)}, 4800);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_electronium_battery, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_electronium, 64), new RecipesCommon.OreDictStack(OreDictManager.OSMIRIDIUM.dust(), 48), new RecipesCommon.ComparableStack(ModItems.battery_spark_cell_10000, 1), new RecipesCommon.OreDictStack(OreDictManager.AU198.ingot(), 32), new RecipesCommon.ComparableStack(ModItems.nugget_u238m2, 16)}, 6400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_shredder, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.ComparableStack(ModBlocks.steel_beam, 2), new RecipesCommon.ComparableStack(Blocks.field_150411_aY, 2)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_strand_caster, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_firebrick, 12), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateCast(), 6), new RecipesCommon.OreDictStack(OreDictManager.CU.plateWelded(), 2), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 2), new RecipesCommon.OreDictStack(OreDictManager.ANY_CONCRETE.any(), 8)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_well, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 20), new RecipesCommon.ComparableStack(ModItems.tank_steel, 2), new RecipesCommon.ComparableStack(ModItems.motor, 1), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 1), new RecipesCommon.ComparableStack(ModItems.drill_titanium, 1)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_pumpjack, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateWelded(), 8), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 4), new RecipesCommon.ComparableStack(ModItems.tank_steel, 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 32), new RecipesCommon.ComparableStack(ModItems.drill_titanium, 1), new RecipesCommon.ComparableStack(ModItems.motor_desh)}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_fracking_tower), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 40), new RecipesCommon.ComparableStack(ModBlocks.concrete_smooth, 64), new RecipesCommon.ComparableStack(ModItems.drill_titanium), new RecipesCommon.ComparableStack(ModItems.motor_desh, 2), new RecipesCommon.ComparableStack(ModItems.plate_desh, 6), new RecipesCommon.ComparableStack(ModItems.circuit, 16, ItemCircuit.EnumCircuitType.CAPACITOR.ordinal()), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 12)}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_catalytic_cracker), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 6), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.NB.ingot(), 2), new RecipesCommon.OreDictStack(OreDictManager.LA.ingot(), 1), new RecipesCommon.ComparableStack(ModItems.catalyst_clay, 12)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_liquefactor), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.CU.plateCast(), 6), new RecipesCommon.OreDictStack(OreDictManager.ANY_TAR.any(), 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 3), new RecipesCommon.ComparableStack(ModItems.circuit, 12, ItemCircuit.EnumCircuitType.CAPACITOR), new RecipesCommon.ComparableStack(ModItems.catalyst_clay, 4), new RecipesCommon.ComparableStack(ModItems.coil_tungsten, 8)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_solidifier), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_CONCRETE.any(), 8), new RecipesCommon.OreDictStack(OreDictManager.AL.plateCast(), 6), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 3), new RecipesCommon.ComparableStack(ModItems.circuit, 12, ItemCircuit.EnumCircuitType.CAPACITOR), new RecipesCommon.ComparableStack(ModItems.catalyst_clay, 4), new RecipesCommon.ComparableStack(ModItems.coil_copper, 4)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_vacuum_distill, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateCast(), 16), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 16), new RecipesCommon.OreDictStack(OreDictManager.ANY_RESISTANTALLOY.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.sphere_steel, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 12), new RecipesCommon.ComparableStack(ModItems.motor_desh, 3), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.CHIP_BISMOID)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_catalytic_reformer, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateCast(), 12), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.NB.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.ANY_RESISTANTALLOY.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 3), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 8), new RecipesCommon.ComparableStack(ModItems.motor, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_hydrotreater, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateWelded(), 8), new RecipesCommon.OreDictStack(OreDictManager.CU.plateCast(), 4), new RecipesCommon.OreDictStack(OreDictManager.NB.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.ANY_RESISTANTALLOY.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 2), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 8), new RecipesCommon.ComparableStack(ModItems.motor_desh, 2), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_flare, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.IRON.pipe(), 3), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 4), new RecipesCommon.ComparableStack(ModItems.tank_steel, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 4), new RecipesCommon.ComparableStack(ModItems.thermo_element, 3)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_coker, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateWelded(), 3), new RecipesCommon.OreDictStack(OreDictManager.IRON.pipe(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.tank_steel, 2), new RecipesCommon.ComparableStack(ModBlocks.steel_grate, 4)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_refinery, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateWelded(), 3), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 6), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 12), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 8), new RecipesCommon.ComparableStack(ModItems.circuit, 3, ItemCircuit.EnumCircuitType.ANALOG.ordinal())}, 350);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_epress, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.ANY_RUBBER.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.BASIC.ordinal())}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_chemplant, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.CU.pipe(), 2), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 16), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.ComparableStack(ModItems.coil_tungsten, 2), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ANALOG.ordinal())}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_chemfac, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.DURA.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.ANY_RESISTANTALLOY.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 12), new RecipesCommon.OreDictStack(OreDictManager.CU.pipe(), 8), new RecipesCommon.ComparableStack(ModItems.motor_desh, 4), new RecipesCommon.ComparableStack(ModItems.coil_tungsten, 16), new RecipesCommon.ComparableStack(ModItems.circuit, 16, ItemCircuit.EnumCircuitType.BASIC)}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_crystallizer, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateWelded(), 2), new RecipesCommon.OreDictStack(OreDictManager.TI.shell(), 3), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.motor, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.BASIC.ordinal()), new RecipesCommon.ComparableStack(ModItems.blades_advanced_alloy, 2)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_fluidtank, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 2), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 4), new RecipesCommon.OreDictStack(OreDictManager.ANY_TAR.any(), 4)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_mining_laser, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.tank_steel, 3), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 16), new RecipesCommon.ComparableStack(ModItems.crystal_redstone, 3), new RecipesCommon.ComparableStack(Items.field_151045_i, 3), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.motor, 3), new RecipesCommon.OreDictStack(OreDictManager.DURA.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.DURA.bolt(), 8), new RecipesCommon.ComparableStack(ModBlocks.machine_battery, 3)}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_turbofan, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.TI.shell(), 8), new RecipesCommon.OreDictStack(OreDictManager.DURA.pipe(), 4), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 12), new RecipesCommon.ComparableStack(ModItems.turbine_tungsten, 1), new RecipesCommon.OreDictStack(OreDictManager.GOLD.wireDense(), 12), new RecipesCommon.ComparableStack(ModItems.circuit, 3, ItemCircuit.EnumCircuitType.BASIC.ordinal())}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_teleporter, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.TI.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plate(), 12), new RecipesCommon.OreDictStack(OreDictManager.GOLD.wire(), 32), new RecipesCommon.ComparableStack(ModItems.entanglement_kit, 1), new RecipesCommon.ComparableStack(ModItems.telepad, 1), new RecipesCommon.ComparableStack(ModBlocks.machine_schrabidium_battery, 1)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_schrabidium_transmutator, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.MAGTUNG.ingot(), 1), new RecipesCommon.OreDictStack(OreDictManager.TI.ingot(), 24), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plate(), 18), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateWelded(), 12), new RecipesCommon.ComparableStack(ModItems.plate_desh, 6), new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 8), new RecipesCommon.ComparableStack(ModBlocks.machine_battery, 5), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.ADVANCED.ordinal())}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.factory_advanced_hull, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ALLOY.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.POLYMER.ingot(), 2), new RecipesCommon.ComparableStack(ModItems.wire, 6, Mats.MAT_ALLOY.id)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.factory_advanced_furnace, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ALLOY.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.POLYMER.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.coil_advanced_alloy, 2)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.factory_advanced_core, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ALLOY.ingot(), 6), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8), new RecipesCommon.ComparableStack(ModItems.coil_advanced_alloy, 2), new RecipesCommon.ComparableStack(ModItems.motor, 16), new RecipesCommon.ComparableStack((Block)Blocks.field_150331_J, 6), new RecipesCommon.OreDictStack(OreDictManager.POLYMER.block(), 4)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.factory_advanced_conductor, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ALLOY.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.POLYMER.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.wire, 4, Mats.MAT_ALLOY.id), new RecipesCommon.ComparableStack(ModItems.fuse, 6), new RecipesCommon.ComparableStack(ModBlocks.red_wire_coated)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.reactor_element, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 2), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 4), new RecipesCommon.OreDictStack(OreDictManager.PB.plate(), 2), new RecipesCommon.ComparableStack(ModItems.rod_empty, 8)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.reactor_control, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.PB.ingot(), 6), new RecipesCommon.ComparableStack(ModItems.bolt, 6, Mats.MAT_TUNGSTEN.id), new RecipesCommon.ComparableStack(ModItems.motor, 1)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.reactor_hatch, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.brick_concrete, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.reactor_conductor, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 12), new RecipesCommon.ComparableStack(ModItems.wire, 4, Mats.MAT_TUNGSTEN.id)}, 130);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.reactor_computer, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.reactor_conductor, 2), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.CONTROLLER), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CRT_TUBE)}, 250);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.fusion_conductor, 3), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ND.ingot()), new RecipesCommon.ComparableStack(ModBlocks.deco_pipe, 1), new RecipesCommon.ComparableStack(ModItems.coil_advanced_alloy, 10)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.fusion_center, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_HARDPLASTIC.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.wire(), 24)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.fusion_motor, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.TI.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 2), new RecipesCommon.ComparableStack(ModItems.motor, 4)}, 250);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.fusion_heater, 4), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.W.plateWelded(), 2), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateWelded(), 2), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 2), new RecipesCommon.ComparableStack(ModItems.magnetron, 2)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.fwatz_hatch, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.fwatz_scaffold, 4), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CHIP_BISMOID), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.CHIP), new RecipesCommon.ComparableStack(ModItems.wire, 16, Mats.MAT_MINGRADE.id), new RecipesCommon.OreDictStack(OreDictManager.CMB.plate(), 16)}, 250);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.fwatz_computer, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.block_meteor, 1), new RecipesCommon.ComparableStack(ModItems.wire, 16, Mats.MAT_MAGTUNG.id), new RecipesCommon.OreDictStack(OreDictManager.SBD.dust(), 4), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.BISMOID)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.fwatz_core, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.block_meteor, 1), new RecipesCommon.ComparableStack(ModItems.wire, 24, Mats.MAT_MAGTUNG.id), new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.dust(), 8), new RecipesCommon.OreDictStack(OreDictManager.MAGTUNG.dust(), 12), new RecipesCommon.OreDictStack(OreDictManager.DESH.heavyComp()), new RecipesCommon.ComparableStack(ModItems.upgrade_screm, 1), new RecipesCommon.ComparableStack(ModItems.upgrade_overdrive_3, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 8, ItemCircuit.EnumCircuitType.QUANTUM)}, 450);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.nuke_gadget, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.sphere_steel, 1), new RecipesCommon.ComparableStack(ModItems.fins_flat, 2), new RecipesCommon.ComparableStack(ModItems.pedestal_steel, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 3, ItemCircuit.EnumCircuitType.CONTROLLER.ordinal()), new RecipesCommon.OreDictStack("dyeGray", 8)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.nuke_boy, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 2), new RecipesCommon.ComparableStack(ModItems.fins_small_steel, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.CONTROLLER.ordinal()), new RecipesCommon.OreDictStack("dyeBlue", 4)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.nuke_man, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.sphere_steel, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 2), new RecipesCommon.ComparableStack(ModItems.fins_big_steel, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 3, ItemCircuit.EnumCircuitType.CONTROLLER.ordinal()), new RecipesCommon.OreDictStack("dyeYellow", 6)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.nuke_mike, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.sphere_steel, 1), new RecipesCommon.OreDictStack(OreDictManager.AL.shell(), 4), new RecipesCommon.ComparableStack(ModItems.circuit, 8, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED.ordinal()), new RecipesCommon.OreDictStack("dyeLightGray", 16)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.nuke_tsar, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.sphere_steel, 1), new RecipesCommon.OreDictStack(OreDictManager.TI.shell(), 6), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 2), new RecipesCommon.ComparableStack(ModItems.fins_tri_steel, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 16, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED.ordinal()), new RecipesCommon.OreDictStack("dyeBlack", 8)}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.nuke_prototype, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.dysfunctional_reactor, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 2), new RecipesCommon.ComparableStack(ModItems.ingot_euphemium, 3), new RecipesCommon.ComparableStack(ModItems.circuit, 8, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED.ordinal())}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.nuke_fleija, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.AL.shell(), 1), new RecipesCommon.ComparableStack(ModItems.fins_quad_titanium, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CONTROLLER.ordinal()), new RecipesCommon.OreDictStack("dyeWhite", 4)}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.nuke_solinium, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 2), new RecipesCommon.ComparableStack(ModItems.fins_quad_titanium, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CONTROLLER.ordinal()), new RecipesCommon.OreDictStack("dyeGray", 8)}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.nuke_n2, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 6), new RecipesCommon.OreDictStack(OreDictManager.MAGTUNG.wire(), 12), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.CONTROLLER.ordinal()), new RecipesCommon.OreDictStack("dyeBlack", 8)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.nuke_fstbmb, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.sphere_steel, 1), new RecipesCommon.ComparableStack(ModItems.hull_big_titanium, 6), new RecipesCommon.ComparableStack(ModItems.fins_big_steel, 1), new RecipesCommon.ComparableStack(ModItems.powder_magic, 8), new RecipesCommon.ComparableStack(ModItems.wire, 12, Mats.MAT_GOLD.id), new RecipesCommon.ComparableStack(ModItems.circuit, 8, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED.ordinal()), new RecipesCommon.OreDictStack("dyeGray", 6)}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.nuke_custom, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 2), new RecipesCommon.ComparableStack(ModItems.fins_small_steel, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 8, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED.ordinal()), new RecipesCommon.OreDictStack("dyeGray", 4)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.float_bomb, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 12), new RecipesCommon.ComparableStack(ModItems.levitation_unit, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.ComparableStack(ModItems.wire, 6, Mats.MAT_GOLD.id)}, 250);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.therm_endo, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 12), new RecipesCommon.ComparableStack(ModItems.thermo_unit_endo, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.ComparableStack(ModItems.wire, 6, Mats.MAT_GOLD.id)}, 250);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.therm_exo, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 12), new RecipesCommon.ComparableStack(ModItems.thermo_unit_exo, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.ComparableStack(ModItems.wire, 6, Mats.MAT_GOLD.id)}, 250);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.launch_pad, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateWelded(), 8), new RecipesCommon.OreDictStack(OreDictManager.ANY_CONCRETE.any(), 8), new RecipesCommon.OreDictStack(OreDictManager.ANY_HARDPLASTIC.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.ADVANCED.ordinal())}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.spawn_chopper, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.chopper_blades, 5), new RecipesCommon.ComparableStack(ModItems.chopper_gun, 1), new RecipesCommon.ComparableStack(ModItems.chopper_head, 1), new RecipesCommon.ComparableStack(ModItems.chopper_tail, 1), new RecipesCommon.ComparableStack(ModItems.chopper_torso, 1), new RecipesCommon.ComparableStack(ModItems.chopper_wing, 2)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.turret_light, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 6), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 2), new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.ingot(), 2), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.BASIC)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.turret_heavy, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.AL.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 2), new RecipesCommon.ComparableStack(ModItems.hull_small_steel, 1), new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.ComparableStack(ModItems.circuit, 3, ItemCircuit.EnumCircuitType.BASIC)}, 250);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.turret_rocket, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.TI.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.hull_small_steel, 8), new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.ingot(), 6), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.ANALOG)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.turret_flamer, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 2), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 1), new RecipesCommon.ComparableStack(ModItems.tank_steel, 2), new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.ANALOG)}, 250);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.turret_tau, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.TI.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plate(), 4), new RecipesCommon.ComparableStack(ModItems.redcoil_capacitor, 3), new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.ingot(), 12), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.ADVANCED)}, 350);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.turret_spitfire, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 6), new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.ingot(), 6), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 16), new RecipesCommon.OreDictStack(OreDictManager.IRON.plate(), 8), new RecipesCommon.ComparableStack(ModItems.hull_small_steel, 4), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 2), new RecipesCommon.ComparableStack(ModItems.motor, 3), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.BASIC)}, 350);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.turret_cwis, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 6), new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 10), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 4), new RecipesCommon.ComparableStack(ModItems.hull_small_aluminium, 2), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 6), new RecipesCommon.ComparableStack(ModItems.motor, 4), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.ComparableStack(ModItems.magnetron, 3)}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.turret_cheapo, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.IRON.plate(), 4), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 3), new RecipesCommon.ComparableStack(ModItems.motor, 3), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.CHIP)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.gun_defabricator, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 2), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.IRON.plateWelded(), 5), new RecipesCommon.ComparableStack(ModItems.mechanism_special, 3), new RecipesCommon.ComparableStack(ModItems.laser_crystal_dem, 1), new RecipesCommon.ComparableStack(ModItems.plate_dalekanium, 3)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.gun_osipr_ammo, 24), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 2), new RecipesCommon.ComparableStack(Items.field_151137_ax, 1), new RecipesCommon.ComparableStack(Items.field_151114_aO, 1)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.gun_osipr_ammo2, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.CMB.plate(), 4), new RecipesCommon.ComparableStack(Items.field_151137_ax, 7), new RecipesCommon.ComparableStack(ModItems.powder_power, 3)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_revolver_iron), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_revolver_iron_ammo, 24)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_revolver), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_revolver_ammo, 12)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_revolver_gold), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_revolver_gold_ammo, 12)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_revolver_lead), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_revolver_lead_ammo, 12)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_revolver_schrabidium), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_revolver_schrabidium_ammo, 12)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_revolver_cursed), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_revolver_cursed_ammo, 17)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_revolver_nightmare), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_revolver_nightmare_ammo, 6)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_revolver_nightmare2), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_revolver_nightmare2_ammo, 6)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_revolver_pip), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.ammo_44_pip, 6)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_revolver_nopip), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.ammo_44, 12)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_rpg), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.ammo_rocket, 6)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_stinger), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_stinger_ammo, 6)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_fatman), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.ammo_nuke, 6)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_mirv), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.ammo_mirv, 3)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_bf), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_bf_ammo, 2)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_mp40), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.ammo_9mm, 32)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_uzi), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.ammo_22lr, 32)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_uboinik), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.ammo_12gauge, 24)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_lever_action), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.ammo_20gauge, 24)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_bolt_action), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.ammo_20gauge_slug, 24)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_osipr), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_osipr_ammo, 30)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_immolator), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_immolator_ammo, 64)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_cryolator), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_cryolator_ammo, 64)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_mp), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.ammo_566_gold, 40)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_xvl1456), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_xvl1456_ammo, 64)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_emp), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_emp_ammo, 6)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_jack), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_jack_ammo, 12)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_spark), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_spark_ammo, 4)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_hp), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_hp_ammo, 12)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_euthanasia), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_euthanasia_ammo, 16)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.clip_defabricator), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_polymer), new RecipesCommon.ComparableStack(ModItems.gun_defabricator_ammo, 16)}, 40);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.grenade_fire, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.grenade_frag, 1), new RecipesCommon.OreDictStack(OreDictManager.P_RED.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 2)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.grenade_fire, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.grenade_frag, 1), new RecipesCommon.OreDictStack(OreDictManager.P_RED.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 2)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.grenade_shrapnel, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.grenade_frag, 1), new RecipesCommon.ComparableStack(ModItems.pellet_buckshot, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 2)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.grenade_cluster, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.grenade_frag, 1), new RecipesCommon.ComparableStack(ModItems.pellet_cluster, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 2)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.grenade_flare, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.grenade_generic, 1), new RecipesCommon.ComparableStack(Items.field_151114_aO, 1), new RecipesCommon.OreDictStack(OreDictManager.AL.plate(), 2), new RecipesCommon.OreDictStack(OreDictManager.CS.plate(), 1)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.grenade_electric, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.grenade_generic, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 3, ItemCircuit.EnumCircuitType.CAPACITOR.ordinal()), new RecipesCommon.OreDictStack(OreDictManager.GOLD.plate(), 2)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.grenade_pulse, 4), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 1), new RecipesCommon.OreDictStack(OreDictManager.IRON.plate(), 3), new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.wire(), 6), new RecipesCommon.ComparableStack(Items.field_151045_i, 1)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.grenade_plasma, 2), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 3), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plate(), 1), new RecipesCommon.ComparableStack(ModItems.coil_advanced_torus, 1), new RecipesCommon.NbtComparableStack(ItemCell.getFullCell(ModForgeFluids.DEUTERIUM, 1)), new RecipesCommon.NbtComparableStack(ItemCell.getFullCell(ModForgeFluids.TRITIUM, 1))}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.grenade_tau, 2), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.plate(), 3), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plate(), 1), new RecipesCommon.ComparableStack(ModItems.coil_advanced_torus, 1), new RecipesCommon.ComparableStack(ModItems.gun_xvl1456_ammo, 1)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.grenade_schrabidium, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.grenade_flare, 1), new RecipesCommon.OreDictStack(OreDictManager.SA326.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 2)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.grenade_nuclear, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.IRON.plate(), 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 1), new RecipesCommon.OreDictStack(OreDictManager.PU239.nugget(), 2), new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.wire(), 2)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.grenade_zomg, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_paa, 3), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 1), new RecipesCommon.ComparableStack(ModItems.coil_magnetized_tungsten, 3), new RecipesCommon.ComparableStack(ModItems.powder_power, 3), new RecipesCommon.ComparableStack(ModItems.nugget_radspice, 1)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.grenade_black_hole, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 6), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 3), new RecipesCommon.ComparableStack(ModItems.coil_magnetized_tungsten, 2), new RecipesCommon.ComparableStack(ModItems.black_hole, 1)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.multitool_dig, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.rod_reiium, 1), new RecipesCommon.ComparableStack(ModItems.rod_weidanium, 1), new RecipesCommon.ComparableStack(ModItems.rod_australium, 1), new RecipesCommon.ComparableStack(ModItems.rod_verticium, 1), new RecipesCommon.ComparableStack(ModItems.rod_unobtainium, 1), new RecipesCommon.ComparableStack(ModItems.rod_daffergon, 1), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.ComparableStack(ModItems.ducttape, 1)}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.gadget_explosive, 4), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.AL.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.GOLD.wire(), 8), new RecipesCommon.ComparableStack(ModBlocks.det_cord, 4), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 1), new RecipesCommon.OreDictStack(OreDictManager.ANY_HIGHEXPLOSIVE.ingot(), 10), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 2)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.gadget_wireing, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.IRON.plate(), 1), new RecipesCommon.OreDictStack(OreDictManager.GOLD.wire(), 12)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.gadget_core, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PU239.nugget(), 7), new RecipesCommon.OreDictStack(OreDictManager.U238.nugget(), 3)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.boy_shielding, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 12), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 4)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.boy_target, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.U235.nugget(), 7)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.boy_bullet, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.U235.nugget(), 3)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.boy_propellant, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.cordite, 8), new RecipesCommon.OreDictStack(OreDictManager.IRON.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.AL.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.wire(), 4)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.boy_igniter, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_HIGHEXPLOSIVE.ingot(), 1), new RecipesCommon.OreDictStack(OreDictManager.AL.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 1), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED.ordinal()), new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.wire(), 3)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.man_explosive, 4), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.AL.plate(), 4), new RecipesCommon.ComparableStack(ModItems.wire, 8, Mats.MAT_MINGRADE.id), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTICEXPLOSIVE.ingot(), 2), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 1), new RecipesCommon.OreDictStack(OreDictManager.ANY_HIGHEXPLOSIVE.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 1)}, 250);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.man_igniter, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED.ordinal()), new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.wire(), 9)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.man_core, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PU239.nugget(), 8), new RecipesCommon.OreDictStack(OreDictManager.BE.nugget(), 2)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mike_core, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.U238.nugget(), 24), new RecipesCommon.OreDictStack(OreDictManager.PB.ingot(), 6)}, 250);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mike_deut, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.IRON.plate(), 12), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 16), new RecipesCommon.NbtComparableStack(ItemCell.getFullCell(ModForgeFluids.DEUTERIUM, 10))}, 250);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mike_cooling_unit, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.IRON.plate(), 8), new RecipesCommon.ComparableStack(ModItems.coil_copper, 5), new RecipesCommon.ComparableStack(ModItems.coil_tungsten, 5), new RecipesCommon.ComparableStack(ModItems.motor, 2)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.fleija_igniter, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.SA326.wire(), 2), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED.ordinal())}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.fleija_core, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.U235.nugget(), 8), new RecipesCommon.OreDictStack(OreDictManager.NP237.nugget(), 2), new RecipesCommon.OreDictStack(OreDictManager.BE.nugget(), 4), new RecipesCommon.ComparableStack(ModItems.coil_copper, 2)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.fleija_propellant, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_HIGHEXPLOSIVE.ingot(), 3), new RecipesCommon.OreDictStack(OreDictManager.SA326.plate(), 8), new RecipesCommon.ComparableStack(ModItems.ingot_tennessine, 3)}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.solinium_igniter, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.wire(), 2), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED.ordinal()), new RecipesCommon.ComparableStack(ModItems.coil_gold, 1)}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.solinium_core, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.SA327.ingot(), 3), new RecipesCommon.OreDictStack(OreDictManager.EUPH.nugget(), 4), new RecipesCommon.ComparableStack(ModItems.ingot_tennessine, 2)}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.solinium_propellant, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_HIGHEXPLOSIVE.ingot(), 3), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 2), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 6), new RecipesCommon.OreDictStack(OreDictManager.W.wire(), 6), new RecipesCommon.ComparableStack(ModItems.biomass_compressed, 4)}, 350);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.schrabidium_hammer, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.SA326.block(), 35), new RecipesCommon.ComparableStack(ModItems.billet_yharonite, 64), new RecipesCommon.ComparableStack(ModItems.billet_yharonite, 64), new RecipesCommon.ComparableStack(ModItems.coin_ufo, 1), new RecipesCommon.ComparableStack(ModItems.fragment_meteorite, 64), new RecipesCommon.ComparableStack(ModItems.fragment_meteorite, 64), new RecipesCommon.ComparableStack(ModItems.fragment_meteorite, 64), new RecipesCommon.ComparableStack(ModItems.fragment_meteorite, 64), new RecipesCommon.ComparableStack(ModItems.fragment_meteorite, 64), new RecipesCommon.ComparableStack(ModItems.fragment_meteorite, 64), new RecipesCommon.ComparableStack(ModItems.fragment_meteorite, 64), new RecipesCommon.ComparableStack(ModItems.fragment_meteorite, 64)}, 1000);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.component_limiter, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.hull_big_steel, 2), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 32), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 18), new RecipesCommon.ComparableStack(ModItems.plate_desh, 12), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 4), new RecipesCommon.ComparableStack(ModItems.circuit, 8, ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot(), 14), new RecipesCommon.ComparableStack(ModItems.plate_dalekanium, 5), new RecipesCommon.ComparableStack(ModItems.powder_magic, 16), new RecipesCommon.ComparableStack(ModBlocks.fwatz_computer, 3)}, 2500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.component_emitter, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.hull_big_steel, 3), new RecipesCommon.ComparableStack(ModItems.hull_big_titanium, 2), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 32), new RecipesCommon.OreDictStack(OreDictManager.PB.plate(), 24), new RecipesCommon.ComparableStack(ModItems.plate_desh, 24), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 8), new RecipesCommon.ComparableStack(ModItems.circuit, 12, ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot(), 26), new RecipesCommon.ComparableStack(ModItems.powder_magic, 48), new RecipesCommon.ComparableStack(ModBlocks.fwatz_computer, 2), new RecipesCommon.ComparableStack(ModItems.crystal_xen, 1)}, 2500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.ams_limiter, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.component_limiter, 5), new RecipesCommon.OreDictStack(OreDictManager.AL.heavyComp(), 1), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.heavyComp(), 1), new RecipesCommon.ComparableStack(ModItems.plate_dineutronium, 16), new RecipesCommon.ComparableStack(ModItems.circuit, 6, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 16), new RecipesCommon.ComparableStack(ModItems.motor, 12), new RecipesCommon.ComparableStack(ModItems.coil_advanced_torus, 12), new RecipesCommon.ComparableStack(ModItems.entanglement_kit, 1)}, 6000);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.ams_emitter, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.component_emitter, 16), new RecipesCommon.OreDictStack(OreDictManager.W.heavyComp(), 1), new RecipesCommon.OreDictStack(OreDictManager.TI.heavyComp(), 2), new RecipesCommon.ComparableStack(ModItems.plate_dineutronium, 32), new RecipesCommon.ComparableStack(ModItems.circuit, 12, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED), new RecipesCommon.ComparableStack(ModItems.coil_advanced_torus, 24), new RecipesCommon.ComparableStack(ModItems.entanglement_kit, 3), new RecipesCommon.ComparableStack(ModItems.crystal_horn, 1), new RecipesCommon.ComparableStack(ModBlocks.fwatz_core, 1)}, 6000);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_radar, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.ANY_RUBBER.ingot(), 8), new RecipesCommon.ComparableStack(ModItems.magnetron, 3), new RecipesCommon.ComparableStack(ModItems.motor, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 8, ItemCircuit.EnumCircuitType.BASIC.ordinal()), new RecipesCommon.ComparableStack(ModItems.coil_copper, 12), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.CRT_TUBE)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_forcefield, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plate(), 8), new RecipesCommon.ComparableStack(ModItems.plate_desh, 4), new RecipesCommon.ComparableStack(ModItems.coil_gold_torus, 6), new RecipesCommon.ComparableStack(ModItems.coil_magnetized_tungsten, 12), new RecipesCommon.ComparableStack(ModItems.motor, 1), new RecipesCommon.ComparableStack(ModItems.upgrade_radius, 1), new RecipesCommon.ComparableStack(ModItems.upgrade_health, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.ComparableStack(ModBlocks.machine_transformer, 1)}, 1000);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_10_kerosene, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 1), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 1), new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 4)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_10_solid, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 1), new RecipesCommon.ComparableStack(ModItems.coil_tungsten, 1), new RecipesCommon.OreDictStack(OreDictManager.DURA.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 4)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_10_xenon, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 4), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 2), new RecipesCommon.ComparableStack(ModItems.arc_electrode, 4)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_15_kerosene, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 4), new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 4)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_15_kerosene_dual, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 2), new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 1)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_15_kerosene_triple, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 3), new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 6), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 2)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_15_solid, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.DURA.ingot(), 6), new RecipesCommon.ComparableStack(ModItems.coil_tungsten, 3)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_15_solid_hexdecuple, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.DURA.ingot(), 12), new RecipesCommon.ComparableStack(ModItems.coil_tungsten, 6)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_15_hydrogen, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 4), new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6), new RecipesCommon.ComparableStack(ModItems.tank_steel, 1), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 4)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_15_hydrogen_dual, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 2), new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6), new RecipesCommon.ComparableStack(ModItems.tank_steel, 1), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 1)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_15_balefire_short, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 8), new RecipesCommon.ComparableStack(ModBlocks.reactor_element, 1), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.plate(), 12), new RecipesCommon.OreDictStack(OreDictManager.CU.plateWelded(), 2), new RecipesCommon.ComparableStack(ModItems.ingot_uranium_fuel, 4), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 2)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_15_balefire, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 16), new RecipesCommon.ComparableStack(ModBlocks.reactor_element, 2), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.plate(), 24), new RecipesCommon.OreDictStack(OreDictManager.CU.plateWelded(), 4), new RecipesCommon.ComparableStack(ModItems.ingot_uranium_fuel, 8), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 2)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_15_balefire_large, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 16), new RecipesCommon.ComparableStack(ModBlocks.reactor_element, 2), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 24), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.plate(), 32), new RecipesCommon.OreDictStack(OreDictManager.CU.plateWelded(), 4), new RecipesCommon.ComparableStack(ModItems.ingot_uranium_fuel, 8), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 2)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_20_kerosene, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_20, 1), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 8), new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 12), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 8)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_20_kerosene_dual, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_20, 1), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 4), new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 4)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_20_kerosene_triple, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_20, 1), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 6), new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 6)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_20_solid, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_20, 1), new RecipesCommon.ComparableStack(ModItems.coil_tungsten, 8), new RecipesCommon.OreDictStack(OreDictManager.DURA.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 12)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_20_solid_multi, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_20, 1), new RecipesCommon.ComparableStack(ModItems.coil_tungsten, 12), new RecipesCommon.OreDictStack(OreDictManager.DURA.ingot(), 18), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 12)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_thruster_20_solid_multier, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_20, 1), new RecipesCommon.ComparableStack(ModItems.coil_tungsten, 16), new RecipesCommon.OreDictStack(OreDictManager.DURA.ingot(), 20), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 12)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_fuselage_10_kerosene, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 2), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 3), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 12), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 3)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_fuselage_10_solid, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 2), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 3), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 12), new RecipesCommon.OreDictStack(OreDictManager.AL.plate(), 3)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_fuselage_10_xenon, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 2), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 3), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 12), new RecipesCommon.OreDictStack(OreDictManager.CU.plateWelded(), 3)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_fuselage_10_long_kerosene, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 2), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 6), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 24), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_fuselage_10_long_solid, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 2), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 6), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 24), new RecipesCommon.OreDictStack(OreDictManager.AL.plate(), 6)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_fuselage_10_15_kerosene, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 1), new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 9), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 36), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 9)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_fuselage_10_15_solid, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 1), new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 9), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 36), new RecipesCommon.OreDictStack(OreDictManager.AL.plate(), 9)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_fuselage_10_15_hydrogen, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 1), new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 9), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 36), new RecipesCommon.OreDictStack(OreDictManager.IRON.plate(), 9)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_fuselage_10_15_balefire, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 1), new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 9), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 36), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.plate(), 9)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_fuselage_15_kerosene, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 2), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 12), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 48), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 12)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_fuselage_15_solid, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 2), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 12), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 48), new RecipesCommon.OreDictStack(OreDictManager.AL.plate(), 12)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_fuselage_15_hydrogen, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 2), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 12), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 48), new RecipesCommon.OreDictStack(OreDictManager.IRON.plate(), 12)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_fuselage_15_balefire, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 2), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 12), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 48), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.plate(), 12)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_fuselage_15_20_kerosene, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.ComparableStack(ModItems.seg_20, 1), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 16), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 64), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 16)}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_fuselage_15_20_solid, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.ComparableStack(ModItems.seg_20, 1), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 16), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 64), new RecipesCommon.OreDictStack(OreDictManager.AL.plate(), 16)}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_warhead_10_he, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.ANY_HIGHEXPLOSIVE.ingot(), 3), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.BASIC)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_warhead_10_incendiary, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 1), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.P_RED.dust(), 3), new RecipesCommon.OreDictStack(OreDictManager.ANY_HIGHEXPLOSIVE.ingot(), 2), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.BASIC)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_warhead_10_buster, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 1), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 4), new RecipesCommon.ComparableStack(ModBlocks.det_charge, 1), new RecipesCommon.ComparableStack(ModBlocks.det_cord, 4), new RecipesCommon.OreDictStack(OreDictManager.CU.plateCast(), 4), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.BASIC)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_warhead_10_nuclear, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.PU239.ingot(), 1), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 2), new RecipesCommon.OreDictStack(OreDictManager.ANY_HIGHEXPLOSIVE.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.CONTROLLER)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_warhead_10_nuclear_large, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.AL.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.PU239.ingot(), 2), new RecipesCommon.ComparableStack(ModBlocks.det_charge, 4), new RecipesCommon.ComparableStack(ModItems.circuit, 3, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED)}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_warhead_10_taint, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 12), new RecipesCommon.ComparableStack(ModBlocks.det_cord, 2), new RecipesCommon.ComparableStack(ModItems.powder_magic, 12), new RecipesCommon.ComparableStack(ModItems.ingot_mud, 1)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_warhead_10_cloud, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_10, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 12), new RecipesCommon.ComparableStack(ModBlocks.det_cord, 2), new RecipesCommon.ComparableStack(ModItems.grenade_pink_cloud, 2)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_warhead_15_he, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 16), new RecipesCommon.ComparableStack(ModBlocks.det_charge, 4), new RecipesCommon.ComparableStack(ModItems.circuit, 3, ItemCircuit.EnumCircuitType.BASIC)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_warhead_15_incendiary, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 16), new RecipesCommon.ComparableStack(ModBlocks.det_charge, 2), new RecipesCommon.OreDictStack(OreDictManager.P_RED.dust(), 8), new RecipesCommon.ComparableStack(ModItems.circuit, 3, ItemCircuit.EnumCircuitType.BASIC)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_warhead_15_nuclear, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 24), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 12), new RecipesCommon.OreDictStack(OreDictManager.PU239.ingot(), 3), new RecipesCommon.ComparableStack(ModBlocks.det_charge, 6), new RecipesCommon.ComparableStack(ModItems.circuit, 5, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_warhead_15_thermo, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 32), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 16), new RecipesCommon.ComparableStack(ModBlocks.det_nuke, 2), new RecipesCommon.ComparableStack(ModItems.mike_deut, 1), new RecipesCommon.ComparableStack(ModItems.mike_core, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 8, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED)}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_warhead_15_volcano, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 32), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 16), new RecipesCommon.ComparableStack(ModBlocks.det_nuke, 4), new RecipesCommon.OreDictStack(OreDictManager.U238.block(), 32), new RecipesCommon.ComparableStack(ModItems.circuit, 6, ItemCircuit.EnumCircuitType.CAPACITOR_TANTALIUM), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED)}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_warhead_15_mirv, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 24), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 16), new RecipesCommon.ComparableStack(ModItems.warhead_mirvlet, 7), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTICEXPLOSIVE.ingot(), 2), new RecipesCommon.ComparableStack(ModItems.hull_small_steel, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED)}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_warhead_15_n2, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 20), new RecipesCommon.ComparableStack(ModBlocks.det_charge, 24), new RecipesCommon.ComparableStack(Blocks.field_150451_bX, 12), new RecipesCommon.OreDictStack(OreDictManager.MAGTUNG.dust(), 6), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.CONTROLLER)}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.missile_soyuz0, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.TI.shell(), 32), new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 64), new RecipesCommon.ComparableStack(ModItems.rocket_fuel, 64), new RecipesCommon.ComparableStack(ModItems.thruster_small, 12), new RecipesCommon.ComparableStack(ModItems.thruster_medium, 12), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.CONTROLLER.ordinal()), new RecipesCommon.ComparableStack(ModItems.low_density_element, 32)}, 1200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.missile_soyuz_lander, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.rocket_fuel, 10), new RecipesCommon.ComparableStack(ModItems.thruster_small, 3), new RecipesCommon.ComparableStack(ModItems.tank_steel, 2), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.BASIC), new RecipesCommon.OreDictStack(OreDictManager.ANY_RUBBER.ingot(), 32), new RecipesCommon.ComparableStack(ModItems.hull_big_aluminium, 2), new RecipesCommon.ComparableStack(ModItems.sphere_steel, 1), new RecipesCommon.ComparableStack(ModItems.low_density_element, 12)}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.upgrade_overdrive_1, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.upgrade_speed_3, 1), new RecipesCommon.ComparableStack(ModItems.upgrade_effect_3, 1), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.ANY_HARDPLASTIC.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.circuit, 16, ItemCircuit.EnumCircuitType.ADVANCED.ordinal())}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.upgrade_overdrive_2, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.upgrade_overdrive_1, 1), new RecipesCommon.ComparableStack(ModItems.upgrade_speed_3, 1), new RecipesCommon.ComparableStack(ModItems.upgrade_effect_3, 1), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.circuit, 16, ItemCircuit.EnumCircuitType.CAPACITOR_BOARD.ordinal())}, 300);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.upgrade_overdrive_3, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.upgrade_overdrive_2, 1), new RecipesCommon.ComparableStack(ModItems.upgrade_speed_3, 1), new RecipesCommon.ComparableStack(ModItems.upgrade_effect_3, 1), new RecipesCommon.OreDictStack(OreDictManager.ANY_BISMOID.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.circuit, 16, ItemCircuit.EnumCircuitType.BISMOID.ordinal())}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.fusion_shield_tungsten, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.W.block(), 32), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 64), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 32)}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.fusion_shield_desh, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.DESH.block(), 16), new RecipesCommon.OreDictStack(OreDictManager.CO.block(), 16), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.plate(), 64), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.plate(), 32)}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.fusion_shield_chlorophyte, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.W.block(), 16), new RecipesCommon.ComparableStack(ModBlocks.block_dura_steel, 16), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 48), new RecipesCommon.ComparableStack(ModItems.powder_chlorophyte, 48)}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.fusion_shield_vaporwave, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.DNT.block(), 16), new RecipesCommon.ComparableStack(ModBlocks.block_euphemium_cluster, 16), new RecipesCommon.OreDictStack(OreDictManager.SBD.dust(), 64), new RecipesCommon.ComparableStack(ModItems.powder_spark_mix, 48), new RecipesCommon.ComparableStack(ModItems.powder_daffergon, 48)}, 4800);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_fensu, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_electronium, 32), new RecipesCommon.ComparableStack(ModBlocks.machine_dineutronium_battery, 16), new RecipesCommon.OreDictStack(OreDictManager.ANY_RESISTANTALLOY.heavyComp(), 16), new RecipesCommon.OreDictStack(OreDictManager.STAR.block(), 64), new RecipesCommon.ComparableStack(ModBlocks.machine_transformer_dnt, 8), new RecipesCommon.ComparableStack(ModItems.coil_magnetized_tungsten, 24), new RecipesCommon.ComparableStack(ModItems.powder_magic, 64), new RecipesCommon.ComparableStack(ModItems.plate_dineutronium, 24), new RecipesCommon.ComparableStack(ModItems.ingot_u238m2), new RecipesCommon.OreDictStack(OreDictManager.FIBER.ingot(), 64), new RecipesCommon.ComparableStack(ModItems.ingot_radspice, 64)}, 1200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.struct_iter_core, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_RESISTANTALLOY.plateWelded(), 6), new RecipesCommon.OreDictStack(OreDictManager.W.plateWelded(), 6), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 12), new RecipesCommon.ComparableStack(ModItems.coil_advanced_alloy, 12), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 8), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED.ordinal())}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_large_turbine, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.generator_steel, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 12), new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.turbine_titanium, 3), new RecipesCommon.OreDictStack(OreDictManager.GOLD.wireDense(), 6), new RecipesCommon.OreDictStack(OreDictManager.DURA.pipe(), 3), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 4), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.BASIC.ordinal())}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.pellet_chlorophyte, 2), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_chlorophyte, 1), new RecipesCommon.OreDictStack(OreDictManager.PB.nugget(), 12)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.pellet_mercury, 2), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.nugget_mercury, 1), new RecipesCommon.OreDictStack(OreDictManager.PB.nugget(), 12)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.pellet_meteorite, 2), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_meteorite, 1), new RecipesCommon.OreDictStack(OreDictManager.PB.nugget(), 12)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.pellet_canister, 2), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot(), 3)}, 50);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.mp_warhead_15_balefire, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.seg_15, 1), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 16), new RecipesCommon.ComparableStack(ModItems.powder_magic, 6), new RecipesCommon.ComparableStack(ModItems.egg_balefire_shard, 4), new RecipesCommon.OreDictStack(OreDictManager.ANY_HIGHEXPLOSIVE.ingot(), 8), new RecipesCommon.ComparableStack(ModItems.circuit, 8, ItemCircuit.EnumCircuitType.ADVANCED)}, 60);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_cyclotron, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.machine_desh_battery, 3), new RecipesCommon.OreDictStack(OreDictManager.ND.wireDense(), 32), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 32), new RecipesCommon.OreDictStack(OreDictManager.AL.plate(), 32), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 24), new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 24), new RecipesCommon.OreDictStack(OreDictManager.CU.plateCast(), 8), new RecipesCommon.ComparableStack(ModItems.circuit, 16, ItemCircuit.EnumCircuitType.BASIC.ordinal())}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.uu_gigafactory, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.machine_orbus, 1), new RecipesCommon.ComparableStack(ModBlocks.machine_saturnite_battery, 2), new RecipesCommon.ComparableStack(ModBlocks.hadron_analysis, 16), new RecipesCommon.ComparableStack(ModItems.laser_crystal_cmb, 1), new RecipesCommon.ComparableStack(ModItems.powder_nitan_mix, 8), new RecipesCommon.OreDictStack(OreDictManager.AL.heavyComp(), 1), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CONTROLLER_QUANTUM)}, 900);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.gun_zomg, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.crystal_xen, 2), new RecipesCommon.ComparableStack(ModItems.singularity_counter_resonant, 1), new RecipesCommon.ComparableStack(ModItems.mechanism_special, 3), new RecipesCommon.ComparableStack(ModItems.plate_paa, 12), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 8), new RecipesCommon.ComparableStack(ModItems.coil_magnetized_tungsten, 5), new RecipesCommon.ComparableStack(ModItems.powder_magic, 4), new RecipesCommon.OreDictStack(OreDictManager.ASBESTOS.ingot(), 8)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_industrial_generator, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.machine_coal_off, 2), new RecipesCommon.ComparableStack(ModBlocks.machine_boiler_off, 2), new RecipesCommon.ComparableStack(ModBlocks.machine_large_turbine, 1), new RecipesCommon.ComparableStack(ModBlocks.machine_transformer, 1), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 20), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.PB.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.AL.plate(), 12), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 1)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.euphemium_capacitor, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.NB.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.redcoil_capacitor, 1), new RecipesCommon.ComparableStack(ModItems.ingot_euphemium, 4), new RecipesCommon.ComparableStack(ModItems.circuit, 8, ItemCircuit.EnumCircuitType.CAPACITOR_BOARD), new RecipesCommon.ComparableStack(ModItems.powder_nitan_mix, 18)}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.block_cap_nuka, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.cap_nuka, 64), new RecipesCommon.ComparableStack(ModItems.cap_nuka, 64)}, 10);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.block_cap_quantum, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.cap_quantum, 64), new RecipesCommon.ComparableStack(ModItems.cap_quantum, 64)}, 10);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.block_cap_sparkle, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.cap_sparkle, 64), new RecipesCommon.ComparableStack(ModItems.cap_sparkle, 64)}, 10);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.block_cap_rad, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.cap_rad, 64), new RecipesCommon.ComparableStack(ModItems.cap_rad, 64)}, 10);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.block_cap_korl, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.cap_korl, 64), new RecipesCommon.ComparableStack(ModItems.cap_korl, 64)}, 10);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.block_cap_fritz, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.cap_fritz, 64), new RecipesCommon.ComparableStack(ModItems.cap_fritz, 64)}, 10);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.block_cap_sunset, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.cap_sunset, 64), new RecipesCommon.ComparableStack(ModItems.cap_sunset, 64)}, 10);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.block_cap_star, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.cap_star, 64), new RecipesCommon.ComparableStack(ModItems.cap_star, 64)}, 10);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.ammo_75bolt, 2), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 2), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 1), new RecipesCommon.ComparableStack(ModItems.primer_50, 5), new RecipesCommon.ComparableStack(ModItems.casing_50, 5), new RecipesCommon.OreDictStack(OreDictManager.ANY_HIGHEXPLOSIVE.ingot(), 5), new RecipesCommon.ComparableStack(ModItems.cordite, 5), new RecipesCommon.OreDictStack(OreDictManager.REDSTONE.dust(), 3)}, 60);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.ammo_75bolt_incendiary, 2), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 2), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 1), new RecipesCommon.ComparableStack(ModItems.primer_50, 5), new RecipesCommon.ComparableStack(ModItems.casing_50, 5), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTICEXPLOSIVE.ingot(), 3), new RecipesCommon.ComparableStack(ModItems.cordite, 3), new RecipesCommon.OreDictStack(OreDictManager.P_WHITE.ingot(), 3)}, 60);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.ammo_75bolt_he, 2), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 2), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 1), new RecipesCommon.ComparableStack(ModItems.primer_50, 5), new RecipesCommon.ComparableStack(ModItems.casing_50, 5), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTICEXPLOSIVE.ingot(), 5), new RecipesCommon.ComparableStack(ModItems.cordite, 5), new RecipesCommon.ComparableStack(Items.field_151137_ax, 3)}, 60);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.spawn_worm, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.W.heavyComp(), 1), new RecipesCommon.ComparableStack(ModItems.motor, 64), new RecipesCommon.ComparableStack(ModBlocks.glass_trinitite, 25), new RecipesCommon.OreDictStack(OreDictManager.REDSTONE.dust(), 40), new RecipesCommon.OreDictStack(OreDictManager.GOLD.wireDense(), 32), new RecipesCommon.OreDictStack(OreDictManager.PO210.block(), 10), new RecipesCommon.ComparableStack(ModItems.plate_armor_titanium, 50), new RecipesCommon.ComparableStack(ModItems.coin_worm, 1)}, 1200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.turret_chekhov, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.machine_battery, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.motor, 3), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 3), new RecipesCommon.ComparableStack(ModBlocks.crate_iron, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CRT_TUBE)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.turret_friendly, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.machine_battery, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.motor, 3), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.BASIC), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 3), new RecipesCommon.ComparableStack(ModBlocks.crate_iron, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CRT_TUBE)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.turret_jeremy, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.machine_saturnite_battery, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.ComparableStack(ModItems.motor_desh, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 3), new RecipesCommon.ComparableStack(ModBlocks.crate_steel, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CRT_TUBE)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.turret_tauon, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.machine_saturnite_battery, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.ComparableStack(ModItems.motor_desh, 1), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 32), new RecipesCommon.ComparableStack(ModItems.battery_lithium, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CRT_TUBE)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.turret_richard, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.machine_saturnite_battery, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 2), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 8), new RecipesCommon.ComparableStack(ModBlocks.crate_steel, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CRT_TUBE)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.turret_howard, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.machine_battery, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 24), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.ComparableStack(ModItems.motor_desh, 2), new RecipesCommon.ComparableStack(ModItems.circuit, 3, ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 10), new RecipesCommon.ComparableStack(ModBlocks.crate_steel, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CRT_TUBE)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.turret_maxwell, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.machine_saturnite_battery, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 24), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 4), new RecipesCommon.ComparableStack(ModItems.magnetron, 16), new RecipesCommon.OreDictStack(OreDictManager.ANY_RESISTANTALLOY.ingot(), 8), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CRT_TUBE)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.turret_fritz, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.machine_battery, 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.motor, 3), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 8), new RecipesCommon.ComparableStack(ModBlocks.barrel_steel, 1), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CRT_TUBE)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.gun_egon, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.mechanism_special, 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 16), new RecipesCommon.OreDictStack(OreDictManager.PB.plate(), 24), new RecipesCommon.ComparableStack(ModItems.coil_advanced_torus, 32), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.CHIP_QUANTUM), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 8), new RecipesCommon.ComparableStack(ModBlocks.machine_schrabidium_battery, 2), new RecipesCommon.ComparableStack(ModBlocks.machine_waste_drum, 1), new RecipesCommon.ComparableStack(ModItems.wire, 8, Mats.MAT_COPPER.id)}, 256);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.silo_hatch, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateWelded(), 4), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 4), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.OreDictStack(OreDictManager.STEEL.bolt(), 16), new RecipesCommon.OreDictStack("dyeGray", 4)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.sat_gerald, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.heavy_duty_element, 32), new RecipesCommon.ComparableStack(ModBlocks.det_nuke, 64), new RecipesCommon.ComparableStack(ModItems.circuit, 64, ItemCircuit.EnumCircuitType.CONTROLLER_QUANTUM), new RecipesCommon.ComparableStack(ModItems.coin_ufo, 1), new RecipesCommon.ComparableStack(ModBlocks.machine_radspice_battery, 2), new RecipesCommon.ComparableStack(ModBlocks.dfc_core, 1), new RecipesCommon.ComparableStack(ModItems.mp_thruster_15_balefire_large_rad, 1), new RecipesCommon.ComparableStack(ModItems.mp_thruster_15_balefire_large_rad, 1)}, 1200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_chungus, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.generator_steel, 6), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateWelded(), 16), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 12), new RecipesCommon.OreDictStack(OreDictManager.ANY_RESISTANTALLOY.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.turbine_tungsten, 5), new RecipesCommon.ComparableStack(ModItems.turbine_titanium, 3), new RecipesCommon.ComparableStack(ModItems.flywheel_beryllium, 1), new RecipesCommon.OreDictStack(OreDictManager.GOLD.wireDense(), 48), new RecipesCommon.OreDictStack(OreDictManager.DURA.pipe(), 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 16)}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_condenser_powered, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateWelded(), 8), new RecipesCommon.OreDictStack(OreDictManager.ANY_RESISTANTALLOY.plateWelded(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 16), new RecipesCommon.ComparableStack(ModItems.motor_desh, 3), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 24), new RecipesCommon.NbtComparableStack(ItemFluidCanister.getFullCanister(ModForgeFluids.LUBRICANT, 4))}, 600);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_silex, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.glass_quartz, 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateCast(), 8), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 8), new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.crystal(), 1)}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_fel, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.machine_saturnite_battery, 1), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.wireDense(), 64), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateCast(), 12), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.circuit, 16, ItemCircuit.EnumCircuitType.CAPACITOR), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.BASIC)}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.rbmk_blank, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.concrete_asbestos, 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateCast(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 4)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.multitool_hit, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_RESISTANTALLOY.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.GOLD.wire(), 12), new RecipesCommon.ComparableStack(ModItems.motor, 4), new RecipesCommon.ComparableStack(ModItems.circuit, 16, ItemCircuit.EnumCircuitType.CAPACITOR_BOARD)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_bat9000, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 16), new RecipesCommon.OreDictStack(OreDictManager.TI.plateWelded(), 2), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 16), new RecipesCommon.OreDictStack(OreDictManager.ANY_TAR.any(), 16)}, 150);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.machine_orbus, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.ANY_RESISTANTALLOY.plateWelded(), 8), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.plate(), 12), new RecipesCommon.ComparableStack(ModItems.coil_advanced_alloy, 12), new RecipesCommon.ComparableStack(ModItems.battery_sc_polonium, 1)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.large_vehicle_door, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateCast(), 16), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 4), new RecipesCommon.ComparableStack(ModItems.motor, 4), new RecipesCommon.OreDictStack(OreDictManager.DURA.bolt(), 16), new RecipesCommon.OreDictStack("dyeGreen", 4)}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.water_door, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 16), new RecipesCommon.OreDictStack(OreDictManager.DURA.bolt(), 4), new RecipesCommon.OreDictStack("dyeRed", 1)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.qe_containment, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateCast(), 4), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plateCast(), 4), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 8), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.OreDictStack(OreDictManager.DURA.bolt(), 32), new RecipesCommon.OreDictStack("dyeBlack", 4)}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.qe_sliding_door, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 4), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 4), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.OreDictStack(OreDictManager.DURA.bolt(), 4), new RecipesCommon.OreDictStack("dyeWhite", 4), new RecipesCommon.ComparableStack(Blocks.field_150359_w, 4)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.fire_door, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.plate(), 12), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 36), new RecipesCommon.OreDictStack(OreDictManager.ASBESTOS.ingot(), 12), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 6), new RecipesCommon.OreDictStack(OreDictManager.STEEL.block(), 4), new RecipesCommon.ComparableStack(ModItems.motor, 4), new RecipesCommon.ComparableStack(ModItems.bolt, 6, Mats.MAT_DURA.id), new RecipesCommon.OreDictStack("dyeRed", 8)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.small_hatch, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plateCast(), 2), new RecipesCommon.ComparableStack(ModItems.bolt, 1, Mats.MAT_DURA.id), new RecipesCommon.ComparableStack(ModBlocks.brick_concrete, 1), new RecipesCommon.ComparableStack(ModBlocks.ladder_red, 1)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.round_airlock_door, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.plate(), 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 32), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plateCast(), 12), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 12), new RecipesCommon.OreDictStack(OreDictManager.STEEL.block(), 6), new RecipesCommon.ComparableStack(ModItems.motor, 6), new RecipesCommon.ComparableStack(ModItems.bolt, 12, Mats.MAT_DURA.id), new RecipesCommon.OreDictStack("dyeGray", 4)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.secure_access_door, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateWelded(), 12), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plateCast(), 16), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 8), new RecipesCommon.ComparableStack(ModItems.motor, 4), new RecipesCommon.OreDictStack(OreDictManager.DURA.bolt(), 32), new RecipesCommon.OreDictStack("dyeCyan", 8)}, 400);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.sliding_seal_door, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 12), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 4), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.OreDictStack(OreDictManager.DURA.bolt(), 4), new RecipesCommon.OreDictStack("dyeWhite", 2)}, 200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.sliding_gate_door, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.plateWelded(), 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 12), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plateCast(), 4), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 2), new RecipesCommon.OreDictStack(OreDictManager.STEEL.block(), 1), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.ComparableStack(ModItems.bolt, 2, Mats.MAT_DURA.id), new RecipesCommon.OreDictStack("dyeWhite", 2)}, 500);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.transition_seal, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.cmb_brick_reinforced, 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateWelded(), 64), new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plateCast(), 40), new RecipesCommon.OreDictStack(OreDictManager.ANY_RUBBER.ingot(), 36), new RecipesCommon.OreDictStack(OreDictManager.STEEL.block(), 24), new RecipesCommon.ComparableStack(ModItems.motor_desh, 16), new RecipesCommon.OreDictStack(OreDictManager.DURA.bolt(), 16), new RecipesCommon.OreDictStack("dyeYellow", 4)}, 1200);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.control_panel_custom, 1), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.OreDictStack(OreDictManager.STEEL.block(), 1), new RecipesCommon.ComparableStack(ModItems.wire, 24, Mats.MAT_COPPER.id), new RecipesCommon.ComparableStack(ModBlocks.pole_top)}, 100);
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModBlocks.railgun_plasma, 1), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 24), new RecipesCommon.ComparableStack(ModItems.hull_big_steel, 2), new RecipesCommon.ComparableStack(ModItems.hull_small_steel, 6), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 2), new RecipesCommon.ComparableStack(ModBlocks.machine_schrabidium_battery, 1), new RecipesCommon.ComparableStack(ModItems.coil_copper, 16), new RecipesCommon.ComparableStack(ModItems.coil_copper_torus, 8), new RecipesCommon.ComparableStack(ModItems.plate_desh, 4), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.CAPACITOR), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 4)}, 500);
        hidden.add(new RecipesCommon.ComparableStack(ModBlocks.machine_radgen, 1));
        for (NTMMaterial mat : Mats.orderedList) {
            if (!mat.shapes.contains(MaterialShapes.CASTPLATE) || !mat.shapes.contains(MaterialShapes.HEAVY_COMPONENT)) continue;
            AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.heavy_component, 1, mat.id), new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(MaterialShapes.CASTPLATE.name() + mat.names[0], 64), new RecipesCommon.OreDictStack(MaterialShapes.CASTPLATE.name() + mat.names[0], 64), new RecipesCommon.OreDictStack(MaterialShapes.CASTPLATE.name() + mat.names[0], 64), new RecipesCommon.OreDictStack(MaterialShapes.CASTPLATE.name() + mat.names[0], 64)}, 12000);
        }
    }

    public static void makeRecipe(RecipesCommon.ComparableStack out, RecipesCommon.AStack[] in, int duration) {
        if (out == null || Item.field_150901_e.func_177774_c((Object)out.item) == null) {
            MainRegistry.logger.error("Canceling assembler registration, item was null!");
            return;
        }
        recipes.put(out, in);
        time.put(out, duration);
    }

    public static void removeRecipe(RecipesCommon.ComparableStack out) {
        if (out == null || Item.field_150901_e.func_177774_c((Object)out.item) == null) {
            MainRegistry.logger.error("Canceling assembler recipe removal, item was null!");
            return;
        }
        recipes.remove(out);
        time.remove(out);
        recipeList.remove(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadRecipesFromConfig() {
        itemRegistry = GameRegistry.findRegistry(Item.class);
        blockRegistry = GameRegistry.findRegistry(Block.class);
        File recipeConfig = new File(MainRegistry.proxy.getDataDir().getPath() + "/config/hbm/assemblerConfig.cfg");
        if (!recipeConfig.exists()) {
            try {
                recipeConfig.getParentFile().mkdirs();
                FileWriter write = new FileWriter(recipeConfig);
                write.write("# Format: time;itemName,meta,amount|nextItemName,meta,amount;productName,meta,amount\n# One line per recipe.\n# For an oredict input item, replace the mod id with oredict, like oredict:plateSteel. These do not require metatdata\n# Example for iron plates: 30;minecraft:iron_ingot,0,3;oredict:plateIron,2\n# For an NBT item, use a 4th item parameter with the nbt string of the tag.\n# The NBT string format is the same as used in commands\n# Example for turning kerosene canisters into steel plates:\n# 20;hbm:canister_fuel,0,2,{HbmFluidKey:{FluidName:\"kerosene\",Amount:1000}};hbm:plate_steel,0,32\n#\n# To remove a recipe, use the format: \n# remove hbm:plate_iron,0,2\n# This will remove any recipe with the output of two iron plates");
                AssemblerRecipes.addConfigRecipes(write);
                write.close();
            }
            catch (IOException e) {
                MainRegistry.logger.log(Level.ERROR, "ERROR: Could not create config file: " + recipeConfig.getAbsolutePath());
                e.printStackTrace();
                return;
            }
        }
        BufferedReader read = null;
        try {
            read = new BufferedReader(new FileReader(recipeConfig));
            String currentLine = null;
            int lineCount = 0;
            while ((currentLine = read.readLine()) != null) {
                ++lineCount;
                if (currentLine.startsWith("#") || currentLine.isEmpty()) continue;
                if (currentLine.startsWith("remove")) {
                    AssemblerRecipes.parseRemoval(currentLine, lineCount);
                    continue;
                }
                AssemblerRecipes.parseRecipe(currentLine, lineCount);
            }
        }
        catch (FileNotFoundException e) {
            MainRegistry.logger.log(Level.ERROR, "Could not find assembler config file! This should never happen.");
            e.printStackTrace();
        }
        catch (IOException e) {
            MainRegistry.logger.log(Level.ERROR, "Error reading assembler config!");
            e.printStackTrace();
        }
        finally {
            if (read != null) {
                try {
                    read.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void parseRemoval(String currentLine, int line) {
        String[] parts = currentLine.split(" ");
        if (parts.length != 2) {
            MainRegistry.logger.log(Level.WARN, "Could not parse assembler recipe removal on line " + line + ": does not have two parts. Skipping...");
            return;
        }
        RecipesCommon.AStack stack = AssemblerRecipes.parseAStack(parts[1], 64);
        if (stack == null) {
            MainRegistry.logger.log(Level.WARN, "Could not parse assembler output itemstack from \"" + parts[1] + "\" on line " + line + ". Skipping...");
            return;
        }
        if (!(stack instanceof RecipesCommon.ComparableStack)) {
            MainRegistry.logger.log(Level.WARN, "Oredict stacks are not allowed as assembler outputs! Line number: " + line + " Skipping...");
            return;
        }
        RecipesCommon.ComparableStack cStack = (RecipesCommon.ComparableStack)stack;
        recipes.remove(cStack);
        time.remove(cStack);
        recipeList.remove(cStack);
    }

    private static void parseRecipe(String currentLine, int line) {
        String[] parts = currentLine.split(";");
        if (parts.length != 3) {
            MainRegistry.logger.log(Level.WARN, "Could not parse assembler recipe on line " + line + ": does not have three parts. Skipping...");
            return;
        }
        int recipeTime = 0;
        try {
            recipeTime = Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException e) {
            MainRegistry.logger.log(Level.WARN, "Could not parse assembler process time from \"" + parts[0] + "\" on line " + line + ". Skipping...");
            return;
        }
        ArrayList<RecipesCommon.AStack> input = new ArrayList<RecipesCommon.AStack>();
        for (String s : parts[1].split("\\|")) {
            RecipesCommon.AStack stack = AssemblerRecipes.parseAStack(s, 768);
            if (stack == null) {
                MainRegistry.logger.log(Level.WARN, "Could not parse assembler input itemstack from \"" + s + "\" on line " + line + ". Skipping...");
                return;
            }
            input.add(stack);
        }
        RecipesCommon.AStack output = AssemblerRecipes.parseAStack(parts[2], 64);
        if (output == null) {
            MainRegistry.logger.log(Level.WARN, "Could not parse assembler output itemstack from \"" + parts[2] + "\" on line " + line + ". Skipping...");
            return;
        }
        if (!(output instanceof RecipesCommon.ComparableStack)) {
            MainRegistry.logger.log(Level.WARN, "Oredict stacks are not allowed as assembler outputs! Line number: " + line + " Skipping...");
            return;
        }
        if (recipes.containsKey(output)) {
            MainRegistry.logger.log(Level.WARN, "Found duplicate assembler recipe outputs! This is not allowed! Line number: " + line + " Skipping...");
        }
        recipes.put((RecipesCommon.ComparableStack)output, input.toArray(new RecipesCommon.AStack[0]));
        time.put((RecipesCommon.ComparableStack)output, recipeTime);
        recipeList.add((RecipesCommon.ComparableStack)output);
    }

    private static String readSplitPart(int idx, String s) {
        StringBuilder build = new StringBuilder();
        int braceCount = 0;
        for (int i = idx; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '{') {
                ++braceCount;
            } else if (c == '}') {
                --braceCount;
            }
            if (braceCount == 0 && (c == '|' || c == ',' || c == ';')) break;
            build.append(c);
        }
        if (build.length() == 0) {
            return null;
        }
        return build.toString();
    }

    private static String[] splitStringIgnoreBraces(String s) {
        String part;
        ArrayList<String> list = new ArrayList<String>();
        for (int idx = 0; idx < s.length() && (part = AssemblerRecipes.readSplitPart(idx, s)) != null; idx += part.length() + 1) {
            list.add(part);
            if (list.size() >= 4) break;
        }
        return list.toArray(new String[0]);
    }

    private static RecipesCommon.AStack parseAStack(String s, int maxSize) {
        String[] parts = AssemblerRecipes.splitStringIgnoreBraces(s);
        if (parts.length == 3 || parts.length == 4) {
            Block block = null;
            Item item = (Item)itemRegistry.getValue(new ResourceLocation(parts[0]));
            if (item == null) {
                block = (Block)blockRegistry.getValue(new ResourceLocation(parts[0]));
            }
            if (item == null && block == null) {
                MainRegistry.logger.log(Level.WARN, "Could not parse item or block from \"" + parts[0] + "\", probably isn't a registered item. Skipping...");
                return null;
            }
            int meta = 0;
            try {
                meta = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                MainRegistry.logger.log(Level.WARN, "Could not parse item metadata from \"" + parts[1] + "\". Skipping...");
                return null;
            }
            if (meta < 0) {
                MainRegistry.logger.log(Level.WARN, "Bad item meta: " + meta + ". Skipping...");
                return null;
            }
            int amount = 0;
            try {
                amount = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                MainRegistry.logger.log(Level.WARN, "Could not parse item amount from \"" + parts[2] + "\". Skipping...");
                return null;
            }
            if (amount < 0 || amount > maxSize) {
                MainRegistry.logger.log(Level.WARN, "Bad item amount: " + amount + ". Skipping...");
                return null;
            }
            if (parts.length == 4) {
                String name = parts[3];
                name.trim();
                NBTTagCompound tag = AssemblerRecipes.parseNBT(name);
                if (tag == null) {
                    MainRegistry.logger.log(Level.WARN, "Failed to parse NBT tag: " + parts[3] + ". Skipping...");
                    return null;
                }
                ItemStack stack = item == null ? new ItemStack(block, amount, meta) : new ItemStack(item, amount, meta);
                stack.func_77982_d(tag);
                return new RecipesCommon.NbtComparableStack(stack);
            }
            if (item == null) {
                return new RecipesCommon.ComparableStack(block, amount, meta);
            }
            return new RecipesCommon.ComparableStack(item, amount, meta);
        }
        if (parts.length == 2) {
            String[] ore = parts[0].split(":");
            if (ore.length == 2 && ore[0].equals("oredict")) {
                String name = ore[1];
                int amount = 0;
                try {
                    amount = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException e) {
                    MainRegistry.logger.log(Level.WARN, "Could not parse item amount from \"" + parts[1] + "\". Skipping...");
                    return null;
                }
                if (amount < 0 || amount > 768) {
                    MainRegistry.logger.log(Level.WARN, "Bad item amount: " + amount + ". Skipping...");
                    return null;
                }
                return new RecipesCommon.OreDictStack(name, amount);
            }
            MainRegistry.logger.log(Level.WARN, "Could not parse ore dict name from \"" + parts[0] + "\". Skipping...");
        }
        return null;
    }

    private static NBTTagCompound parseNBT(String json) {
        try {
            return JsonToNBT.func_180713_a((String)json);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void addConfigRecipes(FileWriter write) throws IOException {
        write.write("\n");
    }

    static {
        gson = new Gson();
        recipes = new LinkedHashMap();
        time = new HashMap();
        recipeList = new ArrayList<RecipesCommon.ComparableStack>();
        hidden = new HashSet();
        backupHidden = new HashSet();
    }
}

