/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.hazard.type;

import com.hbm.handler.ArmorUtil;
import com.hbm.hazard.modifier.HazardModifier;
import com.hbm.hazard.type.HazardTypeBase;
import com.hbm.lib.Library;
import com.hbm.util.ArmorRegistry;
import com.hbm.util.I18nUtil;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;

public class HazardTypeToxic
extends HazardTypeBase {
    @Override
    public void onUpdate(EntityLivingBase livingTEntity, float level, ItemStack stack) {
        boolean hasToxFilter = false;
        boolean hasHazmat = false;
        level *= (float)stack.func_190916_E();
        if (livingTEntity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)livingTEntity;
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
            if (ArmorRegistry.hasProtection(livingTEntity, EntityEquipmentSlot.HEAD, ArmorRegistry.HazardClass.NERVE_AGENT)) {
                ArmorUtil.damageGasMaskFilter(livingTEntity, 1);
                hasToxFilter = true;
            }
            hasHazmat = ArmorUtil.checkForHazmat(livingTEntity);
        }
        if (!hasToxFilter && !hasHazmat) {
            if (level > 0.0f) {
                livingTEntity.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 110, Math.min(255, (int)level)));
            }
            if (level > 10.0f) {
                livingTEntity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 110, Math.min(255, (int)level / 10)));
            }
            if (level > 100.0f) {
                livingTEntity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 110, Math.min(4, (int)level / 100)));
            }
            if (level > 1000.0f && (level > 2000.0f || livingTEntity.field_70170_p.field_73012_v.nextInt((int)(2000.0f / level)) == 0)) {
                livingTEntity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 110, Math.min(255, (int)level / 1000)));
            }
        }
        if (!hasHazmat || !hasToxFilter) {
            if (level > 2000.0f) {
                livingTEntity.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 110, Math.min(255, (int)level / 2000)));
            }
            if (level > 10000.0f) {
                livingTEntity.func_70690_d(new PotionEffect(MobEffects.field_76433_i, 110, Math.min(255, (int)level / 5000)));
            }
        }
    }

    @Override
    public void updateEntity(EntityItem item, float level) {
    }

    @Override
    public void addHazardInformation(EntityPlayer player, List<String> list, float level, ItemStack stack, List<HazardModifier> modifiers) {
        float rl = Library.roundFloat(level *= (float)stack.func_190916_E(), 3);
        if (level > 10000.0f) {
            list.add("\u00a7a[" + I18nUtil.resolveKey("adjective.extreme", new Object[0]) + " " + I18nUtil.resolveKey("trait.toxic", new Object[0]) + "] " + rl);
        } else if (level > 1000.0f) {
            list.add("\u00a7a[" + I18nUtil.resolveKey("adjective.veryhigh", new Object[0]) + " " + I18nUtil.resolveKey("trait.toxic", new Object[0]) + "] " + rl);
        } else if (level > 100.0f) {
            list.add("\u00a7a[" + I18nUtil.resolveKey("adjective.high", new Object[0]) + " " + I18nUtil.resolveKey("trait.toxic", new Object[0]) + "] " + rl);
        } else if (level > 10.0f) {
            list.add("\u00a7a[" + I18nUtil.resolveKey("adjective.medium", new Object[0]) + " " + I18nUtil.resolveKey("trait.toxic", new Object[0]) + "] " + rl);
        } else if (level > 0.0f) {
            list.add("\u00a7a[" + I18nUtil.resolveKey("adjective.little", new Object[0]) + " " + I18nUtil.resolveKey("trait.toxic", new Object[0]) + "] " + rl);
        }
    }
}

