/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.jei;

import com.hbm.blocks.ModBlocks;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.forgefluid.SpecialContainerFillLists;
import com.hbm.handler.jei.HadronRecipeHandler;
import com.hbm.inventory.AnvilRecipes;
import com.hbm.inventory.AnvilSmithingRecipe;
import com.hbm.inventory.ArcWelderRecipes;
import com.hbm.inventory.AssemblerRecipes;
import com.hbm.inventory.BreederRecipes;
import com.hbm.inventory.ChemplantRecipes;
import com.hbm.inventory.CokerRecipes;
import com.hbm.inventory.CombinationRecipes;
import com.hbm.inventory.CrackRecipes;
import com.hbm.inventory.CrucibleRecipes;
import com.hbm.inventory.CyclotronRecipes;
import com.hbm.inventory.DiFurnaceRecipes;
import com.hbm.inventory.FractionRecipes;
import com.hbm.inventory.FusionRecipes;
import com.hbm.inventory.GasCentrifugeRecipes;
import com.hbm.inventory.HadronRecipes;
import com.hbm.inventory.HeatRecipes;
import com.hbm.inventory.HydrotreatingRecipes;
import com.hbm.inventory.LiquefactionRecipes;
import com.hbm.inventory.MagicRecipes;
import com.hbm.inventory.MixerRecipes;
import com.hbm.inventory.NuclearTransmutationRecipes;
import com.hbm.inventory.PressRecipes;
import com.hbm.inventory.RBMKFuelRecipes;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.RefineryRecipes;
import com.hbm.inventory.ReformingRecipes;
import com.hbm.inventory.SAFERecipes;
import com.hbm.inventory.SILEXRecipes;
import com.hbm.inventory.SolderingRecipes;
import com.hbm.inventory.SolidificationRecipes;
import com.hbm.inventory.StorageDrumRecipes;
import com.hbm.inventory.VacuumDistillRecipes;
import com.hbm.inventory.WasteDrumRecipes;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemAssemblyTemplate;
import com.hbm.items.machine.ItemFELCrystal;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.items.machine.ItemFluidTank;
import com.hbm.items.machine.ItemMold;
import com.hbm.items.machine.ItemScraps;
import com.hbm.items.special.ItemCell;
import com.hbm.items.tool.ItemFluidCanister;
import com.hbm.items.tool.ItemGasCanister;
import com.hbm.lib.Library;
import com.hbm.util.I18nUtil;
import com.hbm.util.Tuple;
import com.hbm.util.WeightedRandomObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class JeiRecipes {
    private static List<ChemRecipe> chemRecipes = null;
    private static List<MixerRecipe> mixerRecipes = null;
    private static List<CyclotronRecipe> cyclotronRecipes = null;
    private static List<PressRecipe> pressRecipes = null;
    private static List<AlloyFurnaceRecipe> alloyFurnaceRecipes = null;
    private static List<CombinationFurnaceRecipe> combinationFurnaceRecipes = null;
    private static List<FoundrySmeltRecipe> foundrySmeltRecipes = null;
    private static List<FoundryMixRecipe> foundryMixRecipes = null;
    private static List<FoundryPourRecipe> foundryPourRecipes = null;
    private static List<ArcWelderRecipe> arcWelderRecipes = null;
    private static List<SolderingRecipe> solderingRecipes = null;
    private static List<BoilerRecipe> boilerRecipes = null;
    private static List<LiquefactionRecipe> liquefactionRecipes = null;
    private static List<SolidificationRecipe> solidificationRecipes = null;
    private static List<GasCentRecipe> gasCentRecipes = null;
    private static List<ReactorRecipe> reactorRecipes = null;
    private static List<WasteDrumRecipe> wasteDrumRecipes = null;
    private static List<StorageDrumRecipe> storageDrumRecipes = null;
    private static List<RBMKFuelRecipe> rbmkFuelRecipes = null;
    private static List<RefineryRecipe> refineryRecipes = null;
    private static List<CrackingRecipe> crackingRecipes = null;
    private static List<FractioningRecipe> fractioningRecipes = null;
    private static List<HydrotreaterRecipe> hydrotreaterRecipes = null;
    private static List<ReformingRecipe> reformingRecipes = null;
    private static List<VacuumDistillRecipe> vacuumdistillRecipes = null;
    private static List<CokerRecipe> cokerRecipes = null;
    private static List<FluidRecipe> fluidEquivalences = null;
    private static List<BookRecipe> bookRecipes = null;
    private static List<FusionRecipe> fusionByproducts = null;
    private static List<SAFERecipe> safeRecipes = null;
    private static List<HadronRecipe> hadronRecipes = null;
    private static List<SILEXRecipe> silexRecipes = null;
    private static Map<ItemFELCrystal.EnumWavelengths, List<SILEXRecipe>> waveSilexRecipes = new HashMap<ItemFELCrystal.EnumWavelengths, List<SILEXRecipe>>();
    private static List<SmithingRecipe> smithingRecipes = null;
    private static List<AnvilRecipe> anvilRecipes = null;
    private static List<TransmutationRecipe> transmutationRecipes = null;
    private static List<ItemStack> batteries = null;
    private static Map<Integer, List<ItemStack>> reactorFuelMap = new HashMap<Integer, List<ItemStack>>();
    private static List<ItemStack> blades = null;
    private static List<ItemStack> alloyFuels = null;

    public static List<ChemRecipe> getChemistryRecipes() {
        if (chemRecipes != null) {
            return chemRecipes;
        }
        chemRecipes = new ArrayList<ChemRecipe>();
        for (int i : ChemplantRecipes.recipeNames.keySet()) {
            int j;
            ArrayList<RecipesCommon.AStack> inputs = new ArrayList<RecipesCommon.AStack>(7);
            for (int j2 = 0; j2 < 7; ++j2) {
                inputs.add(j2, new RecipesCommon.ComparableStack(ModItems.nothing));
            }
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(6);
            for (int j3 = 0; j3 < 6; ++j3) {
                outputs.add(j3, new ItemStack(ModItems.nothing));
            }
            ItemStack template = new ItemStack(ModItems.chemistry_template, 1, i);
            List<RecipesCommon.AStack> listIn = ChemplantRecipes.getChemInputFromTempate(template);
            FluidStack[] fluidIn = ChemplantRecipes.getFluidInputFromTempate(template);
            ItemStack[] listOut = ChemplantRecipes.getChemOutputFromTempate(template);
            FluidStack[] fluidOut = ChemplantRecipes.getFluidOutputFromTempate(template);
            inputs.set(6, new RecipesCommon.ComparableStack(template));
            if (listIn != null) {
                for (j = 0; j < listIn.size(); ++j) {
                    if (listIn.get(j) == null) continue;
                    inputs.set(j + 2, listIn.get(j).copy());
                }
            }
            if (fluidIn != null) {
                for (j = 0; j < fluidIn.length; ++j) {
                    if (fluidIn[j] == null) continue;
                    inputs.set(j, new RecipesCommon.NbtComparableStack(ItemFluidIcon.getStackWithQuantity(fluidIn[j].getFluid(), fluidIn[j].amount)));
                }
            }
            if (listOut != null) {
                for (j = 0; j < listOut.length; ++j) {
                    if (listOut[j] == null) continue;
                    outputs.set(j + 2, listOut[j].func_77946_l());
                }
            }
            if (fluidOut != null) {
                for (j = 0; j < fluidOut.length; ++j) {
                    if (fluidOut[j] == null) continue;
                    outputs.set(j, ItemFluidIcon.getStackWithQuantity(fluidOut[j].getFluid(), fluidOut[j].amount));
                }
            }
            chemRecipes.add(new ChemRecipe(inputs, outputs));
        }
        return chemRecipes;
    }

    public static List<MixerRecipe> getMixerRecipes() {
        if (mixerRecipes != null) {
            return mixerRecipes;
        }
        mixerRecipes = new ArrayList<MixerRecipe>();
        for (Fluid f : MixerRecipes.recipesDurations.keySet()) {
            ArrayList<RecipesCommon.AStack> inputs = new ArrayList<RecipesCommon.AStack>(3);
            RecipesCommon.AStack inputItem = MixerRecipes.getInputItem(f);
            FluidStack[] inputFluids = MixerRecipes.getInputFluidStacks(f);
            if (inputItem != null) {
                inputs.add(inputItem);
            }
            if (inputFluids != null) {
                if (inputFluids.length >= 1) {
                    inputs.add(new RecipesCommon.NbtComparableStack(ItemFluidIcon.getStackWithQuantity(inputFluids[0].getFluid(), inputFluids[0].amount)));
                }
                if (inputFluids.length == 2) {
                    inputs.add(new RecipesCommon.NbtComparableStack(ItemFluidIcon.getStackWithQuantity(inputFluids[1].getFluid(), inputFluids[1].amount)));
                }
            }
            ItemStack output = ItemFluidIcon.getStackWithQuantity(f, MixerRecipes.getFluidOutputAmount(f));
            mixerRecipes.add(new MixerRecipe(inputs, output));
        }
        return mixerRecipes;
    }

    public static List<CyclotronRecipe> getCyclotronRecipes() {
        if (cyclotronRecipes != null) {
            return cyclotronRecipes;
        }
        Map<ItemStack[], ItemStack> recipes = CyclotronRecipes.getRecipes();
        cyclotronRecipes = new ArrayList<CyclotronRecipe>(recipes.size());
        for (Map.Entry<ItemStack[], ItemStack> e : recipes.entrySet()) {
            cyclotronRecipes.add(new CyclotronRecipe(Arrays.asList(e.getKey()), e.getValue()));
        }
        return cyclotronRecipes;
    }

    public static List<PressRecipe> getPressRecipes() {
        if (pressRecipes != null) {
            return pressRecipes;
        }
        pressRecipes = new ArrayList<PressRecipe>();
        for (Map.Entry<Tuple.Pair<PressRecipes.PressType, RecipesCommon.AStack>, ItemStack> entry : PressRecipes.pressRecipes.entrySet()) {
            ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
            inputs.add(entry.getKey().getValue().getStackList());
            inputs.add(PressRecipes.getStampList(entry.getKey().getKey()));
            pressRecipes.add(new PressRecipe(inputs, entry.getValue()));
        }
        return pressRecipes;
    }

    public static List<AlloyFurnaceRecipe> getAlloyRecipes() {
        if (alloyFurnaceRecipes != null) {
            return alloyFurnaceRecipes;
        }
        alloyFurnaceRecipes = new ArrayList<AlloyFurnaceRecipe>();
        for (Map.Entry<Tuple.Pair<RecipesCommon.AStack, RecipesCommon.AStack>, ItemStack> pairEntry : DiFurnaceRecipes.diRecipes.entrySet()) {
            alloyFurnaceRecipes.add(new AlloyFurnaceRecipe(pairEntry.getKey().getKey(), pairEntry.getKey().getValue(), pairEntry.getValue()));
        }
        return alloyFurnaceRecipes;
    }

    public static List<CombinationFurnaceRecipe> getCombinationFurnaceRecipes() {
        if (combinationFurnaceRecipes != null) {
            return combinationFurnaceRecipes;
        }
        combinationFurnaceRecipes = new ArrayList<CombinationFurnaceRecipe>();
        for (Map.Entry<RecipesCommon.AStack, Tuple.Pair<ItemStack, FluidStack>> pairEntry : CombinationRecipes.recipes.entrySet()) {
            combinationFurnaceRecipes.add(new CombinationFurnaceRecipe(pairEntry.getKey(), pairEntry.getValue().getKey(), pairEntry.getValue().getValue()));
        }
        return combinationFurnaceRecipes;
    }

    public static List<FoundrySmeltRecipe> getFoundrySmeltRecipes() {
        if (foundrySmeltRecipes != null) {
            return foundrySmeltRecipes;
        }
        foundrySmeltRecipes = new ArrayList<FoundrySmeltRecipe>();
        for (NTMMaterial nTMMaterial : Mats.orderedList) {
            for (Map.Entry<String, MaterialShapes> prefixEntry : Mats.prefixByName.entrySet()) {
                String prefix = prefixEntry.getKey();
                ArrayList<ItemStack> shapeMatItemStacks = new ArrayList<ItemStack>();
                for (String name : nTMMaterial.names) {
                    shapeMatItemStacks.addAll(new RecipesCommon.OreDictStack(prefix + name).getStackList());
                }
                if (shapeMatItemStacks.isEmpty()) continue;
                ArrayList<Mats.MaterialStack> mats = new ArrayList<Mats.MaterialStack>();
                mats.add(new Mats.MaterialStack(nTMMaterial.smeltsInto, prefixEntry.getValue().q(1)));
                foundrySmeltRecipes.add(new FoundrySmeltRecipe(shapeMatItemStacks, Mats.matsToScrap(mats, false)));
            }
        }
        for (Map.Entry entry : Mats.materialEntries.entrySet()) {
            foundrySmeltRecipes.add(new FoundrySmeltRecipe(((RecipesCommon.ComparableStack)entry.getKey()).getStackList(), Mats.matsToScrap((List)entry.getValue(), false)));
        }
        for (Map.Entry entry : Mats.materialOreEntries.entrySet()) {
            foundrySmeltRecipes.add(new FoundrySmeltRecipe(new RecipesCommon.OreDictStack((String)entry.getKey()).getStackList(), Mats.matsToScrap((List)entry.getValue(), false)));
        }
        return foundrySmeltRecipes;
    }

    public static List<FoundryMixRecipe> getFoundryMixRecipes() {
        if (foundryMixRecipes != null) {
            return foundryMixRecipes;
        }
        foundryMixRecipes = new ArrayList<FoundryMixRecipe>();
        for (CrucibleRecipes.CrucibleRecipe recipe : CrucibleRecipes.recipes.values()) {
            List<ItemStack> inputs = Mats.matsToScrap(recipe.input, false);
            List<ItemStack> outputs = Mats.matsToScrap(recipe.output, false);
            foundryMixRecipes.add(new FoundryMixRecipe(new ItemStack(ModItems.crucible_template, 1, recipe.getId()), inputs, outputs));
        }
        return foundryMixRecipes;
    }

    public static List<FoundryPourRecipe> getFoundryPourRecipes() {
        if (foundryPourRecipes != null) {
            return foundryPourRecipes;
        }
        foundryPourRecipes = new ArrayList<FoundryPourRecipe>();
        for (NTMMaterial material : Mats.orderedList) {
            if (material.smeltable != NTMMaterial.SmeltingBehavior.SMELTABLE) continue;
            for (ItemMold.Mold mold : ItemMold.molds) {
                ItemStack out = mold.getOutput(material);
                if (out == null) continue;
                ItemStack scrap = ItemScraps.create(new Mats.MaterialStack(material, mold.getCost()), false);
                ItemStack moldStack = new ItemStack(ModItems.mold, 1, mold.id);
                ItemStack basin = new ItemStack((Block)(mold.size == 0 ? ModBlocks.foundry_mold : (mold.size == 1 ? ModBlocks.foundry_basin : Blocks.field_150480_ab)));
                foundryPourRecipes.add(new FoundryPourRecipe(basin, moldStack, scrap, out));
            }
        }
        return foundryPourRecipes;
    }

    public static List<ArcWelderRecipe> getArcWelderRecipes() {
        if (arcWelderRecipes != null) {
            return arcWelderRecipes;
        }
        arcWelderRecipes = new ArrayList<ArcWelderRecipe>();
        for (ArcWelderRecipes.ArcWelderRecipe recipe : ArcWelderRecipes.recipes) {
            ArrayList<RecipesCommon.AStack> recipeItemList = new ArrayList<RecipesCommon.AStack>(Arrays.asList(recipe.ingredients));
            if (recipe.fluid != null) {
                recipeItemList.add(new RecipesCommon.NbtComparableStack(ItemFluidIcon.getStackWithQuantity(recipe.fluid)));
            }
            arcWelderRecipes.add(new ArcWelderRecipe(recipeItemList, recipe.output, recipe.duration, recipe.consumption, recipe.ingredients.length));
        }
        return arcWelderRecipes;
    }

    public static List<SolderingRecipe> getSolderingRecipes() {
        if (solderingRecipes != null) {
            return solderingRecipes;
        }
        solderingRecipes = new ArrayList<SolderingRecipe>();
        for (SolderingRecipes.SolderingRecipe recipe : SolderingRecipes.recipes) {
            ArrayList<RecipesCommon.AStack> recipeItemList = new ArrayList<RecipesCommon.AStack>(Arrays.asList(recipe.toppings));
            recipeItemList.addAll(Arrays.asList(recipe.pcb));
            recipeItemList.addAll(Arrays.asList(recipe.solder));
            if (recipe.fluid != null) {
                recipeItemList.add(new RecipesCommon.NbtComparableStack(ItemFluidIcon.getStackWithQuantity(recipe.fluid)));
            }
            solderingRecipes.add(new SolderingRecipe(recipeItemList, recipe.output, recipe.duration, recipe.consumption, recipe.toppings.length, recipe.pcb.length, recipe.solder.length));
        }
        return solderingRecipes;
    }

    public static List<RBMKFuelRecipe> getRBMKFuelRecipes() {
        if (rbmkFuelRecipes != null) {
            return rbmkFuelRecipes;
        }
        rbmkFuelRecipes = new ArrayList<RBMKFuelRecipe>();
        for (Map.Entry<ItemStack, ItemStack> pairEntry : RBMKFuelRecipes.recipes.entrySet()) {
            rbmkFuelRecipes.add(new RBMKFuelRecipe(pairEntry.getKey(), pairEntry.getValue()));
        }
        return rbmkFuelRecipes;
    }

    public static List<ItemStack> getAlloyFuels() {
        if (alloyFuels != null) {
            return alloyFuels;
        }
        alloyFuels = DiFurnaceRecipes.getAlloyFuels();
        return alloyFuels;
    }

    public static List<BoilerRecipe> getBoilerRecipes() {
        if (boilerRecipes != null) {
            return boilerRecipes;
        }
        boilerRecipes = new ArrayList<BoilerRecipe>();
        for (Fluid f : FluidRegistry.getRegisteredFluids().values()) {
            Object[] outs = HeatRecipes.getBoilerOutput(f);
            if (outs == null) continue;
            boilerRecipes.add(new BoilerRecipe(ItemFluidIcon.getStackWithQuantity(f, (Integer)outs[2]), ItemFluidIcon.getStackWithQuantity((Fluid)outs[0], (Integer)outs[1])));
        }
        return boilerRecipes;
    }

    public static List<ItemStack> getBatteries() {
        if (batteries != null) {
            return batteries;
        }
        batteries = new ArrayList<ItemStack>();
        batteries.add(new ItemStack(ModItems.battery_potato));
        batteries.add(new ItemStack(ModItems.battery_potatos));
        batteries.add(new ItemStack(ModItems.battery_su));
        batteries.add(new ItemStack(ModItems.battery_su_l));
        batteries.add(new ItemStack(ModItems.battery_generic));
        batteries.add(new ItemStack(ModItems.battery_red_cell));
        batteries.add(new ItemStack(ModItems.battery_red_cell_6));
        batteries.add(new ItemStack(ModItems.battery_red_cell_24));
        batteries.add(new ItemStack(ModItems.battery_advanced));
        batteries.add(new ItemStack(ModItems.battery_advanced_cell));
        batteries.add(new ItemStack(ModItems.battery_advanced_cell_4));
        batteries.add(new ItemStack(ModItems.battery_advanced_cell_12));
        batteries.add(new ItemStack(ModItems.battery_lithium));
        batteries.add(new ItemStack(ModItems.battery_lithium_cell));
        batteries.add(new ItemStack(ModItems.battery_lithium_cell_3));
        batteries.add(new ItemStack(ModItems.battery_lithium_cell_6));
        batteries.add(new ItemStack(ModItems.battery_schrabidium));
        batteries.add(new ItemStack(ModItems.battery_schrabidium_cell));
        batteries.add(new ItemStack(ModItems.battery_schrabidium_cell_2));
        batteries.add(new ItemStack(ModItems.battery_schrabidium_cell_4));
        batteries.add(new ItemStack(ModItems.battery_spark));
        batteries.add(new ItemStack(ModItems.battery_spark_cell_6));
        batteries.add(new ItemStack(ModItems.battery_spark_cell_25));
        batteries.add(new ItemStack(ModItems.battery_spark_cell_100));
        batteries.add(new ItemStack(ModItems.battery_spark_cell_1000));
        batteries.add(new ItemStack(ModItems.battery_spark_cell_10000));
        batteries.add(new ItemStack(ModItems.battery_spark_cell_power));
        batteries.add(new ItemStack(ModItems.fusion_core));
        batteries.add(new ItemStack(ModItems.energy_core));
        return batteries;
    }

    public static List<GasCentRecipe> getGasCentrifugeRecipes() {
        if (gasCentRecipes != null) {
            return gasCentRecipes;
        }
        gasCentRecipes = new ArrayList<GasCentRecipe>();
        for (Map.Entry<Fluid, GasCentrifugeRecipes.GasCentRecipe> r : GasCentrifugeRecipes.recipes.entrySet()) {
            Fluid f = r.getKey();
            GasCentrifugeRecipes.GasCentRecipe rec = r.getValue();
            ItemStack inputA = ItemFluidIcon.getStackWithQuantity(f, rec.amountA * rec.totalWeightA);
            ArrayList<ItemStack> resultA = new ArrayList<ItemStack>(4);
            for (GasCentrifugeRecipes.GasCentOutput o : rec.outputListA) {
                ItemStack stack = o.output.func_77946_l();
                stack.func_190920_e(stack.func_190916_E() * o.weight);
                resultA.add(stack);
            }
            gasCentRecipes.add(new GasCentRecipe(false, inputA, resultA));
            if (rec.outputListB == null) continue;
            ItemStack inputB = ItemFluidIcon.getStackWithQuantity(f, rec.amountB * rec.totalWeightB);
            ArrayList<ItemStack> resultB = new ArrayList<ItemStack>(4);
            for (GasCentrifugeRecipes.GasCentOutput o : rec.outputListB) {
                ItemStack stack = o.output.func_77946_l();
                stack.func_190920_e(stack.func_190916_E() * o.weight);
                resultB.add(stack);
            }
            gasCentRecipes.add(new GasCentRecipe(true, inputB, resultB));
        }
        return gasCentRecipes;
    }

    public static List<BookRecipe> getBookRecipes() {
        if (bookRecipes != null) {
            return bookRecipes;
        }
        bookRecipes = new ArrayList<BookRecipe>();
        for (MagicRecipes.MagicRecipe m : MagicRecipes.getRecipes()) {
            bookRecipes.add(new BookRecipe(m));
        }
        return bookRecipes;
    }

    public static List<ReactorRecipe> getReactorRecipes() {
        if (reactorRecipes != null) {
            return reactorRecipes;
        }
        reactorRecipes = new ArrayList<ReactorRecipe>();
        for (Map.Entry<ItemStack, BreederRecipes.BreederRecipe> entry : BreederRecipes.getAllRecipes().entrySet()) {
            reactorRecipes.add(new ReactorRecipe(entry.getKey(), entry.getValue().output, entry.getValue().heat));
        }
        return reactorRecipes;
    }

    public static List<LiquefactionRecipe> getLiquefactionRecipes() {
        if (liquefactionRecipes != null) {
            return liquefactionRecipes;
        }
        liquefactionRecipes = new ArrayList<LiquefactionRecipe>();
        for (Map.Entry<Object, FluidStack> entry : LiquefactionRecipes.recipes.entrySet()) {
            ItemStack output = ItemFluidIcon.getStackWithQuantity(entry.getValue());
            Object object = entry.getKey();
            if (object instanceof String) {
                String name = (String)object;
                liquefactionRecipes.add(new LiquefactionRecipe(new RecipesCommon.OreDictStack(name).getStackList(), output));
                continue;
            }
            object = entry.getKey();
            if (!(object instanceof RecipesCommon.ComparableStack)) continue;
            RecipesCommon.ComparableStack stack = (RecipesCommon.ComparableStack)object;
            liquefactionRecipes.add(new LiquefactionRecipe(stack.getStackList(), output));
        }
        return liquefactionRecipes;
    }

    public static List<SolidificationRecipe> getSolidificationRecipes() {
        if (solidificationRecipes != null) {
            return solidificationRecipes;
        }
        solidificationRecipes = new ArrayList<SolidificationRecipe>();
        for (Map.Entry<Fluid, Tuple.Pair<Integer, ItemStack>> entry : SolidificationRecipes.recipes.entrySet()) {
            solidificationRecipes.add(new SolidificationRecipe(ItemFluidIcon.getStackWithQuantity(entry.getKey(), entry.getValue().getKey()), entry.getValue().getValue()));
        }
        return solidificationRecipes;
    }

    public static List<WasteDrumRecipe> getWasteDrumRecipes() {
        if (wasteDrumRecipes != null) {
            return wasteDrumRecipes;
        }
        wasteDrumRecipes = new ArrayList<WasteDrumRecipe>();
        for (Map.Entry<Item, ItemStack> entry : WasteDrumRecipes.recipes.entrySet()) {
            wasteDrumRecipes.add(new WasteDrumRecipe(new ItemStack(entry.getKey()), entry.getValue()));
        }
        return wasteDrumRecipes;
    }

    public static List<StorageDrumRecipe> getStorageDrumRecipes() {
        if (storageDrumRecipes != null) {
            return storageDrumRecipes;
        }
        storageDrumRecipes = new ArrayList<StorageDrumRecipe>();
        for (Map.Entry<RecipesCommon.ComparableStack, ItemStack> entry : StorageDrumRecipes.recipeOutputs.entrySet()) {
            storageDrumRecipes.add(new StorageDrumRecipe(entry.getKey().getStack(), entry.getValue()));
        }
        return storageDrumRecipes;
    }

    public static List<TransmutationRecipe> getTransmutationRecipes() {
        if (transmutationRecipes != null) {
            return transmutationRecipes;
        }
        transmutationRecipes = new ArrayList<TransmutationRecipe>();
        for (Map.Entry<RecipesCommon.AStack, ItemStack> entry : NuclearTransmutationRecipes.recipesOutput.entrySet()) {
            transmutationRecipes.add(new TransmutationRecipe(entry.getKey().getStackList(), entry.getValue()));
        }
        return transmutationRecipes;
    }

    public static List<ItemStack> getReactorFuels(int heat) {
        if (reactorFuelMap.containsKey(heat)) {
            return reactorFuelMap.get(heat);
        }
        reactorFuelMap.put(heat, BreederRecipes.getAllFuelsFromHEAT(heat));
        return reactorFuelMap.get(heat);
    }

    public static List<RefineryRecipe> getRefineryRecipe() {
        if (refineryRecipes != null) {
            return refineryRecipes;
        }
        refineryRecipes = new ArrayList<RefineryRecipe>();
        for (Fluid fluid : RefineryRecipes.refineryRecipesMap.keySet()) {
            FluidStack[] outputFluids = RefineryRecipes.getRecipe(fluid).getKey();
            ItemStack outputItem = RefineryRecipes.getRecipe(fluid).getValue();
            refineryRecipes.add(new RefineryRecipe(ItemFluidIcon.getStackWithQuantity(fluid, 1000), Arrays.asList(ItemFluidIcon.getStackWithQuantity(outputFluids[0].getFluid(), outputFluids[0].amount * 10), ItemFluidIcon.getStackWithQuantity(outputFluids[1].getFluid(), outputFluids[1].amount * 10), ItemFluidIcon.getStackWithQuantity(outputFluids[2].getFluid(), outputFluids[2].amount * 10), ItemFluidIcon.getStackWithQuantity(outputFluids[3].getFluid(), outputFluids[3].amount * 10), outputItem.func_77946_l())));
        }
        return refineryRecipes;
    }

    public static List<CrackingRecipe> getCrackingRecipe() {
        if (crackingRecipes != null) {
            return crackingRecipes;
        }
        crackingRecipes = new ArrayList<CrackingRecipe>();
        for (String f : CrackRecipes.recipeFluids.keySet()) {
            Fluid fluid = FluidRegistry.getFluid((String)f);
            FluidStack[] outputFluids = CrackRecipes.getOutputsFromFluid(fluid);
            ArrayList<ItemStack> outputIcons = new ArrayList<ItemStack>();
            for (FluidStack fluidStacks : outputFluids) {
                outputIcons.add(ItemFluidIcon.getStackWithQuantity(fluidStacks.getFluid(), fluidStacks.amount * 10));
            }
            crackingRecipes.add(new CrackingRecipe(ItemFluidIcon.getStackWithQuantity(fluid, 1000), outputIcons));
        }
        return crackingRecipes;
    }

    public static List<FractioningRecipe> getFractioningRecipe() {
        if (fractioningRecipes != null) {
            return fractioningRecipes;
        }
        fractioningRecipes = new ArrayList<FractioningRecipe>();
        for (String f : FractionRecipes.fractions.keySet()) {
            Tuple.Quartet<Fluid, Fluid, Integer, Integer> recipe = FractionRecipes.getFractions(f);
            fractioningRecipes.add(new FractioningRecipe(ItemFluidIcon.getStackWithQuantity(FluidRegistry.getFluid((String)f), 1000), Arrays.asList(ItemFluidIcon.getStackWithQuantity(recipe.getW(), recipe.getY() * 10), ItemFluidIcon.getStackWithQuantity(recipe.getX(), recipe.getZ() * 10))));
        }
        return fractioningRecipes;
    }

    public static List<HydrotreaterRecipe> getHydrotreaterRecipes() {
        if (hydrotreaterRecipes != null) {
            return hydrotreaterRecipes;
        }
        hydrotreaterRecipes = new ArrayList<HydrotreaterRecipe>();
        for (Map.Entry<Fluid, Tuple.Triplet<FluidStack, FluidStack, FluidStack>> rec : HydrotreatingRecipes.recipes.entrySet()) {
            hydrotreaterRecipes.add(new HydrotreaterRecipe(Arrays.asList(ItemFluidIcon.getStackWithQuantity(rec.getKey(), 100), ItemFluidIcon.getStackWithQuantity(rec.getValue().getX())), Arrays.asList(ItemFluidIcon.getStackWithQuantity(rec.getValue().getY()), ItemFluidIcon.getStackWithQuantity(rec.getValue().getZ()))));
        }
        return hydrotreaterRecipes;
    }

    public static List<ReformingRecipe> getReformingRecipes() {
        if (reformingRecipes != null) {
            return reformingRecipes;
        }
        reformingRecipes = new ArrayList<ReformingRecipe>();
        for (Map.Entry<Fluid, Tuple.Triplet<FluidStack, FluidStack, FluidStack>> ref : ReformingRecipes.recipes.entrySet()) {
            reformingRecipes.add(new ReformingRecipe(ItemFluidIcon.getStackWithQuantity(ref.getKey(), 100), Arrays.asList(ItemFluidIcon.getStackWithQuantity(ref.getValue().getX()), ItemFluidIcon.getStackWithQuantity(ref.getValue().getY()), ItemFluidIcon.getStackWithQuantity(ref.getValue().getZ()))));
        }
        return reformingRecipes;
    }

    public static List<VacuumDistillRecipe> getVacuumDistillRecipes() {
        if (vacuumdistillRecipes != null) {
            return vacuumdistillRecipes;
        }
        vacuumdistillRecipes = new ArrayList<VacuumDistillRecipe>();
        for (Map.Entry<Fluid, Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack>> vac : VacuumDistillRecipes.vacuum.entrySet()) {
            vacuumdistillRecipes.add(new VacuumDistillRecipe(ItemFluidIcon.getStackWithQuantity(vac.getKey(), 100), Arrays.asList(ItemFluidIcon.getStackWithQuantity(vac.getValue().getW()), ItemFluidIcon.getStackWithQuantity(vac.getValue().getX()), ItemFluidIcon.getStackWithQuantity(vac.getValue().getY()), ItemFluidIcon.getStackWithQuantity(vac.getValue().getZ()))));
        }
        return vacuumdistillRecipes;
    }

    public static List<CokerRecipe> getCokerRecipes() {
        if (cokerRecipes != null) {
            return cokerRecipes;
        }
        cokerRecipes = new ArrayList<CokerRecipe>();
        for (Map.Entry<Fluid, Tuple.Triplet<Integer, ItemStack, FluidStack>> cok : CokerRecipes.recipes.entrySet()) {
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            outputs.add(ItemFluidIcon.getStackWithQuantity(cok.getValue().getZ()));
            if (cok.getValue().getY() != null) {
                outputs.add(cok.getValue().getY());
            }
            cokerRecipes.add(new CokerRecipe(ItemFluidIcon.getStackWithQuantity(cok.getKey(), cok.getValue().getX()), outputs));
        }
        return cokerRecipes;
    }

    public static List<ItemStack> getBlades() {
        if (blades != null) {
            return blades;
        }
        blades = new ArrayList<ItemStack>();
        blades.add(new ItemStack(ModItems.blades_advanced_alloy));
        blades.add(new ItemStack(ModItems.blades_aluminum));
        blades.add(new ItemStack(ModItems.blades_combine_steel));
        blades.add(new ItemStack(ModItems.blades_gold));
        blades.add(new ItemStack(ModItems.blades_iron));
        blades.add(new ItemStack(ModItems.blades_steel));
        blades.add(new ItemStack(ModItems.blades_titanium));
        blades.add(new ItemStack(ModItems.blades_schrabidium));
        return blades;
    }

    public static void addFluidTankRecipe(List<FluidRecipe> eq, Fluid f, ItemStack stack) {
        eq.add(new FluidRecipe(ItemFluidIcon.getStack(f), stack));
        eq.add(new FluidRecipeInverse(ItemFluidIcon.getStack(f), stack));
    }

    public static List<FluidRecipe> getFluidEquivalences() {
        if (fluidEquivalences != null) {
            return fluidEquivalences;
        }
        fluidEquivalences = new ArrayList<FluidRecipe>();
        for (Fluid f : FluidRegistry.getRegisteredFluids().values()) {
            if (f == ModForgeFluids.EXPERIENCE) {
                JeiRecipes.addFluidTankRecipe(fluidEquivalences, f, new ItemStack(ModItems.iv_xp));
            } else if (f == FluidRegistry.WATER) {
                JeiRecipes.addFluidTankRecipe(fluidEquivalences, f, new ItemStack(Items.field_151131_as));
            } else if (f == FluidRegistry.LAVA) {
                JeiRecipes.addFluidTankRecipe(fluidEquivalences, f, new ItemStack(Items.field_151129_at));
            } else if (f == ModForgeFluids.HYDROGEN) {
                JeiRecipes.addFluidTankRecipe(fluidEquivalences, f, new ItemStack(ModItems.particle_hydrogen));
            } else if (f == ModForgeFluids.AMAT) {
                JeiRecipes.addFluidTankRecipe(fluidEquivalences, f, new ItemStack(ModItems.particle_amat));
            } else if (f == ModForgeFluids.ASCHRAB) {
                JeiRecipes.addFluidTankRecipe(fluidEquivalences, f, new ItemStack(ModItems.particle_aschrab));
            }
            if (FluidRegistry.isUniversalBucketEnabled() && FluidRegistry.hasBucket((Fluid)f)) {
                JeiRecipes.addFluidTankRecipe(fluidEquivalences, f, FluidUtil.getFilledBucket((FluidStack)new FluidStack(f, 1000)));
            }
            JeiRecipes.addFluidTankRecipe(fluidEquivalences, f, ItemFluidTank.getFullTank(f));
            JeiRecipes.addFluidTankRecipe(fluidEquivalences, f, ItemFluidTank.getFullTankLead(f));
            JeiRecipes.addFluidTankRecipe(fluidEquivalences, f, ItemFluidTank.getFullBarrel(f));
            if (SpecialContainerFillLists.EnumCanister.contains(f)) {
                JeiRecipes.addFluidTankRecipe(fluidEquivalences, f, ItemFluidCanister.getFullCanister(f));
            }
            if (SpecialContainerFillLists.EnumGasCanister.contains(f)) {
                JeiRecipes.addFluidTankRecipe(fluidEquivalences, f, ItemGasCanister.getFullCanister(f));
            }
            if (!SpecialContainerFillLists.EnumCell.contains(f)) continue;
            JeiRecipes.addFluidTankRecipe(fluidEquivalences, f, ItemCell.getFullCell(f));
        }
        return fluidEquivalences;
    }

    public static List<FusionRecipe> getFusionByproducts() {
        if (fusionByproducts != null) {
            return fusionByproducts;
        }
        fusionByproducts = new ArrayList<FusionRecipe>();
        fusionByproducts.add(new FusionRecipe(ModForgeFluids.PLASMA_DT, FusionRecipes.getByproduct(ModForgeFluids.PLASMA_DT)));
        fusionByproducts.add(new FusionRecipe(ModForgeFluids.PLASMA_HD, FusionRecipes.getByproduct(ModForgeFluids.PLASMA_HD)));
        fusionByproducts.add(new FusionRecipe(ModForgeFluids.PLASMA_HT, FusionRecipes.getByproduct(ModForgeFluids.PLASMA_HT)));
        fusionByproducts.add(new FusionRecipe(ModForgeFluids.PLASMA_MX, FusionRecipes.getByproduct(ModForgeFluids.PLASMA_MX)));
        fusionByproducts.add(new FusionRecipe(ModForgeFluids.PLASMA_PUT, FusionRecipes.getByproduct(ModForgeFluids.PLASMA_PUT)));
        fusionByproducts.add(new FusionRecipe(ModForgeFluids.PLASMA_BF, FusionRecipes.getByproduct(ModForgeFluids.PLASMA_BF)));
        return fusionByproducts;
    }

    public static List<SAFERecipe> getSAFERecipes() {
        if (safeRecipes != null) {
            return safeRecipes;
        }
        safeRecipes = new ArrayList<SAFERecipe>();
        for (Map.Entry<ItemStack, ItemStack> recipe : SAFERecipes.getAllRecipes().entrySet()) {
            safeRecipes.add(new SAFERecipe(recipe.getKey(), recipe.getValue()));
        }
        return safeRecipes;
    }

    public static List<HadronRecipe> getHadronRecipes() {
        if (hadronRecipes != null) {
            return hadronRecipes;
        }
        hadronRecipes = new ArrayList<HadronRecipe>();
        for (HadronRecipes.HadronRecipe recipe : HadronRecipes.getRecipes()) {
            hadronRecipes.add(new HadronRecipe(recipe.in1.toStack(), recipe.in2.toStack(), recipe.out1, recipe.out2, recipe.momentum, recipe.analysisOnly));
        }
        return hadronRecipes;
    }

    public static List<SILEXRecipe> getSILEXRecipes(ItemFELCrystal.EnumWavelengths wavelength) {
        if (waveSilexRecipes.containsKey((Object)wavelength)) {
            return waveSilexRecipes.get((Object)wavelength);
        }
        ArrayList<SILEXRecipe> wSilexRecipes = new ArrayList<SILEXRecipe>();
        for (Map.Entry<List<ItemStack>, SILEXRecipes.SILEXRecipe> e : SILEXRecipes.getRecipes().entrySet()) {
            SILEXRecipes.SILEXRecipe out = e.getValue();
            if (out.laserStrength != wavelength) continue;
            double weight = 0.0;
            for (WeightedRandomObject obj : out.outputs) {
                weight += (double)obj.field_76292_a;
            }
            ArrayList<Double> chances = new ArrayList<Double>(out.outputs.size());
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(chances.size());
            for (int i = 0; i < out.outputs.size(); ++i) {
                WeightedRandomObject obj = out.outputs.get(i);
                outputs.add(obj.asStack());
                chances.add((double)(100 * obj.field_76292_a) / weight);
            }
            wSilexRecipes.add(new SILEXRecipe(e.getKey(), chances, outputs, (double)out.fluidProduced / (double)out.fluidConsumed, out.laserStrength));
        }
        waveSilexRecipes.put(wavelength, wSilexRecipes);
        return wSilexRecipes;
    }

    public static List<SILEXRecipe> getSILEXRecipes() {
        if (silexRecipes != null) {
            return silexRecipes;
        }
        silexRecipes = new ArrayList<SILEXRecipe>();
        for (Map.Entry<List<ItemStack>, SILEXRecipes.SILEXRecipe> e : SILEXRecipes.getRecipes().entrySet()) {
            SILEXRecipes.SILEXRecipe out = e.getValue();
            double weight = 0.0;
            for (WeightedRandomObject obj : out.outputs) {
                weight += (double)obj.field_76292_a;
            }
            ArrayList<Double> chances = new ArrayList<Double>(out.outputs.size());
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(chances.size());
            for (int i = 0; i < out.outputs.size(); ++i) {
                WeightedRandomObject obj = out.outputs.get(i);
                outputs.add(obj.asStack());
                chances.add((double)(100 * obj.field_76292_a) / weight);
            }
            silexRecipes.add(new SILEXRecipe(e.getKey(), chances, outputs, (double)out.fluidProduced / (double)out.fluidConsumed, out.laserStrength));
        }
        return silexRecipes;
    }

    public static List<SmithingRecipe> getSmithingRecipes() {
        if (smithingRecipes != null) {
            return smithingRecipes;
        }
        smithingRecipes = new ArrayList<SmithingRecipe>();
        for (AnvilSmithingRecipe r : AnvilRecipes.getSmithing()) {
            smithingRecipes.add(new SmithingRecipe(r.getLeft(), r.getRight(), r.getSimpleOutput(), r.tier));
        }
        return smithingRecipes;
    }

    public static List<AnvilRecipe> getAnvilRecipes() {
        if (anvilRecipes != null) {
            return anvilRecipes;
        }
        anvilRecipes = new ArrayList<AnvilRecipe>();
        for (AnvilRecipes.AnvilConstructionRecipe r : AnvilRecipes.getConstruction()) {
            ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>(r.input.size());
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(r.output.size());
            ArrayList<Float> chances = new ArrayList<Float>(r.output.size());
            for (RecipesCommon.AStack aStack : r.input) {
                inputs.add(aStack.getStackList());
            }
            for (AnvilRecipes.AnvilOutput anvilOutput : r.output) {
                outputs.add(anvilOutput.stack.func_77946_l());
                chances.add(Float.valueOf(anvilOutput.chance));
            }
            anvilRecipes.add(new AnvilRecipe(inputs, outputs, chances, r.tierLower, r.tierUpper, r.getOverlay()));
        }
        return anvilRecipes;
    }

    public static class ChemRecipe
    implements IRecipeWrapper {
        private final List<List<ItemStack>> inputs;
        private final List<ItemStack> outputs;

        public ChemRecipe(List<RecipesCommon.AStack> inputs, List<ItemStack> outputs) {
            ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>(inputs.size());
            for (RecipesCommon.AStack s : inputs) {
                list.add(s.getStackList());
            }
            this.inputs = list;
            this.outputs = outputs;
        }

        public void getIngredients(IIngredients ingredients) {
            List<List<ItemStack>> in = Library.copyItemStackListList(this.inputs);
            ingredients.setInputLists(VanillaTypes.ITEM, in);
            ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
        }
    }

    public static class MixerRecipe
    implements IRecipeWrapper {
        private final List<List<ItemStack>> inputs;
        private final ItemStack output;

        public MixerRecipe(List<RecipesCommon.AStack> inputs, ItemStack output) {
            ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>(inputs.size());
            for (RecipesCommon.AStack s : inputs) {
                list.add(s.getStackList());
            }
            this.inputs = list;
            this.output = output;
        }

        public void getIngredients(IIngredients ingredients) {
            List<List<ItemStack>> in = Library.copyItemStackListList(this.inputs);
            ingredients.setInputLists(VanillaTypes.ITEM, in);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }

        public int getInputSize() {
            return this.inputs.size();
        }
    }

    public static class CyclotronRecipe
    implements IRecipeWrapper {
        private final List<ItemStack> inputs;
        private final ItemStack output;

        public CyclotronRecipe(List<ItemStack> inputs, ItemStack output) {
            this.inputs = inputs;
            this.output = output;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputs(VanillaTypes.ITEM, this.inputs);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }
    }

    public static class PressRecipe
    implements IRecipeWrapper {
        private final List<List<ItemStack>> inputs;
        private final ItemStack output;

        public PressRecipe(List<List<ItemStack>> inputs, ItemStack output) {
            this.inputs = inputs;
            this.output = output;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }
    }

    public static class AlloyFurnaceRecipe
    implements IRecipeWrapper {
        private final List<List<ItemStack>> inputs;
        private final ItemStack output;

        public AlloyFurnaceRecipe(RecipesCommon.AStack input1, RecipesCommon.AStack input2, ItemStack output) {
            ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>(2);
            list.add(input1.getStackList());
            list.add(input2.getStackList());
            this.inputs = list;
            this.output = output;
        }

        public void getIngredients(IIngredients ingredients) {
            List<List<ItemStack>> in = Library.copyItemStackListList(this.inputs);
            ingredients.setInputLists(VanillaTypes.ITEM, in);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }
    }

    public static class CombinationFurnaceRecipe
    implements IRecipeWrapper {
        private final ItemStack input;
        private final List<ItemStack> outputs;

        public CombinationFurnaceRecipe(RecipesCommon.AStack input, ItemStack outputItem, FluidStack outputFluid) {
            this.input = input.getStack();
            this.outputs = new ArrayList<ItemStack>();
            if (!outputItem.func_190926_b()) {
                this.outputs.add(outputItem);
            }
            if (outputFluid != null) {
                this.outputs.add(ItemFluidIcon.getStackWithQuantity(outputFluid));
            }
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
        }
    }

    public static class FoundrySmeltRecipe
    implements IRecipeWrapper {
        private final List<ItemStack> inputs;
        private final List<ItemStack> outputs;

        public FoundrySmeltRecipe(List<ItemStack> inputs, List<ItemStack> outputs) {
            this.inputs = inputs;
            this.outputs = outputs;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputs(VanillaTypes.ITEM, this.inputs);
            ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
        }
    }

    public static class FoundryMixRecipe
    implements IRecipeWrapper {
        private final List<ItemStack> inputs;
        private final List<ItemStack> outputs;

        public FoundryMixRecipe(ItemStack template, List<ItemStack> inputs, List<ItemStack> outputs) {
            this.inputs = inputs;
            this.inputs.add(0, template);
            this.outputs = outputs;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputs(VanillaTypes.ITEM, this.inputs);
            ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
        }
    }

    public static class FoundryPourRecipe
    implements IRecipeWrapper {
        private final List<ItemStack> inputs = new ArrayList<ItemStack>();
        private final ItemStack output;

        public FoundryPourRecipe(ItemStack basin, ItemStack mold, ItemStack input, ItemStack output) {
            this.inputs.add(basin);
            this.inputs.add(mold);
            this.inputs.add(input);
            this.output = output;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputs(VanillaTypes.ITEM, this.inputs);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }
    }

    public static class ArcWelderRecipe
    implements IRecipeWrapper {
        private final List<List<ItemStack>> inputs;
        private final ItemStack output;
        private final int duration;
        private final long consumption;
        public final int itemLen;

        public ArcWelderRecipe(List<RecipesCommon.AStack> inputs, ItemStack output, int duration, long consumption, int itemLen) {
            ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>(inputs.size());
            for (RecipesCommon.AStack s : inputs) {
                list.add(s.getStackList());
            }
            this.inputs = list;
            this.output = output;
            this.duration = duration;
            this.consumption = consumption;
            this.itemLen = itemLen;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(VanillaTypes.ITEM, Library.copyItemStackListList(this.inputs));
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            FontRenderer fontRenderer = minecraft.field_71466_p;
            String timeText = (double)this.duration / 20.0 + "s";
            fontRenderer.func_78276_b(timeText, 123 - fontRenderer.func_78256_a(timeText), 4, 0x555555);
            String powerText = Library.getShortNumber(this.consumption * 20L) + "HE/s";
            fontRenderer.func_78276_b(powerText, 123 - fontRenderer.func_78256_a(powerText), 43, 0x555555);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static class SolderingRecipe
    implements IRecipeWrapper {
        private final List<List<ItemStack>> inputs;
        private final ItemStack output;
        private final int duration;
        private final long consumption;
        public final int toppingCount;
        public final int pcbCount;
        public final int solderCount;

        public SolderingRecipe(List<RecipesCommon.AStack> inputs, ItemStack output, int duration, long consumption, int toppingCount, int pcbCount, int solderCount) {
            ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>(inputs.size());
            for (RecipesCommon.AStack s : inputs) {
                list.add(s.getStackList());
            }
            this.inputs = list;
            this.output = output;
            this.duration = duration;
            this.consumption = consumption;
            this.toppingCount = toppingCount;
            this.pcbCount = pcbCount;
            this.solderCount = solderCount;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(VanillaTypes.ITEM, Library.copyItemStackListList(this.inputs));
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            FontRenderer fontRenderer = minecraft.field_71466_p;
            String timeText = (double)this.duration / 20.0 + "s";
            fontRenderer.func_78276_b(timeText, 123 - fontRenderer.func_78256_a(timeText), 4, 0x555555);
            String powerText = Library.getShortNumber(this.consumption * 20L) + "HE/s";
            fontRenderer.func_78276_b(powerText, 123 - fontRenderer.func_78256_a(powerText), 43, 0x555555);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static class RBMKFuelRecipe
    implements IRecipeWrapper {
        private final ItemStack input;
        private final ItemStack output;

        public RBMKFuelRecipe(ItemStack input, ItemStack output) {
            this.input = input;
            this.output = output;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }
    }

    public static class BoilerRecipe
    implements IRecipeWrapper {
        private final ItemStack input;
        private final ItemStack output;

        public BoilerRecipe(ItemStack input, ItemStack output) {
            this.input = input;
            this.output = output;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }
    }

    public static class GasCentRecipe
    implements IRecipeWrapper {
        private final ItemStack input;
        private final List<ItemStack> outputs;
        public boolean isUpgraded;

        public GasCentRecipe(boolean isUpgraded, ItemStack input, List<ItemStack> outputs) {
            this.isUpgraded = isUpgraded;
            this.input = input;
            this.outputs = outputs;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
        }
    }

    public static class BookRecipe
    implements IRecipeWrapper {
        List<ItemStack> inputs = new ArrayList<ItemStack>(4);
        ItemStack output;

        public BookRecipe(MagicRecipes.MagicRecipe recipe) {
            for (int i = 0; i < recipe.in.size(); ++i) {
                this.inputs.add(recipe.in.get(i).getStack());
            }
            while (this.inputs.size() < 4) {
                this.inputs.add(new ItemStack(ModItems.nothing));
            }
            this.output = recipe.getResult();
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputs(VanillaTypes.ITEM, this.inputs);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }
    }

    public static class ReactorRecipe
    implements IRecipeWrapper {
        public static IDrawableStatic heatTex;
        private final ItemStack input;
        private final ItemStack output;
        public final int heat;

        public ReactorRecipe(ItemStack input, ItemStack output, int heat) {
            this.input = input;
            this.output = output;
            this.heat = heat;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            heatTex.draw(minecraft, 1, 20, 16 - this.heat * 4, 0, 0, 0);
        }
    }

    public static class LiquefactionRecipe
    implements IRecipeWrapper {
        private final List<ItemStack> inputs;
        private final ItemStack output;

        public LiquefactionRecipe(List<ItemStack> inputs, ItemStack output) {
            this.inputs = inputs;
            this.output = output;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputs(VanillaTypes.ITEM, this.inputs);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }
    }

    public static class SolidificationRecipe
    implements IRecipeWrapper {
        private final ItemStack input;
        private final ItemStack output;

        public SolidificationRecipe(ItemStack input, ItemStack output) {
            this.input = input;
            this.output = output;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }
    }

    public static class WasteDrumRecipe
    implements IRecipeWrapper {
        private final ItemStack input;
        private final ItemStack output;

        public WasteDrumRecipe(ItemStack input, ItemStack output) {
            this.input = input;
            this.output = output;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }
    }

    public static class StorageDrumRecipe
    implements IRecipeWrapper {
        private final ItemStack input;
        private final ItemStack output;

        public StorageDrumRecipe(ItemStack input, ItemStack output) {
            this.input = input;
            this.output = output;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }
    }

    public static class TransmutationRecipe
    implements IRecipeWrapper {
        private final List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        private final ItemStack output;

        public TransmutationRecipe(List<ItemStack> inputs, ItemStack output) {
            this.inputs.add(inputs);
            this.output = output;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }
    }

    public static class RefineryRecipe
    implements IRecipeWrapper {
        private final ItemStack input;
        private final List<ItemStack> outputs;

        public RefineryRecipe(ItemStack input, List<ItemStack> outputs) {
            this.input = input;
            this.outputs = outputs;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
        }
    }

    public static class CrackingRecipe
    implements IRecipeWrapper {
        private final ItemStack input;
        public final List<ItemStack> outputs;

        public CrackingRecipe(ItemStack input, List<ItemStack> outputs) {
            this.input = input;
            this.outputs = outputs;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
        }
    }

    public static class FractioningRecipe
    implements IRecipeWrapper {
        private final ItemStack input;
        private final List<ItemStack> outputs;

        public FractioningRecipe(ItemStack input, List<ItemStack> outputs) {
            this.input = input;
            this.outputs = outputs;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
        }
    }

    public static class HydrotreaterRecipe
    implements IRecipeWrapper {
        private final List<ItemStack> inputs;
        private final List<ItemStack> outputs;

        public HydrotreaterRecipe(List<ItemStack> inputs, List<ItemStack> outputs) {
            this.inputs = inputs;
            this.outputs = outputs;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputs(VanillaTypes.ITEM, this.inputs);
            ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
        }
    }

    public static class ReformingRecipe
    implements IRecipeWrapper {
        private final ItemStack input;
        private final List<ItemStack> outputs;

        public ReformingRecipe(ItemStack input, List<ItemStack> outputs) {
            this.input = input;
            this.outputs = outputs;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
        }
    }

    public static class VacuumDistillRecipe
    implements IRecipeWrapper {
        private final ItemStack input;
        private final List<ItemStack> outputs;

        public VacuumDistillRecipe(ItemStack input, List<ItemStack> outputs) {
            this.input = input;
            this.outputs = outputs;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
        }
    }

    public static class CokerRecipe
    implements IRecipeWrapper {
        private final ItemStack input;
        private final List<ItemStack> outputs;

        public CokerRecipe(ItemStack input, List<ItemStack> outputs) {
            this.input = input;
            this.outputs = outputs;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
        }
    }

    public static class FluidRecipe
    implements IRecipeWrapper {
        protected final ItemStack input;
        protected final ItemStack output;

        public FluidRecipe(ItemStack input, ItemStack output) {
            this.input = input;
            this.output = output;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }
    }

    public static class FluidRecipeInverse
    extends FluidRecipe
    implements IRecipeWrapper {
        public FluidRecipeInverse(ItemStack input, ItemStack output) {
            super(input, output);
        }

        @Override
        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.output);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.input);
        }
    }

    public static class FusionRecipe
    implements IRecipeWrapper {
        ItemStack input;
        ItemStack output;

        public FusionRecipe(Fluid input, ItemStack output) {
            this.input = ItemFluidIcon.getStack(input);
            this.output = output;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }
    }

    public static class SAFERecipe
    implements IRecipeWrapper {
        ItemStack input;
        ItemStack output;

        public SAFERecipe(ItemStack input, ItemStack output) {
            this.input = input;
            this.output = output;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }
    }

    public static class HadronRecipe
    implements IRecipeWrapper {
        public ItemStack in1;
        public ItemStack in2;
        public ItemStack out1;
        public ItemStack out2;
        public int momentum;
        public boolean analysisOnly;

        public HadronRecipe(ItemStack in1, ItemStack in2, ItemStack out1, ItemStack out2, int momentum, boolean analysis) {
            this.in1 = in1;
            this.in2 = in2;
            this.out1 = out1;
            this.out2 = out2;
            this.momentum = momentum;
            this.analysisOnly = analysis;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputs(VanillaTypes.ITEM, Arrays.asList(this.in1, this.in2));
            ingredients.setOutputs(VanillaTypes.ITEM, Arrays.asList(this.out1, this.out2));
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            if (this.analysisOnly) {
                HadronRecipeHandler.analysis.draw(minecraft, 117, 17);
            }
            FontRenderer fontRenderer = minecraft.field_71466_p;
            String mom = "" + this.momentum;
            fontRenderer.func_78276_b(mom, -fontRenderer.func_78256_a(mom) / 2 + 19, 36, 0x404040);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static class SILEXRecipe
    implements IRecipeWrapper {
        List<List<ItemStack>> input = new ArrayList<List<ItemStack>>(1);
        List<Double> chances;
        List<ItemStack> outputs;
        double produced;
        ItemFELCrystal.EnumWavelengths laserStrength;

        public SILEXRecipe(List<ItemStack> inputs, List<Double> chances, List<ItemStack> outputs, double produced, ItemFELCrystal.EnumWavelengths laserStrength) {
            this.input.add(inputs);
            this.chances = chances;
            this.outputs = outputs;
            this.produced = produced;
            this.laserStrength = laserStrength;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(VanillaTypes.ITEM, this.input);
            ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int output_size = this.outputs.size();
            int sep = output_size > 6 ? 4 : (output_size > 4 ? 3 : 2);
            for (int i = 0; i < output_size; ++i) {
                double chance = this.chances.get(i);
                if (i < sep) {
                    fontRenderer.func_78276_b((double)((int)(chance * 100.0)) / 100.0 + "%", 90, 33 + i * 18 - 9 * ((Math.min(output_size, sep) + 1) / 2), 0x404040);
                    continue;
                }
                fontRenderer.func_78276_b((double)((int)(chance * 100.0)) / 100.0 + "%", 138, 33 + (i - sep) * 18 - 9 * ((Math.min(output_size - sep, sep) + 1) / 2), 0x404040);
            }
            String am = (double)((int)(this.produced * 10.0)) / 10.0 + "x";
            fontRenderer.func_78276_b(am, 52 - fontRenderer.func_78256_a(am) / 2, 51, 0x404040);
            String wavelength = this.laserStrength == ItemFELCrystal.EnumWavelengths.NULL ? TextFormatting.WHITE + "N/A" : this.laserStrength.textColor + I18nUtil.resolveKey(this.laserStrength.name, new Object[0]);
            fontRenderer.func_78276_b(wavelength, 35 - fontRenderer.func_78256_a(wavelength) / 2, 17, 0x404040);
        }
    }

    public static class SmithingRecipe
    implements IRecipeWrapper {
        List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>(2);
        ItemStack output;
        int tier;

        public SmithingRecipe(List<ItemStack> left, List<ItemStack> right, ItemStack out, int tier) {
            this.inputs.add(left);
            this.inputs.add(right);
            this.output = out;
            this.tier = tier;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }
    }

    public static class AnvilRecipe
    implements IRecipeWrapper {
        List<List<ItemStack>> inputs;
        List<ItemStack> outputs;
        List<Float> chances;
        int tierLower;
        int tierUpper;
        AnvilRecipes.OverlayType overlay;

        public AnvilRecipe(List<List<ItemStack>> inp, List<ItemStack> otp, List<Float> chance, int tL, int tU, AnvilRecipes.OverlayType ovl) {
            this.inputs = inp;
            this.outputs = otp;
            this.chances = chance;
            this.tierLower = tL;
            this.tierUpper = tU;
            this.overlay = ovl;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
            ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
        }
    }

    public static class AssemblerRecipeWrapper
    implements IRecipeWrapper {
        ItemStack output;
        List<List<ItemStack>> inputs;
        int time;

        public AssemblerRecipeWrapper(ItemStack output, RecipesCommon.AStack[] inputs, int time) {
            this.output = output;
            ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>(inputs.length);
            for (RecipesCommon.AStack s : inputs) {
                list.add(s.getStackList());
            }
            this.inputs = list;
            this.time = time;
        }

        public void getIngredients(IIngredients ingredients) {
            List<List<ItemStack>> in = Library.copyItemStackListList(this.inputs);
            while (in.size() < 12) {
                in.add(Arrays.asList(new ItemStack(ModItems.nothing)));
            }
            int index = -1;
            for (int i = 0; i < AssemblerRecipes.recipeList.size(); ++i) {
                if (!AssemblerRecipes.recipeList.get(i).isApplicable(this.output)) continue;
                index = i;
                break;
            }
            if (index >= 0) {
                in.add(Arrays.asList(ItemAssemblyTemplate.getTemplate(index)));
            } else {
                in.add(Arrays.asList(new ItemStack(ModItems.nothing)));
            }
            ingredients.setInputLists(VanillaTypes.ITEM, in);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }
    }
}

