/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.config.BombConfig;
import com.hbm.entity.effect.EntityNukeTorex;
import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.ExplosionNT;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.interfaces.IBulletImpactBehavior;
import com.hbm.interfaces.IBulletUpdateBehavior;
import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.render.misc.RenderScreenOverlay;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;

public class GunFatmanFactory {
    public static GunConfiguration getFatmanConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 20;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 120;
        config.firingDuration = 0;
        config.ammoCap = 1;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCUMFLEX;
        config.firingSound = HBMSoundHandler.fatmanShoot;
        config.reloadSound = GunConfiguration.RSOUND_FATMAN;
        config.reloadSoundEnd = false;
        config.name = "M-42 Tactical Nuclear Catapult";
        config.manufacturer = "Fort Strong";
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.NUKE_NORMAL);
        config.config.add(BulletConfigSyncingUtil.NUKE_LOW);
        config.config.add(BulletConfigSyncingUtil.NUKE_HIGH);
        config.config.add(BulletConfigSyncingUtil.NUKE_TOTS);
        config.config.add(BulletConfigSyncingUtil.NUKE_SAFE);
        config.config.add(BulletConfigSyncingUtil.NUKE_PUMPKIN);
        config.durability = 1000;
        return config;
    }

    public static GunConfiguration getMIRVConfig() {
        GunConfiguration config = GunFatmanFactory.getFatmanConfig();
        config.name = "M-42 Experimental MIRV";
        config.manufacturer = "Fort Strong";
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.NUKE_MIRV_NORMAL);
        config.config.add(BulletConfigSyncingUtil.NUKE_MIRV_LOW);
        config.config.add(BulletConfigSyncingUtil.NUKE_MIRV_HIGH);
        config.config.add(BulletConfigSyncingUtil.NUKE_MIRV_SAFE);
        config.config.add(BulletConfigSyncingUtil.NUKE_MIRV_SPECIAL);
        config.durability = 1000;
        return config;
    }

    public static GunConfiguration getBELConfig() {
        GunConfiguration config = GunFatmanFactory.getFatmanConfig();
        config.name = "Balefire Egg Launcher";
        config.manufacturer = "Fort Strong";
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.NUKE_AMAT);
        return config;
    }

    public static GunConfiguration getProtoConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 20;
        config.roundsPerCycle = 8;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 120;
        config.firingDuration = 0;
        config.ammoCap = 8;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCUMFLEX;
        config.firingSound = HBMSoundHandler.fatmanShoot;
        config.reloadSound = GunConfiguration.RSOUND_FATMAN;
        config.reloadSoundEnd = false;
        config.name = "M-42 Tactical Nuclear Catapult";
        config.manufacturer = "Fort Strong";
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.NUKE_PROTO_NORMAL);
        config.config.add(BulletConfigSyncingUtil.NUKE_PROTO_LOW);
        config.config.add(BulletConfigSyncingUtil.NUKE_PROTO_HIGH);
        config.config.add(BulletConfigSyncingUtil.NUKE_PROTO_TOTS);
        config.config.add(BulletConfigSyncingUtil.NUKE_PROTO_SAFE);
        config.config.add(BulletConfigSyncingUtil.NUKE_PROTO_PUMPKIN);
        config.durability = 1000;
        return config;
    }

    public static BulletConfiguration getNukeConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardNukeConfig();
        bullet.ammo = ModItems.ammo_nuke;
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                BulletConfigFactory.nuclearExplosion(bullet, x, y, z, 35);
            }
        };
        return bullet;
    }

    public static BulletConfiguration getNukeLowConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardNukeConfig();
        bullet.ammo = ModItems.ammo_nuke_low;
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                BulletConfigFactory.nuclearExplosion(bullet, x, y, z, 20);
            }
        };
        return bullet;
    }

    public static BulletConfiguration getNukeHighConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardNukeConfig();
        bullet.ammo = ModItems.ammo_nuke_high;
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                BulletConfigFactory.nuclearExplosion(bullet, x, y, z, 50);
            }
        };
        return bullet;
    }

    public static BulletConfiguration getNukeTotsConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardNukeConfig();
        bullet.ammo = ModItems.ammo_nuke_tots;
        bullet.bulletsMin = 8;
        bullet.bulletsMax = 8;
        bullet.spread = 0.1f;
        bullet.style = 9;
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                BulletConfigFactory.nuclearExplosion(bullet, x, y, z, 10);
            }
        };
        return bullet;
    }

    public static BulletConfiguration getNukeSafeConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardNukeConfig();
        bullet.ammo = ModItems.ammo_nuke_safe;
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                BulletConfigFactory.nuclearExplosion(bullet, x, y, z, 0);
            }
        };
        return bullet;
    }

    public static BulletConfiguration getNukePumpkinConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardNukeConfig();
        bullet.ammo = ModItems.ammo_nuke_pumpkin;
        bullet.explosive = 10.0f;
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                if (bullet.field_70170_p.field_72995_K) {
                    double posX = bullet.field_70165_t;
                    double posY = bullet.field_70163_u + 0.5;
                    double posZ = bullet.field_70161_v;
                    if (y >= 0) {
                        posX = (double)x + 0.5;
                        posY = (double)y + 1.5;
                        posZ = (double)z + 0.5;
                    }
                    ExplosionLarge.spawnParticles(bullet.field_70170_p, posX, posY, posZ, 45);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getMirvConfig() {
        BulletConfiguration bullet = GunFatmanFactory.getNukeConfig();
        bullet.ammo = ModItems.ammo_mirv;
        bullet.style = 8;
        bullet.velocity *= 3.0f;
        bullet.bUpdate = new IBulletUpdateBehavior(){

            @Override
            public void behaveUpdate(EntityBulletBase bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (bullet.field_70173_aa == 15) {
                    bullet.func_70106_y();
                    for (int i = 0; i < 6; ++i) {
                        EntityBulletBase nuke = new EntityBulletBase(bullet.field_70170_p, BulletConfigSyncingUtil.NUKE_NORMAL);
                        nuke.func_70107_b(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v);
                        double mod = 0.1;
                        nuke.field_70159_w = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        nuke.field_70181_x = -0.1;
                        nuke.field_70179_y = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        bullet.field_70170_p.func_72838_d((Entity)nuke);
                    }
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getMirvLowConfig() {
        BulletConfiguration bullet = GunFatmanFactory.getNukeLowConfig();
        bullet.ammo = ModItems.ammo_mirv_low;
        bullet.style = 8;
        bullet.velocity *= 3.0f;
        bullet.bUpdate = new IBulletUpdateBehavior(){

            @Override
            public void behaveUpdate(EntityBulletBase bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (bullet.field_70173_aa == 15) {
                    bullet.func_70106_y();
                    for (int i = 0; i < 6; ++i) {
                        EntityBulletBase nuke = new EntityBulletBase(bullet.field_70170_p, BulletConfigSyncingUtil.NUKE_LOW);
                        nuke.func_70107_b(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v);
                        double mod = 0.1;
                        nuke.field_70159_w = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        nuke.field_70181_x = -0.1;
                        nuke.field_70179_y = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        bullet.field_70170_p.func_72838_d((Entity)nuke);
                    }
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getMirvHighConfig() {
        BulletConfiguration bullet = GunFatmanFactory.getNukeHighConfig();
        bullet.ammo = ModItems.ammo_mirv_high;
        bullet.style = 8;
        bullet.velocity *= 3.0f;
        bullet.bUpdate = new IBulletUpdateBehavior(){

            @Override
            public void behaveUpdate(EntityBulletBase bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (bullet.field_70173_aa == 15) {
                    bullet.func_70106_y();
                    for (int i = 0; i < 6; ++i) {
                        EntityBulletBase nuke = new EntityBulletBase(bullet.field_70170_p, BulletConfigSyncingUtil.NUKE_HIGH);
                        nuke.func_70107_b(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v);
                        double mod = 0.1;
                        nuke.field_70159_w = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        nuke.field_70181_x = -0.1;
                        nuke.field_70179_y = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        bullet.field_70170_p.func_72838_d((Entity)nuke);
                    }
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getMirvSafeConfig() {
        BulletConfiguration bullet = GunFatmanFactory.getNukeSafeConfig();
        bullet.ammo = ModItems.ammo_mirv_safe;
        bullet.style = 8;
        bullet.velocity *= 3.0f;
        bullet.bUpdate = new IBulletUpdateBehavior(){

            @Override
            public void behaveUpdate(EntityBulletBase bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (bullet.field_70173_aa == 15) {
                    bullet.func_70106_y();
                    for (int i = 0; i < 6; ++i) {
                        EntityBulletBase nuke = new EntityBulletBase(bullet.field_70170_p, BulletConfigSyncingUtil.NUKE_SAFE);
                        nuke.func_70107_b(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v);
                        double mod = 0.1;
                        nuke.field_70159_w = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        nuke.field_70181_x = -0.1;
                        nuke.field_70179_y = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        bullet.field_70170_p.func_72838_d((Entity)nuke);
                    }
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getMirvSpecialConfig() {
        BulletConfiguration bullet = GunFatmanFactory.getNukeConfig();
        bullet.ammo = ModItems.ammo_mirv_special;
        bullet.style = 8;
        bullet.velocity *= 3.0f;
        bullet.bUpdate = new IBulletUpdateBehavior(){

            @Override
            public void behaveUpdate(EntityBulletBase bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (bullet.field_70173_aa == 15) {
                    bullet.func_70106_y();
                    for (int i = 0; i < 24; ++i) {
                        EntityBulletBase nuke = null;
                        nuke = i < 6 ? new EntityBulletBase(bullet.field_70170_p, BulletConfigSyncingUtil.NUKE_LOW) : (i < 12 ? new EntityBulletBase(bullet.field_70170_p, BulletConfigSyncingUtil.NUKE_TOTS) : (i < 18 ? new EntityBulletBase(bullet.field_70170_p, BulletConfigSyncingUtil.NUKE_NORMAL) : new EntityBulletBase(bullet.field_70170_p, BulletConfigSyncingUtil.NUKE_AMAT)));
                        nuke.func_70107_b(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v);
                        double mod = 0.25;
                        nuke.field_70159_w = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        nuke.field_70181_x = -0.1;
                        nuke.field_70179_y = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        bullet.field_70170_p.func_72838_d((Entity)nuke);
                    }
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getBalefireConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardNukeConfig();
        bullet.ammo = ModItems.gun_bf_ammo;
        bullet.style = 10;
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                if (!bullet.field_70170_p.field_72995_K) {
                    double posX = bullet.field_70165_t;
                    double posY = bullet.field_70163_u + 0.5;
                    double posZ = bullet.field_70161_v;
                    if (y >= 0) {
                        posX = (double)x + 0.5;
                        posY = (double)y + 1.5;
                        posZ = (double)z + 0.5;
                    }
                    bullet.field_70170_p.func_184148_a(null, (double)x, (double)y, (double)z, HBMSoundHandler.mukeExplosion, SoundCategory.HOSTILE, 15.0f, 1.0f);
                    ExplosionLarge.spawnShrapnels(bullet.field_70170_p, posX, posY, posZ, 25);
                    ExplosionNT exp = new ExplosionNT(bullet.field_70170_p, null, posX, posY, posZ, 15.0f).addAttrib(ExplosionNT.ExAttrib.BALEFIRE).addAttrib(ExplosionNT.ExAttrib.NOPARTICLE).addAttrib(ExplosionNT.ExAttrib.NOSOUND).addAttrib(ExplosionNT.ExAttrib.NODROP).addAttrib(ExplosionNT.ExAttrib.NOHURT).overrideResolution(64);
                    exp.explode();
                    if (BombConfig.enableNukeClouds) {
                        EntityNukeTorex.statFacBale(bullet.field_70170_p, posX, posY, posZ, 15.0f);
                    }
                }
            }
        };
        return bullet;
    }
}

