/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.crt;

import com.hbm.handler.crt.NTMCraftTweaker;
import com.hbm.inventory.FluidFlameRecipes;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import net.minecraftforge.fluids.FluidRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.ntm.FluidCombustion")
public class FluidCombustion {
    @ZenMethod
    public static void addBurnableFluid(String inputFluid, int heatPerMiliBucket) {
        NTMCraftTweaker.postInitActions.add(new ActionAddBurnableFluid(inputFluid, heatPerMiliBucket));
    }

    @ZenMethod
    public static void removeBurnableFluid(String inputFluid) {
        NTMCraftTweaker.postInitActions.add(new ActionRemoveBurnableFluid(inputFluid));
    }

    private static class ActionAddBurnableFluid
    implements IAction {
        private String inputFluid;
        private int heatPerMiliBucket;

        public ActionAddBurnableFluid(String inputFluid, int heatPerMiliBucket) {
            this.inputFluid = inputFluid;
            this.heatPerMiliBucket = heatPerMiliBucket;
        }

        public void apply() {
            if (this.inputFluid == null || this.inputFluid.trim().isEmpty()) {
                CraftTweakerAPI.logError((String)"ERROR Input Fluid can not be null/empty!");
                return;
            }
            if (!FluidRegistry.isFluidRegistered((String)this.inputFluid)) {
                CraftTweakerAPI.logError((String)("ERROR Input Fluid (" + this.inputFluid + ") does not exist!"));
                return;
            }
            if (this.heatPerMiliBucket < 1) {
                CraftTweakerAPI.logError((String)"ERROR Heat per mB can not be < 1!");
                return;
            }
            if (this.heatPerMiliBucket > 100000) {
                CraftTweakerAPI.logError((String)"ERROR Heat per mB can not be > 100,000!");
                return;
            }
            FluidFlameRecipes.addBurnableFluid(this.inputFluid, (long)this.heatPerMiliBucket);
        }

        public String describe() {
            return "Adding NTM fluid combustion recipe (" + this.inputFluid + " -> " + this.heatPerMiliBucket + "TU/mB)";
        }
    }

    private static class ActionRemoveBurnableFluid
    implements IAction {
        private String inputFluid;

        public ActionRemoveBurnableFluid(String inputFluid) {
            this.inputFluid = inputFluid;
        }

        public void apply() {
            if (this.inputFluid == null || this.inputFluid.trim().isEmpty()) {
                CraftTweakerAPI.logError((String)"ERROR Input Fluid can not be null/empty!");
                return;
            }
            if (!FluidRegistry.isFluidRegistered((String)this.inputFluid)) {
                CraftTweakerAPI.logError((String)("ERROR Input Fluid (" + this.inputFluid + ") does not exist!"));
                return;
            }
            FluidFlameRecipes.removeBurnableFluid(this.inputFluid);
        }

        public String describe() {
            return "Removing NTM fluid combustion recipe for (" + this.inputFluid + ")";
        }
    }
}

