/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.crt;

import com.hbm.handler.crt.NTMCraftTweaker;
import com.hbm.inventory.DFCRecipes;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.ntm.DFC")
public class DFC {
    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output, long spark) {
        NTMCraftTweaker.postInitActions.add(new ActionAddRecipe(input, output, spark));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        NTMCraftTweaker.postInitActions.add(new ActionRemoveRecipe(input));
    }

    private static class ActionAddRecipe
    implements IAction {
        private ItemStack input;
        private ItemStack output;
        private long spark = 0L;

        public ActionAddRecipe(IItemStack input, IItemStack output, long spark) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
            this.spark = spark;
        }

        public void apply() {
            if (this.input == null || this.input.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR DFC recipe input item can not be an empty/air stack!");
                return;
            }
            if (this.output == null || this.output.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR DFC recipe output item can not be an empty/air stack!");
                return;
            }
            if (this.spark < 1L) {
                CraftTweakerAPI.logError((String)("ERROR DFC recipe spark must be >0 not " + this.spark + "!"));
                return;
            }
            DFCRecipes.setRecipe(this.spark, this.input, this.output);
        }

        public String describe() {
            return "Adding NTM dfc recipe (" + this.input + " + " + this.spark + " spark -> " + this.output + ")";
        }
    }

    public static class ActionRemoveRecipe
    implements IAction {
        private ItemStack input;

        public ActionRemoveRecipe(IItemStack input) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
        }

        public void apply() {
            if (this.input == null || this.input.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR DFC input item can not be an empty/air stack!");
                return;
            }
            DFCRecipes.removeRecipe(this.input);
        }

        public String describe() {
            return "Removing NTM dfc recipe for input " + this.input;
        }
    }
}

