/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.crt;

import com.hbm.handler.crt.NTMCraftTweaker;
import com.hbm.inventory.BreederRecipes;
import com.hbm.inventory.RecipesCommon;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.ntm.BreedingReactor")
public class BreedingReactor {
    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output, int heatLvl) {
        NTMCraftTweaker.postInitActions.add(new ActionAddRecipe(input, output, heatLvl));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        NTMCraftTweaker.postInitActions.add(new ActionRemoveRecipe(input));
    }

    @ZenMethod
    public static void addFuel(IItemStack input, int heatLvl, int usesInNuclearFurnace) {
        NTMCraftTweaker.postInitActions.add(new ActionAddFuel(input, heatLvl, usesInNuclearFurnace));
    }

    @ZenMethod
    public static void removeFuel(IItemStack input) {
        NTMCraftTweaker.postInitActions.add(new ActionRemoveFuel(input));
    }

    private static class ActionAddRecipe
    implements IAction {
        private ItemStack input;
        private ItemStack output;
        private int heatLvl = 0;

        public ActionAddRecipe(IItemStack input, IItemStack output, int heatLvl) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
            this.heatLvl = heatLvl;
        }

        public void apply() {
            if (this.input == null || this.input.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Breeding input item can not be an empty/air stack!");
                return;
            }
            if (this.output == null || this.output.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Breeding output item can not be an empty/air stack!");
                return;
            }
            if (this.heatLvl < 1 || this.heatLvl > 4) {
                CraftTweakerAPI.logError((String)("ERROR Breeding heat needs to be between 1-4 not " + this.heatLvl + "!"));
                return;
            }
            BreederRecipes.addRecipe(new RecipesCommon.ComparableStack(this.input), this.output, this.heatLvl);
        }

        public String describe() {
            return "Adding NTM breeder recipe (" + this.input + " + " + this.heatLvl + " HEAT -> " + this.output + ")";
        }
    }

    public static class ActionRemoveRecipe
    implements IAction {
        private ItemStack input;

        public ActionRemoveRecipe(IItemStack input) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
        }

        public void apply() {
            if (this.input == null || this.input.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Breeding input item can not be an empty/air stack!");
                return;
            }
            BreederRecipes.removeRecipe(new RecipesCommon.ComparableStack(this.input));
        }

        public String describe() {
            return "Removing NTM breeder recipe for input " + this.input;
        }
    }

    public static class ActionAddFuel
    implements IAction {
        private ItemStack input;
        private int heatLvl = 0;
        private int usesInNuclearFurnace = 0;

        public ActionAddFuel(IItemStack input, int heatLvl, int usesInNuclearFurnace) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
            this.heatLvl = heatLvl;
            this.usesInNuclearFurnace = usesInNuclearFurnace;
        }

        public void apply() {
            if (this.input == null || this.input.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Breeding input item can not be an empty/air stack!");
                return;
            }
            if (this.heatLvl < 1 || this.heatLvl > 4) {
                CraftTweakerAPI.logError((String)("ERROR Breeding heat needs to be between 1-4 not " + this.heatLvl + "!"));
                return;
            }
            if (this.usesInNuclearFurnace < 1) {
                CraftTweakerAPI.logError((String)("ERROR Breeding uses in Nuclear Furnace can not be < 1 so " + this.usesInNuclearFurnace + " is invalid!"));
                return;
            }
            BreederRecipes.addFuel(new RecipesCommon.ComparableStack(this.input), this.heatLvl, this.usesInNuclearFurnace);
        }

        public String describe() {
            return "Adding NTM breeder fuel (" + this.input + " -> " + this.heatLvl + " HEAT + " + this.usesInNuclearFurnace + " NukeOvenUses)";
        }
    }

    public static class ActionRemoveFuel
    implements IAction {
        private ItemStack input;

        public ActionRemoveFuel(IItemStack input) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
        }

        public void apply() {
            if (this.input == null || this.input.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Breeding fuel item can not be an empty/air stack!");
                return;
            }
            BreederRecipes.removeFuel(new RecipesCommon.ComparableStack(this.input));
        }

        public String describe() {
            return "Removing NTM breeder fuel for input " + this.input;
        }
    }
}

