/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.crt;

import com.hbm.handler.crt.NTMCraftTweaker;
import com.hbm.inventory.AssemblerRecipes;
import com.hbm.inventory.RecipesCommon;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.ntm.Assembler")
public class Assembler {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] inputs, int duration) {
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe(output, inputs, duration));
    }

    @ZenMethod
    public static void replaceRecipe(IItemStack output, IIngredient[] inputs, int duration) {
        NTMCraftTweaker.postInitActions.add(new ActionRemoveRecipe(output));
        NTMCraftTweaker.postInitActions.add(new ActionAddRecipe(output, inputs, duration));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        NTMCraftTweaker.postInitActions.add(new ActionRemoveRecipe(output));
    }

    private static class ActionAddRecipe
    implements IAction {
        private IIngredient[] inputs;
        private ItemStack output;
        private int duration = 0;

        public ActionAddRecipe(IItemStack output, IIngredient[] inputs, int duration) {
            this.inputs = inputs;
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
            this.duration = duration;
        }

        public void apply() {
            if (this.inputs == null || this.inputs.length == 0) {
                CraftTweakerAPI.logError((String)"ERROR Assembler recipe input items can not be an empty array!");
                return;
            }
            if (this.inputs.length > 12) {
                CraftTweakerAPI.logError((String)("ERROR Assembler recipe input item count must be <=12 not " + this.inputs.length + "!"));
                return;
            }
            for (IIngredient i : this.inputs) {
                if (i != null) continue;
                CraftTweakerAPI.logError((String)"ERROR Assembler recipe input items can not include an empty/air stack!");
                return;
            }
            if (this.output == null || this.output.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Assembler recipe output item can not be an empty/air stack!");
                return;
            }
            if (this.duration < 1) {
                CraftTweakerAPI.logError((String)("ERROR Assembler recipe duraction must be >=1 not " + this.duration + "!"));
                return;
            }
            RecipesCommon.AStack[] compInputs = NTMCraftTweaker.IIngredientsToAStack(this.inputs);
            AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(this.output), compInputs, this.duration);
        }

        public String describe() {
            return "Adding NTM assembler recipe (" + Arrays.toString(this.inputs) + " + " + this.duration + " ticks -> " + this.output + ")";
        }
    }

    public static class ActionRemoveRecipe
    implements IAction {
        private ItemStack output;

        public ActionRemoveRecipe(IItemStack output) {
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
        }

        public void apply() {
            if (this.output == null || this.output.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Assembler output item can not be an empty/air stack!");
                return;
            }
            AssemblerRecipes.removeRecipe(new RecipesCommon.ComparableStack(this.output));
        }

        public String describe() {
            return "Removing NTM assembler recipe for output " + this.output;
        }
    }
}

